/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisCollection;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisFactory;
import com.kingdee.eas.ma.mbg.BgFormExcuteAnalysisInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgExcuteAnalysisSetUI;
import com.kingdee.eas.ma.mbg.client.BgExcuteAnalysisScenUI;
import com.kingdee.eas.ma.mbg.client.BgExcuteAnalysisUI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgExcuteAnalysisHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBGAdjustBillHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgExcuteAnalysisSetUI
extends AbstractBgExcuteAnalysisSetUI {
    private static final long serialVersionUID = 5830255783407394517L;
    private static final Logger logger = CoreUIObject.getLogger(BgExcuteAnalysisSetUI.class);
    private BgOrgUnitInfo selectedOrgUnit;
    private BgOrgUnitInfo currOrgUnit = null;
    private String schemeID = null;
    private boolean isClearEntry = false;
    private String createPermissionNum = null;
    protected BgSchemeDimensionHelper schemeHelper = null;
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private boolean hasCancel = true;
    private List<ItemFormula> data = new ArrayList<ItemFormula>();

    public boolean isClearEntry() {
        return this.isClearEntry;
    }

    public void setClearEntry(boolean isClearEntry) {
        this.isClearEntry = isClearEntry;
    }

    public void onLoad() throws Exception {
        this.schemeID = (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        this.createPermissionNum = (String)this.getUIContext().get("permissionItem");
        this.init();
        super.onLoad();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtQuery, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtQuery.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BgExcuteAnalysisSetUI.this.execQuery();
                }
            }
        });
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.schemeID);
        }
        return this.schemeHelper;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        String bgSpecialItemsNumber = null;
        try {
            if (this.getSchemeHelper() != null) {
                Map<String, BgDimensionInfo> map = this.getSchemeHelper().getDimensionBySrcNumber();
                int in = e.getLastRow();
                for (int i = e.getFirstRow(); i <= in; ++i) {
                    String bgSpecialItemsName = null;
                    String bgSpecialItemsNames = null;
                    if (this.tblMain.getCell(i, "bgSpecialItemsNumber") == null) continue;
                    bgSpecialItemsNumber = (String)this.tblMain.getCell(i, "bgSpecialItemsNumber").getValue();
                    bgSpecialItemsNames = (String)this.tblMain.getCell(i, "bgSpecialItems").getValue();
                    if (StringUtils.isEmpty((String)bgSpecialItemsNumber)) continue;
                    String[] srcNumber = bgSpecialItemsNumber.split(",");
                    String[] srcName = bgSpecialItemsNames.split(",");
                    for (int j = 0; j < srcNumber.length; ++j) {
                        String src = srcNumber[j].split(":")[0];
                        String name = srcName[j].split(":")[1];
                        if (!map.containsKey(src)) continue;
                        bgSpecialItemsName = bgSpecialItemsName == null ? map.get(src).getName() + ":" + name : bgSpecialItemsName + "," + map.get(src).getName() + ":" + name;
                    }
                    if (StringUtils.isEmpty(bgSpecialItemsName)) continue;
                    this.tblMain.getCell(i, "bgSpecialItems").setValue(bgSpecialItemsName);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.toolBar.setEnabled(false);
        this.toolBar.setVisible(false);
    }

    protected void init() throws Exception {
        this.initOrgUnit();
        this.initTable();
    }

    protected void initOrgUnit() throws Exception {
        Object obj = this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS);
        if (obj != null) {
            BgOrgUnitInfo _orgUnitLs = (BgOrgUnitInfo)obj;
            if (!_orgUnitLs.isIsVirtual()) {
                this.prmtOrgUnit.setValue((Object)_orgUnitLs);
            } else {
                this.prmtOrgUnit.setValue(null);
            }
        }
        this.initOrgUnit((String)this.getUIContext().get("orgViewId"));
        Object object = this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        if (object != null && object instanceof String) {
            this.setCurrOrgUnit(new BgOrgUnitInfo());
            this.getCurrOrgUnit().setOrgUnitID((String)object);
        }
    }

    private void initOrgUnit(String bgOrgViewId) {
        BgNewOrgDialog orgUnitDim = new BgNewOrgDialog();
        orgUnitDim.setMultipleSelect(false);
        orgUnitDim.setBgOrgViewId(bgOrgViewId);
        orgUnitDim.setShowVirtualOrg(false);
        orgUnitDim.setOrgUnitId(this.getUIContext().get(BgBaseConstants.ORGUNIT_ID).toString());
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgUnitDim);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        this.addDefaultFilter(filter, "bgScheme.id", this.schemeID);
        this.addDefaultFilter(filter, "bgVersion.isSysData", 1);
        this.addDefaultFilter(filter, "processType", 1);
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(15), CompareType.NOTEQUALS));
        return filter;
    }

    protected void addDefaultFilter(FilterInfo filter, String compareExpr, Object compareValue) {
        if (compareValue != null) {
            filter.getFilterItems().add(new FilterItemInfo(compareExpr, compareValue));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)BgBaseConstants.nullID, CompareType.EQUALS));
        }
    }

    protected Set<Integer> getDefaultState() {
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(2));
        state.add(new Integer(50));
        state.add(new Integer(51));
        state.add(new Integer(1));
        return state;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor executor = super.getQueryExecutor(queryPK, viewInfo);
        FilterInfo filter = this.getDefaultFilterForQuery();
        HashSet<String> tmpOrgUnitIds = new HashSet<String>();
        if (this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo orgUnit = (BgOrgUnitInfo)this.prmtOrgUnit.getData();
            tmpOrgUnitIds.add(orgUnit.getOrgUnitID());
        } else if (this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] orgUnits = (BgOrgUnitInfo[])this.prmtOrgUnit.getData();
            int in = orgUnits.length;
            for (int i = 0; i < in; ++i) {
                tmpOrgUnitIds.add(orgUnits[i].getOrgUnitID());
            }
        }
        if (tmpOrgUnitIds.isEmpty()) {
            tmpOrgUnitIds.add(BgBaseConstants.nullID);
        }
        if (!StringUtils.isEmpty((String)this.schemeID)) {
            try {
                Set bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.schemeID);
                if (!bgOrgUnitPer.isEmpty()) {
                    Iterator iterator = tmpOrgUnitIds.iterator();
                    while (iterator.hasNext()) {
                        String orgunitid = (String)iterator.next();
                        if (bgOrgUnitPer.contains(orgunitid)) continue;
                        iterator.remove();
                    }
                    if (tmpOrgUnitIds.isEmpty()) {
                        tmpOrgUnitIds.add("000000000000000000000000000=");
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIException(e);
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", tmpOrgUnitIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35, 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        filter.getFilterItems().add(new FilterItemInfo("bgType.number", null, CompareType.IS));
        filter.getFilterItems().add(new FilterItemInfo("bgType.number", (Object)"SelfDefineAnalysisTemplateGroup", CompareType.NOTEQUALS));
        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND (#6 OR #7) ");
        if (!StringUtils.isEmpty((String)this.txtQuery.getText())) {
            String txt = "%" + this.txtQuery.getText().trim() + "%";
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("currency.name", (Object)txt, CompareType.LIKE));
            filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND (#6 OR #7) AND ( #8 OR #9 OR #10 OR #11 OR #12 OR #13 OR #14 OR #15)");
        }
        try {
            if (!StringUtils.isEmpty((String)this.schemeID)) {
                BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select bgSchemeType.schemeType, id where id = '" + this.schemeID + "'");
                try {
                    MbgPermissionHelper.addFieldDataPermission(bgSchemeInfo.getBgSchemeType().getSchemeType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter, MbgPermissionTypeEnum.TEMPLATE, "bgtemplate.id", this.schemeID, true);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        viewInfo.setFilter(filter);
        return executor;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        Object obj = e.getNewValue();
        if (obj != null && obj instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo info = (BgOrgUnitInfo)obj;
            if (this.getUIContext().get("processType") instanceof BgProcessEnum) {
                BgProcessEnum processType = (BgProcessEnum)((Object)this.getUIContext().get("processType"));
                if (!DimensionCommonHelper.isDecompose(processType) && !info.isIsLeaf()) {
                    this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
                } else if (DimensionCommonHelper.isDecompose(processType) && info.isIsLeaf()) {
                    this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
                }
            }
            if (info.isIsVirtual()) {
                this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
                MsgBox.showError((String)MBGAdjustBillHelper.getString("selectOnlyNoVirtualBgOrg"));
                SysUtil.abort();
            }
        }
        this.execQuery();
    }

    @Override
    protected void btnTxtQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnTxtQuery_actionPerformed(e);
        this.execQuery();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.openFormUI();
        }
    }

    private void openFormUI() throws Exception {
        this.checkSelected();
        boolean isCreatePermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.getUserInfo().getId()), (IObjectPK)new ObjectUuidPK(((BgOrgUnitInfo)this.prmtOrgUnit.getData()).getOrgUnitID()), this.createPermissionNum);
        if (!isCreatePermission) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBgAnalyseResource", (String)"hasCreateExeAnalyPer", (Object[])new Object[]{((BgOrgUnitInfo)this.prmtOrgUnit.getData()).getName()}));
            SysUtil.abort();
        }
        BOSUuid bgFormId = BOSUuid.read((String)this.getSelectedKeyValue());
        BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgNFSHelper.getSelectors());
        BgSchemeDimensionHelper schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("schemeHelper");
        HashSet<String> senarioNum = new HashSet<String>();
        ArrayList listFormula = new ArrayList();
        Object object = BgExcuteAnalysisHelper.initSenarioNum(bgForm, senarioNum, schemeHelper, listFormula);
        if (listFormula.size() < 1 && object == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBgAnalyseResource", (String)"noFormula"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)this.schemeID);
        uiContext.put((Object)BgBaseConstants.BGSCENARIO_INFO, senarioNum);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExcuteAnalysisScenUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        BgExcuteAnalysisScenUI f7UI = (BgExcuteAnalysisScenUI)uiWindow.getUIObject();
        if (f7UI.isCancel()) {
            return;
        }
        Map scenarioMap = f7UI.returnMap();
        this.getUIWindow().close();
        BgFormExcuteAnalysisInfo analysisInfo = this.checkExitAnalysis(bgForm, scenarioMap);
        if (bgForm.getState().equals((Object)BgFormStateEnum.Adjusted)) {
            bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgForm.getAdjustId()), BgNFSHelper.getSelectors());
        }
        boolean isCreate = false;
        if (analysisInfo == null) {
            isCreate = true;
        }
        uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGORGVIEW_ID", this.getUIContext().get("orgViewId"));
        uiContext.put((Object)"BGFORM_INFO", (Object)bgForm);
        uiContext.put((Object)"BGFORM_IDS", (Object)analysisInfo);
        uiContext.put((Object)"OPEN_STATE", (Object)isCreate);
        uiContext.put((Object)DimensionConstants.SCENARIO_DIM_NAME, (Object)scenarioMap);
        uiContext.put((Object)DimensionConstants.DIMENSION, object);
        uiContext.put((Object)"MainUI", this.getUIContext().get("MainUI"));
        IUIWindow uiWindowAnaly = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getExcuteAnalysisUI(), (Map)uiContext, null, OprtState.VIEW);
        uiWindowAnaly.show();
    }

    protected String getExcuteAnalysisUI() {
        return BgExcuteAnalysisUI.class.getName();
    }

    protected BgFormExcuteAnalysisInfo checkExitAnalysis(BgFormInfo bgForm, Map<Integer, BgDimensionMember> scenarioMap) throws Exception {
        BgFormExcuteAnalysisInfo analysisInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgForm.id", (Object)bgForm.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgDataScenario", (Object)scenarioMap.get(0).getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("actDataScenario", (Object)scenarioMap.get(1).getNumber(), CompareType.EQUALS));
        view.setSelector(BgExcuteAnalysisHelper.getSelector());
        view.setFilter(filter);
        BgFormExcuteAnalysisCollection coll = BgFormExcuteAnalysisFactory.getRemoteInstance().getBgFormExcuteAnalysisCollection(view);
        if (coll.size() > 0) {
            analysisInfo = coll.get(0);
        }
        return analysisInfo;
    }

    protected boolean isMultiSelect() {
        return false;
    }

    protected void initTable() {
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        EntityViewInfo view = super.getDefaultEntityViewInfo();
        return view;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void close(boolean hasCancel) {
        this.setHasCancel(hasCancel);
        this.getUIWindow().close();
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.openFormUI();
    }

    @Override
    protected void btnExit_actionPerformed(ActionEvent e) throws Exception {
        super.btnExit_actionPerformed(e);
        this.close(true);
    }

    public void checkSelected() {
        Object obj = this.prmtOrgUnit.getData();
        if (obj == null) {
            MsgBox.showWarning((String)MBGAdjustBillHelper.getString("selectOrgFirst"));
            SysUtil.abort();
        }
        super.checkSelected();
    }

    public void setSelectedOrgUnit(BgOrgUnitInfo selectedOrgUnit) throws EASBizException, BOSException {
        if (selectedOrgUnit != null && !BgOrgUnitInfo.class.isInstance(selectedOrgUnit)) {
            selectedOrgUnit = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo((IObjectPK)new ObjectSingleKey((Object)selectedOrgUnit.getId()));
        }
        this.selectedOrgUnit = selectedOrgUnit;
    }

    public BgOrgUnitInfo getSelectedOrgUnit() {
        return this.selectedOrgUnit;
    }

    public BgOrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public void setCurrOrgUnit(BgOrgUnitInfo currOrgUnit) {
        this.currOrgUnit = currOrgUnit;
    }

    public CtrlUnitInfo getCurrCU() {
        return this.currCU;
    }

    public void setCurrCU(CtrlUnitInfo currCU) {
        this.currCU = currCU;
    }

    public boolean isHasCancel() {
        return this.hasCancel;
    }

    public void setHasCancel(boolean hasCancel) {
        this.hasCancel = hasCancel;
    }

    public List<ItemFormula> getData() {
        return this.data;
    }
}

