/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.mbg.BgFetchIndexCollection;
import com.kingdee.eas.ma.mbg.BgFetchIndexFactory;
import com.kingdee.eas.ma.mbg.BgFetchIndexGroupFactory;
import com.kingdee.eas.ma.mbg.BgFetchIndexGroupInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgFetchIndexGroup;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgFetchIndexGroupEditUI;
import com.kingdee.eas.ma.mbg.client.BgFetchIndexListUI;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BgFetchIndexGroupEditUI
extends AbstractBgFetchIndexGroupEditUI {
    private static final long serialVersionUID = 6976536000727809238L;
    private static final Logger logger = CoreUIObject.getLogger(BgFetchIndexGroupEditUI.class);
    private boolean isRelease = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtNumber.setMaxLength(80);
    }

    protected void loadData() throws Exception {
        CostCenterOrgUnitInfo unitInfo;
        super.loadData();
        this.initPrmtOrgUnit();
        this.disEnabelTxtNumber();
        if ("BFIG".equals(this.txtNumber.getText())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        if ((unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)) != null && !unitInfo.getId().equals((Object)this.editData.getOrgUnit().getId())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    private void disEnabelTxtNumber() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) || this.editData.getId() != null) {
            if (this.getBizInterface().isHasFetchIndex((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
                this.txtNumber.setEditable(false);
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEditable(true);
                this.txtNumber.setEnabled(true);
            }
        } else {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
        }
    }

    private void initPrmtOrgUnit() throws EASBizException, BOSException {
        CostCenterOrgUnitInfo unitInfo = null;
        String curUnitID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String optState = this.getOprtState();
        if (OprtState.ADDNEW.equals(optState)) {
            unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        } else if (OprtState.EDIT.equals(optState) || OprtState.VIEW.equals(optState)) {
            unitInfo = this.editData.getOrgUnit();
        }
        if (unitInfo != null && unitInfo.getId() != null) {
            unitInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
            BgCommCHelper.initOrgUnit((CoreUIObject)this, (KDBizPromptBox)this.prmtOrgUnit, (Object)unitInfo, (String)curUnitID);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.disableAction((JButton)this.btnSubmit, null);
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.getUIContext().get("Owner");
        if (object instanceof BgFetchIndexListUI) {
            ((BgFetchIndexListUI)object).newAccViewNum = this.txtNumber.getText();
        }
        super.actionSubmit_actionPerformed(e);
        if (object instanceof BgFetchIndexListUI) {
            ((BgFetchIndexListUI)object).initTree();
            ((BgFetchIndexListUI)object).setSelectTreeNode();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkFilled();
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.setEditable(true);
        this.txtNumber.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getOrgUnit(), (String)this.getGroupEditPermission());
        this.checkFilled();
        this.checkGroup(false);
        super.actionEdit_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    protected void checkFilled() throws EASBizException, BOSException {
        BgSchemeInfo bgSchemeInfo;
        Object data = this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        if (data instanceof BgSchemeInfo && (bgSchemeInfo = (BgSchemeInfo)data) != null) {
            BgSchemeFactory.getRemoteInstance().checkFilling(bgSchemeInfo.getId().toString());
        }
    }

    private void checkGroup(boolean isDelete) {
        String number;
        BgFetchIndexGroupInfo group = this.editData;
        if (group != null && "BFIG".equals(number = group.getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)(isDelete ? "DefaultGroupDelete" : "DefaultGroupEdit")));
            SysUtil.abort();
        }
    }

    private OrgUnitInfo getOrgUnit() {
        CostCenterOrgUnitInfo unitInfo = null;
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        } else if ((OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) && (unitInfo = this.editData.getOrgUnit()) == null) {
            unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        }
        return unitInfo;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)this.getOrgUnit(), (String)this.getGroupDeletePermission());
        this.checkFilled();
        this.checkGroup(true);
        BgFetchIndexGroupInfo selectGroupInfo = this.editData;
        BgFetchIndexCollection bgFetchIndexCollection = BgFetchIndexFactory.getRemoteInstance().getBgFetchIndexCollection("where group.id='" + selectGroupInfo.getId() + "'");
        if (bgFetchIndexCollection.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFetchIndexResource", (String)"groupHasChild"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected IObjectValue createNewData() {
        BgFetchIndexGroupInfo info = new BgFetchIndexGroupInfo();
        info.setOrgUnit((CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        info.setIsLeaf(true);
        info.setSourceType((RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType")));
        Object data = this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        if (data instanceof BgSchemeInfo) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)data;
            info.setBgScheme(bgSchemeInfo);
        }
        return info;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object selectedItem;
        Object data;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"haveEspecial"));
                SysUtil.abort();
            }
        }
        String text = this.txtNumber.getText();
        if (!StringUtils.isEmpty((String)this.txtNumber.getText()) && "ACG".equals(text)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"defaultGroupNumber"));
            SysUtil.abort();
        }
        if (BgDBUtils.length((String)this.txtNumber.getText()) > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsOverMax", (Object[])new Object[]{80}));
            SysUtil.abort();
        }
        if ((data = ((MultiLangItem)(selectedItem = this.txtName.getModel().getSelectedItem())).getData()) == null || StringUtils.isEmpty((String)data.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameIsNull"));
            SysUtil.abort();
        }
        if (((String)this.kDBizMultiLangArea1.getSelectedItemData()).length() > 255) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)DimensionConstants.DIMEN_COMMON_RESOURCE, (String)"informationOversize"));
            SysUtil.abort();
        }
    }

    protected IBgFetchIndexGroup getBizInterface() throws Exception {
        return BgFetchIndexGroupFactory.getRemoteInstance();
    }

    public boolean checkBeforeWindowClosing() {
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease) {
            BgFetchIndexGroupInfo obj = null;
            if (this.getDataObject() != null) {
                obj = (BgFetchIndexGroupInfo)this.getDataObject();
            }
            if (obj != null && obj.getId() != null) {
                BgAccountHelper.releaseMutexService((String)obj.getId().toString());
            }
        }
        return bclose;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        return sic;
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnAddNew);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnSubmit);
        this.toolBar.add((Component)this.btnRemove);
    }

    protected String getGroupAddNewPermission() {
        return "mbg_fetchIndex01_groupAddNew";
    }

    protected String getGroupEditPermission() {
        return "mbg_fetchIndex02_groupEdit";
    }

    protected String getGroupDeletePermission() {
        return "mbg_fetchIndex03_groupDelete";
    }
}

