/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationFactory;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationInfo;
import com.kingdee.eas.ma.mbg.VersionCopyInfo;
import com.kingdee.eas.ma.mbg.client.BgDataUpdateUI;
import com.kingdee.eas.ma.mbg.client.BgFinalizedCourseProgressUI;
import com.kingdee.eas.ma.mbg.client.BgFinalizedLogListUI;
import com.kingdee.eas.ma.mbg.client.BgFinalizedUI;
import com.kingdee.eas.ma.mbg.client.VersionCopyEditUI;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgFinalizedClientHelper {
    public static final String RES = "com.kingdee.eas.ma.mbg.BgFinalizedResource";
    public static final String permission_finalized = "mbg_form50_finalized";
    public static final String permission_unFinalized = "mbg_form51_unFinalized";
    public static final String permission_finalizedView = "mbg_form52_finalizedView";
    public static final String permission_finalizedLog = "mbg_form53_finalizedLog";
    public static final String permission_finalizedExport = "mbg_form54_finalizedExport";

    public static void actionFinalized_actionPerformed(CoreUI coreUI, BgSchemeInfo bgSchemInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo, BgOrgUnitInfo bgOrgUnitInfo) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)orgUnitInfo, (String)permission_finalized);
        UIContext uiContext = new UIContext((Object)coreUI);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)bgSchemInfo);
        uiContext.put((Object)"BGSCHEME_HELPER", (Object)schemeHelper);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)orgUnitInfo);
        uiContext.put((Object)"BGORGUNIT_INFO", (Object)bgOrgUnitInfo);
        uiContext.put((Object)"IS_FINALIZED", (Object)Boolean.TRUE);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(BgFinalizedUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public static void actionUnFinalized_actionPerformed(CoreUI coreUI, BgSchemeInfo bgSchemInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo, BgOrgUnitInfo bgOrgUnitInfo) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)orgUnitInfo, (String)permission_unFinalized);
        UIContext uiContext = new UIContext((Object)coreUI);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)bgSchemInfo);
        uiContext.put((Object)"BGSCHEME_HELPER", (Object)schemeHelper);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)orgUnitInfo);
        uiContext.put((Object)"BGORGUNIT_INFO", (Object)bgOrgUnitInfo);
        uiContext.put((Object)"IS_FINALIZED", (Object)Boolean.FALSE);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(BgFinalizedUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public static void actionExportFinalized_actionPerformed(CoreUI coreUI, BgSchemeInfo bgSchemInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo, BgOrgUnitInfo bgOrgUnitInfo) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)orgUnitInfo, (String)permission_finalizedExport);
    }

    public static void actionFinalizedLog_actionPerformed(CoreUI coreUI, BgSchemeInfo bgSchemInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo, BgOrgUnitInfo bgOrgUnitInfo) throws Exception {
        BgPermissionUtil.checkPermission((OrgUnitInfo)orgUnitInfo, (String)permission_finalizedLog);
        UIContext uiContext = new UIContext((Object)coreUI);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)bgSchemInfo);
        uiContext.put((Object)"BGSCHEME_HELPER", (Object)schemeHelper);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)orgUnitInfo);
        uiContext.put((Object)"BGORGUNIT_INFO", (Object)bgOrgUnitInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow uiWindow = uiFactory.create(BgFinalizedLogListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static void actionDataUpdateQuery_actionPerformed(CoreUI coreUI, BgSchemeInfo bgSchemInfo) throws Exception {
        UIContext uiContext = new UIContext((Object)coreUI);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)bgSchemInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(BgDataUpdateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static void checkFinalizedFormEdit(CoreUI coreUI, String bgFormId) throws EASBizException, BOSException {
        String msg = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyForm(bgFormId, OprtState.EDIT);
        if (!StringUtils.isEmpty((String)msg)) {
            MsgBox.showInfo((Component)coreUI, (String)msg);
            SysUtil.abort();
        }
    }

    public static void checkFinalizedFormOrgAdd(CoreUI coreUI, BgFormInfo bgFormInfo, List<BgDimensionMember> orgMembers) {
        try {
            String msg = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyForm(bgFormInfo, orgMembers);
            if (!StringUtils.isEmpty((String)msg)) {
                MsgBox.showInfo((Component)coreUI, (String)msg);
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            coreUI.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            coreUI.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    public static Set<String> checkFinalizedForms(List<String> bgFormIds) throws EASBizException, BOSException {
        Set bgFinalizedFormIds = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyForm(bgFormIds);
        if (!bgFinalizedFormIds.isEmpty() && !bgFormIds.isEmpty()) {
            for (int i = bgFormIds.size() - 1; i >= 0; --i) {
                if (!bgFinalizedFormIds.contains(bgFormIds.get(i))) continue;
                bgFormIds.remove(i);
            }
        }
        return bgFinalizedFormIds;
    }

    public static void checkFinalizedByScheme(CoreUI coreUI, BgSchemeInfo bgSchemeInfo, String actionName) throws EASBizException, BOSException {
        boolean isFinalized = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyBgScheme(bgSchemeInfo.getId().toString());
        if (isFinalized) {
            MsgBox.showInfo((Component)coreUI, (String)EASResource.getString((String)RES, (String)"checkBizCalcBgFinalized", (Object[])new Object[]{EASResource.getString((String)RES, (String)actionName)}));
            SysUtil.abort();
        }
    }

    public static void checkFinalizedByScheme(CoreUI coreUI, BgSchemeInfo bgSchemeInfo, String actionName, List<String> bgCalcSchemeIds) throws EASBizException, BOSException {
        boolean isFinalized = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyBgScheme(bgSchemeInfo.getId().toString(), bgCalcSchemeIds);
        if (isFinalized) {
            MsgBox.showInfo((Component)coreUI, (String)EASResource.getString((String)RES, (String)"checkBizCalcBgFinalized", (Object[])new Object[]{EASResource.getString((String)RES, (String)actionName)}));
            SysUtil.abort();
        }
    }

    public static void checkFinalizedBgSchemeIntegration(CoreUI coreUI, String bgSchemeIntegrationId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bgSchemeIntegrationId)) {
            return;
        }
        BgSchemeIntegrationInfo bgSchemeIntegrationInfo = BgSchemeIntegrationFactory.getRemoteInstance().getBgSchemeIntegrationInfo((IObjectPK)new ObjectUuidPK(bgSchemeIntegrationId));
        BgFinalizedClientHelper.checkFinalizedBgSchemeIntegration(coreUI, bgSchemeIntegrationInfo);
    }

    public static void checkFinalizedBgSchemeIntegration(CoreUI coreUI, BgSchemeIntegrationInfo bgSchemeIntegrationInfo) throws EASBizException, BOSException {
        if (bgSchemeIntegrationInfo == null || bgSchemeIntegrationInfo.getTargetBgScheme() == null) {
            return;
        }
        BgSchemeInfo bgSchemeInfo = bgSchemeIntegrationInfo.getTargetBgScheme();
        boolean isFinalized = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyBgScheme(bgSchemeInfo.getId().toString());
        if (isFinalized) {
            MsgBox.showInfo((Component)coreUI, (String)EASResource.getString((String)RES, (String)"checkSchemeIntegration"));
            SysUtil.abort();
        }
    }

    public static void checkFinalizedVersionCopy(VersionCopyEditUI ownerUi, VersionCopyInfo versionCopyInfo) throws EASBizException, BOSException {
        if (versionCopyInfo == null || versionCopyInfo.getBgScheme() == null) {
            return;
        }
        String msg = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyVersionCopy(versionCopyInfo);
        if (!StringUtils.isEmpty((String)msg)) {
            MsgBox.showInfo((Component)((Object)ownerUi), (String)msg);
            SysUtil.abort();
        }
    }

    public static void checkFinalizedMbgQingAnalyseCalc(CoreUI coreUI, BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        if (bgSchemeInfo == null) {
            return;
        }
        boolean isFinalized = BgFinalizedFacadeFactory.getRemoteInstance().checkFinalizedbyBgScheme(bgSchemeInfo.getId().toString());
        if (isFinalized) {
            MsgBox.showInfo((Component)coreUI, (String)EASResource.getString((String)RES, (String)"checkMbgQingAnalyseCalc"));
            SysUtil.abort();
        }
    }

    public static void checkBgFormViewFinalized(CoreUI coreUI, String bgFormId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        boolean isFinalized = BgFinalizedFacadeFactory.getRemoteInstance().checkBgForm(bgFormId);
        if (!isFinalized) {
            MsgBox.showInfo((Component)coreUI, (String)EASResource.getString((String)RES, (String)"checkBgFormViewFinalized"));
            SysUtil.abort();
        }
    }

    public static void checkBgFormsUnFinalized(CoreUI coreUI, List bgFormIds) throws EASBizException, BOSException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        Set unFinalizedFormIds = BgFinalizedFacadeFactory.getRemoteInstance().checkBgForms(bgFormIds, false);
        if (unFinalizedFormIds != null && !unFinalizedFormIds.isEmpty()) {
            MsgBox.showInfo((Component)coreUI, (String)EASResource.getString((String)RES, (String)"checkBgFormsUnFinalized"));
            SysUtil.abort();
        }
    }

    public static void checkBgFormsFinalized(CoreUI coreUI, List bgFormIds) throws EASBizException, BOSException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        Set finalizedFormIds = BgFinalizedFacadeFactory.getRemoteInstance().checkBgForms(bgFormIds, true);
        if (finalizedFormIds != null && !finalizedFormIds.isEmpty()) {
            MsgBox.showInfo((Component)coreUI, (String)EASResource.getString((String)RES, (String)"checkBgFormsFinalized"));
            SysUtil.abort();
        }
    }

    public static void checkParentOrgBgFinalized(CoreUI coreUI, BgFinalizedInfo info) throws EASBizException, BOSException {
        String msg = BgFinalizedFacadeFactory.getRemoteInstance().checkParentOrgBgFinalized(info);
        if (!StringUtils.isEmpty((String)msg)) {
            MsgBox.showInfo((Component)coreUI, (String)msg);
            SysUtil.abort();
        }
    }

    public static void calcSchemeCourse(Component component, List<String> billIds, Map<String, String> auditParams, BOSUuid bgOrgViewId) throws Exception {
        UIContext uiContext = new UIContext((Object)component);
        uiContext.put((Object)"BILLIDS", billIds);
        uiContext.put((Object)"AUDITPARAMS", auditParams);
        uiContext.put((Object)"BGORGVIEWID", (Object)bgOrgViewId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgFinalizedCourseProgressUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, 16);
        uiWindow.show();
    }

    public static BgCalculateSchemeInfo getCalcSchemeByBgScheme(String bgSchemeId) throws EASBizException, BOSException {
        return BgFinalizedFacadeFactory.getRemoteInstance().getCalcSchemeByBgScheme(bgSchemeId);
    }
}

