/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgFormAuditFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgFormFacade;
import com.kingdee.eas.ma.mbg.client.AbstractBgFormAuditIdeaEditUI;
import com.kingdee.eas.ma.mbg.client.BgCourseProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFormAuditProcessUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormAuditIdeaEditUI
extends AbstractBgFormAuditIdeaEditUI {
    private static final long serialVersionUID = 1256787137985729524L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormAuditIdeaEditUI.class);
    private Component component;
    private boolean auditType = true;
    private boolean isCancel = true;

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setAuditType(boolean auditType) {
        this.auditType = auditType;
    }

    public boolean isAuditType() {
        return this.auditType;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    protected IObjectValue createNewData() {
        return new BgAuditIdeaInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAuditIdeaFactory.getRemoteInstance();
    }

    protected IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgFormFacade getFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        BgFormInfo bgFormInfo;
        super.onLoad();
        this.toolBar.setVisible(false);
        this.toolBar.setEnabled(false);
        this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        this.pkCreateTime.setValue((Object)new Timestamp(System.currentTimeMillis()));
        this.kDBizMultiLangArea.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        Object obj = this.getUIContext().get("BGFORM_PROCESSUI");
        if (obj != null && obj instanceof Component) {
            this.setComponent((Component)obj);
        }
        if ((obj = this.getUIContext().get("BGFORM_AUDIT_TYPE")) != null) {
            if ("BGFORM_AUDIT".equals(obj.toString())) {
                this.auditType = true;
            } else if ("BGFORM_ANTIAUDIT".equals(obj.toString())) {
                this.auditType = false;
            }
        }
        if ((bgFormInfo = this.getBgFormInfo()) != null) {
            String msg = null;
            msg = bgFormInfo.getState().getValue() == 35 || bgFormInfo.getState().getValue() == 4 ? BgNFCHelper.getMessageStr("adjustAudit") : BgNFCHelper.getMessageStr("formAudit");
            this.setUITitle(msg);
        }
    }

    private BgFormInfo getBgFormInfo() {
        if (this.getComponent() instanceof BgNFormAuditProcessUI) {
            return (BgFormInfo)((BgNFormAuditProcessUI)((Object)this.getComponent())).getEditData();
        }
        if (this.getComponent() instanceof MBGFormProcessUI) {
            return ((MBGFormProcessUI)((Object)this.getComponent())).getEditData();
        }
        if (this.getComponent() instanceof MbgViewListFormProcessUI) {
            return ((MbgViewListFormProcessUI)((Object)this.getComponent())).getEditData();
        }
        if (this.getComponent() instanceof BgCourseProcessUI) {
            return (BgFormInfo)((BgCourseProcessUI)((Object)this.getComponent())).getEditData();
        }
        return null;
    }

    @Override
    public void actionSubmitIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitIdea_actionPerformed(e);
        boolean isCancel = false;
        if (this.auditType) {
            isCancel = this.submitAuditIdea();
            if (this.kDRadioButtonNoPass.isSelected()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("passNotPass"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("pass"));
            }
        } else {
            this.unSubmitAuditIdea();
            MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("noPass"));
        }
        this.setCancel(isCancel);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancelIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelIdea_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.kDBizMultiLangArea.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() == null || this.kDBizMultiLangArea.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() == 0) {
            this.kDBizMultiLangArea.requestFocus(true);
            this.showWarning("inputIdea");
        }
    }

    private String getMessageStr(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", (String)key);
    }

    private void showWarning(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        MsgBox.showWarning((Component)((Object)this), (String)this.getMessageStr(key));
        SysUtil.abort();
    }

    protected boolean submitAuditIdea() throws Exception {
        if (this.getComponent() == null) {
            return false;
        }
        boolean isCancel = false;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo == null) {
            bgFormInfo = (BgFormInfo)this.getUIContext().get("BGFORM_INFO");
        }
        BgFormStateEnum bgFormStateEnum = bgFormInfo.getState();
        String message = this.kDBizMultiLangArea.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString();
        HashMap<String, String> auditParams = (HashMap<String, String>)this.getUIContext().get("AUDIT_PARAM");
        if (auditParams == null) {
            auditParams = new HashMap<String, String>();
        }
        auditParams.put("CHECK_REPORT", String.valueOf(false));
        auditParams.put("CHECK_EXAMINE", String.valueOf(false));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(false));
        auditParams.put("AUDIT_MESSAGE", message);
        try {
            if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo) || bgFormStateEnum.getValue() == 6) {
                if (this.kDRadioButtonPass.isSelected()) {
                    Map rs = BgAdjustFacadaFactory.getRemoteInstance().audit(bgFormInfo.getId().toString());
                    this.getFacadeInterface().submitAuditIdea(bgFormInfo.getAdjust().getId(), userInfo.getId(), bgFormStateEnum.getValue() == 6 ? BgAuditIdeaEnum.ROLLPASS : BgAuditIdeaEnum.ADJUSTPASS, message);
                    bgFormInfo.setState(BgFormStateEnum.History);
                } else if (this.kDRadioButtonNoPass.isSelected()) {
                    this.getFacadeInterface().submitAuditIdea(bgFormInfo.getAdjust().getId(), userInfo.getId(), bgFormStateEnum.getValue() == 6 ? BgAuditIdeaEnum.ROLLNOPASS : BgAuditIdeaEnum.ADJUSTNOPASS, message);
                }
            } else if (bgFormInfo.getState().getValue() == 1 || bgFormInfo.getState().getValue() == 41) {
                ArrayList<String> billIds;
                if (this.kDRadioButtonPass.isSelected()) {
                    billIds = new ArrayList<String>();
                    billIds.add(bgFormInfo.getId().toString());
                    BgFormAuditFacadeFactory.getRemoteInstance().audit(billIds, auditParams);
                } else if (this.kDRadioButtonNoPass.isSelected()) {
                    billIds = new ArrayList();
                    billIds.add(bgFormInfo.getId().toString());
                    if (bgFormInfo.getState().getValue() == 41) {
                        this.getFacadeInterface().submitAuditIdea(bgFormInfo.getId(), userInfo.getId(), BgAuditIdeaEnum.AUDITNOPASS, message);
                        isCancel = true;
                    } else {
                        BgFormAuditFacadeFactory.getRemoteInstance().unAudit(billIds, auditParams);
                        this.getFacadeInterface().submitAuditIdea(bgFormInfo.getId(), userInfo.getId(), BgAuditIdeaEnum.AUDITNOPASS, message);
                    }
                }
                BgFormInfo bgFormNewInfo = this.getFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId()), this.getSelectors());
                bgFormInfo.setState(bgFormNewInfo.getState());
                bgFormInfo.setLastUpdateTime(bgFormNewInfo.getLastUpdateTime());
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw ex;
        }
        return isCancel;
    }

    protected void unSubmitAuditIdea() throws Exception {
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        return sic;
    }
}

