/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.mbg.BgCommonException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgGatherViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.form.ActionReferBgForm;
import com.kingdee.eas.ma.mbg.utils.BgGatherViewInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class BgGatherViewUI
extends AbstractBgGatherViewUI {
    private static final long serialVersionUID = 3804168664005570241L;
    private static final Logger logger = CoreUIObject.getLogger(BgGatherViewUI.class);
    protected static final String COL_ORGUNITID = "orgUnit.id";
    protected static final String COL_PROCESSTYPE = "processType";
    protected static final String COL_ORGUNITNAME = "orgUnit.name";
    protected static final String COL_VALUE = "value";

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadGatherInfos();
    }

    protected void loadGatherInfos() throws Exception {
        List gatherInfos = (List)this.getUIContext().get("InitDataObject");
        if (gatherInfos == null || gatherInfos.isEmpty()) {
            throw new BgCommonException(BgCommonException.SELECTNOFOUNTGATHER);
        }
        BgGatherViewInfo info = (BgGatherViewInfo)gatherInfos.get(0);
        this.txtItemNumber.setText(info.getItemNumber());
        this.txtItemName.setText(info.getItemName());
        this.txtBgPeriod.setText(info.getPeriodName());
        this.txtBgElement.setText(info.getElementName());
        this.txtBgScenario.setText(info.getScenarioName());
        this.txtCurrency.setText(info.getCurrencyName());
        this.kDTable1.getColumn(COL_VALUE).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)info.getPrecision()));
        IRow row = null;
        for (int i = 0; i < gatherInfos.size(); ++i) {
            info = (BgGatherViewInfo)gatherInfos.get(i);
            row = this.kDTable1.addRow();
            row.setUserObject((Object)info);
            row.getCell(COL_ORGUNITID).setValue((Object)info.getBgOrgUnit().getOrgUnitID());
            row.getCell(COL_PROCESSTYPE).setValue((Object)info.getInfo().getSourceProcessType().getAlias());
            row.getCell(COL_ORGUNITNAME).setValue((Object)info.getBgOrgUnit().getName());
            row.getCell(COL_VALUE).setValue((Object)info.getInfo().getSourceValue());
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.kDTable1.checkParsed();
    }

    @Override
    protected void kDTable1_tableClicked(KDTMouseEvent e) throws Exception {
        super.kDTable1_tableClicked(e);
        if (e.getClickCount() != 2) {
            return;
        }
        this.btnViewBgForm_actionPerformed(null);
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.btnClose_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    protected void btnViewBgForm_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewBgForm_actionPerformed(e);
        if (this.kDTable1.getRowCount() == 0 || this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow row = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        ActionReferBgForm.referBgForm(this, (BgFormInfo)this.getUIContext().get("BGFORM_INFO"), (BgGatherViewInfo)row.getUserObject());
    }
}

