/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.IVirtualAnalyseBaseFacade;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitVirtualModelFacadeFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgMultiDecomposeGatherUI;
import com.kingdee.eas.ma.mbg.client.utils.BgSheetSelectDialog;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgGatherOrgUnitInfo;
import com.kingdee.eas.ma.mbg.utils.BgMultiDecomposeGatherFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitVirtualModeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitVirtualModelFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgMultiDecomposeGatherUI
extends AbstractBgMultiDecomposeGatherUI {
    private static final Logger logger = CoreUIObject.getLogger(BgMultiDecomposeGatherUI.class);
    protected Object ui = null;
    public static final String COL_CHOOSE = "choose";
    public static final String COL_ID = "id";
    public static final String COL_NUMBER = "number";
    public static final String COL_LONGNUMBER = "longNumber";
    public static final String COL_NAME = "name";
    public static final String COL_C01 = "C01";
    public static final String COL_C02 = "C02";
    public static final String COL_C04 = "C04";
    public static final String COL_ISENABLE = "isEnable";
    public static final String COL_ISLEAF = "isLeaf";
    public static final String COL_LEVEL = "level";
    public static final String COL_COMPANYORGUNIT = "isCompanyOrgUnit";
    protected KDButtonGroup kDButtonGroup;
    private BgFormInfo bgFormInfo = null;
    private Book book = null;
    private boolean isCancel = true;
    public static final String BGFORMINFO = "BGFORMINFO";
    public static final String BOOK = "BOOK";
    public static final String ISSINGLEFORM = "ISSINGLEFORM";
    private boolean isSingleForm = true;
    private BgSchemeDimensionHelper schemeHelper = null;
    private NumberExpandHelper numberHelper = null;
    private BgOrgUnitVirtualModeHelper orgVirtualHelper = null;
    private static final String CUST_CALCSUBBIZCALC = "CUST_CALCSUBBIZCALC";
    private static final String CUST_TGATHERORGUNITINFOS = "CUST_TGATHERORGUNITINFOS";
    private static final String CUST_ORGUNIT = "CUST_ORGUNIT";
    private static final String CUST_CLEARPEEKFORMULA = "CUST_CLEARPEEKFORMULA";
    private Map<String, BgOrgUnitInfo> orgUnitInfos = new HashMap<String, BgOrgUnitInfo>();

    public BgMultiDecomposeGatherUI() throws Exception {
    }

    public BgMultiDecomposeGatherUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void onLoad() throws Exception {
        this.bgFormInfo = (BgFormInfo)this.getUIContext().get(BGFORMINFO);
        if (this.getUIContext().get(ISSINGLEFORM) != null) {
            this.isSingleForm = (Boolean)this.getUIContext().get(ISSINGLEFORM);
        }
        if (this.isSingleForm) {
            this.book = (Book)this.getUIContext().get(BOOK);
        }
        this.schemeHelper = new BgSchemeDimensionHelper(this.bgFormInfo.getBgScheme().getId().toString());
        this.loadSearchType();
        this.getNumberExpandHelper();
        this.initOrgVirtualModeHelper();
        super.onLoad();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtFilterOrg, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtFilterOrg.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgMultiDecomposeGatherUI.this.btnQuery_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ((CoreUI)BgMultiDecomposeGatherUI.this.ui).handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        this.init();
    }

    private NumberExpandHelper getNumberExpandHelper() {
        if (this.numberHelper == null) {
            this.numberHelper = new NumberExpandHelper((CoreUI)this.ui, this.tbMain);
        }
        return this.numberHelper;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void initOrgVirtualModeHelper() {
        BgCommHelper.removeEditHelper((KDTable)this.tbMain);
        try {
            this.orgVirtualHelper = new BgOrgUnitVirtualModeHelper((CoreUI)this.ui, this.tbMain, (IVirtualAnalyseBaseFacade)BgOrgUnitVirtualModelFacadeFactory.getRemoteInstance(), new BgOrgUnitVirtualModelFilterParam(this.getOrgUnitSelector(), this.schemeHelper.getBgOrgViewId()));
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            ((CoreUI)this.ui).handUIException((Throwable)e1);
        }
        this.tbMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BgMultiDecomposeGatherUI.this.tbMain_afterDataFill(e);
            }
        });
    }

    private SelectorItemCollection getOrgUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_NUMBER);
        sic.add(COL_LONGNUMBER);
        sic.add(COL_NAME);
        sic.add(COL_ISLEAF);
        sic.add(COL_LEVEL);
        sic.add(COL_COMPANYORGUNIT);
        sic.add(COL_ISENABLE);
        return sic;
    }

    private void tbMain_afterDataFill(KDTDataRequestEvent e) {
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            if (((Number)this.tbMain.getCell(r, COL_ISENABLE).getValue()).intValue() == 1) continue;
            this.tbMain.getRow(r).getStyleAttributes().setLocked(true);
            this.tbMain.getCell(r, COL_CHOOSE).setValue((Object)" ");
            this.tbMain.getCell(r, COL_C01).setValue((Object)"");
            this.tbMain.getCell(r, COL_C02).setValue((Object)"");
            this.tbMain.getCell(r, COL_C04).setValue((Object)"");
        }
    }

    private void init() throws BOSException, EASBizException {
        this.queryOrgUnit(this.bgFormInfo.getOrgUnit().getId().toString());
        this.initC01();
        if (this.isSingleForm) {
            this.initSheetName();
        }
        this.initWorkButton();
    }

    private void initC01() {
        for (int i = 0; i < this.tbMain.getRowCount(); ++i) {
            IRow row = this.tbMain.getRow(i);
            if (((Number)this.tbMain.getCell(i, COL_ISENABLE).getValue()).intValue() == 1) {
                row.getCell(COL_C01).setValue((Object)true);
                row.getCell(COL_C02).setValue((Object)false);
                row.getCell(COL_C04).setValue((Object)false);
            }
            if (((Number)this.tbMain.getCell(i, COL_ISLEAF).getValue()).intValue() == 1) {
                row.getCell(COL_C02).getStyleAttributes().setLocked(true);
                row.getCell(COL_C04).getStyleAttributes().setLocked(true);
                row.getCell(COL_C02).getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
                row.getCell(COL_C04).getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
            }
            if (i == 0) continue;
            row.getCell(COL_CHOOSE).setValue((Object)false);
        }
    }

    @Override
    protected void tbMain_editValueChanged(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex < 0 || rowIndex < 0) {
            return;
        }
        String columnKey = this.tbMain.getColumn(colIndex).getKey();
        if (COL_C01.equals(columnKey) || COL_C02.equals(columnKey) || COL_C04.equals(columnKey)) {
            if (e.getOldValue().equals(e.getValue())) {
                return;
            }
            Object value = e.getValue();
            if (value != null && value instanceof Boolean) {
                Boolean currentValue = (Boolean)value;
                this.setCheck(rowIndex, colIndex, COL_C01, currentValue);
                this.setCheck(rowIndex, colIndex, COL_C02, currentValue);
                this.setCheck(rowIndex, colIndex, COL_C04, currentValue);
            }
        }
    }

    @Override
    protected void tbMain_editStopped(KDTEditEvent e) throws Exception {
    }

    private void setCheck(int rowIndex, int colIndex, String columnKey, boolean isCheck) {
        ICell cell = this.tbMain.getRow(rowIndex).getCell(columnKey);
        if (cell != null && isCheck && cell.getColumnIndex() != colIndex) {
            cell.setValue((Object)(!isCheck ? 1 : 0));
        }
    }

    private void initSheetName() {
        BgSheetSelectDialog f7 = new BgSheetSelectDialog((Object)this, this.book, this.prmtSheetRange, false);
        this.prmtSheetRange.setValue((Object)new String[]{this.book.getActiveSheet().getSheetName()});
    }

    private void queryOrgUnit(String orgUnitId) throws BOSException, EASBizException {
        this.orgVirtualHelper.getFilterParam().setSearchValue(this.txtFilterOrg.getText().trim());
        this.orgVirtualHelper.getFilterParam().setSearchKey(((SearchType)this.comboBox.getSelectedItem()).number);
        this.orgVirtualHelper.getFilterParam().setOrgUnitId(orgUnitId);
        this.orgVirtualHelper.doQuery((FilterParam)this.orgVirtualHelper.getFilterParam());
    }

    private void loadSearchType() {
        this.tbMain.checkParsed();
        for (int i = 0; i < this.tbMain.getColumnCount(); ++i) {
            IColumn col = this.tbMain.getColumn(i);
            if (col.getStyleAttributes().isHided() || !COL_NUMBER.equals(col.getKey()) && !COL_NAME.equals(col.getKey())) continue;
            this.comboBox.addItem((Object)new SearchType(col.getKey(), (String)this.tbMain.getHeadRow(0).getCell(i).getValue()));
        }
    }

    private void initWorkButton() {
        if (!this.isSingleForm) {
            this.rbAllSheet.setEnabled(false);
            this.rbSelectSheet.setEnabled(false);
            this.prmtSheetRange.setEnabled(false);
        } else if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)this.bgFormInfo.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)this.bgFormInfo.getFormType())) {
            this.cbxClearExpression.setVisible(true);
        } else {
            this.cbxClearExpression.setVisible(false);
            this.cbxClearExpression.setSelected(false);
        }
        this.btnSelectAll.addAssistMenuItem((Action)((Object)this.actionSelectAll_All));
        this.btnSelectAll.addAssistMenuItem((Action)((Object)this.actionSelectAll_Direct));
        this.btnSelectAll.addAssistMenuItem((Action)((Object)this.actionSelectAll_Leaf));
        this.btnSelectAll.addAssistMenuItem((Action)((Object)this.actionSelectAll_Fin));
    }

    @Override
    protected void rbAllSheet_actionPerformed(ActionEvent e) throws Exception {
        this.prmtSheetRange.setEnabled(false);
    }

    @Override
    protected void rbSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        this.prmtSheetRange.setEnabled(true);
    }

    @Override
    protected void prmtSheetRange_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            this.prmtSheetRange.setValue(e.getOldValue());
        }
    }

    @Override
    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgMultiDecomposeGatherFilterParam) {
            BgMultiDecomposeGatherFilterParam _filterParam = (BgMultiDecomposeGatherFilterParam)filterParam;
            _filterParam.setCalcSubBizCalc(this.cbxCalcSubBizCalc.isSelected());
            _filterParam.setOrgUnitId(this.bgFormInfo.getOrgUnit().getId().toString());
            _filterParam.setClearExpression(this.cbxClearExpression.isSelected());
            HashMap<String, BgGatherOrgUnitInfo> gatherOrgUnitInfos = new HashMap<String, BgGatherOrgUnitInfo>(this.tbMain.getRowCount());
            for (int i = 0; i < this.tbMain.getRowCount(); ++i) {
                IRow row = this.tbMain.getRow(i);
                if (row != null) {
                    BgGatherOrgUnitInfo gatherInfo = new BgGatherOrgUnitInfo();
                    gatherInfo.setChoose(row.getCell(COL_CHOOSE).getValue());
                    gatherInfo.setId(row.getCell(COL_ID).getValue().toString());
                    gatherInfo.setIsEnable(Integer.parseInt(row.getCell(COL_ISENABLE).getValue().toString()));
                    if (row.getCell(COL_C01).getValue() instanceof Boolean && ((Boolean)row.getCell(COL_C01).getValue()).booleanValue()) {
                        gatherInfo.setBgProcessEnum((Object)BgProcessEnum.C01);
                    } else if (row.getCell(COL_C02).getValue() instanceof Boolean && ((Boolean)row.getCell(COL_C02).getValue()).booleanValue()) {
                        gatherInfo.setBgProcessEnum((Object)BgProcessEnum.C02);
                    } else if (row.getCell(COL_C04).getValue() instanceof Boolean && ((Boolean)row.getCell(COL_C04).getValue()).booleanValue()) {
                        gatherInfo.setBgProcessEnum((Object)BgProcessEnum.C04);
                    } else {
                        gatherInfo.setBgProcessEnum("");
                    }
                    gatherOrgUnitInfos.put(gatherInfo.getId(), gatherInfo);
                }
                _filterParam.setGatherOrgUnitInfos(gatherOrgUnitInfos);
            }
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        if (cp == null || filterParam == null || !(filterParam instanceof BgMultiDecomposeGatherFilterParam)) {
            return;
        }
        BgMultiDecomposeGatherFilterParam _filterParam = (BgMultiDecomposeGatherFilterParam)filterParam;
        Boolean calcSubBizCalc = _filterParam.isCalcSubBizCalc();
        cp.addCustomerParam(CUST_CALCSUBBIZCALC, calcSubBizCalc.toString());
        Map<String, BgGatherOrgUnitInfo> gatherOrgUnitInfos = _filterParam.getGatherOrgUnitInfos();
        cp.addCustomerParam(CUST_TGATHERORGUNITINFOS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(gatherOrgUnitInfos)));
        String orgUnitId = _filterParam.getOrgUnitId();
        cp.addCustomerParam(CUST_ORGUNIT, orgUnitId);
        boolean clearPeekFormula = _filterParam.isClearExpression();
        cp.addCustomerParam(CUST_CLEARPEEKFORMULA, Boolean.toString(clearPeekFormula));
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgMultiDecomposeGatherFilterParam)) {
            return;
        }
        BgMultiDecomposeGatherFilterParam _filterParam = (BgMultiDecomposeGatherFilterParam)filterParam;
        Map tmpList = (Map)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(CUST_TGATHERORGUNITINFOS)));
        _filterParam.setGatherOrgUnitInfos(tmpList);
        String calcSubBizCalc = cp.getCustomerParam(CUST_CALCSUBBIZCALC);
        _filterParam.setCalcSubBizCalc(Boolean.parseBoolean(calcSubBizCalc));
        String orgUnitId = cp.getCustomerParam(CUST_ORGUNIT);
        _filterParam.setOrgUnitId(orgUnitId);
        String clearPeekFormula = cp.getCustomerParam(CUST_CLEARPEEKFORMULA);
        _filterParam.setClearExpression(Boolean.parseBoolean(clearPeekFormula));
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgMultiDecomposeGatherFilterParam();
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgMultiDecomposeGatherFilterParam) {
            BgMultiDecomposeGatherFilterParam _filterParam = (BgMultiDecomposeGatherFilterParam)filterParam;
            this.cbxCalcSubBizCalc.setSelected(_filterParam.isCalcSubBizCalc());
            this.cbxClearExpression.setSelected(_filterParam.isClearExpression());
            Map<String, BgGatherOrgUnitInfo> gatherOrgUnitInfos = _filterParam.getGatherOrgUnitInfos();
            String orgUnitId = _filterParam.getOrgUnitId();
            Map<Object, Object> bgOrgMap = new HashMap();
            try {
                bgOrgMap = this.getBgOrgMap();
                if (this.bgFormInfo != null && this.bgFormInfo.getOrgUnit() != null) {
                    this.queryOrgUnit(this.bgFormInfo.getOrgUnit().getId().toString());
                } else {
                    this.queryOrgUnit(orgUnitId);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.initC01();
            if (gatherOrgUnitInfos != null) {
                for (int i = 0; i < this.tbMain.getRowCount(); ++i) {
                    IRow row = this.tbMain.getRow(i);
                    String id = row.getCell(COL_ID).getValue().toString();
                    BgGatherOrgUnitInfo gatherOrgUnitInfo = gatherOrgUnitInfos.get(id);
                    if (gatherOrgUnitInfo != null) {
                        if (bgOrgMap.containsKey(gatherOrgUnitInfo.getId()) && this.bgFormInfo != null && this.bgFormInfo.getOrgUnit() != null && ((BgOrgUnitInfo)bgOrgMap.get(gatherOrgUnitInfo.getId())).getOrgUnitID().equals(this.bgFormInfo.getOrgUnit().getId().toString())) {
                            row.getCell(COL_CHOOSE).setValue((Object)"");
                            row.getCell(COL_ID).setValue((Object)gatherOrgUnitInfo.getId());
                            row.getCell(COL_C04).setValue((Object)"");
                            row.getCell(COL_C01).setValue((Object)"");
                            row.getCell(COL_C02).setValue((Object)"");
                            continue;
                        }
                        row.getCell(COL_ID).setValue((Object)gatherOrgUnitInfo.getId());
                        if (gatherOrgUnitInfo.getChoose() != null && StringUtils.isEmpty((String)gatherOrgUnitInfo.getChoose().toString())) {
                            row.getCell(COL_CHOOSE).setValue((Object)false);
                            row.getCell(COL_C01).setValue((Object)true);
                            row.getCell(COL_C02).setValue((Object)false);
                            row.getCell(COL_C04).setValue((Object)false);
                            continue;
                        }
                        row.getCell(COL_CHOOSE).setValue(gatherOrgUnitInfo.getChoose());
                        Object bgProcessEnum = gatherOrgUnitInfo.getBgProcessEnum();
                        if (BgProcessEnum.C01.equals(bgProcessEnum)) {
                            row.getCell(COL_C01).setValue((Object)true);
                            row.getCell(COL_C02).setValue((Object)false);
                            row.getCell(COL_C04).setValue((Object)false);
                            continue;
                        }
                        if (BgProcessEnum.C02.equals(bgProcessEnum)) {
                            row.getCell(COL_C02).setValue((Object)true);
                            row.getCell(COL_C01).setValue((Object)false);
                            row.getCell(COL_C04).setValue((Object)false);
                            continue;
                        }
                        if (BgProcessEnum.C04.equals(bgProcessEnum)) {
                            row.getCell(COL_C04).setValue((Object)true);
                            row.getCell(COL_C01).setValue((Object)false);
                            row.getCell(COL_C02).setValue((Object)false);
                            continue;
                        }
                        if (i != 0) {
                            row.getCell(COL_C04).setValue((Object)false);
                            row.getCell(COL_C01).setValue((Object)false);
                            row.getCell(COL_C02).setValue((Object)false);
                            continue;
                        }
                        row.getCell(COL_C04).setValue((Object)"");
                        row.getCell(COL_C01).setValue((Object)"");
                        row.getCell(COL_C02).setValue((Object)"");
                        continue;
                    }
                    if (i == 0) {
                        row.getCell(COL_CHOOSE).setValue((Object)"");
                        row.getCell(COL_C01).setValue((Object)"");
                        row.getCell(COL_C02).setValue((Object)"");
                        row.getCell(COL_C04).setValue((Object)"");
                        continue;
                    }
                    row.getCell(COL_CHOOSE).setValue((Object)false);
                    row.getCell(COL_C01).setValue((Object)true);
                    row.getCell(COL_C02).setValue((Object)false);
                    row.getCell(COL_C04).setValue((Object)false);
                }
            }
        }
    }

    public boolean isCalcBiz() {
        return this.cbxCalcSubBizCalc.isSelected();
    }

    public boolean isClearExpression() {
        return this.cbxClearExpression.isSelected();
    }

    public String[] getSheetNames() {
        if (this.rbAllSheet.isSelected()) {
            return null;
        }
        return (String[])this.prmtSheetRange.getData();
    }

    protected Map<String, BgOrgUnitInfo> getBgOrgMap() throws BOSException {
        HashMap<String, BgOrgUnitInfo> bgOrgMap = new HashMap<String, BgOrgUnitInfo>();
        HashSet<String> bgOrgIds = new HashSet<String>();
        for (int i = 0; i < this.tbMain.getRowCount(); ++i) {
            IRow row = this.tbMain.getRow(i);
            String id = row.getCell(COL_ID).getValue().toString();
            if (StringUtils.isEmpty((String)id)) continue;
            bgOrgIds.add(id);
        }
        if (!bgOrgIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(COL_ID);
            selector.add(COL_NUMBER);
            selector.add(COL_LONGNUMBER);
            selector.add(COL_NAME);
            selector.add("orgUnitID");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(COL_ID, bgOrgIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)this.schemeHelper.getBgOrgViewId(), CompareType.EQUALS));
            view.setFilter(filter);
            BgOrgUnitCollection coll = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
            if (coll != null && !coll.isEmpty()) {
                for (int i = 0; i < coll.size(); ++i) {
                    bgOrgMap.put(coll.get(i).getId().toString(), coll.get(i));
                }
            }
        }
        return bgOrgMap;
    }

    public Map<BgProcessEnum, Set<String>> getSelectOrgUnitIds() {
        Map<Object, Object> bgOrgMap = new HashMap();
        try {
            bgOrgMap = this.getBgOrgMap();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        HashMap<BgProcessEnum, Set<String>> selectIds = new HashMap<BgProcessEnum, Set<String>>();
        for (int i = 0; i < this.tbMain.getRowCount(); ++i) {
            boolean _choose;
            IRow row = this.tbMain.getRow(i);
            Object choose = row.getCell(COL_CHOOSE).getValue();
            if (choose == null || !(choose instanceof Boolean) || !(_choose = ((Boolean)choose).booleanValue())) continue;
            String id = row.getCell(COL_ID).getValue().toString();
            if (((Boolean)row.getCell(COL_C02).getValue()).booleanValue()) {
                if (!selectIds.containsKey((Object)BgProcessEnum.C02)) {
                    selectIds.put(BgProcessEnum.C02, new HashSet());
                }
                ((Set)selectIds.get((Object)BgProcessEnum.C02)).add(((BgOrgUnitInfo)bgOrgMap.get(id)).getOrgUnitID());
                continue;
            }
            if (((Boolean)row.getCell(COL_C04).getValue()).booleanValue()) {
                if (!selectIds.containsKey((Object)BgProcessEnum.C04)) {
                    selectIds.put(BgProcessEnum.C04, new HashSet());
                }
                ((Set)selectIds.get((Object)BgProcessEnum.C04)).add(((BgOrgUnitInfo)bgOrgMap.get(id)).getOrgUnitID());
                continue;
            }
            if (!selectIds.containsKey((Object)BgProcessEnum.C01)) {
                selectIds.put(BgProcessEnum.C01, new HashSet());
            }
            ((Set)selectIds.get((Object)BgProcessEnum.C01)).add(((BgOrgUnitInfo)bgOrgMap.get(id)).getOrgUnitID());
        }
        try {
            this.convertOrgUnitInfos(selectIds);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return selectIds;
    }

    public Map<String, BgOrgUnitInfo> getOrgUnitInfos() {
        return this.orgUnitInfos;
    }

    private void convertOrgUnitInfos(Map<BgProcessEnum, Set<String>> selectIds) throws BOSException {
        HashSet orgUnitIds = new HashSet();
        Collection<Set<String>> values = selectIds.values();
        Iterator<Set<String>> iter = values.iterator();
        while (iter.hasNext()) {
            orgUnitIds.addAll(iter.next());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(COL_ID);
        selector.add(COL_NUMBER);
        selector.add(COL_LONGNUMBER);
        selector.add(COL_NAME);
        selector.add("orgUnitID");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", orgUnitIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)this.schemeHelper.getBgOrgViewId(), CompareType.EQUALS));
        view.setFilter(filter);
        BgOrgUnitCollection coll = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
        Iterator iter2 = coll.iterator();
        while (iter2.hasNext()) {
            BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)iter2.next();
            this.orgUnitInfos.put(bgOrgUnitInfo.getOrgUnitID(), bgOrgUnitInfo);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.clearOrSelectAll(true);
    }

    @Override
    public void actionCancelAll_actionPerformed(ActionEvent e) throws Exception {
        this.clearOrSelectAll(false);
    }

    private void clearOrSelectAll(boolean isSelect) {
        for (int r = 0; r < this.tbMain.getRowCount(); ++r) {
            IRow row = this.tbMain.getRow(r);
            if (row == null || row.getStyleAttributes().isLocked()) continue;
            row.getCell(COL_CHOOSE).setValue((Object)isSelect);
        }
    }

    @Override
    public void actionSelectAll_Fin_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit(false, true, false);
    }

    @Override
    public void actionSelectAll_Direct_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit(false, false, false);
    }

    @Override
    public void actionSelectAll_All_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit(true, false, false);
    }

    @Override
    public void actionSelectAll_Leaf_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit(false, false, true);
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        String number = ((SearchType)this.comboBox.getSelectedItem()).number;
        String filterText = this.txtFilterOrg.getText().trim();
        for (int i = 0; i < this.tbMain.getRowCount(); ++i) {
            IRow row = this.tbMain.getRow(i);
            if (i == 0) continue;
            if (StringUtils.isEmpty((String)filterText)) {
                row.getStyleAttributes().setHided(false);
                continue;
            }
            ICell cell = row.getCell(number);
            if (cell.getValue().toString().contains(filterText)) {
                row.getStyleAttributes().setHided(false);
                continue;
            }
            row.getStyleAttributes().setHided(true);
        }
    }

    private void selectOrgUnit(boolean isAll, boolean isCompanyOrgUnt, boolean isLeaf) throws EASBizException, BOSException {
        if (this.tbMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        IRow row = this.tbMain.getRow(this.tbMain.getSelectManager().getActiveRowIndex());
        String longNumber = (String)row.getCell(COL_LONGNUMBER).getValue();
        String thisLongNumber = null;
        for (int r = this.tbMain.getSelectManager().getActiveRowIndex(); r < this.tbMain.getRowCount() && ((thisLongNumber = (String)(row = this.tbMain.getRow(r)).getCell(COL_LONGNUMBER).getValue()).equals(longNumber) || thisLongNumber.startsWith(longNumber + "!")); ++r) {
            if (row.getStyleAttributes().isHided() || row.getStyleAttributes().isLocked() || (isCompanyOrgUnt ? Integer.parseInt(row.getCell(COL_COMPANYORGUNIT).getValue().toString()) == 0 : (isLeaf ? Integer.parseInt(row.getCell(COL_ISLEAF).getValue().toString()) == 0 : !thisLongNumber.equals(longNumber) && !isAll && thisLongNumber.substring(longNumber.length() + 1).indexOf("!") > 0))) continue;
            row.getCell(COL_CHOOSE).setValue((Object)true);
        }
    }

    public boolean verify() {
        boolean verify = super.verify();
        if (verify) {
            verify = this.checkSelected4C01();
        }
        return verify;
    }

    private Boolean checkSelected4C01() {
        boolean _choose;
        Object choose;
        IRow row;
        int i;
        HashSet<String> numbers = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        boolean hasSelectOrg = false;
        int in = 0;
        for (i = this.tbMain.getRowCount() - 1; i >= in; --i) {
            String[] split;
            String longNumber;
            Object value;
            row = this.tbMain.getRow(i);
            if (i == 0 || (choose = row.getCell(COL_CHOOSE).getValue()) == null || !(choose instanceof Boolean) || !(_choose = ((Boolean)choose).booleanValue()) || (value = row.getCell(COL_C01).getValue()) == null || !(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            Boolean _val = (Boolean)value;
            String number = ((NumberExpandInfo)row.getCell(COL_NUMBER).getValue()).getNumber();
            if (numbers.contains(number)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"checkSubOrg4C01"));
                return false;
            }
            if (!_val.booleanValue() || StringUtils.isEmpty((String)(longNumber = (String)row.getCell(COL_LONGNUMBER).getValue()))) continue;
            for (String str : split = longNumber.split("!")) {
                numbers.add(str);
            }
        }
        in = this.tbMain.getRowCount();
        for (i = 0; i <= in - 1; ++i) {
            row = this.tbMain.getRow(i);
            if (i == 0 || (choose = row.getCell(COL_CHOOSE).getValue()) == null || !(choose instanceof Boolean) || !(_choose = ((Boolean)choose).booleanValue())) continue;
            String id = row.getCell(COL_ID).getValue().toString();
            String number = ((NumberExpandInfo)row.getCell(COL_NUMBER).getValue()).getNumber();
            String name = row.getCell(COL_NAME).getValue().toString();
            boolean checkSelectedProcess = false;
            if (((Boolean)row.getCell(COL_C01).getValue()).booleanValue() || ((Boolean)row.getCell(COL_C02).getValue()).booleanValue() || ((Boolean)row.getCell(COL_C04).getValue()).booleanValue()) {
                checkSelectedProcess = true;
            }
            hasSelectOrg = true;
            if (checkSelectedProcess) continue;
            sb.append(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"gather.select.item", (Object[])new Object[]{i + 1, number + "(" + name + ")"}) + "\r\n");
        }
        if (sb.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"gather.select.processType"), (String)sb.toString(), (int)1);
            return false;
        }
        if (!hasSelectOrg) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"gather.select.org"));
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        try {
            this.queryOrgUnit(this.bgFormInfo.getOrgUnit().getId().toString());
            this.initC01();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionMultiGather");
    }

    private class SearchType {
        String number = null;
        String name = null;

        public SearchType(String number, String name) {
            this.number = number;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

