/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.Excel2007Reader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgNFormImportUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgNFormImportUI
extends AbstractBgNFormImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BgNFormImportUI.class);
    public static final String BGFROM = "BGFROM";
    public static final String MEASUREUNITMAP = "MeasureUnitMap";
    public static final String FORMULAMAP = "formulaMap";
    public static final String MENUITEMDEALREPLACE = "menuItemDealReplace";
    public static final String MENUITEMMEASREPLACE = "menuItemMeasReplace";
    public static final String BOOK = "book";
    public static final String ISVIEWLIST = "isViewList";
    public static final String UIOBJECT = "uiObject";
    private BgFormInfo bgform = null;
    private Map measureUnitMap = null;
    private Map formulaMap = null;
    private boolean isMenuItemDealReplace = false;
    private boolean isMenuItemMeasReplace = false;
    private Book book = null;
    private KDSBook Kdsbook = null;
    SheetListPanel _pnlSheet = null;

    public KDSBook getKdsbook() {
        return this.Kdsbook;
    }

    public void setKdsbook(KDSBook kdsbook) {
        this.Kdsbook = kdsbook;
    }

    public BgFormInfo getBgFormInfo() {
        return this.bgform;
    }

    public Map getMeasureUnitMap() {
        return this.measureUnitMap;
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public boolean isMenuItemDealReplace() {
        return this.isMenuItemDealReplace;
    }

    public boolean isMenuItemMeasReplace() {
        return this.isMenuItemMeasReplace;
    }

    public Book getBook() {
        return this.book;
    }

    public void onLoad() throws Exception {
        boolean isViewList;
        super.onLoad();
        this.setPreferredSize(new Dimension(500, 360));
        this.bgform = this.getUIContext().get(BGFROM) instanceof BgFormInfo ? (BgFormInfo)this.getUIContext().get(BGFROM) : null;
        this.measureUnitMap = this.getUIContext().get(MEASUREUNITMAP) instanceof Map ? (Map)this.getUIContext().get(MEASUREUNITMAP) : null;
        this.formulaMap = this.getUIContext().get(FORMULAMAP) instanceof Map ? (Map)this.getUIContext().get(FORMULAMAP) : null;
        this.isMenuItemDealReplace = this.getUIContext().get(MENUITEMDEALREPLACE) instanceof Boolean ? (Boolean)this.getUIContext().get(MENUITEMDEALREPLACE) : false;
        this.isMenuItemMeasReplace = this.getUIContext().get(MENUITEMMEASREPLACE) instanceof Boolean ? (Boolean)this.getUIContext().get(MENUITEMMEASREPLACE) : false;
        this.book = this.getUIContext().get(BOOK) instanceof Book ? (Book)this.getUIContext().get(BOOK) : null;
        this.txtFilepath.setEditable(false);
        boolean bl = isViewList = (Boolean)this.getUIContext().get(ISVIEWLIST) instanceof Boolean ? (Boolean)this.getUIContext().get(ISVIEWLIST) : false;
        if (isViewList) {
            this.rbDataANDExpression.setEnabled(false);
        }
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new BgFileUtil().getFileChooserForImp((Object)this.getUIContext());
        fileChooser.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "fileImport"));
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setFileFilter((FileFilter)new Excel2007FileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            File file = fileChooser.getSelectedFile();
            if (file != null && file.isFile()) {
                this.txtFilepath.setText(file.getPath());
                this.txtFilepath.setUserObject((Object)file);
            }
            if (!file.exists()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
                SysUtil.abort();
            }
            String fileName = file.getPath();
            String sen = GlobalFunction.getFileExtension((String)fileName);
            KDSBook books = null;
            if (sen.equals("xlsx")) {
                books = POIXlsxReader.parse2((String)fileName);
                if (books == null) {
                    books = new Excel2007Reader().parse(fileName);
                }
            } else {
                books = POIXlsReader.parse((String)fileName);
            }
            this.setKdsbook(books);
            this.kDSheetPanel.removeAll();
            this.clearPnlSheet();
            if (books != null && books.getSheetCount() > 0 && books != null && books.getSheetCount() > 0) {
                this.kDSheetPanel.setVisible(false);
                this._pnlSheet = new SheetListPanel();
                this.add((Component)((Object)this._pnlSheet));
                this._pnlSheet.setLocation(219, 98);
                this._pnlSheet.setData(KDSBookToBook.traslate((KDSBook)books));
            }
        }
    }

    protected void clearPnlSheet() {
        int count = this.getComponentCount();
        for (int i = count - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof SheetListPanel)) continue;
            this.remove(component);
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        Object fileObj;
        if (StringUtils.isEmpty((String)this.txtFilepath.getText()) || this.txtFilepath.getUserObject() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"filePathNotNull"));
            SysUtil.abort();
        }
        if (this.getSelectedSheets().length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"selectSheet"));
            SysUtil.abort();
        }
        if ((fileObj = this.txtFilepath.getUserObject()) instanceof File && (file = (File)fileObj).isFile()) {
            String fileName = file.getPath();
            String sen = GlobalFunction.getFileExtension((String)fileName);
            KDSBook books = null;
            if (sen.equals("xlsx")) {
                books = POIXlsxReader.parse((String)fileName);
                if (books == null) {
                    try {
                        books = new Excel2007Reader().parse(fileName);
                    }
                    catch (Exception exception) {}
                }
            } else {
                books = POIXlsReader.parse((String)fileName);
            }
            try {
                this.importBookContent(books);
                new BgFileUtil().storeDefaultPathForIMP((Object)this.txtFilepath, (Object)this.getUIContext());
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw new BgNFormException(BgNFormException.FILEIMPORTERROR);
            }
        }
        this.getUIWindow().close();
        ((CoreUI)this.getUIContext().get("Owner")).setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
        ((CoreUI)this.getUIContext().get("Owner")).showMessage();
    }

    @Override
    protected void kDSelectAll_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText()) || this.txtFilepath.getUserObject() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"filePathNotNull"));
            SysUtil.abort();
        }
        this._pnlSheet.setAllSelected(true);
    }

    @Override
    protected void kDUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText()) || this.txtFilepath.getUserObject() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"filePathNotNull"));
            SysUtil.abort();
        }
        this._pnlSheet.setAllSelected(false);
    }

    protected void importBookContent(KDSBook kdsBook) throws Exception {
        if (kdsBook == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
            SysUtil.abort();
        }
        Book _book = this.getBook();
        BigDecimal _coefficient = this.getBgFormInfo().getMeasureUnit() != null ? this.getBgFormInfo().getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("IMPORT_BOOK", _book);
        _tmpMap.put("IMPORT_KDSBOOK", kdsBook);
        _tmpMap.put("IMPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("IMPORT_MEASUREUNIT", this.getMeasureUnitMap());
        _tmpMap.put("IMPORT_BGFORMULA", this.getFormulaMap());
        _tmpMap.put("IMPORT_SHEET", this.getSelectedSheets());
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)this.getBgFormInfo().getBgTemplate().getFormType())) {
            _tmpMap.put("bgSpecialItems", (Object)this.getBgFormInfo().getBgSpecialItems());
        }
        if (this.isMenuItemDealReplace()) {
            _tmpMap.put("IMPORT_DATA", Boolean.FALSE);
        } else if (this.isMenuItemMeasReplace()) {
            _tmpMap.put("IMPORT_DATA", Boolean.TRUE);
        }
        if (this.rbDataANDExpression.isSelected()) {
            BgNFCHelper.importExcel(_tmpMap);
        } else if (this.rbData.isSelected()) {
            BgNFCHelper.importExcel(_tmpMap, false);
        }
    }

    String[] getSelectedSheets() {
        return this._pnlSheet.getSelectedSheets();
    }

    private class SheetListPanel
    extends KDScrollPane {
        private KDPanel _pnlList;
        private Book _book;

        SheetListPanel() {
            this.setSize(272, 220);
            this.getVerticalScrollBar().setUnitIncrement(25);
            this.getHorizontalScrollBar().setUnitIncrement(25);
            this._pnlList = new KDPanel();
            this._pnlList.setBorder((Border)BorderFactory.createTitledBorder(BgNFormImportUI.this.resHelper.getString("kDSheetPanel.border.title")));
            this.setViewportView((Component)this._pnlList);
        }

        void setData(Book book) {
            this._book = book;
            this._pnlList.removeAll();
            if (book != null && book.getSheetCount() > 0) {
                int count = book.getSheetCount();
                if (count <= 3) {
                    this._pnlList.setLayout((LayoutManager)new GridLayout(3, 1, 50, 10));
                } else {
                    this._pnlList.setLayout((LayoutManager)new GridLayout(count, 1, 50, 10));
                }
                for (int i = 0; i < count; ++i) {
                    KDCheckBox ck = new KDCheckBox(book.getSheet(i).getSheetName());
                    this._pnlList.add((Component)ck);
                    ck.setSelected(true);
                }
                this._pnlList.doLayout();
                this._pnlList.revalidate();
            }
        }

        void setAllSelected(boolean b) {
            int count = this._pnlList.getComponentCount();
            for (int i = 0; i < count; ++i) {
                ((KDCheckBox)this._pnlList.getComponent(i)).setSelected(b);
            }
        }

        String[] getSelectedSheets() {
            int count = this._pnlList.getComponentCount();
            ArrayList<String> al = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                if (!((KDCheckBox)this._pnlList.getComponent(i)).isSelected()) continue;
                al.add(this._book.getSheet(i).getSheetName());
            }
            if (al.size() == 0) {
                return new String[0];
            }
            String[] str = new String[al.size()];
            for (int i = 0; i < str.length; ++i) {
                str[i] = (String)al.get(i);
            }
            return str;
        }
    }
}

