/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.SearchKeyEnum;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgCommNHelper;
import com.kingdee.eas.ma.base.utils.OrgUnitUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgOrgunitViewFoldEnum;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.client.AbstractBgNewOrgF7UI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgNewOrgF7UI
extends AbstractBgNewOrgF7UI {
    private static final long serialVersionUID = -3079973692189479805L;
    private static final Logger logger = CoreUIObject.getLogger(BgNewOrgF7UI.class);
    public static final String SELECT_ORG_INFOS = "selectedOrgInfos";
    private static final Color ISLEAF_COLOR = new Color(16574898);
    private static final Color SEALUP_COLOR = new Color(0xD9D9D2);
    private static final Color SELECTEDORG_COLOR = new Color(225, 237, 255);
    protected boolean isCanceled = true;
    private Set<BgOrgUnitInfo> selectedOrgs = new HashSet<BgOrgUnitInfo>();
    private Set<String> selectedOrgIDs = new HashSet<String>();
    private SelectorItemCollection selectorCollection;
    private final int criticalNum = 10000;
    protected IObjectPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    private Set canSelectOrgIds = null;
    private Set canDisplayOrgNumbers = null;
    private String bgOrgViewId;
    private String orgUnitId;
    private boolean multipleSelect = true;
    private boolean isDefaultContainSub = false;
    private boolean isFilterByCurOrg = true;
    private boolean isBuildTreeStartFromRoot = true;
    private boolean isOnlyLeaf = false;
    private boolean isOnlyNoLeaf = false;
    private boolean hasPermission = true;
    private boolean isShowVirtualOrg = true;
    protected OrgViewType[] orgViewTypes = null;
    private static final String ORG_F7_RESOURCE_PATH = "com.kingdee.eas.basedata.org.client.OrgF7Resource";
    private TreeWillExpandListener listener = null;
    private TreeModel oldTree = null;
    private boolean isRefeshOrgUnitTree = false;
    private LongTimeDialog dialog = null;
    private SorterItemCollection sorterCollection;

    public IObjectPK getUserPK() {
        return this.userPK;
    }

    public void setUserPK(IObjectPK userPK) {
        this.userPK = userPK;
    }

    protected Set getSelectedOrgIDs() {
        return this.selectedOrgIDs;
    }

    protected Set getSelectedOrgs() {
        return this.selectedOrgs;
    }

    public String getBgOrgViewId() {
        return this.bgOrgViewId;
    }

    public void setBgOrgViewId(String bgOrgViewId) {
        this.bgOrgViewId = bgOrgViewId;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public boolean isMultiSelect() {
        return this.multipleSelect;
    }

    public void setMultiSelect(boolean multipleSelect) {
        this.multipleSelect = multipleSelect;
    }

    public boolean isDefaultContainSub() {
        return this.isDefaultContainSub;
    }

    public void setDefaultContainSub(boolean isDefaultContainSub) {
        this.isDefaultContainSub = isDefaultContainSub;
    }

    public boolean isFilterByCurOrg() {
        return this.isFilterByCurOrg;
    }

    public void setFilterByCurOrg(boolean isFilterByCurOrg) {
        this.isFilterByCurOrg = isFilterByCurOrg;
    }

    public boolean isBuildTreeStartFromRoot() {
        return this.isBuildTreeStartFromRoot;
    }

    public void setBuildTreeStartFromRoot(boolean isBuildTreeStartFromRoot) {
        this.isBuildTreeStartFromRoot = isBuildTreeStartFromRoot;
    }

    public boolean isOnlyLeaf() {
        return this.isOnlyLeaf;
    }

    public void setOnlyLeaf(boolean isOnlyLeaf) {
        this.isOnlyLeaf = isOnlyLeaf;
    }

    public void setOnlyNoLeaf(boolean isOnlyNoLeaf) {
        this.isOnlyNoLeaf = isOnlyNoLeaf;
    }

    public boolean isOnlyNoLeaf() {
        return this.isOnlyNoLeaf;
    }

    public void setHasPermission(boolean hasPermission) {
        this.hasPermission = hasPermission;
    }

    public boolean isHasPermission() {
        return this.hasPermission;
    }

    public boolean isShowVirtualOrg() {
        return this.isShowVirtualOrg;
    }

    public void setShowVirtualOrg(boolean isShowVirtualOrg) {
        this.isShowVirtualOrg = isShowVirtualOrg;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("bgOrgViewId") == null) {
            throw new BOSException("bgOrgViewId is null");
        }
        this.setBgOrgViewId(this.getUIContext().get("bgOrgViewId").toString());
        if (this.getUIContext().get("multipleSelect") != null) {
            this.setMultiSelect((Boolean)this.getUIContext().get("multipleSelect"));
        }
        if (this.getUIContext().get("orgUnitId") != null) {
            this.setOrgUnitId((String)this.getUIContext().get("orgUnitId"));
        }
        if (this.getUIContext().get("isFilterByCurOrg") != null) {
            this.setFilterByCurOrg((Boolean)this.getUIContext().get("isFilterByCurOrg"));
            if (this.isFilterByCurOrg()) {
                this.setOrgUnitId(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
            }
        }
        if (this.getUIContext().get("isBuildTreeStartFromRoot") != null) {
            this.setBuildTreeStartFromRoot((Boolean)this.getUIContext().get("isBuildTreeStartFromRoot"));
        }
        if (this.getUIContext().get("isOnlyLeaf") != null) {
            this.setOnlyLeaf((Boolean)this.getUIContext().get("isOnlyLeaf"));
        }
        if (this.getUIContext().get("isOnlyNoLeaf") != null) {
            this.setOnlyNoLeaf((Boolean)this.getUIContext().get("isOnlyNoLeaf"));
        }
        if (this.getUIContext().get("permissionFilter") != null) {
            this.setHasPermission((Boolean)this.getUIContext().get("permissionFilter"));
        }
        if (this.getUIContext().get(SELECT_ORG_INFOS) != null) {
            this.selectedOrgs = (Set)this.getUIContext().get(SELECT_ORG_INFOS);
            for (BgOrgUnitInfo orgUnit : this.selectedOrgs) {
                this.selectedOrgIDs.add(orgUnit.getId().toString());
            }
        }
        if (this.getUIContext().get("OrgF7Proxy") != null) {
            Set<BgOrgUnitInfo> promptInitDataId = this.getBizPromptBoxData();
            this.selectedOrgs.addAll(promptInitDataId);
            for (BgOrgUnitInfo orgUnit : this.selectedOrgs) {
                this.selectedOrgIDs.add(orgUnit.getId().toString());
            }
        }
        if (this.getUIContext().get("isShowVirtualOrg") instanceof Boolean) {
            this.isShowVirtualOrg = (Boolean)this.getUIContext().get("isShowVirtualOrg");
        }
        this.treeOrgUnit.setModel((TreeModel)new DefaultTreeModel(null));
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isMultiSelect()) {
            this.selectedContainer.setVisible(false);
            this.tableSplitPane.setDividerSize(0);
        }
        this.txtFieldValue.requestFocus();
        this.fillDataToSelectTable();
    }

    public void init() throws Exception {
        BgBaseHelper.setRootCannotClose((KDTree)this.treeOrgUnit);
        this.initTreePopMenu();
        this.initCanSelect();
        this.initBgOrgUnit();
        this.initComponent();
        this.addListener4TblMain();
        this.buildTypeCombox();
        this.buildQuickQueryCombox();
    }

    protected void initCanSelect() throws BOSException {
        this.canSelectOrgIds = (Set)this.getUIContext().get("orgIds");
        if (this.getUIContext().get("permissionItem") != null) {
            OrgType orgType = OrgType.CostCenter;
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.CostCenter));
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            FullOrgUnitCollection unitCol = null;
            try {
                unitCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, (String)this.getUIContext().get("permissionItem"));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            HashSet<String> permissionIds = new HashSet<String>();
            int size = unitCol.size();
            for (int i = 0; i < size; ++i) {
                permissionIds.add(unitCol.get(i).getId().toString());
            }
            if (this.canSelectOrgIds == null) {
                this.canSelectOrgIds = permissionIds;
            } else {
                this.canSelectOrgIds.retainAll(permissionIds);
            }
        }
        if (this.canSelectOrgIds == null) {
            this.canDisplayOrgNumbers = null;
        } else {
            this.canDisplayOrgNumbers = new HashSet();
            if (this.canSelectOrgIds != null) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("longNumber");
                evi.getSelector().add("simpleName");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)this.canSelectOrgIds, CompareType.INCLUDE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)this.getBgOrgViewId(), CompareType.EQUALS));
                BgOrgUnitCollection col = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
                for (int i = 0; i < col.size(); ++i) {
                    this.canDisplayOrgNumbers.addAll(Arrays.asList(col.get(i).getLongNumber().split("!")));
                }
            }
        }
    }

    private void buildTypeCombox() {
        this.cbOrgType.removeAllItems();
        String string = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"bgorg");
        OrgViewType orgViewType = OrgViewType.getInstance((String)string, (int)-1, null, null);
        this.orgViewTypes = new OrgViewType[]{orgViewType};
        for (int i = 0; i < this.orgViewTypes.length; ++i) {
            this.cbOrgType.addItem((Object)this.orgViewTypes[i]);
        }
        this.cbOrgType.setMaximumRowCount(this.orgViewTypes.length);
        this.cbOrgType.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.cbOrgTree.setVisible(false);
        this.cbOrgTree.setEnabled(false);
        this.chkShowAssistantOrg.setVisible(false);
        this.chkShowAssistantOrg.setEnabled(false);
        this.chkShowVirtual.setVisible(false);
        this.chkShowVirtual.setEnabled(false);
        this.chkContainSealUp.setVisible(false);
        this.chkContainSealUp.setEnabled(false);
    }

    public void initBgOrgUnit() throws Exception {
        this.treeOrgUnit.setShowCheckBox(false);
        this.treeOrgUnit.removeTreeWillExpandListener(this.getListener());
        if (this.isBuildTreeStartFromRoot()) {
            this.treeOrgUnit.setRootVisible(false);
            this.setOldTree(BgOrgUnitUtils.getBgOrgTreeMode2(this.treeOrgUnit, this.orgUnitId, this.getListener(), this.bgOrgViewId, this.isHasPermission(), this.canDisplayOrgNumbers, this.isShowVirtualOrg(), this.isOnlyNoLeaf()));
        } else {
            this.setOldTree(BgOrgUnitUtils.getBgOrgTreeMode2(this.treeOrgUnit, this.orgUnitId, this.getListener(), this.bgOrgViewId, this.isHasPermission(), this.canDisplayOrgNumbers, false, this.isOnlyNoLeaf()));
        }
        if (!StringUtils.isEmpty((String)this.bgOrgViewId) && !StringUtils.isEmpty((String)this.orgUnitId)) {
            BgViewClientHelper.addBeforeAction(this, this.treeOrgUnit, BOSUuid.read((String)this.bgOrgViewId), BOSUuid.read((String)this.orgUnitId), false, this.isShowVirtualOrg(), false, this.canDisplayOrgNumbers);
        }
        this.treeOrgUnit.setModel(this.getOldTree());
        BgOrgViewInfo bgOrgView = BgOrgViewFactory.getRemoteInstance().getBgOrgViewInfo((IObjectPK)new ObjectUuidPK(this.getBgOrgViewId()));
        if (bgOrgView.getBgOrguniteDirectFold() != BgOrgunitViewFoldEnum.unfold) {
            this.treeOrgUnit.expandOnLevel(2);
        } else {
            this.treeOrgUnit.expandOnLevel(3);
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (root != null) {
            if (root.getUserObject() != null && root.getUserObject() instanceof BgOrgUnitInfo && !"Virroot".equals(root.getText())) {
                this.treeOrgUnit.setSelectionNode(root);
            } else if (root.getChildCount() > 0) {
                this.treeOrgUnit.setSelectionNode((DefaultKingdeeTreeNode)root.getChildAt(0));
            }
        }
    }

    private Set<BgOrgUnitInfo> getBizPromptBoxData() {
        HashSet<BgOrgUnitInfo> idSet = new HashSet<BgOrgUnitInfo>();
        BgNewOrgDialog dialog = (BgNewOrgDialog)((Object)this.getUIContext().get("OrgF7Proxy"));
        if (dialog == null) {
            return idSet;
        }
        KDBizPromptBox box = dialog.getBizPromptBox();
        if (box == null) {
            return idSet;
        }
        Object data = box.getData();
        if (data == null) {
            return idSet;
        }
        BgOrgUnitInfo orgId = this.getOrgId(data);
        if (orgId != null) {
            idSet.add(orgId);
        }
        if (data instanceof Object[]) {
            Object[] datas;
            for (Object d : datas = (Object[])data) {
                BgOrgUnitInfo id = this.getOrgId(d);
                if (id == null) continue;
                idSet.add(id);
            }
        }
        return idSet;
    }

    private BgOrgUnitInfo getOrgId(Object data) {
        if (data instanceof BgOrgUnitInfo) {
            return (BgOrgUnitInfo)data;
        }
        return null;
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        if (!BgNewOrgF7UI.getBgOrgViewInterface().checkHasOrg(BOSUuid.read((String)this.getBgOrgViewId()))) {
            this.fillTblMain();
        } else {
            this.tblMain.refresh();
        }
    }

    protected void fillTblMain() throws BOSException, EASBizException {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        if (node == null) {
            return;
        }
        DefaultKingdeeTreeNode dNode = null;
        dNode = node.getChildCount() > 1 ? node : OrgUnitUtils.getDefaultKingdeeTreeNode((DefaultKingdeeTreeNode)node, null);
        FullOrgUnitInfo info1 = ((OrgStructureInfo)dNode.getUserObject()).getUnit();
        this.setCellValue(info1);
        int count = dNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode temNode = (DefaultKingdeeTreeNode)dNode.getChildAt(i);
            if (temNode.getUserObject() == null) continue;
            FullOrgUnitInfo info = ((OrgStructureInfo)temNode.getUserObject()).getUnit();
            this.setCellValue(info);
        }
    }

    private void setCellValue(FullOrgUnitInfo info) {
        if (this.canSelectOrgIds != null && !this.canSelectOrgIds.contains(info.getId().toString())) {
            return;
        }
        if (this.isOnlyLeaf() && !info.isIsLeaf()) {
            return;
        }
        if (this.isOnlyNoLeaf() && info.isIsLeaf()) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.getCell("id").setValue((Object)info.getId().toString());
        row.getCell("unit.id").setValue((Object)info.getId().toString());
        row.getCell("name").setValue((Object)info.getName());
        row.getCell("number").setValue((Object)info.getNumber());
        row.getCell("unit.code").setValue((Object)info.getCode());
        row.getCell("longNumber").setValue((Object)info.getLongNumber());
        row.setUserObject((Object)info);
    }

    public boolean isChkSubSelected() {
        return this.chkContainSub.isSelected();
    }

    public OrgTreeInfo getComboTreeSelectedItem() {
        return (OrgTreeInfo)this.cbOrgTree.getSelectedItem();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public Object getReturnValue() {
        if (!this.isCanceled) {
            return this.selectedOrgs;
        }
        return new HashSet();
    }

    private void initComponent() {
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtFieldValue, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtFieldValue.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgNewOrgF7UI.this.btnQuickQuery_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                        BgNewOrgF7UI.this.handleException(e1);
                    }
                }
            }
        });
        this.selectedContainer.addButton((JButton)this.btnDownSelect);
        this.selectedContainer.addButton((JButton)this.btnUpSelect);
        this.selectedContainer.addButton((JButton)this.btnDownAll);
        this.selectedContainer.addButton((JButton)this.btnUpAll);
        this.kDPanel4.setLayout((LayoutManager)new FlowLayout(0));
        this.kDPanel4.add((Component)this.chkContainSealUp);
        this.kDPanel4.add((Component)this.chkShowAssistantOrg);
        this.kDPanel4.add((Component)this.chkShowAll);
        this.kDPanel4.add((Component)this.chkShowVirtual);
        this.kDPanel5.setLayout((LayoutManager)new FlowLayout(2));
        this.kDPanel5.add((Component)this.btnOk);
        this.kDPanel5.add((Component)this.btnCancel);
        this.btnDownAll.setEnabled(this.isMultiSelect());
        this.chkContainSub.setSelected(this.isDefaultContainSub());
        this.chkShowAll.setVisible(false);
        if (this.isMultiSelect()) {
            this.tblMain.getSelectManager().setSelectMode(10);
            this.tblMainSelected.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
            this.tblMainSelected.getSelectManager().setSelectMode(2);
        }
        this.tblMainSelected.getStyleAttributes().setLocked(true);
        this.chkContainSub.setSelected(this.isDefaultContainSub());
        this.tblMain.setEditable(false);
    }

    private void addListener4TblMain() {
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    try {
                        BgNewOrgF7UI.this.doubleClick_actionPerformed(e);
                    }
                    catch (Exception e1) {
                        BgNewOrgF7UI.this.handUIException(e1);
                    }
                }
            }
        });
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgNewOrgF7UI.this.afterTableRequestData(e);
                }
                catch (EASBizException e1) {
                    BgNewOrgF7UI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    BgNewOrgF7UI.this.handUIException(e1);
                }
            }
        });
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    if (BgNewOrgF7UI.this.isMultiSelect() && e.isControlDown() && e.getKeyCode() == 65) {
                        BgNewOrgF7UI.this.tblMain.setRowCount(BgNewOrgF7UI.this.getQueryExecutor(BgNewOrgF7UI.this.bgOrgUnitQueryPK, BgNewOrgF7UI.this.getEntityViewInfo()).getRowCount());
                    } else if (e.getKeyCode() == 10) {
                        BgNewOrgF7UI.this.doubleClick_actionPerformed(null);
                    }
                }
                catch (BOSException e1) {
                    BgNewOrgF7UI.this.handUIException(e1);
                }
                catch (Exception e2) {
                    BgNewOrgF7UI.this.handUIException(e2);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void doubleClick_actionPerformed(KDTMouseEvent e) throws Exception {
        if (this.isMultiSelect()) {
            this.addDataToSelected();
        } else {
            this.btnOk_actionPerformed(null);
        }
    }

    protected void addDataToSelected() throws BOSException {
        CoreBaseCollection coll = this.getSelectedKeyValues();
        this.fillDataToSelectTable(coll);
    }

    private void fillDataToSelectTable(CoreBaseCollection coll) {
        if (coll != null) {
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                BgOrgUnitInfo info = (BgOrgUnitInfo)coll.get(i);
                if (this.canSelectOrgIds != null && !this.canSelectOrgIds.contains(info.getOrgUnitID().toString())) {
                    return;
                }
                if (this.selectedOrgIDs.contains(info.getId().toString())) continue;
                this.selectedOrgIDs.add(info.getId().toString());
                this.selectedOrgs.add(info);
                String[] cellValues = this.getTableCellValues((CoreBaseInfo)info);
                this.fullfillRowValue(this.getInsertIndexByInfo((CoreBaseInfo)info), cellValues);
            }
        }
    }

    protected void fullfillRowValue(int insertPosition, String[] cellValues) {
        if (cellValues != null && cellValues.length == 4) {
            IRow row = null;
            row = -1 == insertPosition ? this.tblMainSelected.addRow() : this.tblMainSelected.addRow(insertPosition);
            row.getCell("id").setValue((Object)cellValues[0]);
            row.getCell("name").setValue((Object)cellValues[1]);
            row.getCell("number").setValue((Object)cellValues[2]);
            row.getCell("longNumber").setValue((Object)cellValues[3]);
        }
    }

    private int getInsertIndexByInfo(CoreBaseInfo info) {
        if (info != null && !StringUtils.isEmpty((String)info.getString("longNumber"))) {
            String longNumber;
            int index;
            for (index = 0; index < this.tblMainSelected.getRowCount() && (StringUtils.isEmpty((String)(longNumber = (String)this.tblMainSelected.getRow(index).getCell("longNumber").getValue())) || longNumber.compareTo(info.getString("longNumber")) <= 0); ++index) {
            }
            return index;
        }
        return 0;
    }

    protected String[] getTableCellValues(CoreBaseInfo info) {
        String[] cellValues = new String[4];
        if (info != null && info.getId() != null) {
            BgOrgUnitInfo unitInfo;
            cellValues[0] = info.getId().toString();
            if (info instanceof BgOrgUnitInfo) {
                unitInfo = (BgOrgUnitInfo)info;
                cellValues[1] = unitInfo.getName();
                cellValues[2] = unitInfo.getNumber();
                cellValues[3] = unitInfo.getLongNumber();
            }
            if (info instanceof FullOrgUnitInfo) {
                unitInfo = (FullOrgUnitInfo)info;
                cellValues[1] = unitInfo.getName();
                cellValues[2] = unitInfo.getNumber();
                cellValues[3] = unitInfo.getLongNumber();
            }
        }
        return cellValues;
    }

    private CoreBaseCollection getSelectedKeyValues() throws BOSException {
        CoreBaseCollection coll = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return coll;
        }
        if (size == 1 && selectRows.length == 1) {
            coll = this.handleOneRow();
        } else {
            ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
            int mode = 0;
            if (blockList != null && blockList.size() == 1) {
                mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
            }
            coll = mode == 8 ? this.handleKeyFieldBySelectedIds() : this.handleMutiRows(selectRows);
        }
        return coll;
    }

    private CoreBaseCollection handleOneRow() throws BOSException {
        HashSet<String> tmp = new HashSet<String>();
        int rowNum = this.tblMain.getSelectManager().get().getTop();
        ICell cell = this.tblMain.getRow(rowNum).getCell(this.getKeyFieldName());
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if (cell != null && cell.getValue() != null) {
            tmp.add(cell.getValue().toString());
        }
        return this.getCollBySelectedOrgIds(this.buildFilterInfo(tmp));
    }

    private CoreBaseCollection handleMutiRows(int[] selectRows) throws BOSException {
        CoreBaseCollection result = new CoreBaseCollection();
        if (selectRows != null) {
            int allIdSize = selectRows.length;
            HashSet<String> tmp = new HashSet<String>();
            for (int m = 0; m < allIdSize / 10000 + 1; ++m) {
                int j = (m + 1) * 10000 > allIdSize ? allIdSize : (m + 1) * 10000;
                for (int i = m * 10000; i < j; ++i) {
                    ICell cell = this.tblMain.getRow(selectRows[i]).getCell(this.getKeyFieldName());
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if (cell != null && cell.getValue() == null || cell == null || cell.getValue() == null) continue;
                    tmp.add(cell.getValue().toString());
                }
                result.addCollection(this.getCollBySelectedOrgIds(this.buildFilterInfo(tmp)));
                tmp.clear();
            }
        }
        return result;
    }

    private CoreBaseCollection getCollBySelectedOrgIds(FilterInfo filterInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = this.getSelectorCollection();
        if (sic != null && sic.size() > 0) {
            viewInfo.setSelector(sic);
        }
        return this.getBgOrgUnitBizInterface().getCollection(viewInfo);
    }

    private IBgOrgUnit getBgOrgUnitBizInterface() throws BOSException {
        return BgOrgUnitFactory.getRemoteInstance();
    }

    protected static IBgOrgView getBgOrgViewInterface() throws BOSException {
        return BgOrgViewFactory.getRemoteInstance();
    }

    protected SelectorItemCollection getSelectorCollection() {
        if (this.selectorCollection != null && this.selectorCollection.size() != 0) {
            return this.selectorCollection;
        }
        SelectorItemCollection selectorCollection = new SelectorItemCollection();
        selectorCollection.add(new SelectorItemInfo("id"));
        selectorCollection.add(new SelectorItemInfo("orgUnitID"));
        selectorCollection.add(new SelectorItemInfo("name"));
        selectorCollection.add(new SelectorItemInfo("number"));
        selectorCollection.add(new SelectorItemInfo("longNumber"));
        selectorCollection.add(new SelectorItemInfo("isOUSealUp"));
        selectorCollection.add(new SelectorItemInfo("isLeaf"));
        selectorCollection.add(new SelectorItemInfo("isVirtual"));
        selectorCollection.add(new SelectorItemInfo("simpleName"));
        selectorCollection.add(new SelectorItemInfo("displayName"));
        return selectorCollection;
    }

    private FilterInfo buildFilterInfo(Set<String> selectedKeyValues) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", selectedKeyValues, CompareType.INCLUDE));
        return filter;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected void btnDownSelect_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMainSelected.getRowCount();
        if (!this.isMultiSelect() && count > 0) {
            MsgBox.showInfo((String)this.getName("SingleModeTips"));
            return;
        }
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i < 0) {
            MsgBox.showInfo((String)this.getName("MutiModeTips"));
            return;
        }
        this.addDataToSelected();
    }

    @Override
    protected void btnDownAll_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMainSelected.getRowCount();
        if (!this.isMultiSelect() && count > 0) {
            MsgBox.showInfo((String)this.getName("SingleModeTips"));
            return;
        }
        LongTimeDialog ltd = null;
        Window o = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (o instanceof Dialog) {
            ltd = new LongTimeDialog((Dialog)o);
        } else if (o instanceof Frame) {
            ltd = new LongTimeDialog((Frame)o);
        }
        if (ltd != null) {
            ltd.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    CoreBaseCollection coll = BgNewOrgF7UI.this.handleKeyFieldBySelectedIds();
                    BgNewOrgF7UI.this.fillDataToSelectTable(coll);
                    return null;
                }

                public void afterExec(Object arg0) throws Exception {
                }
            });
            ltd.show();
        }
    }

    @Override
    protected void btnUpSelect_actionPerformed(ActionEvent e) throws Exception {
        int i = this.tblMainSelected.getSelectManager().getActiveRowIndex();
        if (i < 0) {
            MsgBox.showInfo((String)this.getName("MutiModeTips"));
        }
        this.removeDataFromSelected();
        this.afterRemoveDataFromSelected();
    }

    private void afterRemoveDataFromSelected() throws BOSException {
        if (!this.isMultiSelect()) {
            int size = this.tblMainSelected.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMainSelected, (IBlock)this.tblMainSelected.getSelectManager().get(i));
                int size1 = selectBlock.getBottom();
                for (int j = selectBlock.getTop(); j <= size1; ++j) {
                    this.tblMainSelected.removeRow(selectBlock.getTop());
                }
            }
        } else {
            this.fillDataToSelectTable();
        }
    }

    @Override
    protected void btnUpAll_actionPerformed(ActionEvent e) throws Exception {
        HashSet<Object> delOrgIdlist = new HashSet<Object>();
        int j = this.tblMainSelected.getRowCount();
        for (int i = 0; i < j; ++i) {
            delOrgIdlist.add(this.tblMainSelected.getRow(i).getCell("id").getValue());
        }
        this.selectedOrgIDs.removeAll(delOrgIdlist);
        HashSet<CoreBaseInfo> list = new HashSet<CoreBaseInfo>();
        for (CoreBaseInfo coreBaseInfo : this.selectedOrgs) {
            if (!delOrgIdlist.contains(coreBaseInfo.getId().toString())) continue;
            list.add(coreBaseInfo);
        }
        this.selectedOrgs.removeAll(list);
        this.tblMainSelected.removeRows();
    }

    private void removeDataFromSelected() {
        HashSet<String> delOrgIdlist = new HashSet<String>();
        int size = this.tblMainSelected.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMainSelected, (IBlock)this.tblMainSelected.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object obj = this.tblMainSelected.getRow(j).getCell("id").getValue();
                delOrgIdlist.add(obj.toString());
            }
        }
        this.selectedOrgIDs.removeAll(delOrgIdlist);
        HashSet<CoreBaseInfo> list = new HashSet<CoreBaseInfo>();
        for (CoreBaseInfo coreBaseInfo : this.selectedOrgs) {
            if (!delOrgIdlist.contains(coreBaseInfo.getId().toString())) continue;
            list.add(coreBaseInfo);
        }
        this.selectedOrgs.removeAll(list);
    }

    protected Set beforeFillDataToSelectTable(Set selectedOrgs) throws BOSException {
        return selectedOrgs;
    }

    protected void fillDataToSelectTable() throws BOSException {
        Set validData = this.beforeFillDataToSelectTable(this.selectedOrgs);
        if (validData != null) {
            this.tblMainSelected.removeRows();
            for (CoreBaseInfo info : validData) {
                String[] cellValues = this.getTableCellValues(info);
                this.fullfillRowValue(this.getInsertIndexByInfo(info), cellValues);
            }
        }
    }

    private CoreBaseCollection handleKeyFieldBySelectedIds() throws BOSException {
        List selectKeyIdFields = this.getQueryPkList();
        CoreBaseCollection result = new CoreBaseCollection();
        if (selectKeyIdFields != null) {
            int allIdSize = selectKeyIdFields.size();
            HashSet<String> tmp = new HashSet<String>();
            for (int m = 0; m < allIdSize / 10000 + 1; ++m) {
                int j = (m + 1) * 10000 > allIdSize ? allIdSize : (m + 1) * 10000;
                for (int i = m * 10000; i < j; ++i) {
                    Object idObj = selectKeyIdFields.get(i);
                    if (idObj == null) continue;
                    tmp.add(idObj.toString());
                }
                result.addCollection(this.getCollBySelectedOrgIds(this.buildFilterInfo(tmp)));
                tmp.clear();
            }
        }
        return result;
    }

    protected List getQueryPkList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IQueryExecutor iexec = this.getQueryExecutor(this.bgOrgUnitQueryPK, this.getEntityViewInfo());
            IRowSet rs = iexec.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("id"));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return list;
    }

    protected String getName(String value) {
        return EASResource.getString((String)ORG_F7_RESOURCE_PATH, (String)value);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.btnOkAction();
    }

    protected void btnOkAction() throws Exception {
        this.isCanceled = false;
        if (this.isMultiSelect()) {
            int n = this.getSelectedOrgIDs().size();
        } else {
            this.getSelectedOrgIDs().clear();
            this.getSelectedOrgs().clear();
            this.addDataToSelected();
        }
        this.setCanceled(false);
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void buildQuickQueryCombox() {
        this.checkBlured.setSelected(true);
        this.comboField.removeAllItems();
        this.comboField.addItem((Object)SearchKeyEnum.orgName);
        this.comboField.addItem((Object)SearchKeyEnum.orgNumber);
        this.comboField.setSelectedIndex(this.getQueryFieldIndexOnUILoad());
    }

    protected int getQueryFieldIndexOnUILoad() {
        return 0;
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    @Override
    protected void btnQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuickQuery_actionPerformed(e);
        String txt = this.txtFieldValue.getText();
        if (StringUtils.isEmpty((String)txt)) {
            this.treeOrgUnit.setModel(this.getOldTree());
            this.treeOrgUnit.setSelectionNode((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot());
            return;
        }
        this.loadOrgUnitTree();
        TreeModel model = null;
        SearchKeyEnum keyEnum = (SearchKeyEnum)this.comboField.getSelectedItem();
        if (keyEnum.getValue() == 10) {
            model = BgOrgUnitUtils.clipAndCloneTreeModel(this.getOldTree(), new String[]{"name"}, txt, true);
        } else if (keyEnum.getValue() == 0) {
            model = BgOrgUnitUtils.clipAndCloneTreeModel(this.getOldTree(), new String[]{"number"}, txt, true);
        }
        BgOrgUnitCollection bgOrgUnitCollection = null;
        if (keyEnum.getValue() == 10) {
            bgOrgUnitCollection = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select level where name like '%" + txt + "%' order by level desc");
        } else if (keyEnum.getValue() == 0) {
            bgOrgUnitCollection = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select level where number like '%" + txt + "%' order by level desc");
        }
        if (bgOrgUnitCollection != null && !bgOrgUnitCollection.isEmpty()) {
            BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(0);
            this.treeOrgUnit.expandOnLevel(bgOrgUnitInfo.getLevel());
        }
        this.treeOrgUnit.setModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (root != null) {
            if (root.getUserObject() != null && root.getUserObject() instanceof BgOrgUnitInfo && !"Virroot".equals(root.getText())) {
                this.treeOrgUnit.setSelectionNode(root);
            } else if (root.getChildCount() > 0) {
                this.treeOrgUnit.setSelectionNode((DefaultKingdeeTreeNode)root.getChildAt(0));
            }
        }
        this.treeOrgUnit.expandAllNodes(true, (TreeNode)((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot()));
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    protected void loadOrgUnit() {
        if (!this.isRefeshOrgUnitTree()) {
            this.loadOrgUnitTree();
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void loadOrgUnitTree() {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgNewOrgF7UI.this.refeshOrgUnitTree();
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    public void refeshOrgUnitTree() throws Exception {
        if (!this.isRefeshOrgUnitTree()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            this.refeshOrgUnitTree(root);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1 || root.getChildCount() == 0) {
            try {
                BgOrgUnitUtils.addChildNode(root, this.getBgOrgViewId(), null, this.isHasPermission(), false, this.isShowVirtualOrg(), this.isOnlyNoLeaf());
            }
            catch (Exception ex) {
                logger.error((Object)"OrgUnitUtils.addChildNode Error:", (Throwable)ex);
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    @Override
    protected void chkContainSub_actionPerformed(ActionEvent e) throws Exception {
        super.chkContainSub_actionPerformed(e);
        this.tblMain.refresh();
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            long t2 = System.currentTimeMillis();
            this.bgOrgUnitQuery = this.getEntityViewInfo();
            logger.error((Object)("getEntityView cost: " + (System.currentTimeMillis() - t2)));
            logger.error((Object)("querySQL is: " + this.bgOrgUnitQuery.toString()));
            if (this.bgOrgUnitQuery != null) {
                int start = (Integer)e.getParam1();
                int length = (Integer)e.getParam2() - start + 1;
                long t1 = System.currentTimeMillis();
                IQueryExecutor exec = this.getQueryExecutor(this.bgOrgUnitQueryPK, this.bgOrgUnitQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                logger.info((Object)("tblMain_doRequestRowSet cost: " + (System.currentTimeMillis() - t1)));
                e.setRowSet(rowSet);
            }
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
        if (this.isMultiSelect()) {
            this.tblMain.getSelectManager().setSelectMode(10);
            this.tblMainSelected.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
            this.tblMainSelected.getSelectManager().setSelectMode(2);
        }
        KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)0);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    private EntityViewInfo getEntityViewInfo() throws BOSException {
        EntityViewInfo viewInfo = this.getEntityViewExceptTreeFilter();
        FilterInfo treefilter = this.buildTreeNodeFilter();
        if (treefilter != null) {
            viewInfo.getFilter().mergeFilter(treefilter, "and");
        }
        FilterInfo filter = new FilterInfo();
        if (this.canSelectOrgIds != null) {
            if (this.canSelectOrgIds.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)this.canSelectOrgIds, CompareType.INCLUDE));
            }
        }
        if (!this.isDefaultContainSub) {
            filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        if (this.isOnlyLeaf()) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        if (this.isOnlyNoLeaf()) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        if (!this.isShowVirtualOrg()) {
            filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)this.txtFieldValue.getText())) {
            if (this.comboField.getSelectedItem().equals(SearchKeyEnum.orgName)) {
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + this.txtFieldValue.getText().trim() + "%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtFieldValue.getText().trim() + "%"), CompareType.LIKE));
            }
        }
        viewInfo.getFilter().mergeFilter(filter, "and");
        viewInfo.setSorter(this.getTableSorter());
        return viewInfo;
    }

    public void setSorterItemCollection(SorterItemCollection coll) {
        this.sorterCollection = coll;
    }

    protected SorterItemCollection getTableSorter() {
        if (this.sorterCollection != null && this.sorterCollection.size() > 0) {
            return this.sorterCollection;
        }
        SorterItemCollection coll = new SorterItemCollection();
        coll.add(new SorterItemInfo("longNumber"));
        return coll;
    }

    protected EntityViewInfo getEntityViewExceptTreeFilter() throws BOSException {
        FilterInfo authorizedOrgFilter;
        EntityViewInfo result = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        result.setFilter(filter);
        FilterInfo bgOrgViewfilter = this.getBgOrgViewFilter();
        if (bgOrgViewfilter != null) {
            filter.mergeFilter(bgOrgViewfilter, "and");
        }
        if (this.isHasPermission() && (authorizedOrgFilter = this.getAuthorizedOrgFilter(this.getUserPK().toString(), OrgViewType.CTRLUNIT.getValue())) != null) {
            filter.mergeFilter(authorizedOrgFilter, "and");
        }
        return result;
    }

    protected FilterInfo getAuthorizedOrgFilter(String userPK, int orgRangeType) throws BOSException {
        FilterInfo filter = null;
        StringBuffer oql = new StringBuffer("orgUnitID").append(" in (").append("select forgid from " + BgCommNHelper.getOrgRangeTable(null) + " where fuserid = '").append(userPK).append("' and ftype = ").append(orgRangeType).append(")");
        try {
            filter = new FilterInfo(oql.toString());
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    protected FilterInfo getBgOrgViewFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)this.getBgOrgViewId(), CompareType.EQUALS));
        return filter;
    }

    private FilterInfo buildTreeNodeFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        try {
            TreePath[] objects = this.treeOrgUnit.getSelectionPaths();
            if (objects == null || objects.length == 0 || objects[0] == null || !(objects[0].getLastPathComponent() instanceof DefaultKingdeeTreeNode)) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.EQUALS));
            } else {
                for (int i = 0; i < objects.length; ++i) {
                    Object userObject = ((DefaultKingdeeTreeNode)objects[i].getLastPathComponent()).getUserObject();
                    if (userObject == null) continue;
                    filter.mergeFilter(this.buildTreeNodeFilter(userObject), "or");
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter;
    }

    protected FilterInfo buildTreeNodeFilter(Object userObject) throws BOSException {
        FilterInfo filter = new FilterInfo();
        CoreBaseInfo info = (CoreBaseInfo)userObject;
        String longNumber = info.getString("longNumber");
        String id = info.getId().toString();
        if (!this.isChkSubSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id, CompareType.EQUALS));
            if (!this.isShowVirtualOrg) {
                filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
                filter.setMaskString("((#0 or #1) AND #2)");
            } else {
                filter.setMaskString("(#0 or #1)");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            if (!this.isShowVirtualOrg) {
                filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
                filter.setMaskString("((#0 or #1) AND #2)");
            } else {
                filter.setMaskString("(#0 or #1)");
            }
        }
        return filter;
    }

    protected void afterTableRequestData(KDTDataRequestEvent e) throws EASBizException, BOSException {
        String id;
        KDTable tblMain = (KDTable)e.getSource();
        IRow row = null;
        int rowCount = tblMain.getRowCount3();
        if (rowCount == -1 || rowCount == 0) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            if (row == null) continue;
            ids.append("'").append(row.getCell(this.getKeyFieldName()).getValue()).append("'");
            if (i == e.getLastRow()) continue;
            ids.append(",");
        }
        String oql = "select id, isOUSealUp, isLeaf where id in (" + ids.toString() + ") and (isOUSealUp = 1 or isLeaf = 1) order by longNumber";
        CoreBaseCollection orgUnitCol = this.getBgOrgUnitBizInterface().getCollection(oql);
        if (orgUnitCol != null && orgUnitCol.size() > 0) {
            id = null;
            BgOrgUnitInfo info = null;
            int j = orgUnitCol.size();
            for (int i = 0; i < j; ++i) {
                info = (BgOrgUnitInfo)orgUnitCol.getObject(i);
                id = info.getId().toString();
                for (int m = 0; m < rowCount; ++m) {
                    row = tblMain.getRow(m);
                    if (!row.getCell(this.getKeyFieldName()).getValue().toString().equals(id)) continue;
                    if (info.getBoolean("isLeaf")) {
                        row.getStyleAttributes().setBackground(ISLEAF_COLOR);
                        continue;
                    }
                    if (!info.getBoolean("isOUSealUp")) continue;
                    row.getStyleAttributes().setBackground(SEALUP_COLOR);
                }
            }
        }
        if (this.multipleSelect) {
            id = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                id = row.getCell(this.getKeyFieldName()).getValue().toString();
                if (!this.getSelectedOrgIDs().contains(id)) continue;
                row.getStyleAttributes().setBackground(SELECTEDORG_COLOR);
            }
        }
    }

    private Map initMap() {
        String resource = "com.kingdee.eas.ma.mbg.client.BgFormResource";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("actopen", EASResource.getString((String)resource, (String)"actopen"));
        map.put("actclose", EASResource.getString((String)resource, (String)"actclose"));
        map.put("actopenll", EASResource.getString((String)resource, (String)"actopenll"));
        map.put("actopenall", EASResource.getString((String)resource, (String)"actopenall"));
        map.put("actcloseall", EASResource.getString((String)resource, (String)"actcloseall"));
        return map;
    }

    protected void initTreePopMenu() {
        Map map = this.initMap();
        JMenuItem mItem = null;
        for (int i = 0; i < this.treeOrgUnit.getPopupMenu().getComponentCount(); ++i) {
            if (!(this.treeOrgUnit.getPopupMenu().getComponent(i) instanceof JMenuItem)) continue;
            mItem = (JMenuItem)this.treeOrgUnit.getPopupMenu().getComponent(i);
            String text = null;
            try {
                String key = mItem.getActionCommand();
                if (!map.containsKey(key)) continue;
                text = map.get(key).toString();
                mItem.setText(text);
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)"Read resource error:", (Throwable)e);
            }
        }
        this.treeOrgUnit.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                return BgNewOrgF7UI.this.isShowTreePopMenu();
            }
        });
    }

    protected boolean isShowTreePopMenu() {
        return true;
    }
}

