/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitException;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.utils.BgOrgDataHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgOrgAddHandler {
    private BgOrgDataHelper helper = null;
    private String viewId = null;
    private DefaultKingdeeTreeNode curNode = null;
    private DefaultKingdeeTreeNode selectedNode = null;
    private DefaultKingdeeTreeNode rootNode = null;
    private Map<String, BgOrgUnitInfo> subBgOrgMap = new HashMap<String, BgOrgUnitInfo>();
    private Map<String, BgOrgUnitInfo> bgOrgMap = new HashMap<String, BgOrgUnitInfo>();
    private List<String> validNodeOrgIDCol = new ArrayList<String>();
    private int rootOldLevel = 1;

    public BgOrgAddHandler() {
    }

    public BgOrgAddHandler(BgOrgDataHelper helper, String viewId, DefaultKingdeeTreeNode rootNode) {
        this.helper = helper;
        this.viewId = viewId;
        this.rootNode = rootNode;
        this.rootOldLevel = rootNode.getLevel() + 1;
    }

    public void putAllToOrgMap() {
        this.bgOrgMap.putAll(this.subBgOrgMap);
    }

    public void addValidNodeOrgID() {
        String orgID = BgOrgTreeHelper.getOrgIDFromTreeNode(this.selectedNode);
        if (!this.validNodeOrgIDCol.contains(orgID) && this.selectedNode != this.rootNode) {
            this.validNodeOrgIDCol.add(orgID);
        }
    }

    public void addHandler() throws BgOrgUnitException {
        this.converToBgOrgInfo();
        this.putAllToOrgMap();
        this.addValidNodeOrgID();
    }

    public void converToBgOrgInfo() throws BgOrgUnitException {
        if (this.rootNode == null || this.curNode == null) {
            return;
        }
        DefaultKingdeeTreeNode parentNode = null;
        BgOrgUnitInfo info = null;
        BgOrgUnitInfo parentInfo = null;
        OrgStructureInfo rootStructInfo = (OrgStructureInfo)this.rootNode.getUserObject();
        OrgStructureInfo structInfo = (OrgStructureInfo)this.curNode.getUserObject();
        if (structInfo.getLevel() <= rootStructInfo.getLevel() && this.rootNode != this.curNode) {
            info = BgOrgTreeHelper.createNewBgOrg(this.curNode, this.viewId);
            Object[] obj = new Object[]{info.getName()};
            throw new BgOrgUnitException(BgOrgUnitException.NOTSUPERORG, obj);
        }
        info = this.createNewBgOrgForAdd();
        if (this.curNode.getParent() != null && this.curNode != this.rootNode && (structInfo = (OrgStructureInfo)(parentNode = (DefaultKingdeeTreeNode)this.curNode.getParent()).getUserObject()).getLevel() >= rootStructInfo.getLevel()) {
            this.setCurNode(parentNode);
            parentInfo = this.createNewBgOrgForAdd();
            if (parentInfo != null && info.getParent() == null) {
                if (this.helper.getRefBgDataOrgMap().containsKey(parentInfo.getOrgUnitID())) {
                    String msg = BgOrgUnitHelper.getBgOrgMsg("hasBgData");
                    msg = MessageFormat.format(msg, parentInfo.getName());
                    MsgBox.showWarning((String)msg);
                    SysUtil.abort();
                }
                if (parentInfo.isIsLeaf()) {
                    parentInfo.setIsLeaf(false);
                }
                info.setParent(parentInfo);
            }
            this.converToBgOrgInfo();
        }
    }

    public BgOrgUnitInfo createNewBgOrgForAdd() throws BgOrgUnitException {
        BgOrgUnitInfo bgOrgUnitInfo = null;
        BgOrgUnitInfo tmpBgOrgInfo = null;
        bgOrgUnitInfo = BgOrgTreeHelper.createNewBgOrg(this.curNode, this.viewId);
        bgOrgUnitInfo.setLevel(bgOrgUnitInfo.getLevel() - this.rootOldLevel + 1);
        String orgUnitId = bgOrgUnitInfo.getOrgUnitID();
        if (this.bgOrgMap.containsKey(orgUnitId)) {
            bgOrgUnitInfo = this.bgOrgMap.get(orgUnitId);
        } else if (this.subBgOrgMap.containsKey(orgUnitId)) {
            bgOrgUnitInfo = this.subBgOrgMap.get(orgUnitId);
        } else if (this.helper.getCurOrgUnitMap().containsKey(orgUnitId)) {
            tmpBgOrgInfo = this.helper.getCurOrgUnitMap().get(orgUnitId);
            if (!tmpBgOrgInfo.getOrgUnitID().equals(bgOrgUnitInfo.getOrgUnitID())) {
                if (this.curNode != this.selectedNode) {
                    Object[] obj = new Object[]{bgOrgUnitInfo.getName()};
                    throw new BgOrgUnitException(BgOrgUnitException.SUPERORGERROR, obj);
                }
                throw new BgOrgUnitException(BgOrgUnitException.EXISTINORGVIEW);
            }
            bgOrgUnitInfo = tmpBgOrgInfo;
        }
        if (!this.subBgOrgMap.containsKey(bgOrgUnitInfo.getOrgUnitID())) {
            this.subBgOrgMap.put(bgOrgUnitInfo.getOrgUnitID(), bgOrgUnitInfo);
        }
        return bgOrgUnitInfo;
    }

    public BgOrgDataHelper getHelper() {
        return this.helper;
    }

    public String getViewId() {
        return this.viewId;
    }

    public DefaultKingdeeTreeNode getCurNode() {
        return this.curNode;
    }

    public void setCurNode(DefaultKingdeeTreeNode curNode) {
        this.curNode = curNode;
    }

    public DefaultKingdeeTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(DefaultKingdeeTreeNode selectedNode) {
        this.selectedNode = selectedNode;
    }

    public DefaultKingdeeTreeNode getRootNode() {
        return this.rootNode;
    }

    public Map<String, BgOrgUnitInfo> getSubBgOrgMap() {
        return this.subBgOrgMap;
    }

    public Map<String, BgOrgUnitInfo> getBgOrgMap() {
        return this.bgOrgMap;
    }

    public List<String> getValidNodeOrgIDCol() {
        return this.validNodeOrgIDCol;
    }
}

