/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgAdjustPastDataInfo;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.mbg.BgAdjustBillCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgPastSourceEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.MBgAdjustConstants;
import com.kingdee.eas.ma.mbg.client.AbstractBgPastRecordViewUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustBillEditExpUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustBillEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class BgPastRecordViewUI
extends AbstractBgPastRecordViewUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgPastRecordViewUI.class);
    protected static final String COL_ID = "id";
    protected static final String COL_BGFORMDID = "bgFormId";
    protected static final String COL_ORGNAME = "orgName";
    protected static final String COL_BGINDEX = "bgIndex";
    protected static final String COL_DIMCOMBIN = "dimCombin";
    protected static final String COL_BGELEMENT = "bgElement";
    protected static final String COL_BGSCENAIO = "bgScenario";
    protected static final String COL_BGVERSION = "bgVersion";
    protected static final String COL_BGPERIOD = "bgPeriod";
    protected static final String COL_TYPE = "type";
    protected static final String COL_OLDVALUE = "oldValue";
    protected static final String COL_NEWVALUE = "newValue";
    protected static final String COL_DEVVALUE = "devValue";
    protected static final String COL_TRANSITVALUE = "transitValue";
    protected static final String COL_ADJUSTOR = "adjustor";
    protected static final String COL_ADJUSTTIME = "adjustTime";
    protected static final String COL_AUDITOR = "auditor";
    protected static final String COL_AUDITTIME = "auditTime";
    protected static final String COL_ADJUSTREASON = "adjustReason";
    protected static final String COL_REFBILL = "refBill";
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    private boolean isTransitBudget = false;

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getCellHelper().init();
        Object processType = this.getUIContext().get("processType");
        if (processType != null && processType instanceof BgProcessEnum) {
            boolean bl = this.isTransitBudget = BgParamCHelper.isLoadTransitBudget() && BgProcessEnum.C01.equals(processType);
        }
        if (this.getUIContext().get("data") instanceof List) {
            this.fillDataToTable();
        } else {
            this.execQuery();
        }
        ActionMap am = this.getTable().getActionMap();
        am.remove("Paste");
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.getUIMenuBar().setVisible(false);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.disableButton((JButton)this.btnSave, true, true);
        this.disableButton((JButton)this.btnOK, true, true);
        this.disableButton((JButton)this.btnAddNew, false, false);
        this.disableButton((JButton)this.btnView, false, false);
        this.disableButton((JButton)this.btnEdit, false, false);
        this.disableButton((JButton)this.btnRefresh, false, false);
        this.disableButton((JButton)this.btnRemove, false, false);
        this.disableButton((JButton)this.btnAttachment, false, false);
        this.disableButton((JButton)this.btnCancelCancel, false, false);
        this.disableButton((JButton)this.btnCancel, false, false);
        this.disableButton((JButton)this.btnQueryScheme, false, false);
        this.disableButton((JButton)this.btnQuery, false, false);
        this.disableButton((JButton)this.btnLocate, false, false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && this.btnViewBill.isEnabled()) {
            this.actionViewBill_actionPerformed(new ActionEvent(this.btnView, 0, "Double Clicked"));
        }
    }

    protected void disableButton(JButton btn, boolean isDisable, boolean isVisible) {
        btn.setEnabled(isDisable);
        btn.setVisible(isVisible);
    }

    protected void execQuery() {
        this.checkTableParsed();
        int colIndex = this.getTable().getColumn(COL_ORGNAME).getColumnIndex();
        if (colIndex > 0) {
            boolean tbM = this.getTable().isColumnMoveable();
            this.getTable().setColumnMoveable(true);
            this.getTable().getColumn(COL_ORGNAME).setMoveable(true);
            this.getTable().moveColumn(colIndex, 0);
            this.getTable().getColumn(COL_ORGNAME).setMoveable(false);
            this.getTable().setColumnMoveable(tbM);
            this.getTable().getColumn(COL_ORGNAME).getStyleAttributes().setHided(false);
        }
    }

    private void hideTransitCol(boolean hide) {
        this.getTable().getColumn(COL_TRANSITVALUE).getStyleAttributes().setHided(hide);
    }

    @Override
    protected void displayLastTimeCheckBox_itemStateChanged(ItemEvent e) throws Exception {
        super.displayLastTimeCheckBox_itemStateChanged(e);
        if (this.displayLastTimeCheckBox.isSelected()) {
            this.setDisplayByAdjustTime(false);
        } else {
            this.setDisplayByAdjustTime(true);
        }
    }

    private void setDisplayByAdjustTime(boolean isShow) {
        ArrayList data = (ArrayList)this.getUIContext().get("data");
        if (data == null || data.isEmpty()) {
            return;
        }
        HashMap<String, Timestamp> maxTime = new HashMap<String, Timestamp>();
        for (BgAdjustPastDataInfo info : data) {
            String itemKey = info.getOrgLongNumber() + "_" + info.getFormula() + "_" + info.getBgVersionNumber();
            if (!maxTime.containsKey(itemKey)) {
                maxTime.put(itemKey, info.getAdjustTime());
                continue;
            }
            if (((Timestamp)maxTime.get(itemKey)).compareTo(info.getAdjustTime()) >= 0) continue;
            maxTime.put(itemKey, info.getAdjustTime());
        }
        KDTable table = this.getTable();
        for (int i = 0; i < table.getRowCount3(); ++i) {
            StyleAttributes sa;
            IRow row = table.getRow(i);
            Object obj = row.getUserObject();
            if (!(obj instanceof BgAdjustPastDataInfo)) continue;
            BgAdjustPastDataInfo info = (BgAdjustPastDataInfo)obj;
            String itemKey = info.getOrgLongNumber() + "_" + info.getFormula() + "_" + info.getBgVersionNumber();
            Timestamp adjustTime = info.getAdjustTime();
            if (!isShow) {
                if (info.isAdjusting()) continue;
                sa = row.getStyleAttributes();
                sa.setHided(true);
                row.setStyleAttributes(sa);
                continue;
            }
            sa = row.getStyleAttributes();
            sa.setHided(false);
            row.setStyleAttributes(sa);
        }
    }

    private void fillDataToTable() throws BOSException {
        String orgUnitId;
        List data = (List)this.getUIContext().get("data");
        Map<String, String> refBills = this.queryRefBill(data);
        String companyId = (String)this.getUIContext().get("ORGUNIT_COMPANY");
        BgSchemeDimensionHelper schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("schemeHelper");
        String accountViewId = null;
        if (schemeHelper != null && schemeHelper instanceof BgSchemeDimensionHelper) {
            accountViewId = schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId();
        }
        if (StringUtils.isEmpty((String)companyId) && (orgUnitId = (String)this.getUIContext().get("ORGUNIT_ID")) != null) {
            try {
                CompanyOrgUnitInfo company = BgNFCHelper.getCompanyByOrgUnit(BOSUuid.read((String)orgUnitId));
                if (company != null) {
                    companyId = company.getId().toString();
                }
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
        }
        this.checkTableParsed();
        this.getTable().getColumn(COL_ADJUSTTIME).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.getTable().getColumn(COL_AUDITTIME).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.getTable().setEditable(true);
        this.getTable().getColumn(COL_ADJUSTREASON).getStyleAttributes().setLocked(false);
        BgAdjustPastDataInfo pastDataInfo = null;
        boolean hasSave = false;
        Collections.sort(data, new Comparator<BgAdjustPastDataInfo>(){

            @Override
            public int compare(BgAdjustPastDataInfo d1, BgAdjustPastDataInfo d2) {
                int value = BgCommHelper.compare((Comparable)((Object)d1.getOrgLongNumber()), (Comparable)((Object)d2.getOrgLongNumber()));
                if (value == 0) {
                    value = BgCommHelper.compare((Comparable)((Object)d1.getFormula()), (Comparable)((Object)d2.getFormula()));
                }
                if (value == 0) {
                    value = BgCommHelper.compare((Comparable)d1.getAdjustTime(), (Comparable)d2.getAdjustTime());
                }
                return value;
            }
        });
        boolean hasNullOrg = false;
        StringBuilder sb = null;
        for (int index = 0; index < data.size(); ++index) {
            pastDataInfo = (BgAdjustPastDataInfo)data.get(index);
            if (BgNConstants.ZERO.equals((pastDataInfo.getAdjustValue() == null ? BgNConstants.ZERO : pastDataInfo.getAdjustValue()).subtract(pastDataInfo.getOldValue() == null ? BgNConstants.ZERO : pastDataInfo.getOldValue()))) continue;
            IRow row = this.getTable().addRow();
            row.setUserObject((Object)pastDataInfo);
            row.getCell(COL_ID).setValue((Object)pastDataInfo.getPastDataId());
            row.getCell(COL_BGFORMDID).setValue((Object)pastDataInfo.getBgFormId());
            row.getCell(COL_ORGNAME).setValue((Object)pastDataInfo.getOrgName());
            if (pastDataInfo.getOrgName() == null) {
                hasNullOrg = true;
            }
            String indexNumber = pastDataInfo.getIndexNumber();
            String dimNumber = pastDataInfo.getDimNumber();
            if (dimNumber == null && pastDataInfo.getDimName() == null) {
                row.getCell(COL_DIMCOMBIN).setValue((Object)"");
            } else {
                row.getCell(COL_DIMCOMBIN).setValue((Object)(dimNumber + "(" + pastDataInfo.getDimName() + ")"));
                String[] nums = dimNumber.toString().split(",");
                String[] names = pastDataInfo.getDimName().split(",");
                if (nums != null && names != null && nums.length == names.length) {
                    sb = new StringBuilder();
                    for (int k = 0; k < names.length; ++k) {
                        String substring = nums[k].substring(nums[k].indexOf(":") + 1);
                        if (k == names.length - 1) {
                            sb.append(substring).append("(").append(names[k]).append(")");
                            continue;
                        }
                        sb.append(substring).append("(").append(names[k]).append("),");
                    }
                    String combinDim = sb.toString().replace(dimNumber.toString(), "");
                    if (combinDim.startsWith(",")) {
                        combinDim = combinDim.substring(1);
                    }
                    row.getCell(COL_DIMCOMBIN).setValue((Object)combinDim);
                } else {
                    logger.error((Object)"data error !");
                }
            }
            row.getCell(COL_BGINDEX).setValue((Object)this.getCellHelper().getIndexDisplayName(accountViewId, indexNumber, pastDataInfo.getIndexName()));
            row.getCell(COL_BGELEMENT).setValue((Object)pastDataInfo.getBgElementName());
            row.getCell(COL_BGPERIOD).setValue((Object)pastDataInfo.getPeriod());
            row.getCell(COL_BGSCENAIO).setValue((Object)pastDataInfo.getBgScenarioName());
            row.getCell(COL_BGVERSION).setValue((Object)pastDataInfo.getBgVersionName());
            row.getCell(COL_TYPE).setValue((Object)BgPastSourceEnum.getEnum(pastDataInfo.getPastSource()));
            row.getCell(COL_OLDVALUE).setValue((Object)MBgAdjustConstants.getEffectValue(pastDataInfo.getOldValue()));
            row.getCell(COL_NEWVALUE).setValue((Object)MBgAdjustConstants.getEffectValue(pastDataInfo.getAdjustValue()));
            row.getCell(COL_DEVVALUE).setValue((Object)MBgAdjustConstants.getEffectValue(pastDataInfo.getAdjustValue().subtract(pastDataInfo.getOldValue() == null ? BgNConstants.ZERO : pastDataInfo.getOldValue())));
            row.getCell(COL_TRANSITVALUE).setValue((Object)MBgAdjustConstants.getEffectValue(pastDataInfo.getTransitValue()));
            row.getCell(COL_ADJUSTOR).setValue((Object)pastDataInfo.getAdjustorName());
            row.getCell(COL_ADJUSTTIME).setValue((Object)pastDataInfo.getAdjustTime());
            row.getCell(COL_AUDITOR).setValue((Object)pastDataInfo.getAuditorName());
            row.getCell(COL_AUDITTIME).setValue((Object)pastDataInfo.getAuditTime());
            row.getCell(COL_ADJUSTREASON).setValue((Object)pastDataInfo.getAdjustReason());
            row.getCell(COL_REFBILL).setValue((Object)refBills.get(pastDataInfo.getBgFormId()));
            if (pastDataInfo.isAdjusting() && !(this.getUIContext().get("BGFORM_AUDIT_TYPE") instanceof String)) {
                row.getCell(COL_ADJUSTREASON).getStyleAttributes().setLocked(false);
                hasSave = true;
                continue;
            }
            row.getCell(COL_ADJUSTREASON).getStyleAttributes().setLocked(true);
        }
        this.getTable().getColumn(COL_ORGNAME).getStyleAttributes().setHided(hasNullOrg);
        this.btnSave.setEnabled(hasSave);
    }

    private Map<String, String> queryRefBill(List<BgAdjustPastDataInfo> data) throws BOSException {
        HashSet<String> ids;
        HashMap<String, String> refBills = new HashMap<String, String>();
        HashMap<BOSObjectType, HashSet<String>> bosTypeIds = new HashMap<BOSObjectType, HashSet<String>>();
        for (BgAdjustPastDataInfo bgAdjustPastDataInfo : data) {
            String bgFormId = bgAdjustPastDataInfo.getBgFormId();
            if (StringUtils.isEmpty((String)bgFormId)) continue;
            BOSObjectType type = BOSUuid.read((String)bgFormId).getType();
            if (type != null && !bosTypeIds.containsKey(type)) {
                ids = new HashSet<String>();
                bosTypeIds.put(type, ids);
            }
            ((Set)bosTypeIds.get(type)).add(bgFormId);
        }
        for (Map.Entry entry : bosTypeIds.entrySet()) {
            Serializable info;
            Iterator iter;
            BOSObjectType bosType = (BOSObjectType)entry.getKey();
            ids = (HashSet<String>)entry.getValue();
            if (new BgFormInfo().getBOSType().equals((Object)bosType)) {
                BgFormCollection bgFormColl = BgFormFactory.getRemoteInstance().getBgFormCollection(this.getEntityViewInfo(ids));
                iter = bgFormColl.iterator();
                while (iter.hasNext()) {
                    info = (BgFormInfo)iter.next();
                    refBills.put(info.getId().toString(), info.getNumber());
                }
                continue;
            }
            if (!new BgAdjustBillInfo().getBOSType().equals((Object)bosType)) continue;
            BgAdjustBillCollection bgAdjustBillColl = BgAdjustBillFactory.getRemoteInstance().getBgAdjustBillCollection(this.getEntityViewInfo(ids));
            iter = bgAdjustBillColl.iterator();
            while (iter.hasNext()) {
                info = (BgAdjustBillInfo)iter.next();
                refBills.put(info.getId().toString(), info.getNumber());
            }
        }
        return refBills;
    }

    private EntityViewInfo getEntityViewInfo(Set<String> ids) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo(COL_ID));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo(COL_ID, ids, CompareType.INCLUDE));
        return view;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        boolean isAdjustBill = false;
        String id = this.getSelectId();
        if (id != null) {
            BOSObjectType type = BOSUuid.read((String)id).getType();
            isAdjustBill = new BgAdjustBillInfo().getBOSType().equals((Object)type);
        }
        this.actionViewBill.setEnabled(isAdjustBill);
        this.btnViewBill.setEnabled(isAdjustBill);
    }

    protected String getSelectId() {
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (row != null && row.getCell(COL_BGFORMDID).getValue() != null) {
            return String.valueOf(row.getCell(COL_BGFORMDID).getValue());
        }
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow;
        super.actionViewBill_actionPerformed(e);
        String id = this.getSelectId();
        if (id == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"canResize", (Object)"true");
        String UIName = BgAdjustBillEditUI.class.getName();
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        Object value = null;
        if (this.tblMain.getRow(index) != null && this.tblMain.getRow(index).getCell(COL_TYPE) != null) {
            value = this.tblMain.getRow(index).getCell(COL_TYPE).getValue();
        }
        if (value instanceof BgPastSourceEnum) {
            UIName = ((BgPastSourceEnum)((Object)value)).getValue() == 3 ? BgAdjustBillEditExpUI.class.getName() : BgAdjustBillEditUI.class.getName();
        }
        if ((uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UIName, (Map)uiContext, null, "FINDVIEW")) instanceof JDialog) {
            JDialog frame = (JDialog)uiWindow;
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            Insets inset = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
            size.height = size.height - inset.bottom + inset.top;
            size.width = size.width - inset.right + inset.left;
            frame.setPreferredSize(size);
            frame.setResizable(true);
        }
        Component comp = null;
        try {
            KDToolBar toolBar = uiWindow.getUIObject().getUIToolBar();
            int btnCount = toolBar.getComponentCount();
            for (int i = 0; i < btnCount - 1; ++i) {
                comp = toolBar.getComponent(i);
                comp.setEnabled(false);
            }
            KDMenuBar menuBar = uiWindow.getUIObject().getUIMenuBar();
            int menuItemCount = menuBar.getComponentCount();
            for (int j = 0; j < menuItemCount; ++j) {
                menuBar.getComponent(j).setEnabled(false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        uiWindow.show();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.getTable().getEditManager().stopEditing();
        HashMap reasonMap = new HashMap();
        for (int rowIndex = 0; rowIndex < this.getTable().getRowCount(); ++rowIndex) {
            IRow row = this.getTable().getRow(rowIndex);
            if (row.getCell(COL_ADJUSTREASON).getStyleAttributes().isLocked()) continue;
            BgAdjustPastDataInfo pataInfo = (BgAdjustPastDataInfo)row.getUserObject();
            pataInfo.setPastDataId(row.getCell(COL_ID).getValue().toString());
            if (row.getCell(COL_ADJUSTREASON).getValue() == null) {
                pataInfo.setAdjustReason(null);
            } else {
                pataInfo.setAdjustReason((String)row.getCell(COL_ADJUSTREASON).getValue());
                if (pataInfo.getAdjustReason().length() > 255) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"adjustReasonToLong"));
                    SysUtil.abort();
                }
            }
            reasonMap.put(pataInfo, null);
        }
        boolean isSuccess = BgAdjustFacadaFactory.getRemoteInstance().modifyAjustReason(reasonMap);
        if (isSuccess) {
            Map adjustMap = (Map)this.getUIContext().get("adjustMap");
            String orgId = (String)this.getUIContext().get("ORGUNIT_ID");
            if (adjustMap != null && orgId != null && adjustMap.containsKey(orgId)) {
                adjustMap = (Map)adjustMap.get(orgId);
                for (BgAdjustPastDataInfo pataInfo : reasonMap.keySet()) {
                    if (!adjustMap.containsKey(pataInfo.getFormula())) continue;
                    ((BgAdjustFormDiversityData)adjustMap.get(pataInfo.getFormula())).setAdjustReson(pataInfo.getAdjustReason());
                }
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgViewFormAdjustResource", (String)"saveSuccess"));
            this.isModify = false;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgViewFormAdjustResource", (String)"saveFail"));
        }
    }

    @Override
    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        super.tblMain_editStopping(e);
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        this.isModify = true;
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.isModify) {
            int rs = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"dataIsEdit"));
            if (rs == 0 || rs == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                    this.isModify = false;
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                return false;
            }
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void refreshList() throws Exception {
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof KDDialog) {
            ((KDDialog)this.getUIWindow()).setResizable(true);
        }
    }

    protected void checkTableParsed() {
        this.getTable().checkParsed();
        if (this.isTransitBudget) {
            this.hideTransitCol(false);
        } else {
            this.hideTransitCol(true);
        }
    }
}

