/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgPeriodDecomposeUI;
import com.kingdee.eas.ma.mbg.client.utils.BgDemcomposeSheetDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDecomposeParameter;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.SheetInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgPeriodDecomposeUI
extends AbstractBgPeriodDecomposeUI {
    private static final long serialVersionUID = 8445789212507830297L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodDecomposeUI.class);
    private final String RES = "com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource";
    private BgDecomposeParameter paramter = null;
    private KDTDefaultCellEditor defNumEditor = null;
    protected CalendarHelper calendar = new CalendarHelper();
    private String COL_SOURCEPERIOD = "sourcePeriod";
    private String COL_SCALE = "scale";
    public static final String BOOK_STR = "BOOK_STR";
    public static final String SOURCE_PERIOD_TYPE = "SOURCE_PERIOD_TYPE";
    public static final String TARGE_PERIOD_TYPE = "TARGE_PERIOD_TYPE";
    public static final String SOURCE_PERIODS = "SOURCE_PERIODS";
    public static final String TARGE_PERIODS = "TARGE_PERIODS";
    public static final String SOURCE_BGSCENARIOS = "SOURCE_BGSCENARIOS";
    public static final String TARGE_BGSCENARIOS = "TARGE_BGSCENARIOS";
    public static final String SOURCE_BGELEMENTS = "SOURCE_BGELEMENTS";
    public static final String TARGE_BGELEMENTS = "TARGE_BGELEMENTS";
    private List<BgPeriodTypeInfo> sourceTypes = null;
    private List<BgPeriodTypeInfo> targeTypes = null;
    private Set<String> sourcePeriods = null;
    private Set<String> targePeriods = null;
    private Set<String> sourceBgScenarios = null;
    private Set<String> targeBgScenarios = null;
    private Set<String> sourceBgElements = null;
    private Set<String> targeBgElements = null;
    private BgPeriodTypeInfo oldSourceType = null;
    private BgPeriodTypeInfo oldTargeType = null;
    private BgSchemeInfo bgSchemeInfo = null;
    private BgSchemeDimensionHelper bgSchemeHelper = null;
    private boolean isCancel = true;
    private boolean isCheckType = true;

    public BgDecomposeParameter getBgPeriodDecParameter() {
        return this.paramter;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.init();
    }

    protected void init() throws EASBizException, BOSException {
        this.initParams();
        this.isCheckType = false;
        this.combSourcePeriodType.removeAllItems();
        if (this.sourceTypes != null && !this.sourceTypes.isEmpty()) {
            this.combSourcePeriodType.addItems(this.sourceTypes.toArray());
            for (BgPeriodTypeInfo typeInfo : this.sourceTypes) {
                if (!typeInfo.getNumber().equals("YEAR")) continue;
                this.combSourcePeriodType.setSelectedItem((Object)typeInfo);
                break;
            }
        }
        this.combTargePeriodType.removeAllItems();
        if (this.targeTypes != null && !this.targeTypes.isEmpty()) {
            this.combTargePeriodType.addItems(this.targeTypes.toArray());
            boolean same = false;
            for (BgPeriodTypeInfo typeInfo : this.targeTypes) {
                if (same) {
                    this.combTargePeriodType.setSelectedItem((Object)typeInfo);
                    break;
                }
                if (!typeInfo.getNumber().equals("MONT")) continue;
                if (!((BgPeriodTypeInfo)this.combSourcePeriodType.getSelectedItem()).getNumber().equals(typeInfo.getNumber())) {
                    this.combTargePeriodType.setSelectedItem((Object)typeInfo);
                    break;
                }
                same = true;
            }
        }
        this.isCheckType = true;
        this.initPrmt();
        this.tblMain.getColumn(this.COL_SCALE).setEditor((ICellEditor)this.getDefNumEditor());
    }

    protected void initPrmt() throws EASBizException, BOSException {
        if (this.bgSchemeInfo == null || this.bgSchemeHelper == null) {
            return;
        }
        BgSchemeInfo bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(this.bgSchemeInfo.getId()));
        BgPeriodDialog sdialog = new BgPeriodDialog((CoreUIObject)this);
        sdialog.setBgPeriodBeginDate(bgScheme.getDateFrom());
        sdialog.setBgPeriodEndDate(bgScheme.getDateTo());
        this.prmtSourcePeriod.setHistoryRecordEnabled(false);
        this.prmtSourcePeriod.setEditable(false);
        this.prmtSourcePeriod.setSelector((KDPromptSelector)sdialog);
        BgPeriodDialog tdialog = new BgPeriodDialog((CoreUIObject)this, true);
        tdialog.setBgPeriodBeginDate(bgScheme.getDateFrom());
        tdialog.setBgPeriodEndDate(bgScheme.getDateTo());
        tdialog.setOnlyLeaf(true);
        this.prmtTargePeriod.setEnabledMultiSelection(true);
        this.prmtTargePeriod.setHistoryRecordEnabled(false);
        this.prmtTargePeriod.setEditable(false);
        this.prmtTargePeriod.setSelector((KDPromptSelector)tdialog);
        this.prmtSourceBgScenario.setEnabledMultiSelection(false);
        this.prmtSourceBgScenario.setValue(null);
        this.prmtSourceBgScenario.setEditable(false);
        DimensionMemberSelectHelper.addIdFilter(this.prmtSourceBgScenario, DimensionConstants.DEF_SCENARIO_NUMBER, this.bgSchemeHelper);
        if (this.prmtSourceBgScenario.getEntityViewInfo() == null) {
            this.prmtSourceBgScenario.setEntityViewInfo(new EntityViewInfo());
            this.prmtSourceBgScenario.getEntityViewInfo().setFilter(new FilterInfo());
        }
        this.prmtSourceBgScenario.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("type", (Object)0));
        this.prmtSourceBgScenario.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("number", this.sourceBgScenarios, CompareType.INCLUDE));
        this.prmtTargeBgScenario.setEnabledMultiSelection(false);
        this.prmtTargeBgScenario.setValue(null);
        this.prmtTargeBgScenario.setEditable(false);
        DimensionMemberSelectHelper.addIdFilter(this.prmtTargeBgScenario, DimensionConstants.DEF_SCENARIO_NUMBER, this.bgSchemeHelper);
        if (this.prmtTargeBgScenario.getEntityViewInfo() == null) {
            this.prmtTargeBgScenario.setEntityViewInfo(new EntityViewInfo());
            this.prmtTargeBgScenario.getEntityViewInfo().setFilter(new FilterInfo());
        }
        this.prmtTargeBgScenario.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("type", (Object)0));
        this.prmtTargeBgScenario.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("number", this.targeBgScenarios, CompareType.INCLUDE));
        this.prmtSourceBgElement.setEditable(false);
        DimensionMemberSelectHelper.addIdFilter(this.prmtSourceBgElement, DimensionConstants.DEF_ELEMENT_NUMBER, this.bgSchemeHelper);
        if (this.prmtSourceBgElement.getEntityViewInfo() == null) {
            this.prmtSourceBgElement.setEntityViewInfo(new EntityViewInfo());
            this.prmtSourceBgElement.getEntityViewInfo().setFilter(new FilterInfo());
        }
        this.prmtSourceBgElement.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("number", this.sourceBgElements, CompareType.INCLUDE));
        this.prmtTargeBgElement.setEditable(false);
        DimensionMemberSelectHelper.addIdFilter(this.prmtTargeBgElement, DimensionConstants.DEF_ELEMENT_NUMBER, this.bgSchemeHelper);
        if (this.prmtTargeBgElement.getEntityViewInfo() == null) {
            this.prmtTargeBgElement.setEntityViewInfo(new EntityViewInfo());
            this.prmtTargeBgElement.getEntityViewInfo().setFilter(new FilterInfo());
        }
        this.prmtTargeBgElement.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("number", this.targeBgElements, CompareType.INCLUDE));
        this.initSheetF7();
    }

    private void initSheetF7() {
        if (this.getUIContext().get(BOOK_STR) instanceof Book) {
            Book book = (Book)this.getUIContext().get(BOOK_STR);
            int count = book.getSheetCount();
            SheetInfo sheetInfo = null;
            SheetInfo[] sheetInfoArray = new SheetInfo[count];
            for (int i = 0; i < count; ++i) {
                sheetInfo = new SheetInfo();
                sheetInfo.setSheetName(book.getSheetName(i));
                sheetInfo.setSheetIndex(i);
                sheetInfoArray[i] = sheetInfo;
            }
            BgDemcomposeSheetDialog tb = new BgDemcomposeSheetDialog();
            tb.setBook(book);
            tb.setSheetsInfo(sheetInfoArray);
            this.prmtSheetNames.setSelector((KDPromptSelector)tb);
            this.prmtSheetNames.setEditable(false);
            this.prmtSheetNames.setDisplayFormat("$name$");
            this.prmtSheetNames.setData((Object)sheetInfoArray);
        }
    }

    @Override
    protected void prmtSheetNames_willShow(SelectorEvent e) throws Exception {
        KDBizPromptBox box;
        if (e != null && e.getSource() instanceof KDBizPromptBox && (box = (KDBizPromptBox)e.getSource()).getSelector() instanceof BgDemcomposeSheetDialog) {
            BgDemcomposeSheetDialog b = (BgDemcomposeSheetDialog)box.getSelector();
            Object o = box.getData();
            if (o == null) {
                b.setSheetsInfo(null);
            } else if (o instanceof SheetInfo[]) {
                b.setSheetsInfo((SheetInfo[])o);
            }
        }
    }

    @Override
    protected void prmtSheetNames_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null) {
            Object newObj = e.getNewValue();
            Object oldObj = e.getOldValue();
            if (newObj == null) {
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("selectSheet"));
                this.prmtSheetNames.setDataNoNotify(oldObj);
            }
        }
    }

    protected void initParams() throws EASBizException, BOSException {
        if (this.getUIContext().get(SOURCE_PERIOD_TYPE) instanceof List) {
            this.sourceTypes = (List)this.getUIContext().get(SOURCE_PERIOD_TYPE);
        }
        if (this.getUIContext().get(TARGE_PERIOD_TYPE) instanceof List) {
            this.targeTypes = (List)this.getUIContext().get(TARGE_PERIOD_TYPE);
        }
        if (this.getUIContext().get("BGSCHEME_INFO") instanceof BgSchemeInfo) {
            this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
            if (this.bgSchemeInfo != null) {
                this.bgSchemeHelper = new BgSchemeDimensionHelper(this.bgSchemeInfo.getId().toString());
            }
        }
        if (this.getUIContext().get(SOURCE_PERIODS) instanceof Set) {
            this.sourcePeriods = (Set)this.getUIContext().get(SOURCE_PERIODS);
        }
        if (this.getUIContext().get(TARGE_PERIODS) instanceof Set) {
            this.targePeriods = (Set)this.getUIContext().get(TARGE_PERIODS);
        }
        if (this.getUIContext().get(SOURCE_BGSCENARIOS) instanceof Set) {
            this.sourceBgScenarios = (Set)this.getUIContext().get(SOURCE_BGSCENARIOS);
        }
        if (this.getUIContext().get(TARGE_BGSCENARIOS) instanceof Set) {
            this.targeBgScenarios = (Set)this.getUIContext().get(TARGE_BGSCENARIOS);
        }
        if (this.getUIContext().get(SOURCE_BGELEMENTS) instanceof Set) {
            this.sourceBgElements = (Set)this.getUIContext().get(SOURCE_BGELEMENTS);
        }
        if (this.getUIContext().get(TARGE_BGELEMENTS) instanceof Set) {
            this.targeBgElements = (Set)this.getUIContext().get(TARGE_BGELEMENTS);
        }
    }

    @Override
    protected void combSourcePeriodType_actionPerformed(ActionEvent e) throws Exception {
        super.combSourcePeriodType_actionPerformed(e);
    }

    @Override
    protected void combSourcePeriodType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            if (e.getItem() != null && e.getItem() instanceof BgPeriodTypeInfo) {
                this.oldSourceType = (BgPeriodTypeInfo)e.getItem();
            }
            return;
        }
        if (e.getItem() instanceof BgPeriodTypeInfo) {
            BgPeriodTypeInfo source = (BgPeriodTypeInfo)e.getItem();
            BgPeriodTypeInfo targe = (BgPeriodTypeInfo)this.combTargePeriodType.getSelectedItem();
            if (this.isCheckType && targe != null && source.getNumber().equals(targe.getNumber())) {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"sameBgPeriodType"));
                this.combSourcePeriodType.setSelectedItem((Object)this.oldSourceType, false);
                this.isCheckType = false;
            } else {
                this.prmtSourcePeriod.setDataNoNotify(null);
            }
        }
    }

    @Override
    protected void combTargePeriodType_actionPerformed(ActionEvent e) throws Exception {
        super.combTargePeriodType_actionPerformed(e);
    }

    @Override
    protected void combTargePeriodType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            if (e.getItem() != null && e.getItem() instanceof BgPeriodTypeInfo) {
                this.oldTargeType = (BgPeriodTypeInfo)e.getItem();
            }
            return;
        }
        if (e.getItem() instanceof BgPeriodTypeInfo) {
            BgPeriodTypeInfo source = (BgPeriodTypeInfo)e.getItem();
            BgPeriodTypeInfo targe = (BgPeriodTypeInfo)this.combSourcePeriodType.getSelectedItem();
            if (this.isCheckType && targe != null && source.getNumber().equals(targe.getNumber())) {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"sameBgPeriodType"));
                this.combTargePeriodType.setSelectedItem((Object)this.oldTargeType, false);
                this.isCheckType = false;
            } else {
                this.prmtTargePeriod.setDataNoNotify(null);
            }
        }
    }

    @Override
    protected void prmtSourcePeriod_dataChanged(DataChangeEvent e) throws Exception {
        Object oldObj = e.getOldValue();
        Object newObj = e.getNewValue();
        if (newObj instanceof BgPeriodInfo) {
            String newNum = ((BgPeriodInfo)newObj).getNumber();
            if (this.sourcePeriods == null || this.sourcePeriods.isEmpty() || !this.sourcePeriods.contains(newNum)) {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"bgPeriodNotInSheet"));
                this.prmtSourcePeriod.setDataNoNotify(oldObj);
            }
        }
    }

    @Override
    protected void prmtSourcePeriod_willShow(SelectorEvent e) throws Exception {
        if (this.combSourcePeriodType.getSelectedItem() instanceof BgPeriodTypeInfo && this.prmtSourcePeriod.getSelector() instanceof BgPeriodDialog) {
            HashSet<String> typeNums = new HashSet<String>();
            typeNums.add(((BgPeriodTypeInfo)this.combSourcePeriodType.getSelectedItem()).getNumber());
            ((BgPeriodDialog)this.prmtSourcePeriod.getSelector()).setBgPeriodTypeNumbers(typeNums);
        }
    }

    @Override
    protected void prmtTargePeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.afterFillTargePeriod();
    }

    protected void afterFillTargePeriod() {
        Object obj = this.prmtTargePeriod.getData();
        this.tblMain.removeRows();
        if (obj instanceof BgPeriodInfo[]) {
            BgPeriodInfo[] bgPeriods = (BgPeriodInfo[])obj;
            BgPeriodInfo info = null;
            IRow row = null;
            int count = bgPeriods.length;
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal scale = BigDecimal.ZERO;
            for (int index = 0; index < bgPeriods.length; ++index) {
                info = bgPeriods[index];
                row = this.tblMain.addRow();
                row.getCell(this.COL_SOURCEPERIOD).setValue((Object)info);
                if (this.isAvgDec()) {
                    if (index == count - 1) {
                        scale = BgNConstants.HUNDRED.subtract(total);
                    } else {
                        scale = BgNConstants.HUNDRED.divide(new BigDecimal(count), 3, 4);
                        total = total.add(scale);
                    }
                    row.getCell(this.COL_SCALE).setValue((Object)scale);
                    row.getCell(this.COL_SCALE).getStyleAttributes().setLocked(true);
                    row.getCell(this.COL_SCALE).getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
                    continue;
                }
                row.getCell(this.COL_SCALE).getStyleAttributes().setLocked(false);
                row.getCell(this.COL_SCALE).getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
            }
        }
    }

    protected void checkTargePeriodExist(DataChangeEvent e) {
        Object oldObj = e.getOldValue();
        Object newObj = e.getNewValue();
        if (newObj instanceof BgPeriodInfo) {
            String newNum = ((BgPeriodInfo)newObj).getNumber();
            if (this.targePeriods == null || this.targePeriods.isEmpty() || !this.targePeriods.contains(newNum)) {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"bgPeriodNotInSheet"));
                this.prmtTargePeriod.setDataNoNotify(oldObj);
            }
        } else if (newObj instanceof BgPeriodInfo[]) {
            BgPeriodInfo[] arr = (BgPeriodInfo[])newObj;
            for (int i = 0; i < arr.length; ++i) {
                String newNum = arr[i].getNumber();
                if (this.targePeriods != null && !this.targePeriods.isEmpty() && this.targePeriods.contains(newNum)) continue;
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"bgPeriodNotInSheet"));
                this.prmtTargePeriod.setDataNoNotify(oldObj);
            }
        }
    }

    @Override
    protected void prmtTargePeriod_willShow(SelectorEvent e) throws Exception {
        if (this.combTargePeriodType.getSelectedItem() instanceof BgPeriodTypeInfo && this.prmtTargePeriod.getSelector() instanceof BgPeriodDialog) {
            HashSet<String> typeNums = new HashSet<String>();
            typeNums.add(((BgPeriodTypeInfo)this.combTargePeriodType.getSelectedItem()).getNumber());
            ((BgPeriodDialog)this.prmtTargePeriod.getSelector()).setBgPeriodTypeNumbers(typeNums);
        }
    }

    @Override
    protected void rdAvgDecompose_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        int count = this.tblMain.getRowCount();
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal scale = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            if (!this.isAvgDec()) continue;
            if (i == count - 1) {
                scale = BgNConstants.HUNDRED.subtract(total);
            } else {
                scale = BgNConstants.HUNDRED.divide(new BigDecimal(count), 3, 4);
                total = total.add(scale);
            }
            this.tblMain.getCell(i, this.COL_SCALE).setValue((Object)scale);
            this.tblMain.getCell(i, this.COL_SCALE).getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, this.COL_SCALE).getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
        }
    }

    @Override
    protected void rdScaleDecompose_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.isAvgDec()) continue;
            this.tblMain.getCell(i, this.COL_SCALE).setValue(null);
            this.tblMain.getCell(i, this.COL_SCALE).getStyleAttributes().setLocked(false);
            this.tblMain.getCell(i, this.COL_SCALE).getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        if (this.isAvgDec()) {
            boolean isAllLeadSelected = this.checkAllLeafMembersSelected((BgPeriodTypeInfo)this.combTargePeriodType.getSelectedItem(), (BgPeriodInfo[])this.prmtTargePeriod.getData());
            if (!isAllLeadSelected) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"notAllLeafPeriod"));
                if (result == 0) {
                    this.createParamter();
                    this.isCancel = false;
                    this.getUIWindow().close();
                } else {
                    this.isCancel = true;
                }
            } else {
                this.createParamter();
                this.isCancel = false;
                this.getUIWindow().close();
            }
        } else {
            this.createParamter();
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    protected List<String> getNumbers(KDBizPromptBox prmtbox) {
        ArrayList<String> lst = new ArrayList<String>();
        if (prmtbox == null || prmtbox.getData() == null) {
            return lst;
        }
        Object obj = prmtbox.getData();
        if (obj instanceof DataBaseInfo) {
            if (!StringUtils.isEmpty((String)((DataBaseInfo)obj).getNumber())) {
                lst.add(((DataBaseInfo)obj).getNumber());
            }
        } else if (obj instanceof DataBaseInfo[]) {
            DataBaseInfo[] arr = (DataBaseInfo[])obj;
            DataBaseInfo info = null;
            for (int i = 0; i < arr.length; ++i) {
                info = arr[i];
                if (info == null || StringUtils.isEmpty((String)info.getNumber()) || lst.contains(info.getNumber())) continue;
                lst.add(info.getNumber());
            }
        }
        return lst;
    }

    protected void createParamter() {
        List<String> targeBgElementNumbers;
        List<String> targeBgScenarioNumbers;
        this.paramter = new BgDecomposeParameter();
        if (!this.getNumbers(this.prmtSourcePeriod).isEmpty()) {
            this.paramter.getSourceNumber().put(DimensionConstants.DEF_PERIOD_NUMBER, this.getNumbers(this.prmtSourcePeriod));
        }
        if (!this.getNumbers(this.prmtTargePeriod).isEmpty()) {
            this.paramter.getTargeNumbers().put(DimensionConstants.DEF_PERIOD_NUMBER, this.getNumbers(this.prmtTargePeriod));
        }
        if (!this.getNumbers(this.prmtSourceBgScenario).isEmpty()) {
            this.paramter.getSourceNumber().put(DimensionConstants.DEF_SCENARIO_NUMBER, this.getNumbers(this.prmtSourceBgScenario));
        }
        if (!(targeBgScenarioNumbers = this.getNumbers(this.prmtTargeBgScenario)).isEmpty()) {
            this.paramter.getTargeNumbers().put(DimensionConstants.DEF_SCENARIO_NUMBER, targeBgScenarioNumbers);
        }
        if (!this.getNumbers(this.prmtSourceBgElement).isEmpty()) {
            this.paramter.getSourceNumber().put(DimensionConstants.DEF_ELEMENT_NUMBER, this.getNumbers(this.prmtSourceBgElement));
        }
        if (!(targeBgElementNumbers = this.getNumbers(this.prmtTargeBgElement)).isEmpty()) {
            this.paramter.getTargeNumbers().put(DimensionConstants.DEF_ELEMENT_NUMBER, targeBgElementNumbers);
        }
        if (this.prmtSheetNames.getData() instanceof SheetInfo[]) {
            this.paramter.setSheetInfos((SheetInfo[])this.prmtSheetNames.getData());
        }
        this.paramter.setAvgDecompose(this.isAvgDec());
        HashMap<String, Object> tmpMap = null;
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (!(row.getCell(this.COL_SOURCEPERIOD).getValue() instanceof BgPeriodInfo)) continue;
            tmpMap = new HashMap<String, Object>();
            if (!targeBgScenarioNumbers.isEmpty()) {
                tmpMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, targeBgScenarioNumbers.get(0));
            }
            if (!targeBgElementNumbers.isEmpty()) {
                tmpMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, targeBgElementNumbers.get(0));
            }
            if (!(row.getCell(this.COL_SCALE).getValue() instanceof BigDecimal)) continue;
            tmpMap.put(DimensionConstants.DEF_PERIOD_NUMBER, ((BgPeriodInfo)row.getCell(this.COL_SOURCEPERIOD).getValue()).getNumber());
            tmpMap.put(DimensionConstants.BGCOMPOSE_SCALE, ((BigDecimal)row.getCell(this.COL_SCALE).getValue()).divide(BgNConstants.HUNDRED));
            this.paramter.getScaleMap().add(tmpMap);
        }
    }

    protected void verify() {
        if (this.prmtSourcePeriod.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"selectSourcePeriod"));
            SysUtil.abort();
        }
        if (this.prmtTargePeriod.getData() == null || this.prmtTargePeriod.getData() instanceof Object[] && ((Object[])this.prmtTargePeriod.getData())[0] == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"selectTargePeriod"));
            SysUtil.abort();
        }
        if (this.prmtSourceBgScenario.getData() == null && this.prmtTargeBgScenario.getData() != null || this.prmtSourceBgScenario.getData() != null && this.prmtTargeBgScenario.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"bgScenario_bothNeed"));
            SysUtil.abort();
        }
        if (this.prmtSourceBgElement.getData() == null && this.prmtTargeBgElement.getData() != null || this.prmtSourceBgElement.getData() != null && this.prmtTargeBgElement.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"bgElement_bothNeed"));
            SysUtil.abort();
        }
        if (!this.isAvgDec()) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (this.tblMain.getCell(i, this.COL_SCALE).getValue() != null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"setScale"));
                SysUtil.abort();
            }
        }
        BgPeriodTypeInfo source = (BgPeriodTypeInfo)this.combSourcePeriodType.getSelectedItem();
        BgPeriodTypeInfo targe = (BgPeriodTypeInfo)this.combTargePeriodType.getSelectedItem();
        if (source.getNumber().equals(targe.getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"sameBgPeriodType"));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtSourceBgScenario_dataChanged(DataChangeEvent e) throws Exception {
        Object newObj = e.getNewValue();
        if (newObj != null && this.prmtTargeBgScenario.getData() == null) {
            this.prmtTargeBgScenario.setDataNoNotify(newObj);
        }
    }

    @Override
    protected void prmtSourceBgElement_dataChanged(DataChangeEvent e) throws Exception {
        Object newObj = e.getNewValue();
        if (newObj != null && this.prmtTargeBgElement.getData() == null) {
            this.prmtTargeBgElement.setDataNoNotify(newObj);
        }
    }

    @Override
    protected void prmtTargeBgScenario_dataChanged(DataChangeEvent e) throws Exception {
        Object newObj = e.getNewValue();
        if (newObj != null && newObj instanceof BgScenarioInfo && this.prmtSourceBgScenario.getData() == null && this.sourceBgScenarios != null && this.sourceBgScenarios.contains(((BgScenarioInfo)newObj).getNumber())) {
            this.prmtSourceBgScenario.setDataNoNotify(newObj);
        }
    }

    @Override
    protected void prmtTargeBgElement_dataChanged(DataChangeEvent e) throws Exception {
        Object newObj = e.getNewValue();
        if (newObj != null && newObj instanceof BgElementInfo && this.prmtSourceBgElement.getData() == null && this.sourceBgElements != null && this.sourceBgElements.contains(((BgElementInfo)newObj).getNumber())) {
            this.prmtSourceBgElement.setDataNoNotify(newObj);
        }
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    protected boolean isAvgDec() {
        return this.rdAvgDecompose.isSelected();
    }

    protected boolean checkAllLeafMembersSelected(BgPeriodTypeInfo periodType, BgPeriodInfo[] bgPeriods) throws BOSException {
        BgPeriodDispCollection colls;
        if (periodType == null || bgPeriods == null) {
            return true;
        }
        HashSet<String> fixNums = new HashSet<String>();
        for (int i = 0; i < bgPeriods.length; ++i) {
            fixNums.add(bgPeriods[i].getNumber().substring(0, 10));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("type.id", (Object)periodType.getId().toString()));
        items.add(new FilterItemInfo("isLeaf", (Object)true));
        if (this.bgSchemeInfo.getDateFrom() != null && this.bgSchemeInfo.getDateTo() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.bgSchemeInfo.getDateFrom())), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.bgSchemeInfo.getDateTo())), CompareType.LESS_EQUALS));
            filter.setMaskString("#0 AND #1 AND #2 AND #3");
        }
        if ((colls = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(viewInfo)) != null) {
            HashSet<String> leafNumbers = new HashSet<String>();
            BgPeriodDispInfo dispInfo = null;
            for (int i = 0; i < colls.size(); ++i) {
                dispInfo = colls.get(i);
                if (!fixNums.contains(dispInfo.getNumber().substring(0, 10))) continue;
                leafNumbers.add(dispInfo.getNumber());
            }
            HashSet<String> tmpSet = new HashSet<String>();
            for (int i = 0; i < bgPeriods.length; ++i) {
                tmpSet.add(bgPeriods[i].getNumber());
            }
            Iterator it = leafNumbers.iterator();
            while (it.hasNext()) {
                if (tmpSet.contains(it.next())) continue;
                return false;
            }
        }
        return true;
    }

    protected KDTDefaultCellEditor getDefNumEditor() {
        if (this.defNumEditor == null) {
            this.defNumEditor = this.getNumberEditor();
        }
        return this.defNumEditor;
    }

    protected KDTDefaultCellEditor getNumberEditor() {
        KDFormattedTextField kdfTextField = new KDFormattedTextField();
        kdfTextField.setDataType(1);
        kdfTextField.setPrecision(3);
        kdfTextField.setSupportedEmpty(true);
        kdfTextField.setNegatived(true);
        return new MyCellEditor((JTextField)kdfTextField);
    }

    class MyCellEditor
    extends KDTDefaultCellEditor {
        public MyCellEditor(JTextField textField) {
            super(textField);
        }

        public Object getValue() {
            Object obj = super.getValue();
            if (obj instanceof String && StringUtils.isEmpty((String)((String)obj))) {
                return null;
            }
            return obj;
        }
    }
}

