/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.mbg.client.AbstractBgProcessInstanceListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgProcessInstanceListUI
extends AbstractBgProcessInstanceListUI {
    private static final long serialVersionUID = -2950558233262152804L;
    private static final Logger logger = CoreUIObject.getLogger(BgProcessInstanceListUI.class);
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String STATE = "state";
    private static final String CREATETIME = "createTime";
    private static final String CREATOR = "creator";
    private static final String ID = "id";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuTool.setEnabled(false);
        this.menuTool.setVisible(false);
    }

    protected void initTable() {
        List processInstInfos = (List)this.getUIContext().get("processInstInfos");
        Collections.sort(processInstInfos, new Comparator<ProcessInstInfo>(){

            @Override
            public int compare(ProcessInstInfo o1, ProcessInstInfo o2) {
                if (o1.getCreatedTime().after(o2.getCreatedTime())) {
                    return -1;
                }
                return 1;
            }
        });
        IRow row = null;
        this.tblMain.checkParsed();
        for (ProcessInstInfo processInstInfo : processInstInfos) {
            row = this.tblMain.addRow();
            row.getCell(NAME).setValue((Object)processInstInfo.getProcDefName(this.currentLocale));
            row.getCell(NUMBER).setValue((Object)processInstInfo.getCode());
            row.getCell(STATE).setValue((Object)processInstInfo.getMeta().getState().getAlias());
            row.getCell(CREATETIME).setValue((Object)processInstInfo.getCreatedTime());
            row.getCell(CREATOR).setValue((Object)processInstInfo.getInitiatorName(this.currentLocale));
            row.getCell(ID).setValue((Object)processInstInfo.getProcInstId());
        }
        this.tblMain.setEditable(false);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.openViewFlow(e);
        }
    }

    private void openViewFlow(KDTMouseEvent e) throws Exception {
        int index = e.getRowIndex();
        IRow row = this.tblMain.getRow(index);
        if (row != null && row.getCell(ID) != null && row.getCell(ID).getValue() != null) {
            String id = (String)row.getCell(ID).getValue();
            UIContext uiContext = new UIContext((Object)this.ui);
            uiContext.put((Object)ID, (Object)id);
            BasicWorkFlowMonitorPanel.Show((Map)uiContext);
        }
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        String id = null;
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1) {
            IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
            id = (String)row.getCell(ID).getValue();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)ID, (Object)id);
        BasicWorkFlowMonitorPanel.Show((Map)uiContext);
    }
}

