/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioNodeCollection;
import com.kingdee.eas.ma.base.BgScenarioNodeFactory;
import com.kingdee.eas.ma.base.BgScenarioNodeInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioCollObject;
import com.kingdee.eas.ma.mbg.BgRollPartEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleFactory;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgRollSettingsCollection;
import com.kingdee.eas.ma.mbg.BgRollSettingsInfo;
import com.kingdee.eas.ma.mbg.BgRollTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgRollRuleEditUI;
import com.kingdee.eas.ma.mbg.client.BgTemplateTypeSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BgRollRuleEditUI
extends AbstractBgRollRuleEditUI {
    private static final long serialVersionUID = 6113900200882392244L;
    private static final Logger logger = CoreUIObject.getLogger(BgRollRuleEditUI.class);
    private static final String COL_BGSCENARIO_ID = "bgScenarioId";
    private static final String COL_BGSCENARIO = "bgScenario";
    private static final String COL_ACTSCENARIO_ID = "actScenarioId";
    private static final String COL_ACTSCENARIO = "actScenario";
    private Map<String, BgScenarioCollection> scenarioNodes = new HashMap<String, BgScenarioCollection>();
    private BgScenarioCollection scenarios;
    private Locale l = this.getCurrentLocale();
    public static final String resourcePath = "com.kingdee.eas.ma.mbg.client.BgRollRuleResource";

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    public void onLoad() throws Exception {
        this.initScenarioCache();
        this.initScenario();
        this.initBgTemplateType();
        super.onLoad();
        this.initRollPart(this.rdoLimitLength.isSelected());
        if (OprtState.COPYADDNEW.equals(this.getOprtState())) {
            this.setFieldsNull((AbstractObjectValue)this.editData);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        long time = System.currentTimeMillis();
        this.txtNumber.setText(null);
        this.editData.setId(BOSUuid.create((BOSObjectType)new BgRollRuleInfo().getBOSType()));
        this.editData.setNumber(null);
        this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setCreateTime(new Timestamp(time));
        this.editData.setLastUpdateTime(new Timestamp(time));
        this.editData.setOrgUnit(SysContext.getSysContext().getCurrentCostUnit().castToFullOrgUnitInfo());
        BgRollSettingsCollection settings = this.editData.getBgRollSettings();
        int in = settings.size();
        for (int i = 0; i < in; ++i) {
            settings.get(i).setId(BOSUuid.create((BOSObjectType)new BgRollSettingsInfo().getBOSType()));
        }
    }

    private void initScenarioCache() throws BOSException {
        this.scenarios = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("bgScenario.id");
        evi.getSelector().add("actScenario.*");
        BgScenarioNodeCollection coll = BgScenarioNodeFactory.getRemoteInstance().getCollection(evi);
        if (coll != null && !coll.isEmpty()) {
            int in = coll.size();
            for (int i = 0; i < in; ++i) {
                BgScenarioNodeInfo scenNodeInfo = coll.get(i);
                String id = scenNodeInfo.getBgScenario().getId().toString();
                BgScenarioInfo actScenInfo = scenNodeInfo.getActScenario();
                if (!this.scenarioNodes.containsKey(id)) {
                    this.scenarioNodes.put(id, new BgScenarioCollection());
                }
                this.scenarioNodes.get(id).add(actScenInfo);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeTemplateType();
        this.storeScenario();
        if (this.rdoLimitLength.isSelected()) {
            this.editData.setRollType(BgRollTypeEnum.limitLengthRoll);
        } else {
            this.editData.setRollType(BgRollTypeEnum.continuousRoll);
        }
        this.editData.setHisPeriodLength((Integer)this.spnHisPeriod.getValue());
        this.editData.setLength((Integer)this.spnLength.getValue());
    }

    protected void storeTemplateType() {
        Object data = this.prmtTemplateType.getData();
        StringBuffer buf = new StringBuffer();
        StringBuffer numBuf = new StringBuffer();
        if (data != null && data instanceof BgTemFormTypeEnum[]) {
            BgTemFormTypeEnum[] enums;
            for (BgTemFormTypeEnum iEnum : enums = (BgTemFormTypeEnum[])data) {
                buf.append(iEnum.getAlias(this.l)).append(",");
                numBuf.append(iEnum.getName()).append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            numBuf.deleteCharAt(numBuf.length() - 1);
            this.editData.setTemplateType(buf.toString());
            this.editData.setTptTypeNumber(numBuf.toString());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadTemplateType();
        this.loadScenario();
        BgRollTypeEnum rollType = this.editData.getRollType();
        if (BgRollTypeEnum.limitLengthRoll.equals((Object)rollType)) {
            this.rdoLimitLength.setSelected(true);
            this.spnHisPeriod.setEnabled(false);
        } else {
            this.rdoContinuous.setSelected(true);
            this.spnHisPeriod.setEnabled(true);
        }
        this.spnHisPeriod.setValue((Object)this.editData.getHisPeriodLength());
        this.spnLength.setValue((Object)this.editData.getLength());
        if (this.tblMain.getRowCount() <= 0) {
            this.tblMain.addRow();
        }
        this.checkExistsBgForm();
        this.fillTxt();
    }

    private void checkExistsBgForm() {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            try {
                if (BgRollRuleFactory.getRemoteInstance().checkExistsBgForm(this.editData.getId().toString())) {
                    this.rdoLimitLength.setEnabled(false);
                    this.rdoContinuous.setEnabled(false);
                    this.comboRollPart.setEnabled(false);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                SysUtil.abort();
            }
        }
    }

    protected void loadTemplateType() {
        String templateType = this.editData.getTptTypeNumber();
        if (!StringUtils.isEmpty((String)templateType)) {
            String[] names = templateType.split(",");
            BgTemFormTypeEnum[] data = new BgTemFormTypeEnum[names.length];
            HashSet<String> selt = new HashSet<String>();
            int in = names.length;
            for (int i = 0; i < in; ++i) {
                selt.add(names[i]);
                data[i] = BgTemFormTypeEnum.getEnum(names[i]);
            }
            BgTemplateTypeSelectDialog dialog = (BgTemplateTypeSelectDialog)this.prmtTemplateType.getSelector();
            dialog.setSelectMembers(selt);
            this.prmtTemplateType.setValue((Object)data);
        }
    }

    protected void storeScenario() {
        this.editData.getBgRollSettings().clear();
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            BgRollSettingsInfo setting = (BgRollSettingsInfo)this.tblMain.getRow(i).getUserObject();
            if (setting == null) continue;
            setting.setBgScenario((BgScenarioInfo)this.tblMain.getCell(i, COL_BGSCENARIO).getValue());
            setting.setActScenario((BgScenarioInfo)this.tblMain.getCell(i, COL_ACTSCENARIO).getValue());
            this.editData.getBgRollSettings().add(setting);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setCompStatus();
    }

    private void setCompStatus() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.COPYADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(true);
            this.setCompStatus(true);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.setCompStatus(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.setCompStatus(false);
        }
    }

    private void setCompStatus(boolean status) {
        this.txtName.setEnabled(status);
        this.rdoLimitLength.setEnabled(status);
        this.rdoContinuous.setEnabled(status);
        this.comboRollPart.setEnabled(status);
        this.spnLength.setEnabled(status);
        this.prmtTemplateType.setEnabled(status);
        this.btnAddRow.setEnabled(status);
        this.btnRemoveRow.setEnabled(status);
        this.tblMain.setEnabled(status);
        this.descMulitArea.setEnabled(status);
    }

    protected void loadScenario() {
        BgRollSettingsCollection bgRollSettings = this.editData.getBgRollSettings();
        this.tblMain.removeRows();
        if (bgRollSettings != null && !bgRollSettings.isEmpty()) {
            int in = bgRollSettings.size();
            for (int i = 0; i < in; ++i) {
                BgRollSettingsInfo setting = bgRollSettings.get(i);
                BgScenarioInfo bgScenario = setting.getBgScenario();
                BgScenarioInfo actScenario = setting.getActScenario();
                this.tblMain.addRow();
                this.tblMain.getCell(i, COL_BGSCENARIO_ID).setValue((Object)bgScenario.getId().toString());
                this.tblMain.getCell(i, COL_BGSCENARIO).setValue((Object)bgScenario);
                this.tblMain.getCell(i, COL_ACTSCENARIO_ID).setValue((Object)actScenario.getId().toString());
                this.tblMain.getCell(i, COL_ACTSCENARIO).setValue((Object)actScenario);
                this.tblMain.getRow(i).setUserObject((Object)setting);
            }
        }
    }

    private void initScenario() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn(COL_BGSCENARIO).setRequired(true);
        this.tblMain.getColumn(COL_ACTSCENARIO).setRequired(true);
        this.tblMain.getColumn(COL_BGSCENARIO).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.scenarioPromptBox(false)));
        this.tblMain.getColumn(COL_ACTSCENARIO).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.scenarioPromptBox(true)));
    }

    private KDBizPromptBox scenarioPromptBox(boolean isActScenario) throws EASBizException, BOSException {
        return this.scenarioPromptBox(isActScenario, null);
    }

    private KDBizPromptBox scenarioPromptBox(boolean isActScenario, FilterItemCollection filterItems) throws EASBizException, BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setEditFormat("$number$");
        if (isActScenario) {
            prmtSelect.setEnabledMultiSelection(false);
        } else {
            prmtSelect.setEnabledMultiSelection(true);
        }
        prmtSelect.setEditable(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!isActScenario) {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)isActScenario, CompareType.EQUALS));
        }
        if (filterItems != null) {
            filter.getFilterItems().addObjectCollection((IObjectCollection)filterItems);
        }
        evi.setFilter(filter);
        prmtSelect.setEntityViewInfo(evi);
        prmtSelect.getQueryAgent().resetRuntimeEntityView();
        return prmtSelect;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        IRow iRow;
        BgScenarioInfo info;
        ICell cell;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblMain.getColumnIndex(COL_BGSCENARIO)) {
            int i;
            int in;
            cell = this.tblMain.getCell(rowIndex, COL_BGSCENARIO);
            BgScenarioCollection col = new BgScenarioCollection();
            if (cell.getValue() instanceof String) {
                if (this.scenarios != null) {
                    String number = cell.getValue() == null ? "" : cell.getValue().toString();
                    in = this.scenarios.size();
                    for (i = 0; i < in; ++i) {
                        info = this.scenarios.get(i);
                        if (!info.getNumber().equals(number)) continue;
                        iRow = this.tblMain.getRow(rowIndex);
                        iRow.getCell(COL_BGSCENARIO_ID).setValue((Object)info.getId().toString());
                        iRow.getCell(COL_BGSCENARIO).setValue((Object)info);
                    }
                }
            } else if (cell.getValue() instanceof Object[]) {
                Object[] objs = (Object[])cell.getValue();
                in = objs.length;
                for (i = 0; i < in; ++i) {
                    if (!(objs[i] instanceof BgScenarioInfo)) continue;
                    col.add((BgScenarioInfo)objs[i]);
                }
            } else if (cell.getValue() instanceof BgScenarioCollObject) {
                BgScenarioCollObject colObj = (BgScenarioCollObject)cell.getValue();
                col.addCollection(colObj.getResult());
            }
            int inputN = rowIndex;
            if (col.isEmpty()) {
                return;
            }
            BgScenarioInfo oldValue = null;
            Object oldActValue = this.tblMain.getCell(rowIndex, COL_ACTSCENARIO).getValue();
            if (oldActValue != null && oldActValue instanceof BgScenarioInfo) {
                oldValue = (BgScenarioInfo)oldActValue;
            }
            this.tblMain.removeRow(rowIndex);
            int in2 = col.size();
            for (int i2 = 0; i2 < in2; ++i2) {
                info = col.get(i2);
                iRow = this.tblMain.addRow(inputN);
                BgRollSettingsInfo setting = new BgRollSettingsInfo();
                setting.setId(BOSUuid.create((BOSObjectType)setting.getBOSType()));
                iRow.setUserObject((Object)setting);
                if (info == null) {
                    return;
                }
                iRow.getCell(COL_BGSCENARIO_ID).setValue((Object)info.getId().toString());
                iRow.getCell(COL_BGSCENARIO).setValue((Object)info);
                ++inputN;
                this.filterActBgScenario(iRow);
                if (i2 != 0 || oldValue == null) continue;
                if (!this.scenarioNodes.containsKey(info.getId().toString())) {
                    iRow.getCell(COL_ACTSCENARIO_ID).setValue((Object)oldValue.getId().toString());
                    iRow.getCell(COL_ACTSCENARIO).setValue((Object)oldValue);
                    continue;
                }
                if (!this.scenarioNodes.get(info.getId().toString()).contains(oldValue)) continue;
                iRow.getCell(COL_ACTSCENARIO_ID).setValue((Object)oldValue.getId().toString());
                iRow.getCell(COL_ACTSCENARIO).setValue((Object)oldValue);
            }
        }
        if (colIndex == this.tblMain.getColumnIndex(COL_ACTSCENARIO)) {
            cell = this.tblMain.getCell(rowIndex, COL_ACTSCENARIO);
            if (cell.getValue() instanceof String) {
                String number;
                String string = number = cell.getValue() == null ? "" : cell.getValue().toString();
                if (this.scenarios != null) {
                    int in = this.scenarios.size();
                    for (int i = 0; i < in; ++i) {
                        info = this.scenarios.get(i);
                        if (!info.getNumber().equals(number)) continue;
                        iRow = this.tblMain.getRow(rowIndex);
                        iRow.getCell(COL_ACTSCENARIO_ID).setValue((Object)info.getId().toString());
                        iRow.getCell(COL_ACTSCENARIO).setValue((Object)info);
                    }
                }
            } else if (cell.getValue() instanceof BgScenarioInfo) {
                info = (BgScenarioInfo)cell.getValue();
                iRow = this.tblMain.getRow(rowIndex);
                iRow.getCell(COL_ACTSCENARIO_ID).setValue((Object)info.getId().toString());
                iRow.getCell(COL_ACTSCENARIO).setValue((Object)info);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int i;
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"numberNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"nameNull"));
            SysUtil.abort();
        }
        if (this.prmtTemplateType.getData() == null) {
            this.prmtTemplateType.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"templateTypeNull"));
            SysUtil.abort();
        }
        if (this.tblMain.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"bgScenarioNull"));
            SysUtil.abort();
        }
        HashSet<String> scenarioNum = new HashSet<String>();
        for (i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            if (this.tblMain.getRowCount() == 1 || this.tblMain.getRow(i).getUserObject() != null) continue;
            this.tblMain.removeRow(i);
        }
        int in = this.tblMain.getRowCount();
        for (i = 0; i < in; ++i) {
            BgScenarioInfo info;
            Object bgScen = this.tblMain.getRow(i).getCell(COL_BGSCENARIO).getValue();
            Object actScen = this.tblMain.getRow(i).getCell(COL_ACTSCENARIO).getValue();
            if (bgScen == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"bgScenarioNull"));
                SysUtil.abort();
            }
            if (actScen == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"actScenarioNull"));
                SysUtil.abort();
            }
            if (scenarioNum.contains((info = (BgScenarioInfo)bgScen).getNumber())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"existsScenarioNum", (Object[])new Object[]{info.getName(this.l)}));
                SysUtil.abort();
                continue;
            }
            scenarioNum.add(info.getNumber());
        }
    }

    private void filterActBgScenario(IRow iRow) throws EASBizException, BOSException {
        BgScenarioInfo info = (BgScenarioInfo)iRow.getCell(COL_BGSCENARIO).getValue();
        FilterItemCollection filterItems = new FilterItemCollection();
        if (this.scenarioNodes.containsKey(info.getId().toString())) {
            BgScenarioCollection coll = this.scenarioNodes.get(info.getId().toString());
            HashSet<String> set = new HashSet<String>();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                set.add(((BgScenarioInfo)iter.next()).getId().toString());
            }
            filterItems.add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        iRow.getCell(COL_ACTSCENARIO).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.scenarioPromptBox(true, filterItems)));
    }

    private void initBgTemplateType() {
        BgTemplateTypeSelectDialog dialog = new BgTemplateTypeSelectDialog();
        dialog.setMulti(true);
        this.prmtTemplateType.setSelector((KDPromptSelector)dialog);
        this.prmtTemplateType.addDataChangeListener((DataChangeListener)dialog);
        HashSet<String> selMembers = new HashSet<String>();
        selMembers.add(BgTemFormTypeEnum.VIEWLIST.getName());
        selMembers.add(BgTemFormTypeEnum.SPECIALFORM.getName());
        selMembers.add(BgTemFormTypeEnum.FIXEDFORM.getName());
        BgTemFormTypeEnum[] initData = new BgTemFormTypeEnum[selMembers.size()];
        initData[0] = BgTemFormTypeEnum.VIEWLIST;
        initData[1] = BgTemFormTypeEnum.FIXEDFORM;
        initData[2] = BgTemFormTypeEnum.SPECIALFORM;
        this.prmtTemplateType.setData((Object)initData);
        dialog.setSelectMembers(selMembers);
    }

    @Override
    protected void prmtTemplateType_willShow(SelectorEvent e) throws Exception {
        BgTemplateTypeSelectDialog selector = (BgTemplateTypeSelectDialog)this.prmtTemplateType.getSelector();
        HashSet<String> filterMembers = new HashSet<String>();
        if (this.rdoContinuous.isSelected() && BgRollPartEnum.monthWeek_monthRoll.equals(this.comboRollPart.getSelectedItem())) {
            filterMembers.add(BgTemFormTypeEnum.SPECIALFORM.getName());
            filterMembers.add(BgTemFormTypeEnum.FIXEDFORM.getName());
        } else if (this.rdoLimitLength.isSelected() && BgRollPartEnum.month_quarterRoll.equals(this.comboRollPart.getSelectedItem())) {
            filterMembers.add(BgTemFormTypeEnum.SPECIALFORM.getName());
            filterMembers.add(BgTemFormTypeEnum.FIXEDFORM.getName());
        }
        selector.setFilterMembers(filterMembers);
    }

    @Override
    protected void btnRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain);
        if (rows != null && !rows.isEmpty()) {
            Collections.sort(rows);
            for (int i = rows.size() - 1; i >= 0; --i) {
                this.tblMain.removeRow(((Integer)rows.get(i)).intValue());
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void comboRollPart_itemStateChanged(ItemEvent e) throws Exception {
        ArrayList data;
        BgTemFormTypeEnum[] enums;
        if (BgRollPartEnum.monthWeek_monthRoll.equals(e.getItem())) {
            ArrayList data2;
            BgTemFormTypeEnum[] enums2 = (BgTemFormTypeEnum[])this.prmtTemplateType.getData();
            if (enums2 != null && (data2 = new ArrayList(Arrays.asList((Object[])enums2))) != null && !data2.isEmpty()) {
                data2.remove((Object)BgTemFormTypeEnum.FIXEDFORM);
                data2.remove((Object)BgTemFormTypeEnum.SPECIALFORM);
                this.prmtTemplateType.setData((Object)data2.toArray(new BgTemFormTypeEnum[data2.size()]));
            }
        } else if (BgRollPartEnum.month_quarterRoll.equals(e.getItem()) && this.rdoLimitLength.isSelected() && (enums = (BgTemFormTypeEnum[])this.prmtTemplateType.getData()) != null && (data = new ArrayList(Arrays.asList((Object[])enums))) != null && !data.isEmpty()) {
            data.remove((Object)BgTemFormTypeEnum.FIXEDFORM);
            data.remove((Object)BgTemFormTypeEnum.SPECIALFORM);
            this.prmtTemplateType.setData((Object)data.toArray(new BgTemFormTypeEnum[data.size()]));
        }
        this.fillTxt();
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
        BgRollRuleFactory.getRemoteInstance().checkNumberDup(this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        BgNFCHelper.refreshListUI((CoreUI)this);
    }

    @Override
    protected void rdoLimitLength_actionPerformed(ActionEvent e) throws Exception {
        this.resetRollPart(true);
        this.spnHisPeriod.setEnabled(false);
        this.spnHisPeriod.setValue((Object)0);
    }

    @Override
    protected void rdoContinuous_actionPerformed(ActionEvent e) throws Exception {
        this.resetRollPart(false);
        this.spnHisPeriod.setEnabled(true);
    }

    private void resetRollPart(boolean isLimitLength) {
        BgRollPartEnum selectedItem = (BgRollPartEnum)((Object)this.comboRollPart.getSelectedItem());
        this.initRollPart(isLimitLength);
        int in = this.comboRollPart.getItemCount();
        for (int i = 0; i < in; ++i) {
            if (!this.comboRollPart.getItemAt(i).equals((Object)selectedItem)) continue;
            this.comboRollPart.setSelectedIndex(i);
        }
    }

    private void initRollPart(boolean isLimitLength) {
        this.comboRollPart.removeAllItems();
        if (isLimitLength) {
            this.comboRollPart.addItem((Object)BgRollPartEnum.monthWeekRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.monthRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.quarterRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.halfYearRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.month_quarterRoll);
        } else {
            this.comboRollPart.addItem((Object)BgRollPartEnum.monthWeekRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.monthRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.quarterRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.halfYearRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.month_quarterRoll);
            this.comboRollPart.addItem((Object)BgRollPartEnum.monthWeek_monthRoll);
        }
        this.comboRollPart.setSelectedItem((Object)this.editData.getRollPart());
    }

    protected IObjectValue createNewData() {
        BgRollRuleInfo rollRuleInfo = new BgRollRuleInfo();
        rollRuleInfo.setId(BOSUuid.create((BOSObjectType)rollRuleInfo.getBOSType()));
        rollRuleInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        rollRuleInfo.setOrgUnit(SysContext.getSysContext().getCurrentCostUnit().castToFullOrgUnitInfo());
        rollRuleInfo.setRollType(BgRollTypeEnum.limitLengthRoll);
        rollRuleInfo.setRollPart(BgRollPartEnum.monthRoll);
        rollRuleInfo.setHisVersion(this.resHelper.getString("txtHisVersion.text"));
        rollRuleInfo.setLength(1);
        return rollRuleInfo;
    }

    public boolean isModify() {
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW)) {
            return false;
        }
        return super.isModify();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgRollRuleFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (this.rdoLimitLength.isSelected()) {
            this.spnHisPeriod.setEnabled(false);
        } else {
            this.spnHisPeriod.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setCompStatus();
        SpinnerNumberModel model = new SpinnerNumberModel();
        model.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        model.setMinimum(Integer.valueOf(0));
        this.spnHisPeriod.setModel((SpinnerModel)model);
        SpinnerNumberModel lengthModel = new SpinnerNumberModel();
        lengthModel.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        lengthModel.setMinimum(Integer.valueOf(1));
        this.spnLength.setModel((SpinnerModel)lengthModel);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void fillTxt() {
        if (BgRollPartEnum.month_quarterRoll.equals(this.comboRollPart.getSelectedItem())) {
            this.lblLength.setText(EASResource.getString((String)resourcePath, (String)"month_quarterRoll"));
            this.lblHisPeriod.setText(EASResource.getString((String)resourcePath, (String)"month_quarterRoll"));
        } else if (BgRollPartEnum.monthWeek_monthRoll.equals(this.comboRollPart.getSelectedItem())) {
            this.lblLength.setText(EASResource.getString((String)resourcePath, (String)"monthWeek_monthRoll"));
            this.lblHisPeriod.setText(EASResource.getString((String)resourcePath, (String)"monthWeek_monthRoll"));
        } else {
            this.lblLength.setText("");
            this.lblHisPeriod.setText("");
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("id");
        selectors.add("rollType");
        selectors.add("templateType");
        selectors.add("tptTypeNumber");
        selectors.add("hisPeriodLength");
        selectors.add("length");
        selectors.add("bgRollSettings.*");
        selectors.add("bgRollSettings.bgScenario.*");
        selectors.add("bgRollSettings.actScenario.*");
        selectors.add("orgUnit.id");
        return selectors;
    }

    private String getCopyPermission() {
        return "mbg_BgRollRule02_addnew";
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo currentOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        UserInfo useInfo = SysContext.getSysContext().getCurrentUserInfo();
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(useInfo.getId()), (IObjectPK)new ObjectUuidPK(currentOrgUnit.getId()), this.getCopyPermission());
        super.actionCopy_actionPerformed(e);
    }

    private void checkOrgUnit(String key) throws Exception {
        FullOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCostUnit().castToFullOrgUnitInfo();
        if (!this.editData.getOrgUnit().getId().equals((Object)orgUnitInfo.getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)key));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgUnit("cantEdit");
        super.actionEdit_actionPerformed(e);
        this.checkExistsBgForm();
        if (BgRollTypeEnum.limitLengthRoll.equals((Object)this.editData.getRollType())) {
            this.spnHisPeriod.setEnabled(false);
        } else {
            this.spnHisPeriod.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgUnit("cantRemove");
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        if (this.confirmRemove()) {
            boolean bool = UtilRequest.isPrepare((String)"ActionRemove", (CoreUIObject)this);
            if (bool) {
                this.prepareRomove(null).callHandler();
            }
            this.removeByPK((IObjectPK)pk);
            this.removeAttachmentByBoPK(new String[]{pk.toString()});
        }
    }
}

