/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.BgSchemeDispatchReportUI;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.util.client.EASResource;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class BgSchemeCopyReportUI
extends BgSchemeDispatchReportUI {
    protected String RES = "com.kingdee.eas.ma.mbg.BgSchemeCopyResource";
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeCopyReportUI.class);

    @Override
    protected boolean isCheck() {
        return false;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void initReport() throws Exception {
        this.kDTable.checkParsed();
        this.kDTable.getStyleAttributes().setLocked(true);
        this.kDTable.addColumns(4);
        this.kDTable.getColumn(0).setWidth(125);
        this.kDTable.getColumn(1).setWidth(225);
        this.kDTable.getColumn(2).setWidth(85);
        this.kDTable.getColumn(3).setWidth(250);
        this.kDTable.addHeadRow();
        Date date = new Date();
        DateFormat simpleDateFormat = BgNationalFormatUIUtil.getNationalDateFormat();
        String dateStr = simpleDateFormat.format(date);
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        List result = (List)this.getUIContext().get(BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT);
        this.fillMainMsg(dateStr, bgScheme);
        if (result != null && !result.isEmpty()) {
            IRow row = this.kDTable.addRow();
            this.fillTitle(row);
            KDTableHelper.autoFitRowHeight((KDTable)this.kDTable, (int)row.getRowIndex());
            for (BgCopySchemeResult resultItem : result) {
                row = this.kDTable.addRow();
                this.fillRowData(row, resultItem);
            }
        }
    }

    @Override
    protected void fillTitle(IRow row) {
        row.getCell(0).setValue((Object)BgCommCHelper.getMessageStr((String)this.RES, (String)"baseMsg"));
        row.getCell(1).setValue((Object)BgCommCHelper.getMessageStr((String)this.RES, (String)"name"));
        row.getCell(2).setValue((Object)BgCommCHelper.getMessageStr((String)this.RES, (String)"orgUnit"));
        row.getCell(3).setValue((Object)BgCommCHelper.getMessageStr((String)this.RES, (String)"result"));
        row.getCell(3).getStyleAttributes().setWrapText(true);
    }

    protected void fillRowData(IRow row, BgCopySchemeResult resultItem) {
        row.getCell(0).setValue((Object)resultItem.getBaseMsg());
        row.getCell(1).setValue((Object)resultItem.getName());
        row.getCell(2).setValue((Object)resultItem.getOrgName());
        row.getCell(3).setValue((Object)resultItem.getCopyResult());
    }

    @Override
    protected void fillMainMsg(String dateStr, BgSchemeInfo bgScheme) {
        IRow row = this.kDTable.addRow();
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), this.kDTable.getColumnCount() - 1);
        row.getCell(0).setValue((Object)(EASResource.getString((String)this.RES, (String)"scheme") + " : " + bgScheme.getName()));
        row = this.kDTable.addRow();
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), this.kDTable.getColumnCount() - 1);
        row.getCell(0).setValue((Object)(EASResource.getString((String)this.RES, (String)"time") + " : " + dateStr));
        row = this.kDTable.addRow();
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), this.kDTable.getColumnCount() - 1);
        row.getCell(0).setValue((Object)(EASResource.getString((String)this.RES, (String)"person") + " : " + SysContext.getSysContext().getCurrentUserInfo().getName()));
    }

    @Override
    public String getUITitle() {
        String title = BgCommCHelper.getMessageStr((String)this.RES, (String)"schemeCopyResultUI");
        return title;
    }

    public void onShow() throws Exception {
        super.onShow();
        BgSchemeCopyReportUI.setWindowResizable(this.getUIWindow(), true);
    }

    public static void setWindowResizable(IUIWindow uiWindow, boolean resize) {
        if (uiWindow instanceof UINewFrame) {
            UINewFrame uiFrame = (UINewFrame)uiWindow;
            uiFrame.setResizable(resize);
        } else if (uiWindow instanceof UIModelDialog) {
            UIModelDialog uIModelDialog = (UIModelDialog)uiWindow;
            uIModelDialog.setResizable(resize);
        }
    }
}

