/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgSchemeDispatchReportUI;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgSchemeDispatchReportUI
extends AbstractBgSchemeDispatchReportUI {
    private static final long serialVersionUID = -8949942874897005591L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeDispatchReportUI.class);
    private boolean isDispath = true;

    public void setDispath(boolean isDispath) {
        this.isDispath = isDispath;
    }

    public boolean isDispath() {
        return this.isDispath;
    }

    protected void initUserConfig() {
        super.initUserConfig();
        PopupMenuManager mgr = this.createPopupMenuManager((JComponent)this.kDTable);
        mgr.removeMenuSection("table");
        mgr.removeMenuSection("tableSetting");
        mgr.removeMenuSection("saveSetting");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isCheck()) {
            Boolean dispatch = (Boolean)this.getUIContext().get(BgSchemeDispatchConstants.SCHEME_DISPATCH);
            this.setDispath(dispatch);
        }
        this.initReport();
    }

    protected boolean isCheck() {
        return true;
    }

    public String getUITitle() {
        String title = super.getUITitle();
        if (!this.isDispath()) {
            title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"scheme.antiDispatchReport.title");
        }
        return title;
    }

    protected void initReport() throws Exception {
        this.kDTable.checkParsed();
        this.kDTable.getStyleAttributes().setLocked(true);
        this.kDTable.addColumns(4);
        this.kDTable.getColumn(0).setWidth(125);
        this.kDTable.getColumn(1).setWidth(225);
        this.kDTable.getColumn(2).setWidth(85);
        this.kDTable.getColumn(3).setWidth(250);
        this.kDTable.addHeadRow();
        Date date = new Date();
        DateFormat simpleDateFormat = BgNationalFormatUIUtil.getNationalDateFormat();
        String dateStr = simpleDateFormat.format(date);
        String tmpStr = null;
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        List result = (List)this.getUIContext().get(BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT);
        this.fillMainMsg(dateStr, bgScheme);
        if (result != null && !result.isEmpty()) {
            IRow row = this.kDTable.addRow();
            this.fillTitle(row);
            KDTableHelper.autoFitRowHeight((KDTable)this.kDTable, (int)row.getRowIndex());
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String[] s1 = (String[])o1;
                    String[] s2 = (String[])o2;
                    if (s1[0].equals(s2[0])) {
                        return 0;
                    }
                    if (Boolean.valueOf(s1[0]).booleanValue()) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (String[] strs : result) {
                tmpStr = strs[0];
                row = this.kDTable.addRow();
                this.fillRowData(tmpStr, row, strs);
            }
        }
    }

    protected void fillMainMsg(String dateStr, BgSchemeInfo bgScheme) {
        IRow row = this.kDTable.addRow();
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), this.kDTable.getColumnCount() - 1);
        row.getCell(0).setValue((Object)(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"schemeDispatch") + " : " + bgScheme.getName()));
        row = this.kDTable.addRow();
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), this.kDTable.getColumnCount() - 1);
        row.getCell(0).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)(this.isDispath() ? "dispatch.time" : "antidispatch.time"), (Object[])new String[]{dateStr}));
        row = this.kDTable.addRow();
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), this.kDTable.getColumnCount() - 1);
        row.getCell(0).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)(this.isDispath() ? "dispatch.user" : "antidispatch.user"), (Object[])new String[]{SysContext.getSysContext().getCurrentUserInfo().getName()}));
        row = this.kDTable.addRow();
        this.kDTable.getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), this.kDTable.getColumnCount() - 1);
    }

    protected void fillTitle(IRow row) {
        row.getCell(0).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"template"));
        row.getCell(1).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"orgUnit"));
        if (this.isDispath()) {
            row.getCell(2).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"result"));
        } else {
            row.getCell(2).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"result.anti"));
        }
        row.getCell(3).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"cause"));
        row.getCell(3).getStyleAttributes().setWrapText(true);
    }

    protected void fillRowData(String tmpStr, IRow row, String[] strs) {
        row.getCell(0).setValue((Object)(strs[2] + "(" + strs[3] + ")"));
        row.getCell(1).setValue((Object)(strs[4] + "(" + strs[5] + ")"));
        if (Boolean.valueOf(tmpStr).booleanValue()) {
            row.getCell(2).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"dispatch.success"));
        } else {
            row.getCell(2).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)"dispatch.fail"));
            if (!StringUtils.isEmpty((String)strs[1])) {
                if (!StringUtils.isEmpty((String)strs[6])) {
                    row.getCell(3).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)strs[1], (Object[])new Object[]{strs[6]}));
                } else {
                    row.getCell(3).setValue((Object)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource", (String)strs[1]));
                }
            }
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }
}

