/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgSchemeF7UI;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeF7UI
extends AbstractBgSchemeF7UI {
    private static final long serialVersionUID = 1184314724848094248L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeF7UI.class);
    private String NUMBER = "number";
    private String NAME = "name";
    private String ISFORMAL = "isformal";
    private String BEGINDATE = "beginDate";
    private String ENDDATE = "endDate";
    private String ORGUNIT = "orgUnit.name";
    private BOSUuid bgOrgUnitId = null;
    private Set<String> bgSchemeIds = null;
    private boolean isOnlyExp = false;
    private boolean isMulti = false;
    private Object result = null;
    private boolean isCancel = true;

    public void setBgOrgUnitId(BOSUuid bgOrgUnitId) {
        this.bgOrgUnitId = bgOrgUnitId;
    }

    public BOSUuid getBgOrgUnitId() {
        if (this.bgOrgUnitId == null) {
            this.bgOrgUnitId = (BOSUuid)this.getUIContext().get("ORGUNIT_ID");
        }
        return this.bgOrgUnitId;
    }

    public void setBgSchemeIds(Set<String> bgSchemeIds) {
        this.bgSchemeIds = bgSchemeIds;
    }

    public Set<String> getBgSchemeIds() {
        return this.bgSchemeIds;
    }

    public void setOnlyExp(boolean isOnlyExp) {
        this.isOnlyExp = isOnlyExp;
    }

    public boolean isOnlyExp() {
        return this.isOnlyExp;
    }

    public void setMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    public boolean isMulti() {
        Boolean type = (Boolean)this.getUIContext().get("type");
        if (type != null) {
            this.isMulti = type;
        }
        return this.isMulti;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgSchemeF7UI() throws Exception {
        this.init();
    }

    public void init() {
        this.kdTable.checkParsed();
        this.kdTable.getStyleAttributes().setLocked(true);
        if (this.isMulti()) {
            this.kdTable.getSelectManager().setSelectMode(10);
        } else {
            this.kdTable.getSelectManager().setSelectMode(2);
        }
        this.kdTable.getColumn(this.BEGINDATE).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.kdTable.getColumn(this.ENDDATE).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
    }

    public void onShow() throws Exception {
        super.onShow();
        Object isCsl = this.getUIContext().get(DimensionConstants.DEF_CSL_NAME);
        if (isCsl != null && ((Boolean)isCsl).booleanValue()) {
            super.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslScheme"));
            this.kDLabelContainer1.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslSchemeSearch"));
            this.kDLabelContainer1.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslSchemeSearch"));
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBgSchemeIds((Set)this.getUIContext().get("BGSCHEME_ID"));
        this.fillBgScheme();
    }

    public String getUITitle() {
        return super.getUITitle();
    }

    public void fillBgScheme() throws BOSException, EASBizException {
        this.kdTable.removeRows();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (this.getBgSchemeIds() == null || this.getBgSchemeIds().isEmpty()) {
            return;
        }
        BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("id", this.getBgSchemeIds(), CompareType.INCLUDE));
        if (this.isOnlyExp()) {
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgSchemeType.id", (Object)"lVIAAAAuzHmQxGui", CompareType.EQUALS));
        }
        this.addSearchFilter(view);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isFormal");
        sic.add("orgUnit.name");
        sic.add("dateFrom");
        sic.add("dateTo");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        view.getSorter().add(new SorterItemInfo("number"));
        BgSchemeCollection colls = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(view);
        if (colls != null && colls.size() > 0) {
            IRow row = null;
            BgSchemeInfo bgSchemeInfo = null;
            for (int i = 0; i < colls.size(); ++i) {
                bgSchemeInfo = colls.get(i);
                row = this.kdTable.addRow();
                row.setUserObject((Object)bgSchemeInfo);
                row.getCell(this.NUMBER).setValue((Object)bgSchemeInfo.getNumber());
                row.getCell(this.NAME).setValue((Object)bgSchemeInfo.getName());
                row.getCell(this.ISFORMAL).setValue((Object)new Boolean(bgSchemeInfo.isIsFormal()));
                row.getCell(this.BEGINDATE).setValue((Object)bgSchemeInfo.getDateFrom());
                row.getCell(this.ENDDATE).setValue((Object)bgSchemeInfo.getDateTo());
                row.getCell(this.ORGUNIT).setValue((Object)bgSchemeInfo.getOrgUnit().getName());
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.getBgOrgUnitId() == null) {
            return;
        }
        this.setBgSchemeIds(BgSchemeF7UI.getBgSchemeIds(this.getBgOrgUnitId()));
        this.fillBgScheme();
    }

    public static Set<String> getBgSchemeIds(BOSUuid orgUnitId) throws BOSException, EASBizException {
        return BgSchemeFactory.getRemoteInstance().getCollection4SchemeList(orgUnitId.toString(), true);
    }

    @Override
    protected void kdTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdTable_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.btnSubmit_actionPerformed(null);
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        ArrayList blocks = this.kdTable.getSelectManager().getBlocks();
        if (blocks != null) {
            IRow row = null;
            BgSchemeCollection colls = new BgSchemeCollection();
            for (KDTSelectBlock block : blocks) {
                if (block == null) continue;
                int in = block.getEndRow();
                for (int i = block.getBeginRow(); i <= in; ++i) {
                    row = this.kdTable.getRow(i);
                    if (row == null) continue;
                    colls.add((BgSchemeInfo)row.getUserObject());
                }
            }
            if (colls.isEmpty()) {
                return;
            }
            if (this.isMulti()) {
                Object[] objs = new Object[colls.size()];
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    objs[i] = colls.get(i);
                }
                this.result = objs;
            } else {
                this.result = colls.get(0);
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void kDSearch_focusLost(FocusEvent e) throws Exception {
        super.kDSearch_focusLost(e);
        this.kDSearch.requestFocus();
        if (StringUtils.equals((String)this.kDSearch.getText(), (String)((String)this.kDSearch.getUserObject()))) {
            return;
        }
        this.fillBgScheme();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.fillBgScheme();
    }

    protected void addSearchFilter(EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            return;
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        int filterSize = viewInfo.getFilter().getFilterItems().size();
        String filterText = this.kDSearch.getText().trim().toString();
        this.kDSearch.setUserObject((Object)filterText);
        if (!StringUtils.isEmpty((String)filterText)) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("description", (Object)("%" + filterText + "%"), CompareType.LIKE));
            if (filterSize == 0) {
                viewInfo.getFilter().setMaskString(" #0 OR #1 OR #2");
            } else {
                viewInfo.getFilter().setMaskString(" ( " + viewInfo.getFilter().getMaskString() + " ) And (#" + filterSize + " OR #" + (filterSize + 1) + " OR #" + (filterSize + 2) + " )");
            }
            this.kDSearch.setSelectAllOnFocus(true);
        }
    }
}

