/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.BGReportUI;
import com.kingdee.eas.ma.base.client.BgBaseImportUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationEntryInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationMapCollection;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationMapInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.client.utils.BgSchemeIntegrationClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeIntegrationImportUI
extends BgBaseImportUI {
    private static final long serialVersionUID = 6856164018559214869L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeIntegrationImportUI.class);
    private BgSchemeDimensionHelper sourceSchemeHelper = null;
    private BgSchemeDimensionHelper targetSchemeHelper = null;
    private static final String Res = "com.kingdee.eas.ma.mbg.BgSchemeIntegrationResource";
    private static int SOURCENUMINDEX = 0;
    private static int SOURCENAMEINDEX = 1;
    private static int TARGETNUMINDEX = 2;
    private static int TARGETNAMEINDEX = 3;
    private KDTable tblMap = null;
    private Map<String, BgDimensionMember> querySourceMembers = null;
    private Map<String, BgDimensionMember> queryTargetMembers = null;
    private BgSchemeIntegrationEntryInfo entryInfo;
    private OrgUnitInfo orgUnitInfo = null;
    IDimensionFormulaFacade formulaFacade = null;

    public Map<String, BgDimensionMember> getQuerySourceMembers() {
        return this.querySourceMembers;
    }

    public void setQuerySourceMembers(Map<String, BgDimensionMember> querySourceMembers) {
        this.querySourceMembers = querySourceMembers;
    }

    public Map<String, BgDimensionMember> getQueryTargetMembers() {
        return this.queryTargetMembers;
    }

    public void setQueryTargetMembers(Map<String, BgDimensionMember> queryTargetMembers) {
        this.queryTargetMembers = queryTargetMembers;
    }

    public BgSchemeIntegrationEntryInfo getEntryInfo() {
        return this.entryInfo;
    }

    public void setEntryInfo(BgSchemeIntegrationEntryInfo entryInfo) {
        this.entryInfo = entryInfo;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public BgSchemeDimensionHelper getSourceSchemeHelper() {
        return this.sourceSchemeHelper;
    }

    public void setSourceSchemeHelper(BgSchemeDimensionHelper sourceSchemeHelper) {
        this.sourceSchemeHelper = sourceSchemeHelper;
    }

    public BgSchemeDimensionHelper getTargetSchemeHelper() {
        return this.targetSchemeHelper;
    }

    public void setTargetSchemeHelper(BgSchemeDimensionHelper targetSchemeHelper) {
        this.targetSchemeHelper = targetSchemeHelper;
    }

    public KDTable getTblMap() {
        return this.tblMap;
    }

    public void setTblMap(KDTable tblMap) {
        this.tblMap = tblMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("sourceSchemeHelper") != null) {
            this.setSourceSchemeHelper((BgSchemeDimensionHelper)this.getUIContext().get("sourceSchemeHelper"));
        }
        if (this.getUIContext().get("targetSchemeHelper") != null) {
            this.setTargetSchemeHelper((BgSchemeDimensionHelper)this.getUIContext().get("targetSchemeHelper"));
        }
        if (this.getUIContext().get("tblMap") != null) {
            this.setTblMap((KDTable)this.getUIContext().get("tblMap"));
        }
        if (this.getUIContext().get("entryInfo") != null) {
            this.setEntryInfo((BgSchemeIntegrationEntryInfo)this.getUIContext().get("entryInfo"));
        }
        if (this.getUIContext().get("orgUnitInfo") != null) {
            this.setOrgUnitInfo((OrgUnitInfo)this.getUIContext().get("orgUnitInfo"));
        }
    }

    protected String getImportTitle() {
        return BgSchemeIntegrationClientHelper.getString("importTitle");
    }

    protected String getTemplateTitle() {
        return EASResource.getString((String)Res, (String)"bgSchemeIntegImportTemplate");
    }

    protected void importData(KDSSheet sheet) {
        this.checkSheetStyle(sheet);
        this.setQuerySourceMembers(this.getDimensionMembers(sheet, SOURCENUMINDEX, this.sourceSchemeHelper, this.getQuerySourceMembers()));
        this.setQueryTargetMembers(this.getDimensionMembers(sheet, TARGETNUMINDEX, this.targetSchemeHelper, this.getQueryTargetMembers()));
        this.importFileData(sheet);
    }

    private IDimensionFormulaFacade getDimensionFormulaInstance() throws Exception {
        if (this.formulaFacade == null) {
            this.formulaFacade = DimensionFormulaFacadeFactory.getRemoteInstance();
        }
        return this.formulaFacade;
    }

    private Map<String, BgDimensionMember> getDimensionMembers(KDSSheet sheet, int numIndex, BgSchemeDimensionHelper schemeHelper, Map<String, BgDimensionMember> queryDimMembers) {
        if (queryDimMembers == null) {
            try {
                HashSet<String> dimNums = new HashSet<String>();
                int in = sheet.getRowCount();
                for (int i = 2; i < in; ++i) {
                    Object dimNum = sheet.getCell(i, numIndex, false).getValue();
                    if (dimNum == null || StringUtils.isEmpty((String)dimNum.toString())) continue;
                    dimNums.add(dimNum.toString());
                }
                queryDimMembers = this.getDimensionFormulaInstance().queryMembers(this.getOrgUnitInfo().getId().toString(), schemeHelper, this.entryInfo.getDimNumber(), dimNums, false, null);
                if (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(this.entryInfo.getDimNumber())) {
                    Set<String> notRollVersions = DimensionRelationClientHelper.getNotRollVersion(schemeHelper);
                    for (String version : queryDimMembers.keySet()) {
                        if (notRollVersions.contains(version)) continue;
                        queryDimMembers.remove(version);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"BgSchemeIntegrationImportUI getDimMembers error", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
        }
        return queryDimMembers;
    }

    private void importFileData(KDSSheet sheet) {
        try {
            HashSet<String> exsitsNum = new HashSet<String>();
            int jn = this.tblMap.getRowCount();
            for (int j = 0; j < jn; ++j) {
                ICell cell = this.tblMap.getCell(j, SOURCENUMINDEX);
                if (cell == null || cell.getValue() == null) continue;
                exsitsNum.add(this.tblMap.getCell(j, SOURCENUMINDEX).getValue().toString());
            }
            int errorNum = this.getErrorNum();
            this.progressBar.setValue(0);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(sheet.getRowCount());
            BgSchemeIntegrationMapCollection importMap = new BgSchemeIntegrationMapCollection();
            BgSchemeIntegrationMapInfo info = null;
            BgDimensionMember member = null;
            ArrayList errorList = new ArrayList();
            HashSet<String> errorSoucNums = new HashSet<String>();
            HashSet<String> errorTargNums = new HashSet<String>();
            HashMap<String, String> map = null;
            int count = 0;
            int in = sheet.getRowCount();
            for (int i = 2; i < in; ++i) {
                this.progressBar.setValue(i);
                if (this.checkHasEmptyRow(sheet, i)) continue;
                Object sourceNum = sheet.getCell(i, SOURCENUMINDEX, false).getValue();
                Object targetNum = sheet.getCell(i, TARGETNUMINDEX, false).getValue();
                if (exsitsNum.contains(sourceNum)) continue;
                ++count;
                if (sourceNum == null || StringUtils.isEmpty((String)sourceNum.toString())) {
                    map = new HashMap();
                    map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)Res, (String)"importError0"), i - 1));
                    errorList.add(map);
                    if (errorNum != 1) continue;
                    break;
                }
                if (targetNum == null || StringUtils.isEmpty((String)targetNum.toString())) {
                    map = new HashMap();
                    map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)Res, (String)"importError1"), i - 1));
                    errorList.add(map);
                    if (errorNum != 1) continue;
                    break;
                }
                if (this.querySourceMembers != null && !this.querySourceMembers.containsKey(sourceNum.toString())) {
                    map = new HashMap();
                    map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)Res, (String)"importError2"), i - 1, sourceNum.toString()));
                    errorList.add(map);
                    errorSoucNums.add(sourceNum.toString());
                    if (errorNum != 1) continue;
                    break;
                }
                if (this.queryTargetMembers != null && !this.queryTargetMembers.containsKey(targetNum.toString())) {
                    map = new HashMap();
                    map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)Res, (String)"importError3"), i - 1, targetNum.toString()));
                    errorList.add(map);
                    errorTargNums.add(targetNum.toString());
                    if (errorNum != 1) continue;
                    break;
                }
                member = this.queryTargetMembers.get(targetNum);
                if (!member.isLeaf()) {
                    map = new HashMap();
                    map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)Res, (String)"importError4"), i - 1, member.getNumber()));
                    errorList.add(map);
                    errorTargNums.add(member.getNumber());
                    if (errorNum != 1) continue;
                    break;
                }
                info = new BgSchemeIntegrationMapInfo();
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                info.setEntry(this.entryInfo);
                info.setSourceMemberNumber(sourceNum.toString());
                info.setSourceMemberName(this.querySourceMembers.get(sourceNum.toString()).getName());
                info.setTargetMemberNumber(targetNum.toString());
                info.setTargetMemberName(this.queryTargetMembers.get(info.getTargetMemberNumber()).getName());
                importMap.add(info);
            }
            this.fillData(importMap);
            ArrayList txtlst = new ArrayList();
            map = new HashMap<String, String>();
            map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)Res, (String)"importMsg_1"), importMap.size()));
            txtlst.add(map);
            if (sheet.getRowCount() - importMap.size() != 2) {
                map = new HashMap();
                if (errorNum == 1) {
                    map.put(" ", BgCommCHelper.getMessageStr((String)Res, (String)"importMsg_2", (Object[])new String[]{String.valueOf(count - importMap.size())}));
                } else {
                    map.put(" ", BgCommCHelper.getMessageStr((String)Res, (String)"importMsg_2", (Object[])new String[]{String.valueOf(count - importMap.size())}));
                }
                txtlst.add(map);
            }
            txtlst.addAll(errorList);
            ArrayList<String> listHeadTitle = new ArrayList<String>();
            listHeadTitle.add(" ");
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"LIST_CONTENT", txtlst);
            ctx.put((Object)"LIST_HEAD_TITLE", listHeadTitle);
            String invokeTime = BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date());
            ctx.put((Object)"INVOKE_TIME", (Object)invokeTime);
            ctx.put((Object)"UI_OWNER_TITLE", (Object)BgCommCHelper.getMessageStr((String)Res, (String)"importTitle"));
            ctx.put((Object)"ORG_DETAIL", (Object)BgCommCHelper.getMessageStr((String)Res, (String)"schemeIntegImportDetail"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGReportUI.class.getName(), (Map)ctx);
            uiWindow.show();
        }
        catch (Exception e) {
            logger.error((Object)"BgSchemeIntegrationImportUI importFileData error", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    private boolean checkHasEmptyRow(KDSSheet sheet, int rowIndex) {
        if (sheet.getRow(rowIndex, false) == null) {
            return true;
        }
        KDSCell cell = null;
        boolean hasCell = true;
        for (int colIndex = 0; colIndex <= sheet.getColumnCount(); ++colIndex) {
            cell = sheet.getCell(rowIndex, colIndex, false);
            if (this.getValue(cell) == null) continue;
            hasCell = false;
            break;
        }
        return hasCell;
    }

    private Object getValue(KDSCell cell) {
        String _value = null;
        if (cell != null && cell.getValue() != null && StringUtils.isEmpty((String)(_value = cell.getValue().toString().trim()))) {
            _value = null;
        }
        return _value;
    }

    private void fillData(BgSchemeIntegrationMapCollection importMap) {
        if (importMap == null || this.tblMap == null) {
            return;
        }
        this.tblMap.getEditManager().stopEditing();
        int rowBegin = this.tblMap.getRowCount();
        BgSchemeIntegrationMapInfo info = null;
        this.tblMap.addRows(importMap.size());
        IRow row = null;
        int in = importMap.size();
        for (int i = 0; i < in; ++i) {
            row = this.tblMap.getRow(rowBegin + i);
            info = importMap.get(i);
            BgSchemeIntegrationClientHelper.loadMap(row, info);
        }
    }

    private void checkSheetStyle(KDSSheet sheet) {
        int columnCount = 0;
        int rowCount = sheet.getRowCount();
        columnCount = sheet.getColumnCount() > 0 ? sheet.getColumnCount() : sheet.getExpandedColumns();
        if (columnCount < 4 || columnCount < this.tblMap.getColumnCount()) {
            MsgBox.showWarning((String)BgSchemeIntegrationClientHelper.getString("importStyleError"));
            SysUtil.abort();
        }
        if (rowCount < 2) {
            MsgBox.showWarning((String)BgSchemeIntegrationClientHelper.getString("importNoData"));
            SysUtil.abort();
        }
        int in = columnCount;
        for (int i = 0; i < in; ++i) {
            String tblValue;
            String sheetValue = sheet.getCell(1, i, false).getValue() == null ? "" : sheet.getCell(1, i, false).getValue().toString();
            String string = tblValue = this.tblMap.getHeadRow(1).getCell(i).getValue() == null ? "" : this.tblMap.getHeadRow(1).getCell(i).getValue().toString();
            if (sheetValue.equals(tblValue)) continue;
            MsgBox.showWarning((String)BgSchemeIntegrationClientHelper.getString("importStyleError"));
            SysUtil.abort();
        }
    }
}

