/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FindDialog;
import com.kingdee.eas.framework.client.ListFind;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationFactory;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationReportFactory;
import com.kingdee.eas.ma.mbg.client.AbstractBgSchemeIntegrationRptListUI;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgSchemeIntegrationRptListUI
extends AbstractBgSchemeIntegrationRptListUI {
    private static final long serialVersionUID = -2863278482489494078L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeIntegrationRptListUI.class);
    private BgCellRenderHelper sourceCellHelper = new BgCellRenderHelper();
    private BgCellRenderHelper targetCellHelper = new BgCellRenderHelper();
    private static final String COL_orgUnitName = "orgUnitName";
    private static final String COL_bgPeriodName = "bgPeriodName";
    private static final String COL_sourceOrgUnitName = "sourceOrgUnitName";
    private static final String COL_sourceBgPeriodName = "sourceBgPeriodName";
    private static final String COL_value = "value";
    private static final String COL_creatorName = "creator.name";
    private static final String COL_createTime = "createTime";
    private static final String COL_accountName = "accountName";
    private static final String COL_accountNumber = "accountNumber";
    private static final String COL_sourceAccountName = "sourceAccountName";
    private static final String COL_sourceAccountNumber = "sourceAccountNumber";
    private static final String COL_otherNumber = "otherNumber";
    private static final String COL_otherName = "otherName";
    private static final String COL_sourceOtherNumber = "sourceOtherNumber";
    private static final String COL_sourceOtherName = "sourceOtherName";
    private static final String COL_sourceValue = "sourceValue";
    private FindDialog findDialog = null;

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.tblMain.getColumn(COL_value).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)2));
        this.tblMain.getColumn(COL_sourceValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)2));
    }

    public void onLoad() throws Exception {
        String id = this.getIntegerationId();
        BgSchemeIntegrationInfo info = null;
        if (id != null) {
            info = BgSchemeIntegrationFactory.getRemoteInstance().getBgSchemeIntegrationInfo("select id, number, name, sourceBgScheme.id, sourceBgScheme.number, sourceBgScheme.name, targetBgScheme.id, targetBgScheme.number, targetBgScheme.name where id = '" + id + "'");
            this.targetCellHelper.init();
            this.sourceCellHelper.init();
        }
        super.onLoad();
        this.tblMain.setColumnMoveable(false);
        if (info != null) {
            this.txtNumber.setText(info.getNumber());
            this.txtName.setText(info.getName());
            this.prmtSourceBgScheme.setData((Object)info.getSourceBgScheme());
            this.prmtTargetBgScheme.setData((Object)info.getTargetBgScheme());
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            this.tblMain.getMergeManager().setMergeMode(5);
            this.tblMain.getColumn(COL_accountName).setRenderer((IBasicRender)this.targetCellHelper.getOVRender(BgCellRenderHelper.getAccountViewIdByBgScheme(info.getTargetBgScheme())));
            this.tblMain.getColumn(COL_sourceAccountName).setRenderer((IBasicRender)this.sourceCellHelper.getOVRender(BgCellRenderHelper.getAccountViewIdByBgScheme(info.getSourceBgScheme())));
            this.tblMain.getColumn(COL_otherName).setRenderer((IBasicRender)BgCellRenderHelper.getMemberComRender());
            this.tblMain.getColumn(COL_sourceOtherName).setRenderer((IBasicRender)BgCellRenderHelper.getMemberComRender());
        }
    }

    protected String getIntegerationId() {
        return (String)this.getUIContext().get("ID");
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String inteId = this.getIntegerationId();
        if (inteId == null) {
            inteId = "000000000000000000000000000=";
        }
        filter.getFilterItems().add(new FilterItemInfo("integration.id", (Object)inteId, CompareType.EQUALS));
        return filter;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo != null && viewInfo.getFilter() != null && !viewInfo.getFilter().getFilterItems().isEmpty()) {
            int i;
            viewInfo = (EntityViewInfo)viewInfo.clone();
            StringBuilder maskString = null;
            if (StringUtils.isEmpty((String)viewInfo.getFilter().getMaskString())) {
                maskString = new StringBuilder();
                for (i = 0; i < viewInfo.getFilter().getFilterItems().size(); ++i) {
                    if (i > 0) {
                        maskString.append(" AND ");
                    }
                    maskString.append("#").append(i);
                }
            } else {
                maskString = new StringBuilder(viewInfo.getFilter().getMaskString());
            }
            for (i = 0; i < viewInfo.getFilter().getFilterItems().size(); ++i) {
                if (this.replaceFilterItem(viewInfo, i, maskString, COL_accountName, COL_accountNumber)) {
                    ++i;
                    continue;
                }
                if (this.replaceFilterItem(viewInfo, i, maskString, COL_sourceAccountName, COL_sourceAccountNumber)) {
                    ++i;
                    continue;
                }
                if (this.replaceFilterItem(viewInfo, i, maskString, COL_otherName, COL_otherNumber)) {
                    ++i;
                    continue;
                }
                if (!this.replaceFilterItem(viewInfo, i, maskString, COL_sourceOtherName, COL_sourceOtherNumber)) continue;
                ++i;
            }
            viewInfo.getFilter().setMaskString(maskString.toString());
        }
        IQueryExecutor executor = super.getQueryExecutor(queryPK, viewInfo);
        return executor;
    }

    private boolean replaceFilterItem(EntityViewInfo viewInfo, int index, StringBuilder maskString, String nameField, String numberField) {
        if (viewInfo.getFilter().getFilterItems().size() <= index) {
            return false;
        }
        FilterItemInfo filterItem = viewInfo.getFilter().getFilterItems().get(index);
        if (!nameField.equalsIgnoreCase(filterItem.getPropertyName())) {
            return false;
        }
        filterItem = (FilterItemInfo)filterItem.clone();
        filterItem.setPropertyName(numberField);
        for (int i = viewInfo.getFilter().getFilterItems().size() - 1; i > index; --i) {
            this.replace(maskString, "#" + i, "#" + (i + 1));
        }
        this.replace(maskString, "#" + index, " (#" + index + " OR #" + (index + 1) + ") ");
        if (viewInfo.getFilter().getFilterItems().size() == index + 1) {
            viewInfo.getFilter().getFilterItems().add(filterItem);
        } else {
            viewInfo.getFilter().getFilterItems().insertObject(index, (IObjectValue)filterItem);
        }
        return true;
    }

    private void replace(StringBuilder maskString, String s1, String s2) {
        int index = maskString.indexOf(s1);
        if (index < 0) {
            return;
        }
        maskString.replace(index, index + s1.length(), s2);
    }

    protected FindDialog getFindDialog() throws Exception {
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        ArrayList<ListFind> FindPropertyName = new ArrayList<ListFind>();
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            String name1;
            if (this.tblMain.getColumn(i).getStyleAttributes().isHided()) continue;
            String name0 = this.tblMain.getHeadRow(0).getCell(i).getValue().toString();
            if (!name0.equals(name1 = this.tblMain.getHeadRow(1).getCell(i).getValue().toString())) {
                name0 = name0 + "_" + name1;
            }
            ListFind cEnum = new ListFind(this.tblMain.getColumnKey(i), name0);
            FindPropertyName.add(cEnum);
        }
        if (FindPropertyName.size() == 0) {
            return null;
        }
        this.findDialog = win instanceof Frame ? new MyFindDialog((Frame)win, "", FindPropertyName, true) : new MyFindDialog((Dialog)win, "", FindPropertyName, true);
        this.findDialog.addFindListListener(this.getFindListListener());
        return this.findDialog;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgSchemeIntegrationReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            this.convertMember(r, COL_accountName, COL_accountNumber);
            this.convertMember(r, COL_otherName, COL_otherNumber);
            this.convertMember(r, COL_sourceAccountName, COL_sourceAccountNumber);
            this.convertMember(r, COL_sourceOtherName, COL_sourceOtherNumber);
        }
    }

    private void convertMember(int rowIndex, String nameCol, String numberCol) {
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null || !(row.getCell(nameCol).getValue() instanceof String)) {
            return;
        }
        String number = (String)row.getCell(numberCol).getValue();
        String name = (String)row.getCell(nameCol).getValue();
        row.getCell(nameCol).setValue((Object)new BgDimensionMember(null, null, name, number));
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    class MyFindDialog
    extends FindDialog {
        public MyFindDialog(Frame owner, String messages, List FindPropertyName, boolean mode) throws Exception {
            super(owner, messages, FindPropertyName, mode);
        }

        public MyFindDialog(Dialog owner, String messages, List FindPropertyName, boolean mode) throws Exception {
            super(owner, messages, FindPropertyName, mode);
        }

        public void initUIContentLayout() {
            if (FrameWorkUtils.isWindowsXP()) {
                this.setBounds(new Rectangle(300, 400, 505, 329));
            } else {
                this.setBounds(new Rectangle(300, 400, 505, 322));
            }
            this.getContentPane().setLayout(null);
            this.lblLocation.setBounds(new Rectangle(10, 10, 200, 19));
            this.getContentPane().add((Component)this.lblLocation, null);
            this.sroPane.setBounds(new Rectangle(10, 37, 244, 214));
            this.getContentPane().add((Component)this.sroPane, null);
            this.lblLocate.setBounds(new Rectangle(262, 10, 100, 19));
            this.getContentPane().add((Component)this.lblLocate, null);
            this.txtLocate.setBounds(new Rectangle(262, 37, 231, 19));
            this.getContentPane().add((Component)this.txtLocate, null);
            this.kDSeparator1.setBounds(new Rectangle(0, 259, 500, 10));
            this.getContentPane().add((Component)this.kDSeparator1, null);
            this.btnLocate.setBounds(new Rectangle(344, 267, 73, 21));
            this.getContentPane().add((Component)this.btnLocate, null);
            this.btnClose.setBounds(new Rectangle(420, 267, 73, 21));
            this.getContentPane().add((Component)this.btnClose, null);
            this.chkMistiness.setBounds(new Rectangle(258, 66, 226, 19));
            this.getContentPane().add((Component)this.chkMistiness, null);
            this.rbnPrevious.setBounds(new Rectangle(262, 93, 140, 19));
            this.getContentPane().add((Component)this.rbnPrevious, null);
            this.rbnNext.setBounds(new Rectangle(262, 120, 140, 19));
            this.getContentPane().add((Component)this.rbnNext, null);
            this.setResizable(false);
        }
    }
}

