/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.core.TabbedBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgSheetManager;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.client.AbstractBgSheetNameUI;
import com.kingdee.eas.ma.mbg.client.BgSheetManagerUI;
import com.kingdee.eas.ma.mbg.client.ViewListLayoutDesignerUI;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgSheetNameUI
extends AbstractBgSheetNameUI {
    private static final long serialVersionUID = -8156270436138989363L;
    private static final Logger logger = CoreUIObject.getLogger(BgSheetNameUI.class);
    public static final String SELECTED_INDEX = "selectedIndex";
    protected BgSheetManager sheetManager = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        int selectIndex = (Integer)this.getUIContext().get(SELECTED_INDEX);
        this.sheetManager = (BgSheetManager)this.getOwner().getSheetList().getElement(selectIndex);
        this.updateSheetName.setStringValue(this.sheetManager.getSheetName());
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.verifyInput();
        this.sheetManager.setSheetName(this.updateSheetName.getText());
        this.destroyWindow();
    }

    protected void verifyInput() throws Exception {
        String updatedSheetName = this.updateSheetName.getText();
        if (StringUtils.isEmpty((String)updatedSheetName)) {
            throw new TemplateException(TemplateException.CURRENTSHEETISNULL);
        }
        updatedSheetName = updatedSheetName.trim();
        if (!((ViewListLayoutDesignerUI)this.getOwner().getOwner()).checkSheetName(updatedSheetName)) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{LanguageManager.getLangMessage((String)"renameWarning3", TabbedBar.class, (String)"NotFound")});
        }
        int end = this.getOwner().getSheetList().getElementCount();
        for (int start = 0; start < end; ++start) {
            String existSheetName;
            if (this.getOwner().getSheetList().getElement(start).equals(this.sheetManager) || !updatedSheetName.equals(existSheetName = ((BgSheetManager)this.getOwner().getSheetList().getElement(start)).getSheetName())) continue;
            throw new TemplateException(TemplateException.SHEETNAMEREPEATE);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    protected BgSheetManagerUI getOwner() {
        return (BgSheetManagerUI)((Object)this.getUIContext().get("Owner"));
    }
}

