/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.client.AbstractBgSpecialCourseProcessUI;
import com.kingdee.eas.ma.mbg.client.BgFinalizedClientHelper;
import com.kingdee.eas.ma.mbg.client.BgTemFormatImportUI;
import com.kingdee.eas.ma.mbg.client.form.BgNFormSpecialProvider;
import com.kingdee.eas.ma.mbg.client.utils.BgFormAuditClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BudgetEditMenuManager;
import com.kingdee.eas.ma.mbg.client.utils.DimensionFillHelper;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialFormProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialTemplateProcessUI;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class BgSpecialCourseProcessUI
extends AbstractBgSpecialCourseProcessUI
implements IBgSpecialFormProcessUI,
IBgSpecialTemplateProcessUI {
    private static final long serialVersionUID = -256231882359029483L;
    private static final Logger logger = CoreUIObject.getLogger(BgSpecialCourseProcessUI.class);
    private boolean createNewBook = true;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.addPagePanel();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            BgFormInfo bgFormInfo = this.getBgFormInfo();
            String logName = bgFormInfo.getNumber() + " " + bgFormInfo.getName();
            IObjectPK Loginpk = LogUtil.beginLog(null, (String)"actionEdit_actionPerformed", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"mbg_bgForm_update");
            LogUtil.afterLog(null, (IObjectPK)Loginpk);
        }
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BudgetEditMenuManager((Component)((Object)this));
    }

    @Override
    protected void initToolbarAction() {
        super.initToolbarAction();
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionUnConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_untreadreport"));
        this.actionUnCertificate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.actionCertificate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.menuItemCertificate.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.menuItemUnCertificate.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.menuItemBack.setIcon(EASResource.getIcon((String)"imgTbtn_untreadreport"));
        this.menuItemConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemUnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionConfirm), "common");
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionUnConfirm), "common");
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionBack), "common");
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionUnCertificate), "common");
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionCertificate), "common");
        this.actionSave.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_save"));
        toolBarManager.addFirstGroupItem((Action)this.actionSave, "common");
        if (this.getUIContext().get("BGFORMINFO_TYPE") != null) {
            BgFormInfo bgFormInfo = (BgFormInfo)this.getUIContext().get("BGFORMINFO_TYPE");
            boolean isVirtual = false;
            if (this.getUIContext().get("IS_GATHER") != null) {
                isVirtual = (Boolean)this.getUIContext().get("IS_GATHER");
            }
            if (!isVirtual) {
                if (bgFormInfo.getState().getValue() == 40) {
                    this.menuItemCertificate.setVisible(true);
                    this.menuItemUnCertificate.setVisible(false);
                    this.menuItemBack.setVisible(true);
                    this.menuItemConfirm.setVisible(false);
                    this.menuItemUnConfirm.setVisible(false);
                    this.actionCertificate.setVisible(true);
                    this.actionUnCertificate.setVisible(false);
                    this.actionBack.setVisible(true);
                    this.actionConfirm.setVisible(false);
                    this.actionUnConfirm.setVisible(false);
                } else if (bgFormInfo.getState().getValue() == 41) {
                    this.menuItemCertificate.setVisible(false);
                    this.menuItemUnCertificate.setVisible(true);
                    this.menuItemBack.setVisible(false);
                    this.menuItemConfirm.setVisible(true);
                    this.menuItemUnConfirm.setVisible(false);
                    this.actionCertificate.setVisible(false);
                    this.actionUnCertificate.setVisible(true);
                    this.actionBack.setVisible(false);
                    this.actionConfirm.setVisible(true);
                    this.actionUnConfirm.setVisible(false);
                } else if (bgFormInfo.getState().getValue() == 2) {
                    this.actionCertificate.setVisible(false);
                    this.actionUnCertificate.setVisible(false);
                    this.actionBack.setVisible(false);
                    this.actionConfirm.setVisible(false);
                    this.actionUnConfirm.setVisible(true);
                    this.menuItemCertificate.setVisible(false);
                    this.menuItemUnCertificate.setVisible(false);
                    this.menuItemBack.setVisible(false);
                    this.menuItemConfirm.setVisible(false);
                    this.menuItemUnConfirm.setVisible(true);
                } else {
                    this.actionCertificate.setVisible(false);
                    this.actionUnCertificate.setVisible(false);
                    this.actionBack.setVisible(false);
                    this.actionConfirm.setVisible(false);
                    this.actionUnConfirm.setVisible(false);
                    this.menuItemCertificate.setVisible(false);
                    this.menuItemUnCertificate.setVisible(false);
                    this.menuItemBack.setVisible(false);
                    this.menuItemConfirm.setVisible(false);
                    this.menuItemUnConfirm.setVisible(false);
                }
            } else {
                this.actionCertificate.setVisible(false);
                this.actionUnCertificate.setVisible(false);
                this.actionBack.setVisible(false);
                this.actionConfirm.setVisible(false);
                this.actionUnConfirm.setVisible(false);
                this.menuItemCertificate.setVisible(false);
                this.menuItemUnCertificate.setVisible(false);
                this.menuItemBack.setVisible(false);
                this.menuItemConfirm.setVisible(false);
                this.menuItemUnConfirm.setVisible(false);
            }
        } else {
            this.actionCertificate.setVisible(false);
            this.actionUnCertificate.setVisible(false);
            this.actionBack.setVisible(false);
            this.actionConfirm.setVisible(false);
            this.actionUnConfirm.setVisible(false);
            this.menuItemCertificate.setVisible(false);
            this.menuItemUnCertificate.setVisible(false);
            this.menuItemBack.setVisible(false);
            this.menuItemConfirm.setVisible(false);
            this.menuItemUnConfirm.setVisible(false);
        }
        this.actionBgExamineCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_examinecheck"));
        toolBarManager.addLastGroupItem((Action)((Object)this.actionBgExamineCheck), "common");
        toolBarManager.getToolBar("common");
    }

    @Override
    public IBookProvider getBudgetProvider() {
        return new BgNFormSpecialProvider((Component)((Object)this));
    }

    @Override
    public Book getBook() {
        Book book = null;
        if (this.createNewBook && OprtState.ADDNEW.equals(this.getOprtState())) {
            this.createNewBook = false;
            try {
                book = this.getBookProvider().loadBook();
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                this.handleException(ex);
                SysUtil.abort();
            }
        } else {
            book = super.getBook();
        }
        return book;
    }

    public void addPagePanel() throws Exception {
        this.getUIContentPane().add(BgSpecialBudgetClientHelper.getPageDimensionPanel(this.getSpreadManager().getSpreadContainer(), (CoreUI)this, this.getBgFormInfo(), this.getSchemeHelper(), this.getOrgUnitInfo()), "Center");
    }

    @Override
    protected SelectorItemCollection getFormSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        BgSpecialBudgetClientHelper.getSpecialItemSelector(sic);
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBgItemFill_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            uiContext.put((Object)"ORGUNITID", (Object)this.getBgFormInfo().getOrgUnit().getId().toString());
            uiContext.put((Object)"item_formula_map", (Object)this.getItemFormulMap());
            uiContext.put((Object)"this_is_from_template", (Object)Boolean.FALSE);
            uiContext.put((Object)"BGSCHEME_ID", (Object)this.getBgSchemeId());
            uiContext.put((Object)"filterValueMap", this.getFilterMap());
            uiContext.put((Object)"IS_SPECIAL_BUDGET", (Object)Boolean.TRUE);
            uiContext.put((Object)BgBaseConstants.BGPERIOD_INFO, (Object)this.getBgFormInfo().getBgPeriod());
            uiContext.put((Object)BgBaseConstants.CURRENCY_INFO, (Object)this.getBgFormInfo().getCurrency());
            try {
                uiContext.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
            }
            catch (EASBizException ex) {
                logger.error((Object)"", (Throwable)ex);
                this.handUIExceptionAndAbort((Exception)((Object)ex));
            }
            catch (BOSException ex) {
                logger.error((Object)"", (Throwable)ex);
                this.handUIExceptionAndAbort((Exception)((Object)ex));
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormatImportUI.class.getName(), (Map)uiContext, null, this.getOprtState());
            uiWindow.show();
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    public Map<String, Set<String>> getFilterMap() throws EASBizException, BOSException {
        return BgSpecialBudgetHelper.getFilterMapByBgForm(null, this.getBgFormInfo(), this.getSchemeHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            this.getBook().getUndoManager().startGroup();
            String orgUnitId = this.getBgFormInfo().getOrgUnit().getId().toString();
            try {
                DimensionFillHelper.showBgItem(this, this.getBgSchemeId(), this.getBook().getActiveSheet(), true, "", this.getBgFormInfo().getCurrency().getNumber(), this.getItemFormulMap(), null, false, false, orgUnitId, true, this.getFilterMap(), true, true);
                this.getSpreadManager().getSpreadContainer().repaint();
            }
            finally {
                this.getBook().getUndoManager().endGroup();
            }
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    public void actionCreateItemFormula_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            super.actionCreateItemFormula_actionPerformed(e);
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    protected void cell_Content_Changed(SheetChangeEvent e) throws Exception {
        super.cell_Content_Changed(e);
    }

    @Override
    protected void showCell(Cell cell) throws Exception {
        super.showCell(cell);
        if (cell != null) {
            this.setOldFormula(cell, BgNFSHelper.getFormulaOfCell(cell));
        }
    }

    @Override
    protected void showAllBook() throws Exception {
        super.showAllBook();
        BgSpecialBudgetHelper.clearSrcMap();
    }

    @Override
    public void addCell(Cell cell) {
        super.addCell(cell);
    }

    @Override
    public void fillSpecialItem() {
        if (this.cells.isEmpty()) {
            return;
        }
        BgSheetRange range = new BgSheetRange(this.getBook().getActiveSheet());
        for (Cell cell : this.cells) {
            range.addCell(cell.getRow(), cell.getCol());
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(range.getRange());
        try {
            BgSpecialBudgetHelper.buildFormula((Range)ranges.get(0), BgSpecialBudgetClientHelper.getBgSpecialItemByForm(this.getBgFormInfo()));
            BgNTemplateHelper.dealWith(ranges, this.getOrgUnitInfo().getId().toString(), this.getItemFormulMap(), true, true, null, true, false, null, this.getSchemeHelper(), true, null, true, true);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    public void afterFill() {
        super.afterFill();
    }

    @Override
    public boolean isElementRequired() {
        return true;
    }

    @Override
    public boolean isScenarioRequired() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected String getCertificatePermission() {
        return "mbg_course04_certificate";
    }

    @Override
    public void actionCertificate_actionPerformed(ActionEvent e) throws Exception {
        this.verifyPermission(this.getCertificatePermission());
        BgOrgUnitInfo orgInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
        BgFormInfo bgFormInfo = (BgFormInfo)this.getUIContext().get("BGFORMINFO_TYPE");
        String bgOrgViewID = (String)this.getUIContext().get("BGORGVIEW_ID");
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        List<String> billIds = this.getBillIds(bgFormInfo.getId().toString());
        BOSUuid bgOrgViewId = BOSUuid.read((String)bgOrgViewID);
        BgFormAuditClientHelper.getInstance().certificate((Component)((Object)this), bgSchemeId, this.getUserPk().toString(), billIds, orgInfo.getOrgUnitID(), bgOrgViewId, true);
    }

    protected String getUnCertificatePermission() {
        return "mbg_course05_antiCertificate";
    }

    @Override
    public void actionUnCertificate_actionPerformed(ActionEvent e) throws Exception {
        this.verifyPermission(this.getUnCertificatePermission());
        BgOrgUnitInfo orgInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
        BgFormInfo bgFormInfo = (BgFormInfo)this.getUIContext().get("BGFORMINFO_TYPE");
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        List<String> billIds = this.getBillIds(bgFormInfo.getId().toString());
        BgFinalizedClientHelper.checkBgFormsFinalized((CoreUI)this, billIds);
        BgFormAuditClientHelper.getInstance().unCertificate((Component)((Object)this), bgSchemeId, this.getUserPk().toString(), billIds, orgInfo.getOrgUnitID(), true);
    }

    protected String getBackPermission() {
        return "mbg_course06_back";
    }

    @Override
    public void actionBack_actionPerformed(ActionEvent e) throws Exception {
        this.verifyPermission(this.getBackPermission());
        BgOrgUnitInfo orgInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
        BgFormInfo bgFormInfo = (BgFormInfo)this.getUIContext().get("BGFORMINFO_TYPE");
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        List<String> billIds = this.getBillIds(bgFormInfo.getId().toString());
        BgFinalizedClientHelper.checkBgFormsFinalized((CoreUI)this, billIds);
        BgFormAuditClientHelper.getInstance().back((Component)((Object)this), bgSchemeId, this.getUserPk().toString(), billIds, orgInfo.getOrgUnitID(), true);
    }

    protected String getConfirmPermission() {
        return "mbg_course10_confirm";
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verifyPermission(this.getConfirmPermission());
        BgOrgUnitInfo orgInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
        BgFormInfo bgFormInfo = (BgFormInfo)this.getUIContext().get("BGFORMINFO_TYPE");
        String bgOrgViewID = (String)this.getUIContext().get("BGORGVIEW_ID");
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        BOSUuid bgOrgViewId = BOSUuid.read((String)bgOrgViewID);
        BgFormAuditClientHelper.getInstance().audit((Component)((Object)this), bgSchemeId, this.getUserPk().toString(), (IObjectValue)bgFormInfo, orgInfo.getOrgUnitID(), bgOrgViewId);
    }

    protected String getUnConfirmPermission() {
        return "mbg_course11_unConfirm";
    }

    @Override
    public void actionUnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verifyPermission(this.getUnConfirmPermission());
        BgOrgUnitInfo orgInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
        BgFormInfo bgFormInfo = (BgFormInfo)this.getUIContext().get("BGFORMINFO_TYPE");
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        List<String> billIds = this.getBillIds(bgFormInfo.getId().toString());
        BgFinalizedClientHelper.checkBgFormsFinalized((CoreUI)this, billIds);
        BgFormAuditClientHelper.getInstance().unAudit((Component)((Object)this), bgSchemeId, this.getUserPk().toString(), (IObjectValue)bgFormInfo, orgInfo.getOrgUnitID(), true);
    }

    protected void verifyPermission(String permission) throws Exception {
        BgOrgUnitInfo orgInfo = (BgOrgUnitInfo)this.getUIContext().get("BGORGUNIT_INFO");
        BgPermissionUtil.checkPermission((BOSUuid)BOSUuid.read((String)orgInfo.getOrgUnitID()), (String)permission);
    }

    protected List<String> getBillIds(String id) throws Exception {
        if (id == null || id.isEmpty()) {
            return null;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(id);
        return billIds;
    }

    protected IObjectPK getUserPk() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        return userPK;
    }

    @Override
    protected boolean checkBeforeWindowClosing() {
        return true;
    }
}

