/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.client.AbstractBgTemplateImportUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgTemplateImportUI
extends AbstractBgTemplateImportUI {
    private static final long serialVersionUID = -1306326629041769635L;
    private static final Logger logger = CoreUIObject.getLogger(BgTemplateImportUI.class);
    private FullOrgUnitInfo orgUnitInfo = null;
    private Hashtable selectedTemplates = new Hashtable();
    private boolean isConfirm = true;
    private BgTemplateCollection colls = new BgTemplateCollection();
    private BgTemplateCollection coll = new BgTemplateCollection();
    private static final String defaultSeachText = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"serchTemplate");
    private String oldText = defaultSeachText;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnAll_actionPerformed(null);
        this.getColls();
        this.getSearchTemplates();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.oldText = null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtQuickQueryInput.setText(defaultSeachText);
    }

    @Override
    protected void txtQuickQueryInput_focusLost(FocusEvent e) throws Exception {
        super.txtQuickQueryInput_focusLost(e);
        String text = this.txtQuickQueryInput.getText();
        if (!(text == null || text.equals(this.oldText) || this.oldText == null && text.equals(defaultSeachText))) {
            this.loadSearchTemplates(this.coll, text);
            this.oldText = text;
        }
    }

    private void getSearchTemplates() throws BOSException, EASBizException {
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        this.coll = iBgScheme.getTemplate(orgUnitID);
        this.coll = this.excluseFilter(this.coll);
    }

    private BgTemplateCollection excluseFilter(BgTemplateCollection coll) {
        if (BgTemplateImportUI.class.equals(((Object)((Object)this)).getClass())) {
            BgTemplateCollection returnVal = new BgTemplateCollection();
            for (int i = 0; i < coll.size(); ++i) {
                BgTemplateInfo bgTemplateInfo = coll.get(i);
                BgTypeInfo bgType = bgTemplateInfo.getBgType();
                if (bgType != null) {
                    String string = bgType.getId().toString();
                    if ("GjMAAAAAUgj/bNjg".equals(string) || "lVIAAAA0y6A7rHKd".equals(string)) continue;
                    returnVal.add(bgTemplateInfo);
                    continue;
                }
                returnVal.add(bgTemplateInfo);
            }
            return returnVal;
        }
        return coll;
    }

    protected boolean isLoadToRow(BgTemplateInfo bgTemplateInfo) {
        return true;
    }

    protected void loadSearchTemplates(BgTemplateCollection coll, String txtSearchTemplate) {
        this.tblMain.removeRows();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BgTemplateInfo bgTemplateInfo = coll.get(i);
                if (!this.isLoadToRow(bgTemplateInfo) || !this.isInclude(bgTemplateInfo, txtSearchTemplate)) continue;
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)bgTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgTemplateInfo.getName());
                iRow.getCell("temGroupName").setValue(bgTemplateInfo.getBgType() == null ? null : bgTemplateInfo.getBgType().getName());
                iRow.getCell("creator").setValue((Object)bgTemplateInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)bgTemplateInfo.getCreateTime());
                iRow.getCell("id").setValue((Object)bgTemplateInfo.getId().toString());
            }
        }
    }

    private boolean isInclude(BgTemplateInfo bgTemplateInfo, String filter) {
        if (StringUtils.isEmpty((String)filter) || filter.equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"serchTemplate"))) {
            return true;
        }
        if (bgTemplateInfo.getNumber().indexOf(filter) >= 0) {
            return true;
        }
        if (bgTemplateInfo.getName().indexOf(filter) >= 0) {
            return true;
        }
        if (bgTemplateInfo.getBgType() != null && !StringUtils.isEmpty((String)bgTemplateInfo.getBgType().getName()) && bgTemplateInfo.getBgType().getName().indexOf(filter) >= 0) {
            return true;
        }
        return bgTemplateInfo.getCreator().getName().indexOf(filter) >= 0;
    }

    protected void getColls() throws Exception {
        this.selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgTemplateCollection coll = new BgTemplateCollection();
        coll = iBgScheme.getTemplate(orgUnitID);
        coll = this.excluseFilter(coll);
        for (int i = 0; i < coll.size(); ++i) {
            if (!this.selectedTemplates.containsKey(coll.get(i).getId().toString())) continue;
            this.colls.add(coll.get(i));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setConfirm(false);
        this.getUIWindow().close();
        SysUtil.abort();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        this.setConfirm(true);
        int rowCount = this.tblMain.getRowCount();
        Hashtable<String, BgTemplateInfo> selectedBefore = new Hashtable<String, BgTemplateInfo>();
        String selectedTemplatesName = "";
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.tblMain.getRow(i);
            if (!iRow.getCell("select").getValue().equals(Boolean.TRUE)) continue;
            BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)iRow.getUserObject();
            String bgTempID = iRow.getCell("id").getValue().toString();
            if (this.selectedTemplates.containsKey(bgTempID)) {
                selectedBefore.put(bgTempID, bgTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                continue;
            }
            this.selectedTemplates.put(bgTempID, bgTemplateInfo);
            this.colls.add(bgTemplateInfo);
        }
        if (!selectedBefore.isEmpty()) {
            Iterator iter = selectedBefore.keySet().iterator();
            while (iter.hasNext()) {
                BgTemplateInfo template = (BgTemplateInfo)selectedBefore.get(iter.next());
                selectedTemplatesName = selectedTemplatesName + " " + template.getName();
            }
            MsgBox.showWarning((Component)((Object)this), (String)(selectedTemplatesName + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeResource", (String)"TemplateNotReselected")));
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAll_actionPerformed(e);
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgTemplateCollection coll = new BgTemplateCollection();
        coll = iBgScheme.getTemplate(orgUnitID);
        coll = this.excluseFilter(coll);
        this.loadTemplates(coll);
    }

    @Override
    protected void btnNotSelected_actionPerformed(ActionEvent e) throws Exception {
        super.btnNotSelected_actionPerformed(e);
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        String orgUnitID = this.orgUnitInfo.getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgTemplateCollection bgTempColls = new BgTemplateCollection();
        bgTempColls = iBgScheme.getTemplate(orgUnitID);
        bgTempColls = this.excluseFilter(bgTempColls);
        BgTemplateInfo info = new BgTemplateInfo();
        BgTemplateCollection coll = new BgTemplateCollection();
        String id = "";
        Hashtable selectedTemplates = (Hashtable)this.getUIContext().get("templates");
        for (int i = 0; i < bgTempColls.size(); ++i) {
            info = bgTempColls.get(i);
            id = info.getId().toString();
            if (selectedTemplates.get(id) != null) continue;
            coll.add(info);
        }
        this.loadTemplates(coll);
    }

    private Hashtable translateToHashtable(BgTemplateCollection bgTempColls) {
        Hashtable<String, BgTemplateInfo> hashColls = new Hashtable<String, BgTemplateInfo>();
        if (bgTempColls == null) {
            hashColls = null;
        }
        if (hashColls != null) {
            Iterator iter = bgTempColls.iterator();
            while (iter.hasNext()) {
                BgTemplateInfo template = (BgTemplateInfo)iter.next();
                hashColls.put(template.getNumber().toString(), template);
            }
        }
        return hashColls;
    }

    @Override
    protected void btnSeleted_actionPerformed(ActionEvent e) throws Exception {
        super.btnSeleted_actionPerformed(e);
        if ((Hashtable)this.getUIContext().get("templates") != null) {
            Hashtable selectedTemplates = (Hashtable)this.getUIContext().get("templates");
            this.loadTemplates(selectedTemplates);
        }
    }

    protected void loadTemplates(Hashtable coll) {
        this.tblMain.removeRows();
        BgTemplateCollection temColl = new BgTemplateCollection();
        BgTemplateInfo info = new BgTemplateInfo();
        if (coll != null && coll.size() > 0) {
            Iterator iterator = coll.keySet().iterator();
            while (iterator.hasNext()) {
                BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)coll.get(iterator.next());
                temColl.add(bgTemplateInfo);
            }
            BgNFCHelper.sortCollection((IObjectCollection)temColl, new String[]{"number"});
            for (int i = 0; i < temColl.size(); ++i) {
                info = temColl.get(i);
                if (!this.isLoadToRow(info)) continue;
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)info);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)info.getNumber());
                iRow.getCell("name").setValue((Object)info.getName());
                iRow.getCell("temGroupName").setValue(info.getBgType() == null ? null : info.getBgType().getName());
                iRow.getCell("creator").setValue((Object)info.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)info.getCreateTime());
                iRow.getCell("id").setValue((Object)info.getId().toString());
            }
        }
        this.tblMain.getColumn("createTime").getStyleAttributes().setLocked(true);
    }

    protected void loadTemplates(BgTemplateCollection coll) {
        this.tblMain.removeRows();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BgTemplateInfo bgTemplateInfo = coll.get(i);
                if (!this.isLoadToRow(bgTemplateInfo)) continue;
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)bgTemplateInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)bgTemplateInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgTemplateInfo.getName());
                iRow.getCell("temGroupName").setValue(bgTemplateInfo.getBgType() == null ? null : bgTemplateInfo.getBgType().getName());
                iRow.getCell("creator").setValue((Object)bgTemplateInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)bgTemplateInfo.getCreateTime());
                iRow.getCell("id").setValue((Object)bgTemplateInfo.getId().toString());
            }
        }
        this.tblMain.getColumn("createTime").getStyleAttributes().setLocked(true);
    }

    public Hashtable getSelectedTemplates() {
        return this.selectedTemplates;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() != 0 && e.getClickCount() == 2 && e.getRowIndex() >= 0 && e.getColIndex() >= 0) {
            int row = this.tblMain.getSelectManager().getActiveRowIndex();
            IRow irow = this.tblMain.getRow(row);
            irow.getCell("select").setValue((Object)Boolean.TRUE);
            this.btnConfirm_actionPerformed(null);
        }
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public void setConfirm(boolean isConfirm) {
        this.isConfirm = isConfirm;
    }
}

