/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.IBgVersion;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.control.client.BgControlDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.AbstractBgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.client.AbstractBgTemplateLinkSelectUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BgTemplateLinkSelectUI
extends AbstractBgTemplateLinkSelectUI
implements IGetSchemeHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgTemplateLinkSelectUI.class);
    private boolean isCanceled = true;
    private HashMap config = new HashMap(0);
    private String bgTemplateName = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private BgControlDimensionMemberSelectDialog otherMemberDialog = null;

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            if (this.prmtBgScheme.getData() instanceof String) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, (String)this.prmtBgScheme.getData(), true);
            } else if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString(), false);
            }
            if (this.schemeHelper == null) {
                this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
            }
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String orgId = ((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString();
        BgOrgViewF7 orgUnit = new BgOrgViewF7((IUIObject)this);
        orgUnit.setCurrentCUID(orgId);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgUnit);
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.initBgScheme();
        this.initF7();
        this.initBgTemplateF7();
        this.initBgSpecialItems();
    }

    private void initBgScheme() {
        OrgUnitInfo orgUnitInfo = this.getOrgUnitInfo();
        BgNFCHelper.setSchemeView(this.prmtBgScheme, orgUnitInfo, false, null, false, false);
    }

    private OrgUnitInfo getOrgUnitInfo() {
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            orgUnitInfo = (OrgUnitInfo)this.prmtOrgUnit.getData();
        }
        return orgUnitInfo;
    }

    protected void initF7() throws EASBizException, BOSException {
        this.schemeHelper = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.getSchemeHelper().getBgSchemeId()));
        filter.getFilterItems().add(new FilterItemInfo("templateStatus".toLowerCase(), (Object)Integer.toString(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgType.id", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgType.number", (Object)"SelfDefineAnalysisTemplateGroup", CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        viewInfo.setFilter(filter);
        this.comBgTemplate.setEntityViewInfo(viewInfo);
        BgPeriodDialog periodF7 = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)periodF7);
        this.prmtBgPeriod.setData(null);
        periodF7.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        DimensionMemberSelectHelper.addIdFilter(this.prmtCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, this.getSchemeHelper());
        this.prmtCurrency.setData(null);
    }

    private void initBgTemplateF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", this.getUIContext().get("BGSCHEME_ID")));
        viewInfo.setFilter(filter);
        this.comBgTemplate.setEntityViewInfo(viewInfo);
    }

    private void initBgSpecialItems() {
        this.otherMemberDialog = this.initDimensionMemberSelectDialog();
        this.prmtBgSpecialItems.setSelector((KDPromptSelector)this.otherMemberDialog);
        this.prmtBgSpecialItems.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BgTemplateLinkSelectUI.this.checkIsSelectSpecialBgTemplate();
                List sources = null;
                try {
                    sources = BgTemplateLinkSelectUI.this.getdataSource();
                }
                catch (Exception e1) {
                    BgTemplateLinkSelectUI.this.handUIException(e1);
                }
                BgTemplateLinkSelectUI.this.otherMemberDialog.setDimension((Object)((SourceDisplayInfo)sources.get(0)).getDimension());
                BgTemplateLinkSelectUI.this.otherMemberDialog.setOrgUnit((FullOrgUnitInfo)BgTemplateLinkSelectUI.this.getOrgUnitInfo());
                BgTemplateLinkSelectUI.this.otherMemberDialog.setCanSelectSources(sources);
            }
        });
    }

    private void checkIsSelectSpecialBgTemplate() {
        if (this.comBgTemplate.getData() == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BudgetResource", (String)"BgTemplateNotNull");
            this.comBgTemplate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        } else {
            BgTemplateInfo data = (BgTemplateInfo)this.comBgTemplate.getData();
            if (data.getFormType() != BgTemFormTypeEnum.SPECIALFORM || data.getBgSpecialItems() == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BudgetResource", (String)"selectSpecialBgTemplate");
                this.comBgTemplate.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    private List<SourceDisplayInfo> getdataSource() throws BOSException, EASBizException {
        ArrayList<SourceDisplayInfo> sources = new ArrayList<SourceDisplayInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgDimSettings.*");
        BgSchemeInfo bgschemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(this.getBgSchemeID()), sic);
        AbstractBgTemplateInfo bgTemplateInfo = null;
        if (this.comBgTemplate.getData() != null) {
            bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getData();
        }
        BgSpecialItemsInfo bgSpecialItemsInfo = bgTemplateInfo.getBgSpecialItems().get(0);
        Map<String, MbgViewListDimensionInfo> specialDimensions = bgSpecialItemsInfo.getSpecialDimensions(this.getSchemeHelper());
        Map<String, BgDimSettingsInfo> dimSettingMap = this.schemeHelper.getDimSettingMap();
        MbgViewListDimensionInfo bgDimensionInfo = null;
        BgDimSettingsInfo bgDimSettingInfo = null;
        for (String dimNumber : specialDimensions.keySet()) {
            bgDimensionInfo = specialDimensions.get(dimNumber);
            bgDimSettingInfo = dimSettingMap.get(bgDimensionInfo.getNumber());
            sources.add(new SourceDisplayInfo(this.getSchemeHelper().getDimension(bgDimSettingInfo.getDimNumber())));
        }
        return sources;
    }

    protected BgControlDimensionMemberSelectDialog initDimensionMemberSelectDialog() {
        BgControlDimensionMemberSelectDialog dialog = new BgControlDimensionMemberSelectDialog((Component)((Object)this), this.getBgSchemeID(), null);
        dialog.setOrgUnit((FullOrgUnitInfo)this.getOrgUnitInfo());
        return dialog;
    }

    private String getBgSchemeID() {
        if (this.prmtBgScheme.getData() != null) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            return bgSchemeInfo.getId().toString();
        }
        return this.getUIContext().get("BGSCHEME_ID").toString();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initData(HashMap hm) throws Exception {
        String strVersion;
        String strCurrency;
        String strBgPeriod;
        String strTemplate;
        String strScheme;
        String strOrgUnit;
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("name"));
        ObjectUuidPK pk = null;
        if (hm.get("BG_LINK_ORGUNIT_ID") != null && (strOrgUnit = (String)hm.get("BG_LINK_ORGUNIT_ID")) != null && strOrgUnit.trim().length() > 0) {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            pk = new ObjectUuidPK(strOrgUnit);
            FullOrgUnitInfo aFullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)pk, sc);
            this.prmtOrgUnit.setValue((Object)aFullOrgUnitInfo);
        }
        if (hm.get("BG_LINK_SCHEME_ID") != null && (strScheme = (String)hm.get("BG_LINK_SCHEME_ID")) != null && strScheme.trim().length() > 0) {
            IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
            pk = new ObjectUuidPK(strScheme);
            BgSchemeInfo aBgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)pk, sc);
            this.prmtBgScheme.setValue((Object)aBgSchemeInfo);
        }
        if (hm.get("BG_LINK_TEMPLATE_ID") != null && (strTemplate = (String)hm.get("BG_LINK_TEMPLATE_ID")) != null && strTemplate.trim().length() > 0) {
            IBgTemplate iBgTemplate = BgTemplateFactory.getRemoteInstance();
            pk = new ObjectUuidPK(strTemplate);
            BgTemplateInfo aBgTemplateInfo = iBgTemplate.getBgTemplateInfo((IObjectPK)pk);
            this.comBgTemplate.setData((Object)aBgTemplateInfo);
        }
        if (hm.get("BG_LINK_PERIOD_ID") != null && (strBgPeriod = (String)hm.get("BG_LINK_PERIOD_ID")) != null && strBgPeriod.trim().length() > 0) {
            IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
            pk = new ObjectUuidPK(strBgPeriod);
            BgPeriodInfo aBgPeriodInfo = iBgPeriod.getBgPeriodInfo((IObjectPK)pk, sc);
            this.prmtBgPeriod.setValue((Object)aBgPeriodInfo);
        }
        if (hm.get("BG_LINK_CURRENCY_ID") != null && (strCurrency = (String)hm.get("BG_LINK_CURRENCY_ID")) != null && strCurrency.trim().length() > 0) {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            pk = new ObjectUuidPK(strCurrency);
            CurrencyInfo aCurrencyInfo = iCurrency.getCurrencyInfo((IObjectPK)pk, sc);
            this.prmtCurrency.setValue((Object)aCurrencyInfo);
        }
        if (hm.get("BG_LINK_VERSION_ID") != null && (strVersion = (String)hm.get("BG_LINK_VERSION_ID")) != null && strVersion.trim().length() > 0) {
            IBgVersion iVersion = BgVersionFactory.getRemoteInstance();
            pk = new ObjectUuidPK(strVersion);
            BgVersionInfo aBgVersionInfo = iVersion.getBgVersionInfo((IObjectPK)pk, sc);
            this.prmtBgVersion.setValue((Object)aBgVersionInfo);
        }
        if (hm.get("BG_LINK_BGSPECALITEMS_FORMULA") != null) {
            String bgSpecialItemsFormula = (String)hm.get("BG_LINK_BGSPECALITEMS_FORMULA");
            this.prmtBgSpecialItems.setValue((Object)bgSpecialItemsFormula);
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtBgScheme.setValue(null);
        this.comBgTemplate.setValue(null);
        this.initBgScheme();
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.initF7();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.setCanceled(false);
        if (this.comBgTemplate.getData() == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BudgetResource", (String)"BgTemplateNotNull");
            this.comBgTemplate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        if (this.prmtOrgUnit.getData() != null) {
            FullOrgUnitInfo aFullOrgUnitInfo = (FullOrgUnitInfo)this.prmtOrgUnit.getData();
            this.config.put("BG_LINK_ORGUNIT_ID", aFullOrgUnitInfo.getId().toString());
        }
        if (this.prmtBgScheme.getData() != null) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            this.config.put("BG_LINK_SCHEME_ID", bgSchemeInfo.getId().toString());
            this.config.put("BG_LINK_SCHEME_NUMBER", bgSchemeInfo.getNumber());
        }
        if (this.comBgTemplate.getData() != null) {
            BgTemplateInfo aBgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getData();
            this.config.put("BG_LINK_TEMPLATE_ID", aBgTemplateInfo.getId().toString());
            this.config.put("BG_LINK_TEMPLATE_NUMBER", aBgTemplateInfo.getNumber());
            this.setBgTemplateName(aBgTemplateInfo.getName());
        }
        if (this.prmtBgPeriod.getData() != null) {
            BgPeriodInfo aBgPeriodInfo = (BgPeriodInfo)this.prmtBgPeriod.getData();
            this.config.put("BG_LINK_PERIOD_ID", aBgPeriodInfo.getId().toString());
        }
        if (this.prmtCurrency.getData() != null) {
            CurrencyInfo aCurrencyInfo = (CurrencyInfo)this.prmtCurrency.getData();
            this.config.put("BG_LINK_CURRENCY_ID", aCurrencyInfo.getId().toString());
        }
        if (this.prmtBgVersion.getData() != null) {
            BgVersionInfo aBgVerionInfo = (BgVersionInfo)this.prmtBgVersion.getData();
            this.config.put("BG_LINK_VERSION_ID", aBgVerionInfo.getId().toString());
        }
        if (this.prmtBgSpecialItems.getData() != null) {
            if (this.prmtBgSpecialItems.getValue() instanceof BgDimensionMember) {
                BgDimensionMember member = (BgDimensionMember)this.prmtBgSpecialItems.getValue();
                String[] srcNumbers = member.getSrcNumber().split(",");
                String[] numbers = member.getNumber().split(",");
                StringBuffer value = new StringBuffer();
                for (int i = 0; i < srcNumbers.length; ++i) {
                    DimensionFormulaHelper.addItem(value, srcNumbers[i], numbers[i]);
                }
                this.prmtBgSpecialItems.setValue((Object)value.toString());
                this.config.put("BG_LINK_BGSPECALITEMS_FORMULA", value.toString());
            } else if (this.prmtBgSpecialItems.getValue() instanceof String) {
                this.config.put("BG_LINK_BGSPECALITEMS_FORMULA", this.prmtBgSpecialItems.getValue());
            }
        } else {
            this.config.remove("BG_LINK_BGSPECALITEMS_FORMULA");
        }
        this.getUIWindow().close();
    }

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public HashMap getConfig() {
        return this.config;
    }

    public void setConfig(HashMap config) {
        this.config = config;
    }

    public String getBgTemplateName() {
        return this.bgTemplateName;
    }

    public void setBgTemplateName(String bgTemplateName) {
        this.bgTemplateName = bgTemplateName;
    }
}

