/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.client.BgPeriodNSettingUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodVariable;
import com.kingdee.eas.ma.mbg.AbstractBgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractBgViewPeriodF7UI;
import com.kingdee.eas.ma.mbg.client.utils.BgViewMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgViewPeriodF7UI
extends AbstractBgViewPeriodF7UI {
    private static final long serialVersionUID = -5391849688761912346L;
    private static final Logger logger = CoreUIObject.getLogger(BgViewPeriodF7UI.class);
    public static final String ISNEEDNSETTING = "isNeedNSetting";
    private String bgSchemeId = null;
    private Boolean isMultiSelect = false;
    private boolean isSelfSelect = false;
    private boolean isLoadTblVaLeft = false;
    protected Boolean isNeedCheckSwitch = true;
    protected boolean isNeedNSetting = false;
    protected boolean isPageLayout = false;
    BgPeriodTypeInfo bgPeriodTypeInfo = null;
    BgPeriodDispInfo bgPeriodDispInfo = null;
    protected Object returnData;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCbBox();
        this.isPageLayout = "page".equals(this.getUIContext().get("layout"));
        this.bgSchemeId = (String)this.getUIContext().get("BGSCHEME_ID");
        boolean bl = this.isSelfSelect = this.getUIContext().get("isSelfSelect") instanceof Boolean ? (Boolean)this.getUIContext().get("isSelfSelect") : false;
        if (this.isSelfSelect) {
            this.lblRight.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgCommonResource", (String)"memberRange"));
        } else {
            this.lblRight.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgCommonResource", (String)"selectedMembers1"));
        }
        this.isNeedNSetting = Boolean.TRUE.equals(this.getUIContext().get(ISNEEDNSETTING));
        this.btnTop.setEnabled(!this.isSelfSelect && !this.isPageLayout);
        this.btnUp.setEnabled(!this.isSelfSelect && !this.isPageLayout);
        this.btnDown.setEnabled(!this.isSelfSelect && !this.isPageLayout);
        this.btnBottom.setEnabled(!this.isSelfSelect && !this.isPageLayout);
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.isMultiSelect = isMultiSelect;
        boolean isEnable = isMultiSelect && BgMemberSelectTypeEnum.Member == this.getMemberSelectType();
        this.btnAddAll.setEnabled(isMultiSelect);
        this.chkYear.setEnabled(isEnable);
        this.chkHalfYear.setEnabled(isEnable);
        this.chkQuarter.setEnabled(isEnable);
        this.chkMonth.setEnabled(isEnable);
        this.chkMWeek.setEnabled(isEnable);
        this.chkYWeek.setEnabled(isEnable);
        this.btnTop.setVisible(isMultiSelect);
        this.btnUp.setVisible(isMultiSelect);
        this.btnDown.setVisible(isMultiSelect);
        this.btnBottom.setVisible(isMultiSelect);
        this.tblMain.getSelectManager().setSelectMode(isMultiSelect ? 10 : 2);
        this.tblRight.getSelectManager().setSelectMode(isMultiSelect ? 10 : 2);
        this.tblVaLeft.getSelectManager().setSelectMode(isMultiSelect ? 10 : 2);
        this.tblVaRight.getSelectManager().setSelectMode(isMultiSelect ? 10 : 2);
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblVaLeft.checkParsed();
        this.tblVaRight.checkParsed();
        this.tblVaLeft.getSelectManager().setSelectMode(2);
        this.tblVaRight.getSelectManager().setSelectMode(2);
    }

    private void initCbBox() {
        DimensionMemberValueModeEnum memberValueType;
        this.cbxBgPeriodType.setEditable(false);
        this.cbxYear.setEditable(false);
        this.cbxSelectType.addItem((Object)BgMemberSelectTypeEnum.Member);
        DimensionMemberValueModeEnum dimensionMemberValueModeEnum = memberValueType = this.getUIContext().get("memberValueType") instanceof DimensionMemberValueModeEnum ? (DimensionMemberValueModeEnum)((Object)this.getUIContext().get("memberValueType")) : null;
        if (!(memberValueType != null && memberValueType.equals((Object)DimensionMemberValueModeEnum.Null) || Boolean.FALSE.equals(this.getUIContext().get("showVariate")))) {
            this.cbxSelectType.addItem((Object)BgMemberSelectTypeEnum.Variate);
        }
    }

    @Override
    protected void cbxSelectType_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxSelectType_itemStateChanged(e);
        if (e.getStateChange() != 1 || this.getMemberSelectType().equals(this.cbxSelectType.getUserObject())) {
            return;
        }
        if (this.isNeedCheckSwitch.booleanValue()) {
            this.checkCanSwitch(this.cbxSelectType.getUserObject() instanceof BgMemberSelectTypeEnum ? (BgMemberSelectTypeEnum)((Object)this.cbxSelectType.getUserObject()) : this.getMemberSelectType());
        }
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            this.initMemberType();
        } else {
            this.initVariateType();
        }
        this.cbxSelectType.setUserObject((Object)this.getMemberSelectType());
    }

    protected void checkCanSwitch(BgMemberSelectTypeEnum oldSelectType) {
        boolean canSwitch = true;
        if (BgMemberSelectTypeEnum.Member == oldSelectType) {
            canSwitch = this.tblRight.getRowCount() <= 0;
        } else if (BgMemberSelectTypeEnum.Variate == oldSelectType) {
            boolean bl = canSwitch = this.tblVaRight.getRowCount() <= 0;
        }
        if (!canSwitch) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"only_one_source"));
            this.cbxSelectType.setSelectedItem(this.cbxSelectType.getUserObject(), false);
            return;
        }
    }

    private void initMemberType() {
        if (this.cbxBgPeriodType.getSelectedItem() instanceof BgPeriodTypeInfo) {
            this.bgPeriodTypeInfo = (BgPeriodTypeInfo)this.cbxBgPeriodType.getSelectedItem();
        } else if (this.cbxBgPeriodType.getSelectedItem() == null && this.bgPeriodTypeInfo instanceof BgPeriodTypeInfo) {
            this.cbxBgPeriodType.removeItem(null);
            this.cbxBgPeriodType.setSelectedItem((Object)this.bgPeriodTypeInfo, false);
        }
        if (this.cbxYear.getSelectedItem() instanceof BgPeriodDispInfo) {
            this.bgPeriodDispInfo = (BgPeriodDispInfo)this.cbxYear.getSelectedItem();
        } else if (this.cbxYear.getSelectedItem() == null && this.bgPeriodDispInfo instanceof BgPeriodDispInfo) {
            this.cbxYear.removeItem(null);
            this.cbxYear.setSelectedItem((Object)this.bgPeriodDispInfo, false);
        }
        this.switchSelectTypeToMember(true);
    }

    private void initVariateType() throws BOSException {
        this.switchSelectTypeToMember(false);
        this.cbxBgPeriodType.setSelectedItem(null);
        this.cbxYear.setSelectedItem(null);
        if (!this.isLoadTblVaLeft) {
            BgViewMemberSelectHelper.loadBgVariate(this.bgSchemeId, DimensionConstants.DEF_PERIOD_NUMBER, this.tblVaLeft, null);
            this.isLoadTblVaLeft = true;
        }
    }

    private void switchSelectTypeToMember(boolean isSelectMember) {
        this.tblMain.setVisible(isSelectMember);
        this.tblRight.setVisible(isSelectMember);
        this.tblVaLeft.setVisible(!isSelectMember);
        this.tblVaRight.setVisible(!isSelectMember);
        this.cbxBgPeriodType.setEnabled(isSelectMember);
        this.cbxYear.setEnabled(isSelectMember);
        this.chkYear.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkHalfYear.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkQuarter.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkMonth.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkMWeek.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.chkYWeek.setEnabled(isSelectMember && this.isMultiSelect != false);
        this.btnExpand.setEnabled(isSelectMember);
        this.btnConstriction.setEnabled(isSelectMember);
    }

    protected BgMemberSelectTypeEnum getMemberSelectType() {
        return (BgMemberSelectTypeEnum)((Object)this.cbxSelectType.getSelectedItem());
    }

    @Override
    protected void tblVaLeft_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblVaLeft_tableClicked(e);
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        if (e.getClickCount() == 2) {
            BgViewMemberSelectHelper.doubleVaClick(this.tblVaLeft, this.tblVaRight, this.isMultiSelect, false);
            return;
        }
    }

    protected void doubleClick() throws Exception {
        int currRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (currRowIndex >= 0) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            rows.add(currRowIndex);
            BgViewMemberSelectHelper.addPeriodRows((CoreUI)this, rows, this.tblMain, this.tblRight, this.isMultiSelect, Boolean.TRUE.equals(this.getUIContext().get("isOnlyLeaf")));
        }
    }

    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain);
            BgViewMemberSelectHelper.addPeriodRows((CoreUI)this, rows, this.tblMain, this.tblRight, this.isMultiSelect, Boolean.TRUE.equals(this.getUIContext().get("isOnlyLeaf")));
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblVaLeft);
            BgViewMemberSelectHelper.addRows(rows, this.tblVaLeft, this.tblVaRight, this.isMultiSelect, false);
        }
    }

    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            List rows = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblMain);
            BgViewMemberSelectHelper.addPeriodRows((CoreUI)this, rows, this.tblMain, this.tblRight, this.isMultiSelect, Boolean.TRUE.equals(this.getUIContext().get("isOnlyLeaf")));
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            List rows = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblVaLeft);
            BgViewMemberSelectHelper.addRows(rows, this.tblVaLeft, this.tblVaRight, this.isMultiSelect, false);
        }
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            super.btnDelete_actionPerformed(e);
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            BgCommCHelper.removeRows((KDTable)this.tblVaRight);
        }
    }

    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            super.btnDeleteAll_actionPerformed(e);
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            this.tblVaRight.removeRows();
        }
    }

    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            super.btnUp_actionPerformed(e);
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            BgCommCHelper.moveUp((KDTable)this.tblVaRight);
        }
    }

    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            super.btnTop_actionPerformed(e);
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            BgCommCHelper.moveTop((KDTable)this.tblVaRight);
        }
    }

    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            super.btnDown_actionPerformed(e);
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            BgCommCHelper.moveDown((KDTable)this.tblVaRight);
        }
    }

    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
            super.btnBottom_actionPerformed(e);
        } else if (BgMemberSelectTypeEnum.Variate == this.getMemberSelectType()) {
            BgCommCHelper.moveBottom((KDTable)this.tblVaRight);
        }
    }

    public Object getData() {
        MbgViewListResultData data;
        block8: {
            data = new MbgViewListResultData();
            try {
                if (BgMemberSelectTypeEnum.Member == this.getMemberSelectType()) {
                    Object obj = super.getData();
                    if (obj instanceof BgPeriodCollection) {
                        ArrayList<BgPeriodInfo> periodLst = new ArrayList<BgPeriodInfo>();
                        BgPeriodCollection colls = (BgPeriodCollection)obj;
                        int in = colls.size();
                        for (int i = 0; i < in; ++i) {
                            periodLst.add(colls.get(i));
                        }
                        this.setNSetting(periodLst);
                        if (this.isSelfSelect) {
                            data.setCanAddMembers(periodLst);
                        } else {
                            data.setMembers(periodLst);
                        }
                        data.setMemberType(BgMemberSelectTypeEnum.Member);
                        return data;
                    }
                    break block8;
                }
                data.setMembers(BgViewMemberSelectHelper.getBgVariateLst(this.tblVaRight));
                data.setMemberType(BgMemberSelectTypeEnum.Variate);
                return data;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
                this.handUIException(e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
                this.handUIException(e);
            }
        }
        this.returnData = data;
        return this.returnData instanceof MbgViewListResultData ? (MbgViewListResultData)this.returnData : null;
    }

    protected void setNSetting(List<BgPeriodInfo> periodLst) {
        if (!this.isNeedNSetting || periodLst == null || periodLst.isEmpty()) {
            return;
        }
        boolean hasNoNSet = false;
        for (int i = 0; i < periodLst.size(); ++i) {
            if (BgPeriodNVariableHelper.checkCanConvert((String)periodLst.get(i).getNumber())) continue;
            hasNoNSet = true;
            break;
        }
        if (!hasNoNSet) {
            return;
        }
        BgPeriodVariable bgPeriodVariable = null;
        BgPeriodNSettingUI ui = null;
        String message = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"periodParameter");
        int result = MsgBox.showConfirm2New(ui, (String)message);
        if (result == 0) {
            UIContext uiContext = new UIContext((Object)this);
            try {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getSettingUIName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                ui = (BgPeriodNSettingUI)uiWindow.getUIObject();
            }
            catch (UIException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            if (!ui.isCancel()) {
                bgPeriodVariable = ui.getBgPeriodVariable();
            }
        }
        if (ui != null && bgPeriodVariable != null) {
            for (int i = 0; i < periodLst.size(); ++i) {
                periodLst.get(i).setNumber(BgPeriodVariable.getBgPeriodParam((String)periodLst.get(i).getNumber(), (BgPeriodVariable)bgPeriodVariable));
                periodLst.get(i).setName(periodLst.get(i).getNumber());
                periodLst.get(i).setDisplayName(periodLst.get(i).getNumber());
            }
        }
    }

    protected String getSettingUIName() {
        return "com.kingdee.eas.ma.base.client.BgPeriodNSettingUI";
    }

    public void dataChanged(DataChangeEvent eventObj) {
        this.returnData = eventObj.getNewValue();
        if (eventObj.getNewValue() instanceof MbgViewListResultData) {
            BgMemberSelectTypeEnum memberType = ((MbgViewListResultData)eventObj.getNewValue()).getMemberType();
            this.isNeedCheckSwitch = false;
            this.cbxSelectType.setSelectedItem((Object)memberType, true);
            this.isNeedCheckSwitch = true;
            this.reFillData(eventObj);
        } else {
            this.resetRightTable();
        }
    }

    protected void resetRightTable() {
        this.tblRight.removeRows(false);
        this.tblVaRight.removeRows(false);
    }

    protected void reFillData(DataChangeEvent eventObj) {
        MbgViewListResultData newData = (MbgViewListResultData)eventObj.getNewValue();
        BgMemberSelectTypeEnum memberType = newData.getMemberType();
        if (BgMemberSelectTypeEnum.Member == memberType) {
            this.reFillMembers(newData);
        } else if (BgMemberSelectTypeEnum.Variate == memberType) {
            this.reFillVariate(newData);
        }
    }

    protected void reFillMembers(MbgViewListResultData newData) {
        IRow rowRight;
        Object bgPeriodInfo;
        int i;
        List members = newData.getMembers();
        List canAddMembers = newData.getCanAddMembers();
        if (members != null && !members.isEmpty()) {
            this.tblRight.removeRows();
            for (i = 0; i < members.size(); ++i) {
                if (members.get(i) instanceof BgPeriodInfo) {
                    bgPeriodInfo = (BgPeriodInfo)members.get(i);
                    if (bgPeriodInfo == null) continue;
                    rowRight = this.tblRight.addRow();
                    rowRight.getCell("number").setValue((Object)bgPeriodInfo.getNumber());
                    rowRight.getCell("name").setValue((Object)bgPeriodInfo.getName());
                    rowRight.getCell("alias").setValue((Object)bgPeriodInfo.getDisplayName());
                    continue;
                }
                if (!(members.get(i) instanceof BgDimensionMember) || (bgPeriodInfo = (BgDimensionMember)members.get(i)) == null) continue;
                rowRight = this.tblRight.addRow();
                rowRight.getCell("number").setValue((Object)((BgDimensionMember)bgPeriodInfo).getNumber());
                rowRight.getCell("name").setValue((Object)((BgDimensionMember)bgPeriodInfo).getName());
                rowRight.getCell("alias").setValue((Object)((BgDimensionMember)bgPeriodInfo).getAlias());
            }
        }
        if (canAddMembers != null && !canAddMembers.isEmpty()) {
            this.tblRight.removeRows();
            for (i = 0; i < canAddMembers.size(); ++i) {
                if (!(canAddMembers.get(i) instanceof BgPeriodInfo) || (bgPeriodInfo = (BgPeriodInfo)canAddMembers.get(i)) == null) continue;
                rowRight = this.tblRight.addRow();
                rowRight.getCell("number").setValue((Object)bgPeriodInfo.getNumber());
                rowRight.getCell("name").setValue((Object)bgPeriodInfo.getName());
                rowRight.getCell("alias").setValue((Object)bgPeriodInfo.getDisplayName());
            }
        }
    }

    protected void reFillVariate(MbgViewListResultData newData) {
        IRow rowRight;
        BgVariateInfo bgVariateInfo;
        int i;
        List members = newData.getMembers();
        List canAddMembers = newData.getCanAddMembers();
        if (members != null && !members.isEmpty()) {
            this.tblVaRight.removeRows();
            for (i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof BgVariateInfo) || (bgVariateInfo = (BgVariateInfo)members.get(i)) == null) continue;
                rowRight = this.tblVaRight.addRow();
                rowRight.getCell("id").setValue((Object)bgVariateInfo.getId().toString());
                rowRight.getCell("number").setValue((Object)bgVariateInfo.getNumber());
                rowRight.getCell("name").setValue((Object)bgVariateInfo.getName());
            }
        }
        if (canAddMembers != null && !canAddMembers.isEmpty()) {
            this.tblVaRight.removeRows();
            for (i = 0; i < canAddMembers.size(); ++i) {
                if (!(canAddMembers.get(i) instanceof BgVariateInfo) || (bgVariateInfo = (BgVariateInfo)canAddMembers.get(i)) == null) continue;
                rowRight = this.tblVaRight.addRow();
                rowRight.getCell("id").setValue((Object)bgVariateInfo.getId().toString());
                rowRight.getCell("number").setValue((Object)bgVariateInfo.getNumber());
                rowRight.getCell("name").setValue((Object)bgVariateInfo.getName());
            }
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        String bgSchemeId = (String)this.getUIContext().get("BGSCHEME_ID");
        BgSchemeDimensionHelper schemeHelper = null;
        AbstractBgSchemeInfo bgSchemeInfo = null;
        if (bgSchemeId != null) {
            try {
                schemeHelper = new BgSchemeDimensionHelper(bgSchemeId);
                bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK(bgSchemeId));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        if (schemeHelper != null) {
            Set<String> bgPeriodTypeNumbers = schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true);
            this.getUIContext().put("bgPeriodTypeNumbers", bgPeriodTypeNumbers);
        }
        if (bgSchemeInfo != null) {
            this.getUIContext().put("beginDate", bgSchemeInfo.getDateFrom());
            this.getUIContext().put("endDate", bgSchemeInfo.getDateTo());
        }
        this.loadBgPeriodType();
        this.loadYear();
    }
}

