/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.DimensionCollection;
import com.kingdee.eas.ma.mbg.DimensionFactory;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionF7UI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionF7UI
extends AbstractDimensionF7UI {
    private static final long serialVersionUID = -6363674242973074865L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionF7UI.class);
    public static final String COL_Name = "name";
    public static final String COL_Select = "select";
    public static final String COL_RefField = "refField";
    private Set<String> dimFilter;
    private boolean isCanceled = true;
    private List<DimensionInfo> data = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadDimension();
    }

    protected void loadDimension() throws BOSException {
        this.tblMain.removeRows();
        DimensionCollection col = this.queryDimension();
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                if (this.dimFilter != null && !this.dimFilter.contains(col.get(i).getNumber())) continue;
                IRow row = this.tblMain.addRow();
                row.setUserObject((Object)col.get(i));
                row.getCell(COL_Select).setValue((Object)Boolean.FALSE);
                row.getCell(COL_Name).setValue((Object)col.get(i).getName());
                row.getCell(COL_RefField).setValue((Object)col.get(i).getRefField());
            }
        }
    }

    protected DimensionCollection queryDimension() throws BOSException {
        DimensionCollection col = DimensionFactory.getRemoteInstance().getDimensionCollection("select id, number, name, refField where necessary = 0 order by refField");
        return col;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnOk_actionPerformed(e);
        ArrayList<DimensionInfo> newData = new ArrayList<DimensionInfo>();
        HashSet<String> newDataRefs = new HashSet<String>();
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(COL_Select).getValue())) continue;
            DimensionInfo dimension = (DimensionInfo)row.getUserObject();
            newData.add(dimension);
            newDataRefs.add(dimension.getRefField());
        }
        if (newData.isEmpty()) {
            this.data = null;
        } else if (this.data == null || this.data.isEmpty()) {
            this.data = newData;
        } else if (newData.size() != this.data.size()) {
            this.data = newData;
        } else {
            for (i = 0; i < this.data.size(); ++i) {
                if (newDataRefs.contains(this.data.get(i).getRefField())) continue;
                this.data = newData;
                break;
            }
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
    }

    public void reShow() {
        try {
            this.loadDimension();
            this.loadSelectDim();
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.isCanceled = true;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.data;
    }

    public void dataChanged(DataChangeEvent eventObj) {
        this.data = eventObj.getNewValue() instanceof List ? (List)eventObj.getNewValue() : null;
        this.loadSelectDim();
    }

    protected void loadSelectDim() {
        HashSet<String> refFields = new HashSet<String>();
        if (this.data != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                refFields.add(this.data.get(i).getRefField());
            }
        }
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            DimensionInfo dimension = (DimensionInfo)this.tblMain.getRow(i).getUserObject();
            this.tblMain.getCell(i, COL_Select).setValue((Object)refFields.contains(dimension.getRefField()));
        }
    }

    public void setDimFilter(Set<String> dimFilter) {
        this.dimFilter = dimFilter;
    }
}

