/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.KDTIOManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BGReportUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgdimDisplayMemberCollection;
import com.kingdee.eas.ma.mbg.BgdimDisplayMemberFactory;
import com.kingdee.eas.ma.mbg.BgdimDisplayMemberInfo;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionImportUI;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class DimensionImportUI
extends AbstractDimensionImportUI {
    private static final Logger logger = CoreUIObject.getLogger(DimensionImportUI.class);
    public static final String IMPORT_RES = "com.kingdee.eas.tools.datatask.DatataskResource";
    public static final String res = "com.kingdee.eas.ma.mbg.DimensionCommonResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOpenFile.setIcon((Icon)((ImageIcon)ResourceBase.getIcon((String)"com.kingdee.eas.tools.datatask.ui.ImageResource.tbtn_open", (Locale)new Locale("L1"))));
        this.panelProgress.setVisible(false);
        this.setBtnState(true);
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            this.kDLabelContainer2.setVisible(false);
            this.btnConfirm.setText(BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"export"));
            this.kDLabel1.setText(BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"exporting"));
        } else {
            this.comboError.removeAllItems();
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
            this.comboError.setSelectedItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        }
    }

    private void setBtnState(boolean state) {
        this.btnCancel.setEnabled(state);
        this.btnConfirm.setEnabled(state);
        this.btnOpenFile.setEnabled(state);
        this.chkUpdate.setEnabled(state);
        this.btnExportTemplate.setEnabled(state);
        this.btnExportTemplate.setVisible(true);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFile.getText())) {
            return;
        }
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            ProgressThread process = new ProgressThread(false);
            process.start();
        } else {
            ProgressThread process = new ProgressThread(true);
            process.start();
        }
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(BgCommCHelper.getMessageStr((String)res, (String)"dimensionMemberExport"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)filePath)) {
            this.txtFile.setText(filePath.toString());
            this.txtFile.setUserObject((Object)fileChooser.getSelectedFile());
        }
    }

    @Override
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        boolean isSuccess;
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(BgCommCHelper.getMessageStr((String)res, (String)"dimensionMemberTemplet"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(BgCommCHelper.getMessageStr((String)res, (String)"dimensionMemberTemplet")));
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDTable tbl = (KDTable)this.getUIContext().get("template");
        if (!StringUtils.isEmpty((String)filePath) && (isSuccess = this.appendToExcel(filePath, tbl))) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)res, (String)"templetExportSuccess"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean appendToExcel(String filePath, KDTable tbl) throws Exception {
        File file = new File(filePath);
        KDTIOManager ioManager = tbl.getIOManager();
        KDSBook book = null;
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(5);
        try {
            this.progressBar.setValue(1);
            if (file.exists()) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"fileHasExisted"));
                if (result != 0) return false;
                if (!file.delete()) {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"openedfile"));
                    this.disableButtons();
                    return false;
                }
                file = new File(filePath);
                book = new KDSBook(file.getName());
            } else {
                book = new KDSBook(file.getName());
            }
            this.progressBar.setValue(2);
            book.addSheet(null, ioManager.saveToKDSSheet(book, true, false, BgCommCHelper.getMessageStr((String)res, (String)"dimensionMember")));
            this.progressBar.setValue(3);
            ExportManager man = new ExportManager();
            this.progressBar.setValue(4);
            try {
                man.exportToExcel(book, filePath);
            }
            catch (POIExportException ex) {
                MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"183_BgControlRuleEditUI"));
            }
            this.progressBar.setValue(5);
            return true;
        }
        catch (Exception err) {
            logger.error((Object)"mbg error:", (Throwable)err);
            this.handUIException(err);
        }
        return true;
    }

    private boolean verifyInput() {
        return false;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
    }

    protected void enableButtons() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.btnExportTemplate.setEnabled(true);
        this.panelProgress.setVisible(false);
    }

    protected void disableButtons() {
        this.btnConfirm.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpenFile.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.btnExportTemplate.setEnabled(false);
        this.panelProgress.setVisible(true);
    }

    public Icon getImage() {
        return EASResource.getIcon((String)"imgTransfers_pic260");
    }

    private void importData(KDSSheet sheet) {
        String dimNumber = (String)this.getUIContext().get("dimNumber");
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get("bgScheme");
        BgDimSettingsInfo dimSettings = (BgDimSettingsInfo)this.getUIContext().get("dimSettings");
        if (!this.validateTemplate(sheet)) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)res, (String)"templetError"));
            return;
        }
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        CoreBaseCollection settingsMemberCol = new CoreBaseCollection();
        CoreBaseCollection updateMemberCol = new CoreBaseCollection();
        CoreBaseCollection deleteMemberCol = new CoreBaseCollection();
        BgdimDisplayMemberCollection disPlayMemberCol = this.getPolAlColByScheme();
        HashMap<String, String> displayNumberMap = new HashMap<String, String>();
        for (int j = 0; j < disPlayMemberCol.size(); ++j) {
            String memberId = disPlayMemberCol.get(j).getMemberId();
            String dispayId = disPlayMemberCol.get(j).getId().toString();
            displayNumberMap.put(memberId, dispayId);
        }
        Set displayMemberIdSet = displayNumberMap.keySet();
        try {
            try {
                settingsMemberCol = this.getMembersCollByScheme();
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                logger.error((Object)e.getMessage());
            }
            HashSet<String> polAlCantUpdateNumber = new HashSet<String>();
            HashSet<String> settMemNumber = new HashSet<String>();
            HashMap<String, String> coreNumMap = new HashMap<String, String>();
            for (int i = 0; i < settingsMemberCol.size(); ++i) {
                CoreBaseInfo info = settingsMemberCol.get(i);
                if (info instanceof BgVersionInfo) {
                    settMemNumber.add(((BgVersionInfo)info).getNumber());
                    coreNumMap.put(((BgVersionInfo)info).getNumber(), ((BgVersionInfo)info).getId().toString());
                    if (((BgVersionInfo)info).getLevel() != 1) continue;
                    polAlCantUpdateNumber.add(((BgVersionInfo)info).getNumber());
                    continue;
                }
                if (info instanceof BgScenarioInfo) {
                    settMemNumber.add(((BgScenarioInfo)info).getNumber());
                    coreNumMap.put(((BgScenarioInfo)info).getNumber(), ((BgScenarioInfo)info).getId().toString());
                    if (((BgScenarioInfo)info).getLevel() != 1) continue;
                    polAlCantUpdateNumber.add(((BgScenarioInfo)info).getNumber());
                    continue;
                }
                if (!(info instanceof BgElementInfo)) continue;
                settMemNumber.add(((BgElementInfo)info).getNumber());
                coreNumMap.put(((BgElementInfo)info).getNumber(), ((BgElementInfo)info).getId().toString());
                if (((BgElementInfo)info).getLevel() != 1) continue;
                polAlCantUpdateNumber.add(((BgElementInfo)info).getNumber());
            }
            int errorNum = ((ErrorHandleModeEnum)this.comboError.getSelectedItem()).getValue();
            ArrayList errorLst = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            Object dimInfo = null;
            Object numLst = null;
            Object oneLevelNumLst = null;
            Object dimExpMap = null;
            Object dimSrcMap = null;
            int row_0 = 0;
            int row_1 = 1;
            int row_2 = 2;
            int row_3 = 3;
            Object number = null;
            Object name = null;
            Object polAlgorithm = null;
            Object dataType = null;
            boolean isTreeBase = true;
            Object dimExpInfo = null;
            int errSize = 0;
            this.progressBar.setMaximum(sheet.getRowCount());
            int in = sheet.getRowCount();
            for (int i = 1; i < in; ++i) {
                this.progressBar.setValue(i);
                number = sheet.getCell(i, row_0, false).getValue();
                name = sheet.getCell(i, row_1, false).getValue();
                polAlgorithm = sheet.getCell(i, row_2, false).getValue();
                if (dimNumber.equals("BG_Element")) {
                    dataType = sheet.getCell(i, row_3, false).getValue();
                } else if (dimNumber.equals("BG_Scenario")) {
                    dataType = sheet.getCell(i, row_3, false).getValue();
                }
                BgdimDisplayMemberInfo rowInfo = new BgdimDisplayMemberInfo();
                rowInfo.setSchemeId(bgScheme == null ? null : bgScheme.getId().toString());
                rowInfo.setDimNumber(dimNumber == null ? null : dimNumber.toString());
                if (number != null && !number.toString().equals("")) {
                    if (settMemNumber.contains(number.toString())) {
                        String displayId;
                        String id = (String)coreNumMap.get(number.toString());
                        Boolean contain = displayMemberIdSet.contains(id);
                        rowInfo.setMemberId(id);
                        if (polAlgorithm == null || polAlgorithm.toString().trim().equals("")) {
                            rowInfo.setPolAlgorithm(BgUpperGatherEnum.add);
                            if (!contain.booleanValue()) continue;
                            displayId = (String)displayNumberMap.get(id);
                            rowInfo.setId(BOSUuid.read((String)displayId));
                            deleteMemberCol.add((CoreBaseInfo)rowInfo);
                            continue;
                        }
                        if (polAlgorithm.toString().trim().equals(BgUpperGatherEnum.add.getAlias())) {
                            rowInfo.setPolAlgorithm(BgUpperGatherEnum.add);
                            if (!contain.booleanValue()) continue;
                            displayId = (String)displayNumberMap.get(id);
                            rowInfo.setId(BOSUuid.read((String)displayId));
                            deleteMemberCol.add((CoreBaseInfo)rowInfo);
                            continue;
                        }
                        if (polAlgorithm.toString().trim().equals(BgUpperGatherEnum.subtract.getAlias())) {
                            if (polAlCantUpdateNumber.contains(number.toString())) continue;
                            rowInfo.setPolAlgorithm(BgUpperGatherEnum.subtract);
                            if (contain.booleanValue()) {
                                displayId = (String)displayNumberMap.get(id);
                                rowInfo.setId(BOSUuid.read((String)displayId));
                            }
                            updateMemberCol.add((CoreBaseInfo)rowInfo);
                            continue;
                        }
                        if (polAlgorithm.toString().trim().equals(BgUpperGatherEnum.ignore.getAlias())) {
                            if (polAlCantUpdateNumber.contains(number.toString())) continue;
                            rowInfo.setPolAlgorithm(BgUpperGatherEnum.ignore);
                            if (contain.booleanValue()) {
                                displayId = (String)displayNumberMap.get(id);
                                rowInfo.setId(BOSUuid.read((String)displayId));
                            }
                            updateMemberCol.add((CoreBaseInfo)rowInfo);
                            continue;
                        }
                        if (polAlCantUpdateNumber.contains(number.toString())) continue;
                        ++errSize;
                        map = new HashMap();
                        map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"importError_1", (Object[])new Object[]{i + 1}));
                        errorLst.add(map);
                        if (errorNum != 1) continue;
                        break;
                    }
                    if (settMemNumber.contains(number.toString())) continue;
                    ++errSize;
                    map = new HashMap();
                    map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"importError_4", (Object[])new Object[]{i + 1, number}));
                    errorLst.add(map);
                    if (errorNum != 1) continue;
                    break;
                }
                if (number == null || number.toString().equals("")) {
                    map = new HashMap();
                    map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)res, (String)"upGradeError_2"), i + 1));
                }
                ++errSize;
                errorLst.add(map);
                if (errorNum == 1) break;
            }
            try {
                if (updateMemberCol != null && updateMemberCol.size() != 0) {
                    BgdimDisplayMemberFactory.getRemoteInstance().saveBatchData(updateMemberCol);
                }
                if (deleteMemberCol != null && deleteMemberCol.size() != 0) {
                    ObjectUuidPK[] pks = new ObjectUuidPK[deleteMemberCol.size()];
                    for (int i = 0; i < deleteMemberCol.size(); ++i) {
                        pks[i] = new ObjectUuidPK(deleteMemberCol.get(i).getId());
                    }
                    BgdimDisplayMemberFactory.getRemoteInstance().deleteBatchData((IObjectPK[])pks);
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            ArrayList txtlst = new ArrayList();
            map = new HashMap();
            int successSize = sheet.getRowCount() - errSize - 1;
            map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)res, (String)"importMsg_1"), successSize));
            txtlst.add(map);
            if (sheet.getRowCount() - successSize != 1) {
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"importMsg_2", (Object[])new String[]{String.valueOf(sheet.getRowCount() - successSize - 1)}));
                txtlst.add(map);
            }
            txtlst.addAll(errorLst);
            ArrayList<String> listHeadTitle = new ArrayList<String>();
            listHeadTitle.add(" ");
            UIContext ctx = new UIContext((Object)this);
            ctx.put("LIST_CONTENT", txtlst);
            ctx.put("LIST_HEAD_TITLE", listHeadTitle);
            String invokeTime = BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date());
            ctx.put("INVOKE_TIME", invokeTime);
            ctx.put("UI_OWNER_TITLE", BgCommCHelper.getMessageStr((String)res, (String)"dimPropImport"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGReportUI.class.getName(), (Map)ctx);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private boolean getColumnSize(KDSSheet sheet) {
        String dimNumber = (String)this.getUIContext().get("dimNumber");
        int columnCount = sheet.getColumnCount();
        return dimNumber.equals("BG_Version") ? columnCount >= 3 : (dimNumber.equals("BG_Scenario") || dimNumber.equals("BG_Element")) && columnCount >= 4;
    }

    private boolean validateTemplate(KDSSheet sheet) {
        if (!this.getColumnSize(sheet)) {
            return false;
        }
        KDTable tbl = (KDTable)this.getUIContext().get("template");
        String cell = "";
        String tcell = "";
        for (int i = 0; i < tbl.getColumnCount(); ++i) {
            if (sheet.getCell(0, i, false).getValue() != null) {
                cell = tbl.getHeadRow(0).getCell(i).getValue().toString();
                if (cell.equals((tcell = sheet.getCell(0, i, false).getValue().toString()).trim())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private CoreBaseCollection getMembersCollByScheme() throws BOSException {
        String dimNumber = (String)this.getUIContext().get("dimNumber");
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get("bgScheme");
        CoreBaseCollection bgMemberCol = new CoreBaseCollection();
        HashSet memberIdList = new HashSet();
        String tableName = this.getTableName(dimNumber);
        DimensionInfo dimInfo = new DimensionInfo();
        String sql = "SELECT distinct p.fid,p.flevel,p.fnumber,p.fname_l2 FROM t_mbg_bgScheme sc LEFT OUTER JOIN t_mbg_bgDimSettings st on st.fbgSchemeid = sc.fid   LEFT OUTER JOIN t_mbg_bgDimSettingsMember dm on dm.fbgDimSettingsid = st.fid  LEFT OUTER JOIN  " + tableName + " p on p.fid = dm.fmemberid  where   sc.fid = '" + bgScheme.getId().toString() + "' and st.fdimNumber = '" + dimNumber + "'";
        try {
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = iSql.executeSQL();
            while (rs.next()) {
                CoreBaseInfo memberInfo = null;
                String Id = rs.getString("fid");
                String name = rs.getString("fname_l2");
                String number = rs.getString("fnumber");
                int level = Integer.valueOf(rs.getString("flevel").toString());
                if (dimNumber.equals("BG_Version")) {
                    BgVersionInfo verInfo = new BgVersionInfo();
                    verInfo.setNumber(number);
                    verInfo.setName(name);
                    verInfo.setLevel(level);
                    memberInfo = (CoreBaseInfo)verInfo.clone();
                } else if (dimNumber.equals("BG_Element")) {
                    BgElementInfo eleInfo = new BgElementInfo();
                    eleInfo.setNumber(number);
                    eleInfo.setName(name);
                    eleInfo.setLevel(level);
                    memberInfo = (CoreBaseInfo)eleInfo.clone();
                }
                if (dimNumber.equals("BG_Scenario")) {
                    BgScenarioInfo sceInfo = new BgScenarioInfo();
                    sceInfo.setNumber(number);
                    sceInfo.setName(name);
                    sceInfo.setLevel(level);
                    memberInfo = (CoreBaseInfo)sceInfo.clone();
                }
                memberInfo.setId(BOSUuid.read((String)Id));
                bgMemberCol.add(memberInfo);
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        return bgMemberCol;
    }

    private BgdimDisplayMemberCollection getPolAlColByScheme() {
        String dimNumber = (String)this.getUIContext().get("dimNumber");
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.getUIContext().get("bgScheme");
        BgdimDisplayMemberCollection memberCol = new BgdimDisplayMemberCollection();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo item1 = new FilterItemInfo("dimNumber".toLowerCase(), (Object)dimNumber, CompareType.EQUALS);
            FilterItemInfo item2 = new FilterItemInfo("schemeId".toLowerCase(), (Object)bgScheme.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(item1);
            filter.getFilterItems().add(item2);
            filter.setMaskString(" #0 and #1 ");
            evi.setFilter(filter);
            memberCol = BgdimDisplayMemberFactory.getRemoteInstance().getBgdimDisplayMemberCollection(evi);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return memberCol;
    }

    private String getTableName(String dimNumber) {
        String tableName = "";
        tableName = dimNumber.equals("BG_Version") ? "T_mbg_bgVersion " : (dimNumber.equals("BG_Element") ? "T_mbg_bgElement " : "T_mbg_bgScenario ");
        return tableName;
    }

    class ProgressThread
    extends Thread {
        private boolean isImport = false;

        public ProgressThread(boolean isImport) {
            this.isImport = isImport;
        }

        @Override
        public void run() {
            DimensionImportUI.this.disableButtons();
            String fileName = DimensionImportUI.this.txtFile.getText();
            if (this.isImport) {
                KDSBook book = null;
                try {
                    book = POIXlsReader.parse((String)fileName);
                }
                catch (Exception e1) {
                    SysUtil.abort();
                }
                if (book == null) {
                    MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"notFile"));
                    SysUtil.abort();
                }
                KDSSheet sheet = book.getSheet((Object)new Integer(0));
                DimensionImportUI.this.importData(sheet);
                DimensionImportUI.this.getUIWindow().hide();
            } else {
                KDTable tbl = (KDTable)DimensionImportUI.this.getUIContext().get("data");
                try {
                    boolean isSuccess = DimensionImportUI.this.appendToExcel(fileName, tbl);
                    if (isSuccess) {
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)DimensionImportUI.IMPORT_RES, (String)"exportSucceeded"));
                        DimensionImportUI.this.getUIWindow().hide();
                    }
                }
                catch (Exception e) {
                    DimensionImportUI.this.handleException(e);
                }
            }
            DimensionImportUI.this.enableButtons();
        }
    }
}

