/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.DimensionMemberSetUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DimensionMemberAddSubUI
extends DimensionMemberSetUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionMemberAddSubUI.class);
    private IMbgSheetManager mbgSheetManager = null;
    private BgFormInfo bgFormInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.mbgSheetManager = (IMbgSheetManager)this.getUIContext().get("curSheetManager");
        this.bgFormInfo = (BgFormInfo)this.getUIContext().get("bgForm");
        this.setOrgId((String)this.getUIContext().get("orgUnitId"));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.curSheetlc.setVisible(false);
        this.lblCurrScen.setVisible(false);
        this.pnlMemberCon.setBorder(BorderFactory.createEtchedBorder());
        this.pnlMemberCon.setBounds(new Rectangle(0, 0, 780, 450));
        this.pnlMemberCon.remove((Component)this.kDScrollPaneMember);
        this.kDScrollPaneMember.setBounds(new Rectangle(10, 17, 760, 430));
        this.pnlMemberCon.add((Component)this.kDScrollPaneMember, (Object)new KDLayout.Constraints(10, 17, 760, 430, 0));
    }

    @Override
    protected KDPanel getDimensionPanel(BgDimensionInfo bgDimensionInfo) {
        KDPanel pnl = super.getDimensionPanel(bgDimensionInfo);
        HashMap<JComponent, Boolean> componentStateMap = new HashMap<JComponent, Boolean>();
        componentStateMap.put((JComponent)this.getMemberValueTypeComboFromPnl(pnl), false);
        componentStateMap.put((JComponent)this.getMemberDisplayMode(pnl), false);
        componentStateMap.put((JComponent)this.getDinamicCanMemberF7FromPnl(pnl), false);
        componentStateMap.put((JComponent)this.getIsSelectRelationCheckBoxFromPnl(pnl), false);
        componentStateMap.put((JComponent)this.getSelectRelationF7FromPnl(pnl), false);
        KDCheckBox dinamicAddMemberChk = this.getDinamicAddMemberChckFromPnl(pnl);
        componentStateMap.put((JComponent)dinamicAddMemberChk, false);
        this.setComponentEnabled(componentStateMap);
        boolean isCanDinamicAddMember = false;
        if (dinamicAddMemberChk != null) {
            isCanDinamicAddMember = dinamicAddMemberChk.isSelected();
        }
        if (!this.isOrgDimension(bgDimensionInfo) && isCanDinamicAddMember) {
            KDBizPromptBox memberMapping = this.getMemberMappingF7FromPnl(pnl);
            KDBizPromptBox memberValue = this.getMemberValueF7FromPnl(pnl);
            memberMapping.setEnabled(true);
            memberValue.setEnabled(true);
            NewDimensionMemberDialog dialog = (NewDimensionMemberDialog)memberValue.getSelector();
            dialog.setCanFillType(false);
            dialog.setCanMember(this.getCanMember(bgDimensionInfo.getCanAddMember()));
            if (this.bgFormInfo.getId() != null && this.mbgSheetManager != null) {
                dialog.setBgFormId(this.bgFormInfo.getId().toString());
                dialog.setSheetManager(this.mbgSheetManager);
            }
        } else {
            this.getMemberMappingF7FromPnl(pnl).setEnabled(false);
            this.getMemberValueF7FromPnl(pnl).setEnabled(false);
        }
        return pnl;
    }

    protected void setComponentEnabled(Map<JComponent, Boolean> map) {
        JComponent com = null;
        for (Map.Entry<JComponent, Boolean> entry : map.entrySet()) {
            com = entry.getKey();
            if (com == null) continue;
            com.setEnabled(entry.getValue());
        }
    }

    private Map<String, Set<String>> getCanMember(List canAddMember) {
        if (canAddMember == null || canAddMember.isEmpty()) {
            return null;
        }
        HashMap<String, Set<String>> memberFilter = new HashMap<String, Set<String>>();
        for (int i = 0; i < canAddMember.size(); ++i) {
            BgDimensionMember member = (BgDimensionMember)canAddMember.get(i);
            if (!memberFilter.containsKey(member.getType())) {
                memberFilter.put(member.getType(), new HashSet());
            }
            ((Set)memberFilter.get(member.getType())).add(member.getNumber());
        }
        return memberFilter;
    }

    @Override
    protected KDBizPromptBox getDimensionF7(BgDimensionInfo dimensionInfo, String orgId, boolean isMultiSelect) throws Exception {
        return DimensionClientHelper.getDimensionF7(this, dimensionInfo, orgId, isMultiSelect, this.getVersionNo());
    }

    protected BigDecimal getVersionNo() {
        return this.bgFormInfo.getVersionNo();
    }

    @Override
    protected void storeDimensionMemberValue(KDPanel pnl, Map<String, BgDimensionInfo> dimensionMap) {
        if (pnl == null || dimensionMap == null) {
            return;
        }
        KDPanel subPanel = null;
        String dimensionNum = null;
        BgDimensionInfo dimensionInfo = null;
        KDBizPromptBox memberF7 = null;
        for (int i = 0; i < pnl.getComponentCount(); ++i) {
            if (!(pnl.getComponent(i) instanceof KDPanel) || StringUtils.isEmpty((String)(dimensionNum = (subPanel = (KDPanel)pnl.getComponent(i)).getName())) || dimensionMap.get(dimensionNum) == null) continue;
            dimensionInfo = dimensionMap.get(dimensionNum);
            memberF7 = this.getMemberValueF7FromPnl(subPanel);
            if (!memberF7.isEnabled()) continue;
            this.storeF7VauleToDimension(dimensionInfo, memberF7);
        }
    }

    @Override
    protected void storeF7VauleToDimension(BgDimensionInfo dimensionInfo, KDBizPromptBox f7) {
        if (dimensionInfo == null || f7 == null) {
            return;
        }
        BigDecimal formVersionNo = this.getVersionNo();
        List<BgDimensionMember> curMembers = this.convertF7Value(dimensionInfo, f7);
        List oldMembers = dimensionInfo.getMember();
        HashSet<String> srcNumbers = new HashSet<String>();
        MBgTemplateHelper.collectDimensionSrcNums(curMembers, srcNumbers);
        MBgTemplateHelper.collectDimensionSrcNums(oldMembers, srcNumbers);
        try {
            List<BgDimensionMember> newMembers = this.getNewMembersByOrder(curMembers, oldMembers, formVersionNo);
            dimensionInfo.getMember().clear();
            dimensionInfo.getMember().addAll(newMembers);
            dimensionInfo.setValue(dimensionInfo.unParseMember());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    private List<BgDimensionMember> getNewMembersByOrder(List<BgDimensionMember> curMembers, List<BgDimensionMember> oldMembers, BigDecimal versionNo) {
        int i;
        ArrayList<BgDimensionMember> newMembers = new ArrayList<BgDimensionMember>();
        HashMap<String, BgDimensionMember> oldMemberMap = new HashMap<String, BgDimensionMember>();
        if (oldMembers != null) {
            for (int i2 = 0; i2 < oldMembers.size(); ++i2) {
                oldMemberMap.put(MBgTemplateHelper.getDimensionMemeberSign(oldMembers.get(i2)), oldMembers.get(i2));
            }
        }
        HashSet<String> curMemberSign = new HashSet<String>();
        if (curMembers != null) {
            for (i = 0; i < curMembers.size(); ++i) {
                newMembers.add(curMembers.get(i));
                if (!oldMemberMap.keySet().contains(MBgTemplateHelper.getDimensionMemeberSign(curMembers.get(i)))) {
                    curMembers.get(i).setVersion(versionNo);
                } else {
                    curMembers.get(i).setVersion(((BgDimensionMember)oldMemberMap.get(MBgTemplateHelper.getDimensionMemeberSign(curMembers.get(i)))).getVersion());
                }
                curMemberSign.add(MBgTemplateHelper.getDimensionMemeberSign(curMembers.get(i)));
            }
        }
        if (oldMembers != null) {
            for (i = 0; i < oldMembers.size(); ++i) {
                if (curMemberSign.contains(MBgTemplateHelper.getDimensionMemeberSign(oldMembers.get(i))) || oldMembers.get(i).getVersion().compareTo(versionNo) >= 0) continue;
                MBgTemplateHelper.insertNewMemberByOrder(newMembers, oldMembers.get(i));
            }
        }
        return newMembers;
    }

    @Override
    protected IBgDimensionManager getDimensionManager() {
        return this.mbgSheetManager.getDimensionManager();
    }

    @Override
    public IMbgSheetManager getSheetManager() {
        return this.mbgSheetManager;
    }

    @Override
    protected void setF7State(KDBizPromptBox memberF7, KDBizPromptBox mappingF7, KDComboBox bgPeriodTypeBox, KDLabel lblBgPeriodType, int dimensionMemberValueModeEnumValue, BgDimensionInfo dimension) {
        super.setF7State(memberF7, mappingF7, bgPeriodTypeBox, lblBgPeriodType, dimensionMemberValueModeEnumValue, dimension);
        bgPeriodTypeBox.setEnabled(false);
    }
}

