/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.icon.EmptyIcon;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionMemberFilterUI;
import com.kingdee.eas.ma.mbg.client.autoFilter.DimensionMemberAutoFilterButton;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DimensionMemberFilterUI
extends AbstractDimensionMemberFilterUI {
    private static final long serialVersionUID = 5176503181602165817L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionMemberFilterUI.class);
    private DefaultKingdeeTreeNode root = null;
    private Icon searchIcon = EASResource.getIcon((String)"imgTbtn_find");
    private Icon clearIcon = EASResource.getIcon((String)"image_default_remove");
    private EmptyIcon emptyIcon = new EmptyIcon();
    private DimensionMemberFilterInfo memberFilter;
    private BgDimensionBaseInfo dimension;
    private String sheetName;
    private DimensionMemberAutoFilterButton filterButton = null;
    private DimensionMemberFilterMember oldFilterMember = null;
    private boolean isDesc = false;
    protected DimensionMemberAutoFilterButton autoFilterButton = null;
    private JPopupMenu popMenu = new JPopupMenu(){

        @Override
        public void setVisible(boolean b) {
            if (!b) {
                DimensionMemberFilterUI.this.setAutoFilterButton();
            }
            super.setVisible(b);
        }
    };
    public boolean isFilterUIColse = true;
    public final int ALLSUBMEMBERS = 0;
    public final int SUBMEMBERS = 1;
    public final int LEVELPARENT = 2;
    public final int ALLLEVEL = 3;
    protected Map<String, BgPeriodInfo> periodCacheMap = new HashMap<String, BgPeriodInfo>();
    private boolean isExistsNullCell = false;

    public BgDimensionBaseInfo getDimension() {
        return this.dimension;
    }

    public void setDimension(BgDimensionBaseInfo dimension) {
        this.dimension = dimension;
    }

    public DimensionMemberFilterUI() throws Exception {
        this.root = new DefaultKingdeeTreeNode();
        this.root.setUserObject((Object)"");
        this.root.setCustomIcon((Icon)this.emptyIcon);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.treeMain.setShowCheckBox(true);
        this.setBtnSearch(null);
        this.treeMain.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                DimensionMemberFilterUI.this.treeMain_nodeStateChange(event);
            }
        });
    }

    public void reload() {
        this.loadMember(this.getDimensionMembers(), false, false);
    }

    private List getDimensionMembers() {
        ArrayList<BgDimensionMember> mems = this.dimension.getMember();
        if (this.isExistsNullCell()) {
            String nullMsg = EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"nullMsg");
            BgDimensionMember bgDimensionMember = new BgDimensionMember(null, null, nullMsg, null);
            bgDimensionMember.setSortValue((Comparable)((Object)""));
            ArrayList<BgDimensionMember> arrayList = new ArrayList<BgDimensionMember>();
            arrayList.add(bgDimensionMember);
            arrayList.addAll(mems);
            mems = arrayList;
        }
        return mems;
    }

    public void setMemberFilter(String sheetName, BgDimensionBaseInfo dimension, DimensionMemberFilterInfo memberFilter) {
        this.sheetName = sheetName;
        this.dimension = dimension;
        this.memberFilter = memberFilter;
        DimensionMemberFilterMember filter = this.getCurrentFilterMember();
        this.oldFilterMember = this.clone(filter);
        this.isDesc = filter.isDesc();
    }

    private DimensionMemberFilterMember clone(DimensionMemberFilterMember currentFilterMember) {
        if (currentFilterMember == null) {
            return null;
        }
        DimensionMemberFilterMember filter = currentFilterMember.clone();
        return filter;
    }

    protected DimensionMemberFilterMember getCurrentFilterMember() {
        return this.memberFilter.getMemberFilter(this.sheetName, this.dimension.getNumber());
    }

    public void setFilterButton(DimensionMemberAutoFilterButton filterButton) {
        this.filterButton = filterButton;
    }

    private void loadMember(List<BgDimensionMember> members, boolean isSearch, boolean isSelectAll) {
        int i;
        DefaultKingdeeTreeNode node;
        this.root.removeAllChildren();
        DimensionMemberFilterMember filter = this.getCurrentFilterMember();
        if (this.isDesc) {
            this.chbShowType.setEnabled(false);
            this.kDPanel1.setEnabled(false);
            this.rdoAllMembers.setEnabled(false);
            this.rdoLeafMembers.setEnabled(false);
            this.rdoUnLeafMembers.setEnabled(false);
        } else {
            this.chbShowType.setEnabled(true);
            this.kDPanel1.setEnabled(true);
            this.rdoAllMembers.setEnabled(true);
            this.rdoLeafMembers.setEnabled(true);
            this.rdoUnLeafMembers.setEnabled(true);
        }
        if (isSearch && members.isEmpty()) {
            node = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"noFoundMember"));
            node.setCustomIcon((Icon)this.emptyIcon);
            node.setCheckBoxVisible(false);
            this.root.add((MutableTreeNode)node);
            this.treeMain.setShowsRootHandles(false);
            this.btnOk.setEnabled(false);
        } else {
            if (!isSearch && filter != null) {
                isSelectAll = isSelectAll && filter.isSelectAll();
            }
            node = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"selectAll"));
            node.setCustomIcon((Icon)this.emptyIcon);
            node.setChecked(isSelectAll);
            this.root.add((MutableTreeNode)node);
            HashMap<String, DefaultKingdeeTreeNode> nodesMap = new HashMap<String, DefaultKingdeeTreeNode>();
            for (i = 0; i < members.size(); ++i) {
                int lastIndexOf;
                BgDimensionMember bgDimensionMember = members.get(i);
                node = new DefaultKingdeeTreeNode((Object)bgDimensionMember);
                if (this.isOnlyShowName()) {
                    node.setText(bgDimensionMember.getName());
                }
                node.setCustomIcon((Icon)this.emptyIcon);
                if (isSearch) {
                    node.setChecked(true);
                } else if (!isSelectAll) {
                    if (filter != null && filter.getMembers() != null && filter.getMembers().contains(bgDimensionMember.getNumber())) {
                        node.setChecked(true);
                    } else {
                        node.setChecked(false);
                    }
                } else {
                    node.setChecked(true);
                }
                String number = bgDimensionMember.getNumber();
                Comparable sortValue = bgDimensionMember.getSortValue();
                if (sortValue == null) continue;
                String longNumber = sortValue.toString();
                if (this.dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) && this.getPeriodCacheMap(members).containsKey(number)) {
                    longNumber = this.getPeriodCacheMap(members).get(number).getLongNumber();
                }
                if ((lastIndexOf = longNumber.lastIndexOf("!" + number)) > 0) {
                    String parentLongNumber = longNumber.substring(0, lastIndexOf);
                    if (nodesMap.keySet().contains(parentLongNumber)) {
                        ((DefaultKingdeeTreeNode)nodesMap.get(parentLongNumber)).add((MutableTreeNode)node);
                        nodesMap.put(longNumber, node);
                        continue;
                    }
                    this.root.add((MutableTreeNode)node);
                    nodesMap.put(longNumber, node);
                    continue;
                }
                this.root.add((MutableTreeNode)node);
                nodesMap.put(longNumber, node);
            }
            this.treeMain.setShowsRootHandles(true);
            this.btnOk.setEnabled(true);
        }
        this.treeMain.expandAllNodes(true, (TreeNode)this.root);
        if (isSearch && !members.isEmpty() && !isSelectAll) {
            HashSet<String> searchSet = new HashSet<String>();
            for (i = 0; i < members.size(); ++i) {
                searchSet.add(members.get(i).getNumber());
            }
            this.rdoMemberSelect(searchSet, false, true, this.getSelectRdoMembers());
        } else if (!isSearch) {
            this.selectRdoMember(filter.getMembers() == null ? 0 : filter.getSelectType(), false);
            this.rdoMemberSelect(filter == null ? null : filter.getMembers(), false, false, filter.getMembers() == null ? 0 : filter.getSelectType());
        } else {
            this.rdoMemberSelect(filter == null ? null : filter.getMembers(), false, false, filter.getMembers() == null ? this.getSelectRdoMembers() : filter.getSelectType());
        }
        this.chbShowType.setSelected(filter != null ? !filter.isOnlyShowName() : false);
        this.treeMain.updateUI();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.txtSearch.setText("");
        this.txtSearch_keyReleased(null);
    }

    @Override
    protected void txtSearch_keyReleased(KeyEvent e) throws Exception {
        List members = this.getDimensionMembers();
        ArrayList<BgDimensionMember> search = new ArrayList<BgDimensionMember>();
        String text = this.txtSearch.getText();
        if (StringUtils.isEmpty((String)text)) {
            search.addAll(members);
        } else {
            for (int i = 0; i < members.size(); ++i) {
                BgDimensionMember member = (BgDimensionMember)members.get(i);
                if (member.getName().toUpperCase(Locale.ENGLISH).indexOf(text.toUpperCase(Locale.ENGLISH)) < 0 && (member.getNumber() == null || member.getNumber().toUpperCase(Locale.ENGLISH).indexOf(text.toUpperCase(Locale.ENGLISH)) < 0)) continue;
                search.add(member);
            }
        }
        this.setBtnSearch(text);
        this.loadMember(search, true, StringUtils.isEmpty((String)text));
    }

    protected Set<String> getSearchNumbers() {
        List members = this.getDimensionMembers();
        HashSet<String> numbers = new HashSet<String>();
        String text = this.txtSearch.getText();
        if (!StringUtils.isEmpty((String)text)) {
            for (int i = 0; i < members.size(); ++i) {
                BgDimensionMember member = (BgDimensionMember)members.get(i);
                if (member.getName().indexOf(text) < 0 && (member.getNumber() == null || member.getNumber().indexOf(text) < 0)) continue;
                numbers.add(member.getNumber());
            }
        }
        return numbers;
    }

    private void setBtnSearch(String text) {
        if (StringUtils.isEmpty((String)text)) {
            this.btnSearch.setIcon(this.searchIcon);
            this.btnSearch.setEnabled(false);
        } else {
            this.btnSearch.setIcon(this.clearIcon);
            this.btnSearch.setEnabled(true);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.filterButton.setPopupVisible(false);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode multnode;
        super.btnOk_actionPerformed(e);
        if (this.getCurrentFilterMember() != null && this.getCurrentFilterMember().getMembers() != null) {
            this.getCurrentFilterMember().getMembers().clear();
        }
        if ((multnode = (DefaultKingdeeTreeNode)this.root.getChildAt(0)).isChecked()) {
            if (this.getCurrentFilterMember() != null) {
                this.getCurrentFilterMember().setSelectAll(true);
            }
        } else {
            boolean isAllUnSelected = true;
            HashSet<DefaultKingdeeTreeNode> set = new HashSet<DefaultKingdeeTreeNode>();
            Set<DefaultKingdeeTreeNode> nodesSet = this.getRNodes(this.root, set, true);
            for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
                if (!defaultKingdeeTreeNode.isChecked()) continue;
                if (this.getCurrentFilterMember() == null) {
                    DimensionMemberFilterMember filter = new DimensionMemberFilterMember();
                    filter.setDimensionNumber(this.dimension.getNumber());
                    this.memberFilter.addMemberFilter(this.sheetName, filter);
                }
                this.getCurrentFilterMember().setSelectAll(false);
                this.getCurrentFilterMember().getMembers().add(((BgDimensionMember)defaultKingdeeTreeNode.getUserObject()).getNumber());
                isAllUnSelected = false;
            }
            if (isAllUnSelected && this.getCurrentFilterMember() != null && this.getCurrentFilterMember().getMembers() == null) {
                this.getCurrentFilterMember().setSelectAll(false);
            }
            this.getCurrentFilterMember().setSelectType(this.getSelectRdoMembers());
        }
        this.getCurrentFilterMember().setOnlyShowName(this.isOnlyShowName());
        this.filterButton.setPopupVisible(false);
        if (this.isModify()) {
            this.oldFilterMember = this.clone(this.getCurrentFilterMember());
            this.filterButton.refershSheet();
        }
    }

    private Set<DefaultKingdeeTreeNode> getRNodes(DefaultKingdeeTreeNode node, Set<DefaultKingdeeTreeNode> set, Boolean includeChild) {
        if (!this.isAllNode(node) && !node.isRoot()) {
            set.add(node);
        }
        if (includeChild.booleanValue()) {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode childAt = (DefaultKingdeeTreeNode)node.getChildAt(i);
                if (this.isAllNode(childAt)) continue;
                set.add(childAt);
                this.getRNodes(childAt, set, true);
            }
        }
        return set;
    }

    private Set<DefaultKingdeeTreeNode> getRAllNodes(DefaultKingdeeTreeNode node, Set<DefaultKingdeeTreeNode> set) {
        if (!this.isAllNode(node) && !node.isRoot()) {
            set.add(node);
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode childAt = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (!this.isAllNode(childAt)) {
                set.add(childAt);
                this.getRNodes(childAt, set, true);
                continue;
            }
            set.add(childAt);
        }
        return set;
    }

    protected boolean isModify() {
        DimensionMemberFilterMember filter = this.getCurrentFilterMember();
        if (this.oldFilterMember == filter) {
            return false;
        }
        boolean isSelectAll = DimensionMemberFilterMember.isSelectAll(filter);
        if (isSelectAll) {
            return !DimensionMemberFilterMember.isSelectAll(this.oldFilterMember);
        }
        if (DimensionMemberFilterMember.isSelectAll(this.oldFilterMember)) {
            return true;
        }
        return !filter.getMembers().equals(this.oldFilterMember.getMembers());
    }

    protected void treeMain_nodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode currNode = (DefaultKingdeeTreeNode)event.getNode();
        boolean isAllNode = this.isAllNode(currNode);
        HashSet<DefaultKingdeeTreeNode> set = new HashSet<DefaultKingdeeTreeNode>();
        Set<DefaultKingdeeTreeNode> nodesSet = this.getRNodes(this.root, set, true);
        boolean checked = currNode.isChecked();
        if (isAllNode) {
            for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
                defaultKingdeeTreeNode.setChecked(checked);
            }
        } else {
            HashSet<DefaultKingdeeTreeNode> set1 = new HashSet<DefaultKingdeeTreeNode>();
            Set<DefaultKingdeeTreeNode> nodesSet1 = this.getRNodes(currNode, set1, false);
            for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet1) {
                defaultKingdeeTreeNode.setChecked(checked);
            }
        }
        DefaultKingdeeTreeNode multNode = (DefaultKingdeeTreeNode)this.root.getChildAt(0);
        if (!checked) {
            multNode.setChecked(false);
        } else {
            boolean flag = true;
            for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
                if (defaultKingdeeTreeNode.isChecked()) continue;
                flag = false;
                break;
            }
            multNode.setChecked(flag);
        }
        this.treeMain.updateUI();
    }

    protected boolean isAllNode(DefaultKingdeeTreeNode node) {
        return !(node.getUserObject() instanceof BgDimensionMember);
    }

    @Override
    protected void chbShowType_itemStateChanged(ItemEvent e) throws Exception {
        super.chbShowType_itemStateChanged(e);
        BgDimensionMember member = null;
        HashSet<DefaultKingdeeTreeNode> set = new HashSet<DefaultKingdeeTreeNode>();
        Set<DefaultKingdeeTreeNode> nodesSet = this.getRNodes(this.root, set, true);
        for (DefaultKingdeeTreeNode node : nodesSet) {
            if (node == null || !(node.getUserObject() instanceof BgDimensionMember)) continue;
            member = (BgDimensionMember)node.getUserObject();
            if (this.isOnlyShowName()) {
                node.setText(member.getName());
                continue;
            }
            node.setText(member.toString());
        }
        this.treeMain.updateUI();
    }

    protected boolean isOnlyShowName() {
        return !this.chbShowType.isSelected();
    }

    @Override
    protected void rdoAllMembers_stateChanged(ChangeEvent e) throws Exception {
        super.rdoAllMembers_stateChanged(e);
        if (this.isDesc) {
            return;
        }
        this.rdoMemberSelect(this.getSearchNumbers().isEmpty() ? null : this.getSearchNumbers(), true, false, 0);
    }

    @Override
    protected void rdoLeafMembers_stateChanged(ChangeEvent e) throws Exception {
        super.rdoLeafMembers_stateChanged(e);
        if (this.isDesc) {
            return;
        }
        this.rdoMemberSelect(null, true, false, 1);
    }

    @Override
    protected void rdoUnLeafMembers_stateChanged(ChangeEvent e) throws Exception {
        super.rdoUnLeafMembers_stateChanged(e);
        if (this.isDesc) {
            return;
        }
        this.rdoMemberSelect(null, true, false, 2);
    }

    protected void rdoMemberSelect(Set<String> selectMembers, boolean isUpdateUI, boolean isSearch, int selectType) {
        HashSet<DefaultKingdeeTreeNode> set = new HashSet<DefaultKingdeeTreeNode>();
        BgDimensionMember member = null;
        Set<DefaultKingdeeTreeNode> nodesSet = this.getRAllNodes(this.root, set);
        if (selectType == 0 && this.rdoAllMembers.isSelected()) {
            if (isSearch) {
                this.getCurrentFilterMember().setSelectType(0);
            }
            this.root.setChecked(true);
            for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
                if (this.isAllNode(defaultKingdeeTreeNode)) {
                    if (!isSearch && this.getSearchNumbers().isEmpty()) {
                        defaultKingdeeTreeNode.setChecked(true);
                        continue;
                    }
                    defaultKingdeeTreeNode.setChecked(false);
                    continue;
                }
                member = (BgDimensionMember)defaultKingdeeTreeNode.getUserObject();
                if (selectMembers == null) {
                    defaultKingdeeTreeNode.setChecked(true);
                    continue;
                }
                if (selectMembers.isEmpty()) continue;
                if (selectMembers.contains(member.getNumber())) {
                    defaultKingdeeTreeNode.setChecked(true);
                    continue;
                }
                defaultKingdeeTreeNode.setChecked(false);
            }
            if (!isSearch && this.getSearchNumbers().isEmpty()) {
                this.checkSelectAll();
            }
            if (isUpdateUI) {
                this.treeMain.updateUI();
            }
        } else if (selectType == 1 && this.rdoLeafMembers.isSelected()) {
            if (isSearch) {
                this.getCurrentFilterMember().setSelectType(1);
            }
            for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
                if (defaultKingdeeTreeNode.getUserObject() instanceof BgDimensionMember) {
                    member = (BgDimensionMember)defaultKingdeeTreeNode.getUserObject();
                    if (selectMembers == null) {
                        if (member.isLeaf()) {
                            defaultKingdeeTreeNode.setChecked(true);
                            continue;
                        }
                        defaultKingdeeTreeNode.setChecked(false);
                        continue;
                    }
                    if (selectMembers.isEmpty()) continue;
                    if (selectMembers.contains(member.getNumber())) {
                        if (member.isLeaf()) {
                            defaultKingdeeTreeNode.setChecked(true);
                            continue;
                        }
                        defaultKingdeeTreeNode.setChecked(false);
                        continue;
                    }
                    defaultKingdeeTreeNode.setChecked(false);
                    continue;
                }
                if (!this.isAllNode(defaultKingdeeTreeNode)) continue;
                defaultKingdeeTreeNode.setChecked(false);
            }
            if (isUpdateUI) {
                this.treeMain.updateUI();
            }
        } else if (selectType == 2 && this.rdoUnLeafMembers.isSelected()) {
            if (isSearch) {
                this.getCurrentFilterMember().setSelectType(2);
            }
            for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
                if (defaultKingdeeTreeNode.getUserObject() instanceof BgDimensionMember) {
                    member = (BgDimensionMember)defaultKingdeeTreeNode.getUserObject();
                    if (selectMembers == null) {
                        if (!member.isLeaf()) {
                            defaultKingdeeTreeNode.setChecked(true);
                            continue;
                        }
                        defaultKingdeeTreeNode.setChecked(false);
                        continue;
                    }
                    if (selectMembers.isEmpty()) continue;
                    if (selectMembers.contains(member.getNumber())) {
                        if (!member.isLeaf()) {
                            defaultKingdeeTreeNode.setChecked(true);
                            continue;
                        }
                        defaultKingdeeTreeNode.setChecked(false);
                        continue;
                    }
                    defaultKingdeeTreeNode.setChecked(false);
                    continue;
                }
                if (!this.isAllNode(defaultKingdeeTreeNode)) continue;
                defaultKingdeeTreeNode.setChecked(false);
            }
            if (isUpdateUI) {
                this.treeMain.updateUI();
            }
        }
    }

    protected void checkSelectAll() {
        DefaultKingdeeTreeNode multNode = (DefaultKingdeeTreeNode)this.root.getChildAt(0);
        boolean flag = true;
        HashSet<DefaultKingdeeTreeNode> set1 = new HashSet<DefaultKingdeeTreeNode>();
        Set<DefaultKingdeeTreeNode> nodesSet1 = this.getRNodes(this.root, set1, true);
        for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet1) {
            if (defaultKingdeeTreeNode.isChecked()) continue;
            flag = false;
            break;
        }
        multNode.setChecked(flag);
    }

    protected void initListener() {
        super.initListener();
        this.iniPoppMenu();
    }

    public DimensionMemberAutoFilterButton getAutoFilterButton() {
        return this.autoFilterButton;
    }

    public void setAutoFilterButton(DimensionMemberAutoFilterButton autoFilterButton) {
        this.autoFilterButton = autoFilterButton;
    }

    protected void setAutoFilterButton() {
        if (this.getAutoFilterButton() != null) {
            this.isFilterUIColse = true;
        }
    }

    public JPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void TreePopupMenu(MouseEvent e) {
        System.out.println("TreePopupMenuListener show");
        this.isFilterUIColse = false;
        this.getPopMenu().show((Component)this.treeMain, e.getX(), e.getY());
    }

    protected void iniPoppMenu() {
        this.treeMain.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menuItem = new KDMenuItem();
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"allSub"));
        menuItem.addActionListener((ActionListener)new AllSubMembersListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"selectSub"));
        menuItem.addActionListener((ActionListener)new SubMembersListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"allLevelParent"));
        menuItem.addActionListener((ActionListener)new LevelParentListener());
        this.getPopMenu().add((JMenuItem)menuItem);
        menuItem = new KDMenuItem();
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensioMemberAutoFilterResource", (String)"allLevel"));
        menuItem.addActionListener((ActionListener)new AllLevelListener());
        this.getPopMenu().add((JMenuItem)menuItem);
    }

    protected void popMemberSelect(int selectType) {
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (selectedNode == null || selectedNode.getUserObject() == null) {
            return;
        }
        if (selectType == 0) {
            this.selectMember(selectedNode, true);
        } else if (selectType == 1) {
            this.selectDirectMember(selectedNode, true);
        } else if (selectType == 2) {
            this.selectBrotherMember(selectedNode, true);
        } else if (selectType == 3) {
            this.selectLevelMember(selectedNode, true);
        }
        this.treeMain.updateUI();
    }

    protected void selectMember(DefaultKingdeeTreeNode selectedNode, boolean selected) {
        if (selectedNode == null) {
            return;
        }
        selectedNode.setChecked(selected);
        if (this.isAllNode(selectedNode)) {
            selectedNode = this.root;
        }
        DefaultKingdeeTreeNode node = null;
        int count = selectedNode.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)selectedNode.getChildAt(index);
            node.setChecked(selected);
            if (node == null || node.isLeaf()) continue;
            this.selectMember(node, selected);
        }
    }

    public void selectDirectMember(DefaultKingdeeTreeNode selectedNode, boolean selected) {
        if (selectedNode == null) {
            return;
        }
        selectedNode.setChecked(selected);
        if (this.isAllNode(selectedNode)) {
            selectedNode = this.root;
        }
        DefaultKingdeeTreeNode node = null;
        int count = selectedNode.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)selectedNode.getChildAt(index);
            node.setChecked(selected);
        }
    }

    public void selectBrotherMember(DefaultKingdeeTreeNode selectedNode, boolean selected) {
        if (selectedNode == null || selectedNode.getUserObject() == null) {
            return;
        }
        selectedNode.setChecked(selected);
        BgDimensionMember selectMember = (BgDimensionMember)selectedNode.getUserObject();
        HashSet<DefaultKingdeeTreeNode> set = new HashSet<DefaultKingdeeTreeNode>();
        Set<DefaultKingdeeTreeNode> nodesSet = this.getRNodes(this.root, set, true);
        BgDimensionMember member = null;
        for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
            if (!(defaultKingdeeTreeNode.getUserObject() instanceof BgDimensionMember)) continue;
            member = (BgDimensionMember)defaultKingdeeTreeNode.getUserObject();
            if (!this.getParentLongNumber(selectMember).equals(this.getParentLongNumber(member))) continue;
            defaultKingdeeTreeNode.setChecked(true);
        }
    }

    protected void selectLevelMember(DefaultKingdeeTreeNode selectedNode, boolean selected) {
        if (selectedNode == null || selectedNode.getUserObject() == null) {
            return;
        }
        selectedNode.setChecked(selected);
        BgDimensionMember selectMember = (BgDimensionMember)selectedNode.getUserObject();
        HashSet<DefaultKingdeeTreeNode> set = new HashSet<DefaultKingdeeTreeNode>();
        Set<DefaultKingdeeTreeNode> nodesSet = this.getRNodes(this.root, set, true);
        BgDimensionMember member = null;
        for (DefaultKingdeeTreeNode defaultKingdeeTreeNode : nodesSet) {
            if (!(defaultKingdeeTreeNode.getUserObject() instanceof BgDimensionMember)) continue;
            member = (BgDimensionMember)defaultKingdeeTreeNode.getUserObject();
            if (this.getMemberLevel(selectMember) != this.getMemberLevel(member)) continue;
            defaultKingdeeTreeNode.setChecked(true);
        }
    }

    protected int getMemberLevel(BgDimensionMember selectMember) {
        String sortValue = null;
        sortValue = this.dimension != null && this.dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) && this.getPeriodCacheMap(selectMember).containsKey(selectMember.getNumber()) ? this.getPeriodCacheMap(selectMember).get(selectMember.getNumber()).getLongNumber() : (String)((Object)selectMember.getSortValue());
        if (sortValue.indexOf("!") > 0) {
            return sortValue.split("!").length;
        }
        return 0;
    }

    protected String getParentLongNumber(BgDimensionMember selectMember) {
        String parentLongNumber = "";
        String sortValue = null;
        sortValue = this.dimension != null && this.dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) && this.getPeriodCacheMap(selectMember).containsKey(selectMember.getNumber()) ? this.getPeriodCacheMap(selectMember).get(selectMember.getNumber()).getLongNumber() : (String)((Object)selectMember.getSortValue());
        if (sortValue.indexOf("!") > 0) {
            parentLongNumber = sortValue.substring(0, sortValue.lastIndexOf("!"));
        }
        return parentLongNumber;
    }

    protected void selectRdoMember(int selectType, boolean fireListener) {
        if (0 == selectType) {
            if (!this.rdoAllMembers.isSelected()) {
                this.rdoAllMembers.setSelected(true, fireListener);
            }
        } else if (1 == selectType) {
            if (!this.rdoLeafMembers.isSelected()) {
                this.rdoLeafMembers.setSelected(true, fireListener);
            }
        } else if (2 == selectType && !this.rdoUnLeafMembers.isSelected()) {
            this.rdoUnLeafMembers.setSelected(true, fireListener);
        }
    }

    protected int getSelectRdoMembers() {
        if (this.rdoLeafMembers.isSelected()) {
            return 1;
        }
        if (this.rdoUnLeafMembers.isSelected()) {
            return 2;
        }
        return 0;
    }

    public Map<String, BgPeriodInfo> getPeriodCacheMap(BgDimensionMember member) {
        ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
        members.add(member);
        return this.getPeriodCacheMap(members);
    }

    public Map<String, BgPeriodInfo> getPeriodCacheMap(List<BgDimensionMember> members) {
        if (members == null || members.isEmpty() || !this.dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
            return this.periodCacheMap;
        }
        HashSet<String> numbers = new HashSet<String>();
        for (BgDimensionMember member : members) {
            if (this.periodCacheMap.containsKey(member.getNumber())) continue;
            numbers.add(member.getNumber());
        }
        if (!numbers.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("longNumber");
            sic.add("name");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            view.setFilter(filter);
            try {
                BgPeriodCollection colls = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(view);
                if (colls != null && !colls.isEmpty()) {
                    for (int i = 0; i < colls.size(); ++i) {
                        this.periodCacheMap.put(colls.get(i).getNumber(), colls.get(i));
                    }
                }
            }
            catch (BOSException ex) {
                logger.error((Object)"getPeriodCacheMap error:", (Throwable)ex);
            }
        }
        return this.periodCacheMap;
    }

    public boolean isExistsNullCell() {
        return this.isExistsNullCell;
    }

    public void setExistsNullCell(boolean isExistsNullCell) {
        this.isExistsNullCell = isExistsNullCell;
    }

    class AllLevelListener
    implements ActionListener {
        AllLevelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DimensionMemberFilterUI.this.popMemberSelect(3);
        }
    }

    class LevelParentListener
    implements ActionListener {
        LevelParentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DimensionMemberFilterUI.this.popMemberSelect(2);
        }
    }

    class SubMembersListener
    implements ActionListener {
        SubMembersListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DimensionMemberFilterUI.this.popMemberSelect(1);
        }
    }

    class AllSubMembersListener
    implements ActionListener {
        AllSubMembersListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DimensionMemberFilterUI.this.popMemberSelect(0);
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                DimensionMemberFilterUI.this.TreePopupMenu(e);
            }
        }
    }
}

