/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.DefaultTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.client.AbstractDimensionMemberFormulaUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionMemberFormulaUI
extends AbstractDimensionMemberFormulaUI
implements FocusListener,
IGetSchemeHelper {
    private static final long serialVersionUID = -7591011631584436784L;
    private static final Logger logger = CoreUIObject.getLogger(DimensionMemberFormulaUI.class);
    private String formula = "";
    public static final String CURRENTBGPERIODNUMBER = "currentBgPeiodNumber";
    public static final String FILTERVALUEMAP = "filterValueMap";
    private Map<String, Set<String>> filterValueMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
        BgSchemeDimensionHelper schemeHelper = this.getSchemeHelper();
        String orgUnitId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        String unionGroupId = (String)this.getUIContext().get(BgBaseConstants.UNIONGROUP_ID);
        if (this.getUIContext().get(FILTERVALUEMAP) != null) {
            this.filterValueMap = (Map)this.getUIContext().get(FILTERVALUEMAP);
        }
        NewDimensionMemberSelectDialog boxProject = null;
        boxProject = unionGroupId == null ? new NewDimensionMemberSelectDialog((Component)((Object)this), null, (DimensionInfo)null, orgUnitId, false, true) : new NewDimensionMemberSelectDialog((Component)((Object)this), null, null, orgUnitId, false, true, unionGroupId);
        if (schemeHelper != null) {
            boxProject.setBgSchemeId(schemeHelper.getBgSchemeId());
        }
        boxProject.setOnlySelectItem(true);
        if (this.filterValueMap != null) {
            boxProject.setFilterValueMap(this.filterValueMap);
        }
        this.budgetProject.setSelector((KDPromptSelector)boxProject);
        this.budgetProject.getEditor().addFocusListener(this);
        this.budgetProject.setEditable(false);
        BgPeriodDialog boxPeriod = new BgPeriodDialog((CoreUIObject)this);
        this.budgetPeriod.setSelector((KDPromptSelector)boxPeriod);
        this.budgetPeriod.getEditor().addFocusListener(this);
        if (schemeHelper != null) {
            boxPeriod.setBgPeriodTypeNumbers(schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
            boxPeriod.setBgSchemeID(schemeHelper.getBgSchemeId());
        }
        this.budgetPeriod.setEditable(false);
        this.budgetElement.setQueryInfo("com.kingdee.eas.ma.base.BgElementQuery");
        this.budgetElement.setDisplayFormat("$name$");
        this.budgetElement.setCommitFormat("$number$");
        this.budgetElement.setEditFormat("$number$");
        this.budgetElement.getEditor().addFocusListener(this);
        DimensionMemberSelectHelper.addIdFilter(this.budgetElement, DimensionConstants.DEF_ELEMENT_NUMBER, this.getSchemeHelper());
        this.budgetElement.setEditable(false);
        this.promptScenario.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        this.promptScenario.setDisplayFormat("$name$");
        this.promptScenario.setCommitFormat("$number$");
        this.promptScenario.setEditFormat("$number$");
        this.promptScenario.getEditor().addFocusListener(this);
        DimensionMemberSelectHelper.addIdFilter(this.promptScenario, DimensionConstants.DEF_SCENARIO_NUMBER, this.getSchemeHelper());
        this.promptScenario.setEditable(false);
        this.budgetCurrency.getEditor().addFocusListener(this);
        DimensionMemberSelectHelper.addIdFilter(this.budgetCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, this.getSchemeHelper());
        this.budgetCurrency.setEditable(false);
    }

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        return (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.formula = "";
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        String bgProject = "";
        if (this.budgetProject.getData() instanceof BgDimensionMember) {
            bgProject = ((BgDimensionMember)this.budgetProject.getData()).getCombNumber();
        }
        String bgPeriod = this.budgetPeriod.getText();
        String bgElmt = "";
        Object data = this.budgetElement.getData();
        if (data != null && data instanceof BgElementInfo) {
            bgElmt = ((BgElementInfo)data).getNumber();
        }
        String bgScenario = "";
        Object data2 = this.promptScenario.getData();
        if (data2 != null && data2 instanceof BgScenarioInfo) {
            bgScenario = ((BgScenarioInfo)data2).getNumber();
        }
        String bgCurrency = this.budgetCurrency.getText();
        if (this.getUIContext().get("Owner") != null && this.getUIContext().get(CURRENTBGPERIODNUMBER) != null && this.getUIContext().get(CURRENTBGPERIODNUMBER) instanceof String) {
            String currentBgPeriodNumber = (String)this.getUIContext().get(CURRENTBGPERIODNUMBER);
            boolean isRelativeBgPeriod = false;
            int relativeValue = 0;
            try {
                relativeValue = Integer.parseInt(bgPeriod);
                isRelativeBgPeriod = true;
            }
            catch (NumberFormatException e1) {
                isRelativeBgPeriod = false;
            }
            if (isRelativeBgPeriod && Math.abs(relativeValue) > 100) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"257_BgFormProcessUI"));
                return;
            }
            if (isRelativeBgPeriod) {
                try {
                    bgPeriod = BgHelper.getRelativeBgPeriod(null, currentBgPeriodNumber, relativeValue);
                }
                catch (Exception e1) {
                    MsgBox.showWarning((Component)((Object)this), (String)e1.getMessage());
                    return;
                }
            }
        }
        String[] param = new String[]{bgProject, bgPeriod, bgElmt, bgScenario, bgCurrency};
        this.formula = this.constructFormula(param);
        this.getUIWindow().close();
    }

    private String constructFormula(String[] array) {
        String formula = "=BgItem(\"" + array[0] + "\",\"" + array[1] + "\",\"" + array[2] + "\",\"" + array[3] + "\",true,\"" + array[4] + "\")";
        return formula;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object comp = e.getSource();
        if (comp == null || !(comp instanceof DefaultTextField)) {
            return;
        }
        String parentCompName = ((DefaultTextField)comp).getParent().getName();
        if (parentCompName.equals("budgetProject")) {
            this.txtDescription.setText(this.kDLabelContainer1.getBoundLabelText());
        } else if (parentCompName.equals("budgetPeriod")) {
            this.txtDescription.setText(this.kDLabelContainer2.getBoundLabelText());
        } else if (parentCompName.equals("budgetElement")) {
            this.txtDescription.setText(this.kDLabelContainer3.getBoundLabelText());
        } else if (parentCompName.equals("budgetCurrency")) {
            this.txtDescription.setText(this.kDLabelContainer4.getBoundLabelText());
        } else if (parentCompName.equals("promptScenario")) {
            this.txtDescription.setText(this.kDLabelContainer5.getBoundLabelText());
        } else {
            this.txtDescription.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

