/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.fi.rpt.TableToolKitForAPIFactory;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgDetailMemberEnum;
import com.kingdee.eas.ma.mbg.IMbgFunction;
import com.kingdee.eas.ma.mbg.client.AbstractFunctionWizardUI;
import com.kingdee.eas.ma.mbg.client.BgBizPeriodF7UI;
import com.kingdee.eas.ma.mbg.client.FunctionSelectF7UI;
import com.kingdee.eas.ma.mbg.client.MbgWidgetGenerator;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.function.dataType.IMbgFunctionDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunction;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionComp;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionEnumDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionF7DataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionParamter;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionSpinnerDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionTextFieldDataType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class FunctionWizardUI
extends AbstractFunctionWizardUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(FunctionWizardUI.class);
    protected Map paramComponents = new HashMap(5);
    private IMbgFunction function;
    private String functionName;
    private ArrayList txtPrarms;
    private String bgSchemeId;
    protected CoreUI owner;
    private int checkIsEmptyType = 1;

    public FunctionWizardUI() throws Exception {
        HelpUtils.addCSHelpforBtn((JButton)this.btnHelp);
    }

    public void open(String functionName) {
        this.loadFunction(functionName);
        this.onOpen();
        this.showWizard();
    }

    protected void onOpen() {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setDimension();
    }

    public CoreUI getOwner() {
        return this.owner;
    }

    public void setOwner(CoreUI owner) {
        this.owner = owner;
    }

    protected int loadFunction(String name) {
        this.getFunction(name);
        Collection<MbgFunctionParamter> params = ((MbgFunction)this.function).getFunctionParams();
        int num = params.size();
        this.initContentPanel(num);
        boolean isOk = this.putParams(params);
        this.pnlTop.setBorder((Border)BorderFactory.createTitledBorder(""));
        String desc = ((MbgFunction)this.function).getLocalDescription();
        this.txtDescription.setText(desc);
        String ln = this.function.getFunctionTitle().get(MbgFunction.getCurrentLocale()).toString();
        this.setUITitle(ln);
        return -1;
    }

    private Component initContentPanel(int paramNum) {
        this.txtPrarms = new ArrayList(paramNum);
        Dimension dm = this.pnlTop.getPreferredSize();
        dm.height = paramNum * 23 + 20;
        dm.width -= 20;
        JPanel pa = new JPanel();
        pa.setPreferredSize(dm);
        pa.setSize(dm);
        pa.setLayout(null);
        return this.pnlTop.getViewport().add(pa);
    }

    private boolean getFunction(String name) {
        MbgFunctionComp comp = MbgFunctionComp.getInstance();
        try {
            if (!comp.isLoaded()) {
                comp.load();
            }
            this.function = comp.getFunction(name);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return this.function != null;
    }

    private void showWizard() {
        IUIWindow w = this.uiWindow;
        if (this.functionName != null) {
            KDDialog kDDialog = (KDDialog)w;
        }
        this.onShow();
    }

    public void onShow() {
        TableToolKitForAPIFactory.getInstance().setEscAction((CoreUIObject)this, (Action)((Object)this.actionFinish));
    }

    protected boolean putParams(Collection params) {
        boolean id = false;
        for (MbgFunctionParamter p : params) {
            if (this.putParam(p)) continue;
            return false;
        }
        return true;
    }

    protected boolean putParam(MbgFunctionParamter p) {
        String n = p.getLocalName();
        String dataType = p.getParamType();
        JPanel panel = (JPanel)this.pnlTop.getViewport().getComponent(0);
        this.addNameLabel(panel, p);
        this.addDynamicWidget(panel, p);
        this.txtPrarms.add(panel);
        return true;
    }

    private void addDynamicWidget(JPanel panel, MbgFunctionParamter p) {
        String dataType = p.getParamType();
        IMbgFunctionDataType mainType = this.getWidgetType(dataType);
        MbgWidgetGenerator generator = new MbgWidgetGenerator();
        JComponent newWidget = generator.getController(mainType);
        this.paramComponents.put(p.getParamName(), newWidget);
        if (mainType instanceof MbgFunctionF7DataType) {
            KDBizPromptBox prompt = (KDBizPromptBox)newWidget;
            prompt.setBounds(new Rectangle(140, this.txtPrarms.size() * 23 + 10, panel.getPreferredSize().width - 148, 20));
            prompt.setDirty(false);
            panel.add(newWidget);
        } else if (mainType instanceof MbgFunctionEnumDataType) {
            KDComboBox combox = (KDComboBox)newWidget;
            combox.setEditable(false);
            combox.setBounds(new Rectangle(140, this.txtPrarms.size() * 23 + 10, panel.getPreferredSize().width - 148, 20));
        } else {
            if (mainType instanceof MbgFunctionTextFieldDataType) {
                KDTextField fld = (KDTextField)newWidget;
                fld.setAutoscrolls(false);
                fld.setDocument((Document)new PlainDocument());
                fld.setPreferredSize(new Dimension(120, 20));
                fld.setBounds(new Rectangle(140, this.txtPrarms.size() * 23 + 10, panel.getPreferredSize().width - 148, 20));
                fld.setDirty(false);
                if (p.getComments() != null) {
                    fld.setText(p.getComments().get(MbgFunction.getCurrentLocale()).toString());
                }
                fld.setEnabled(((MbgFunctionTextFieldDataType)mainType).isEnable());
                fld.setEditable(((MbgFunctionTextFieldDataType)mainType).isRequired());
                fld.setRequired(((MbgFunctionTextFieldDataType)mainType).isRequired());
                if (p.getComments() != null) {
                    fld.setName(p.getLocalComments());
                }
                panel.add((Component)fld);
                return;
            }
            if (mainType instanceof MbgFunctionSpinnerDataType) {
                KDSpinner spinner = (KDSpinner)newWidget;
                spinner.setAutoscrolls(false);
                spinner.setPreferredSize(new Dimension(120, 20));
                spinner.setBounds(new Rectangle(140, this.txtPrarms.size() * 23 + 10, panel.getPreferredSize().width - 148, 20));
                spinner.setEnabled(((MbgFunctionSpinnerDataType)mainType).isEnable());
                spinner.setEditable(((MbgFunctionSpinnerDataType)mainType).isRequired());
                spinner.setRequired(((MbgFunctionSpinnerDataType)mainType).isRequired());
                if (p.getComments() != null) {
                    spinner.setName(p.getLocalComments());
                }
                panel.add((Component)spinner);
                return;
            }
        }
        panel.add(newWidget);
    }

    private IMbgFunctionDataType getWidgetType(String dataType) {
        List<IMbgFunctionDataType> dataTypeList = ((MbgFunction)this.function).getFunctionDataTypes();
        HashMap<String, IMbgFunctionDataType> nameTypeMap = new HashMap<String, IMbgFunctionDataType>(){};
        for (int i = 0; i < dataTypeList.size(); ++i) {
            nameTypeMap.put(dataTypeList.get(i).getName(), dataTypeList.get(i));
        }
        return (IMbgFunctionDataType)nameTypeMap.get(dataType);
    }

    private void addNameLabel(JPanel panel, MbgFunctionParamter p) {
        KDLabel lbl = new KDLabel();
        lbl.setText(p.getLocalName());
        lbl.setUnderline(true);
        lbl.setVerticalAlignment(3);
        lbl.setPreferredSize(new Dimension(120, 20));
        lbl.setBounds(new Rectangle(10, this.txtPrarms.size() * 23 + 10, 130, 20));
        panel.add((Component)lbl);
    }

    private boolean setDimension() {
        Dimension dm = new Dimension(this.pnlTop.getViewport().getComponent(0).getPreferredSize());
        dm.height = this.pnlBottom.getPreferredSize().height + dm.height + 40;
        dm.width = this.pnlBottom.getPreferredSize().width + 6;
        this.setPreferredSize(dm);
        return true;
    }

    public Object getParamComponent(String paramName) {
        if (paramName == null) {
            return null;
        }
        if (this.paramComponents.get(paramName) == null) {
            return null;
        }
        return this.paramComponents.get(paramName);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkDimMemberSelected();
        super.btnConfirm_actionPerformed(e);
    }

    protected boolean IsOpenByExist() {
        return this.getUIContext().get("isOpenByExist") != null;
    }

    protected int getCheckEmptyType() {
        return this.checkIsEmptyType;
    }

    protected void checkDimMemberSelected() {
        KDTextField textField;
        if (this.getCheckEmptyType() == 1) {
            KDBizPromptBox dimMember = (KDBizPromptBox)this.getParamComponent("dimensionMember");
            if (dimMember == null || dimMember.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFunctionResource", (String)"mustChooseDimMem"));
                SysUtil.abort();
            }
        } else if (this.getCheckEmptyType() == 2) {
            KDBizPromptBox dimMultiMember = (KDBizPromptBox)this.getParamComponent("dimensionMultiMember");
            if (dimMultiMember == null || dimMultiMember.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFunctionResource", (String)"mustChooseDimMem"));
                SysUtil.abort();
            }
        } else if (this.getCheckEmptyType() == 3 && ((textField = (KDTextField)this.getParamComponent("textField")) == null || StringUtils.isEmpty((String)textField.getText()))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFunctionResource", (String)"mustChooseExpr"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        super.btnCancel_actionPerformed(e);
    }

    protected void checkMemberRepeat(String curMem) {
        if (StringUtils.isEmpty((String)curMem)) {
            return;
        }
        if (this.getOwner() instanceof FunctionSelectF7UI && ((FunctionSelectF7UI)this.getOwner()).checkFunctionRepeat(curMem)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFunctionResource", (String)"repeatFunAndParam"));
            SysUtil.abort();
        }
    }

    protected BgDimensionMember getCurBgDimensionMember() {
        KDBizPromptBox dimMember = (KDBizPromptBox)this.getParamComponent("dimensionMember");
        BgDimensionMember resultMember = null;
        List memberList = null;
        Object dimObj = dimMember.getValue();
        if (dimObj instanceof List) {
            memberList = (List)dimObj;
            if (memberList.size() == 1) {
                resultMember = (BgDimensionMember)memberList.get(0);
            }
        } else if (dimMember.getValue() instanceof BgDimensionMember) {
            resultMember = (BgDimensionMember)dimObj;
        }
        return resultMember;
    }

    protected BgDimensionMember getCurBgDimensionMember(String memberKey) {
        if (StringUtils.isEmpty((String)memberKey)) {
            return null;
        }
        KDBizPromptBox dimMember = (KDBizPromptBox)this.getParamComponent(memberKey);
        BgDimensionMember resultMember = null;
        List memberList = null;
        Object dimObj = dimMember.getValue();
        if (dimObj instanceof List) {
            memberList = (List)dimObj;
            if (memberList.size() == 1) {
                resultMember = (BgDimensionMember)memberList.get(0);
            }
        } else if (dimMember.getValue() instanceof BgDimensionMember) {
            resultMember = (BgDimensionMember)dimObj;
        }
        return resultMember;
    }

    protected MbgViewListResultData getCurBgDimensionMembers(String memberKey) {
        if (StringUtils.isEmpty((String)memberKey)) {
            return null;
        }
        KDBizPromptBox dimMember = (KDBizPromptBox)this.getParamComponent(memberKey);
        MbgViewListResultData resultList = null;
        Object dimObj = dimMember.getValue();
        if (dimObj instanceof MbgViewListResultData) {
            resultList = (MbgViewListResultData)dimMember.getValue();
        }
        return resultList;
    }

    protected String getCurDetailMember() {
        KDComboBox detailMember = (KDComboBox)this.getParamComponent("DetailMember");
        String detailEnum = null;
        detailEnum = detailMember.getSelectedItem() == null || BgDetailMemberEnum.all.equals(detailMember.getSelectedItem()) ? "" : ((BgDetailMemberEnum)((Object)detailMember.getSelectedItem())).getValue();
        return detailEnum;
    }

    protected void dealFunction(Map<String, BgDimensionMember> resultFunction) {
        if (this.getOwner() instanceof BgBizPeriodF7UI) {
            ((BgBizPeriodF7UI)this.getOwner()).addFunction(resultFunction);
        } else if (this.getOwner() instanceof FunctionSelectF7UI) {
            ((FunctionSelectF7UI)this.getOwner()).addFunction(resultFunction);
        }
    }
}

