/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.IMBGViewListFormFacade;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMBGViewListFormAddNewUI;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MBGViewListFormAddNewUI
extends AbstractMBGViewListFormAddNewUI {
    private static final long serialVersionUID = -8296416553657266639L;
    private static final Logger logger = CoreUIObject.getLogger(MBGViewListFormAddNewUI.class);
    private Map bgViewDimensionColMap = new HashMap();
    private static final int currYear = new CalendarHelper().getCurrentlyYear();
    private boolean hasOldBgForm = false;
    private static final Map<Integer, int[]> parentBgPeriodEnums = new HashMap<Integer, int[]>();

    @Override
    protected void beforeLoad() throws Exception {
        super.beforeLoad();
    }

    @Override
    public void onLoad() throws Exception {
        this.prmtBatchBgTemplate.setEnabledMultiSelection(false);
        super.onLoad();
        this.afterOnLoad();
    }

    protected void afterOnLoad() throws EASBizException, BOSException {
        this.comCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    MBGViewListFormAddNewUI.this.comCurrency_itemStateChanged(e);
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                    MBGViewListFormAddNewUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
        this.setDefaultBgVersion();
    }

    protected void setDefaultBgVersion() throws EASBizException, BOSException {
        if (this.prpmtBgVersion.getData() != null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_VERSION_NUMBER, false), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"Ve", CompareType.EQUALS));
        BgVersionCollection col = BgVersionFactory.getRemoteInstance().getBgVersionCollection(evi);
        if (col != null && !col.isEmpty()) {
            this.prpmtBgVersion.setData((Object)col.get(0));
        } else {
            this.prpmtBgVersion.setData(null);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.removeMeasureUnitProperty();
    }

    private void removeMeasureUnitProperty() {
        this.editData.remove("measureunit");
    }

    @Override
    protected IObjectValue createNewData() {
        return super.createNewData();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    @Override
    protected IBgTemplate getBgTemplateInterface() throws BOSException {
        return BgTemplateFactory.getRemoteInstance();
    }

    public IObjectValue getDataObject() {
        return this.editData;
    }

    @Override
    protected boolean checkBgTemplateType(int bgTemplateFormType) {
        return 2 == bgTemplateFormType;
    }

    @Override
    protected void prmtBatchBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBatchBgTemplate_dataChanged(e);
        this.checkBgForm();
        this.dealPrmtBgPeriodAndBgVersion();
        this.setCurrencyUnit();
    }

    @Override
    protected void prmtBatchBgTemplate_willShow(SelectorEvent e) throws Exception {
        super.prmtBatchBgTemplate_willShow(e);
        this.initTemplateFormBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
    }

    protected void setCurrencyUnit() throws Exception {
        BgTemplateInfo bgTemplate = (BgTemplateInfo)this.prmtBatchBgTemplate.getValue();
        if (bgTemplate != null) {
            TemplateStyleInfo templateStyleInfo = null;
            if (bgTemplate.getStyleSet() != null && bgTemplate.getStyleSet().getData() != null) {
                templateStyleInfo = MbgXMLParser.parseStyle(bgTemplate.getStyleSet().getData());
            } else {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("styleSet.id");
                selector.add("styleSet.number");
                selector.add("styleSet.name");
                selector.add("styleSet.data");
                bgTemplate = this.getBgTemplateInterface().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplate.getId()), selector);
                templateStyleInfo = MbgXMLParser.parseStyle(bgTemplate.getStyleSet().getData());
            }
            this.txtAmountUnit.setText(templateStyleInfo.getCurrencyUnitName());
        }
    }

    protected void dealPrmtBgPeriodAndBgVersion() {
        BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)this.prmtBatchBgTemplate.getValue();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            return;
        }
        if (bgTemplateInfo == null) {
            this.prpmtBgVersion.setEnabled(false);
            this.prmtBgPeriod.setEnabled(false);
        } else {
            this.prpmtBgVersion.setEnabled(true);
            this.prmtBgPeriod.setEnabled(true);
            HashSet<String> versionNumbers = new HashSet<String>();
            HashSet bgPeriodTypeNumbers = new HashSet();
            try {
                BgViewDimensionInfo viewDim = (BgViewDimensionInfo)this.bgViewDimensionColMap.get(bgTemplateInfo.getId().toString());
                if (viewDim == null) {
                    viewDim = BgViewDimensionFactory.getRemoteInstance().getBgViewDimensionInfo("select data where template.id = '" + bgTemplateInfo.getId() + "'");
                }
                HashSet bgPeriodNumbers = new HashSet();
                MbgViewListXMLParser parser2 = new MbgViewListXMLParser();
                MbgViewListManager view = parser2.parse(viewDim.getData());
                view = ViewListFacadeFactory.getRemoteInstance().parseMember(view, this.editData.getOrgUnit().getId().toString(), this.getSchemeHelper());
                if (view != null) {
                    List<MbgViewListDimensionInfo> dimensions = null;
                    for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                        dimensions = ((MbgViewListSheetManager)view.getSheetManagers().get(s)).getDimensionManager().getAllDimensions();
                        for (int d = 0; d < dimensions.size(); ++d) {
                            int m;
                            MbgViewListDimensionInfo dimension;
                            if (!(dimensions.get(d) instanceof MbgViewListDimensionInfo) || !DimensionConstants.DEF_VERSION_NUMBER.equals((dimension = dimensions.get(d)).getNumber())) continue;
                            if (DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) {
                                versionNumbers = null;
                            }
                            for (m = 0; m < dimension.getMember().size(); ++m) {
                                if (versionNumbers == null) continue;
                                versionNumbers.add(((BgDimensionMember)dimension.getMember().get(m)).getNumber());
                            }
                            if (!DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType())) continue;
                            if (dimension == null || dimension.getCanAddMember().isEmpty()) {
                                versionNumbers = null;
                                continue;
                            }
                            for (m = 0; m < dimension.getCanAddMember().size(); ++m) {
                                if (versionNumbers == null) continue;
                                versionNumbers.add(BgViewHelper.getNumber(dimension.getCanAddMember().get(m)));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIException(e);
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            if (versionNumbers != null) {
                if (versionNumbers.isEmpty()) {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
                } else {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", versionNumbers, CompareType.INCLUDE));
                }
            } else {
                try {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_VERSION_NUMBER, true), CompareType.INCLUDE));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
            this.prpmtBgVersion.setEntityViewInfo(evi);
            if (this.prpmtBgVersion != null && this.prpmtBgVersion.getData() != null && this.prpmtBgVersion.getData() instanceof BgVersionInfo && versionNumbers != null && !versionNumbers.contains(((BgVersionInfo)this.prpmtBgVersion.getData()).getNumber())) {
                this.prpmtBgVersion.setDataNoNotify(null);
            }
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        this.checkBgForm();
    }

    @Override
    protected void prpmtBgVersion_dataChanged(DataChangeEvent e) throws Exception {
        super.prpmtBgVersion_dataChanged(e);
        this.checkBgForm();
    }

    protected void comCurrency_itemStateChanged(ItemEvent e) throws Exception {
        this.checkBgForm();
    }

    @Override
    public BgFormInfo saveBgFormInfo(boolean isBatch) throws Exception {
        Map result = this.getMbgViewListFacade().addNewViewListFormInfo(this.editData, (String)this.getUIContext().get("BGORGVIEW_ID"), isBatch, this.getAddNewPermissionNumber());
        if (result != null) {
            String id = (String)result.remove(BgBaseConstants.ID);
            if (id != null) {
                this.editData.setId(BOSUuid.read((String)id));
            }
            if (isBatch) {
                int totalCount = (Integer)result.remove("totalCount");
                String resultKey = (String)result.remove("result");
                if (!resultKey.isEmpty()) {
                    int failCount = 0;
                    for (Object obj : result.values()) {
                        if (obj instanceof Collection) {
                            failCount += ((Collection)obj).size();
                            continue;
                        }
                        if (!(obj instanceof Map)) continue;
                        failCount += ((Map)obj).size();
                    }
                    if (failCount == 0) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"addSuccess"));
                    } else {
                        String error = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"addNewBatchFail"), totalCount, failCount);
                        String detail = this.getBatchAddNewDetail(result);
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)detail, (int)1);
                    }
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"addBathWarng"));
                }
            }
        }
        return this.editData;
    }

    private String getBatchAddNewDetail(Map result) {
        int i;
        StringBuffer detail = new StringBuffer();
        Map numRepeatOrgs = (Map)result.get("formNumRepeat");
        String numRepeatMsg = MBGViewListFormClientHelper.getString("formNumRepeat");
        Map noPerOrgs = (Map)result.get("batchAddViewOrgNoPermission");
        String noPerMsg = MBGViewListFormClientHelper.getString("batchAddViewOrgNoPermission");
        Map templateRepeatOrgs = (Map)result.get("templateRepeat");
        String templateRepeatMsg = MBGViewListFormClientHelper.getString("templateRepeat");
        Object[] orgNumbers = null;
        if (numRepeatOrgs != null && !numRepeatOrgs.isEmpty()) {
            orgNumbers = numRepeatOrgs.keySet().toArray();
            Arrays.sort(orgNumbers);
            for (i = 0; i < orgNumbers.length; ++i) {
                if (detail.length() > 0) {
                    detail.append("\r\n");
                }
                detail.append(MessageFormat.format(numRepeatMsg, ((OrgUnitInfo)numRepeatOrgs.get(orgNumbers[i])).getName(), this.editData.getNumber()));
            }
        }
        if (noPerOrgs != null && !noPerOrgs.isEmpty()) {
            orgNumbers = noPerOrgs.keySet().toArray();
            Arrays.sort(orgNumbers);
            for (i = 0; i < orgNumbers.length; ++i) {
                if (detail.length() > 0) {
                    detail.append("\r\n");
                }
                detail.append(MessageFormat.format(noPerMsg, ((OrgUnitInfo)noPerOrgs.get(orgNumbers[i])).getName()));
            }
        }
        if (templateRepeatOrgs != null && !templateRepeatOrgs.isEmpty()) {
            orgNumbers = templateRepeatOrgs.keySet().toArray();
            Arrays.sort(orgNumbers);
            for (i = 0; i < orgNumbers.length; ++i) {
                if (detail.length() > 0) {
                    detail.append("\r\n");
                }
                detail.append(MessageFormat.format(templateRepeatMsg, ((OrgUnitInfo)templateRepeatOrgs.get(orgNumbers[i])).getName(), ((CurrencyInfo)this.comCurrency.getSelectedItem()).getName(), ((BgPeriodInfo)this.prmtBgPeriod.getData()).getName(), ((BgTemplateInfo)this.prmtBatchBgTemplate.getValue()).getName(), ((BgVersionInfo)this.prpmtBgVersion.getData()).getName()));
            }
        }
        return detail.toString();
    }

    @Override
    protected void doSubmintForAddNew(ActionEvent e) throws Exception {
        this.verify(e);
        this.checkFormRepeat();
        this.submitBgFormInfo();
        this.checkNumberRepeat();
        this.openProgressUI(this.isBatch());
    }

    protected String getAddNewPermissionNumber() {
        return "mbg_form02_addNew";
    }

    @Override
    protected void checkFormRepeat() throws Exception {
        super.checkFormRepeat();
        if (!this.isBatch()) {
            this.checkExistsForm();
        }
    }

    protected void checkBgForm() throws Exception {
        if (!OprtState.ADDNEW.equals(this.getCcOprtState())) {
            return;
        }
        Object old = null;
        if (this.checkCreateName()) {
            this.storeFields();
            if (this.prpmtBgVersion.getData() != null) {
                // empty if block
            }
        }
        if (old == null) {
            if (this.hasOldBgForm) {
                this.hasOldBgForm = false;
                if (this.numberCodeHelper.isHasCodeNumber()) {
                    this.txtNumber.setEnabled(false);
                    if (this.numberCodeHelper.isHasShowCodeNumber()) {
                        this.getNumberByCodingRule((IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString());
                    }
                } else {
                    this.txtNumber.setEnabled(true);
                }
                this.txtName.setText(null);
                if (this.nameCodeHelper.isHasCodeNumber()) {
                    this.txtName.setEnabled(false);
                    if (this.nameCodeHelper.isHasShowCodeNumber()) {
                        this.storeFields();
                        this.nameCodeHelper.applyNumber(this.txtName, (IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString(), null);
                    }
                } else {
                    this.txtName.setEnabled(true);
                    this.updateBgFormName();
                }
                this.txtContent.setText(null);
            }
        } else {
            this.hasOldBgForm = true;
            if (!this.numberCodeHelper.isHasCodeNumber()) {
                this.txtNumber.setText(old.getNumber());
                this.txtNumber.setEnabled(false);
            }
            if (this.nameCodeHelper.isHasCodeNumber()) {
                this.txtName.setEnabled(false);
                if (this.nameCodeHelper.isHasShowCodeNumber()) {
                    this.storeFields();
                    this.nameCodeHelper.applyNumber(this.txtName, (IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString(), null);
                }
            } else {
                this.txtName.setText(old.getName());
                this.txtName.setEnabled(false);
            }
            this.txtContent.setText(old.getDescription());
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("BGFORM_LINK_SCHEME", this.getUIContext().get("BGFORM_LINK_SCHEME"));
            request.put("BGFORM_LINK_TEMPLATE", this.getUIContext().get("BGFORM_LINK_TEMPLATE"));
            request.put("BGFORM_LINK_PERIOD", this.getUIContext().get("BGFORM_LINK_PERIOD"));
            request.put("BGFORM_LINK_CURRENCY", this.getUIContext().get("BGFORM_LINK_CURRENCY"));
        }
        return handler;
    }

    @Override
    public boolean isPrepareDestoryWindow() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgUnit.*");
        sic.add("number");
        sic.add("bgScheme.*");
        sic.add("currency");
        sic.add("bgPeriod.*");
        sic.add("creator.*");
        sic.add("name");
        sic.add("bgTemplate.*");
        sic.add("bgType.*");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("createTime");
        sic.add("description");
        return sic;
    }

    @Override
    protected void initTitle() {
        super.initTitle();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setUITitle(MBGViewListFormClientHelper.getString("MBGViewListForm") + " - " + this.getMessageStr(this.getCcOprtState() + "_FIX"));
        }
    }

    protected IMBGViewListFormFacade getMbgViewListFacade() throws BOSException {
        return MBGViewListFormFacadeFactory.getRemoteInstance();
    }

    static {
        parentBgPeriodEnums.put(7, new int[]{5, 6, 9, 4, 3, 2, 1});
        parentBgPeriodEnums.put(5, new int[]{1});
        parentBgPeriodEnums.put(6, new int[]{4, 3, 2, 1});
        parentBgPeriodEnums.put(9, new int[]{4, 3, 2, 1});
        parentBgPeriodEnums.put(4, new int[]{3, 2, 1});
        parentBgPeriodEnums.put(3, new int[]{2, 1});
        parentBgPeriodEnums.put(2, new int[]{1});
    }
}

