/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.IVirtualAnalyseBaseFacade;
import com.kingdee.eas.ma.base.client.utils.AnalyseVirtualHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgAnalyseAdjustFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMBgAdjustAnalyseUI;
import com.kingdee.eas.ma.mbg.client.BgPastRecordViewUI;
import com.kingdee.eas.ma.mbg.client.MBgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.mbg.client.MbgAdjustAnalyseFilterUI;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.query.BaseFilterParam;
import com.kingdee.eas.ma.mbg.query.MbgAdjustAnalyseFilterParam;
import com.kingdee.eas.ma.mbg.query.MbgAdjustAnalyseMultiFilterParam;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MBgAdjustAnalyseUI
extends AbstractMBgAdjustAnalyseUI {
    private static final long serialVersionUID = -1617765996709726558L;
    private static final Logger logger = CoreUIObject.getLogger(MBgAdjustAnalyseUI.class);
    private static final String COL_id = "id";
    private static final String COL_orgUnit = "orgUnit";
    private static final String COL_indexMember = "indexMember";
    private static final String COL_refMember = "refMember";
    private static final String COL_bgScenario = "bgScenario";
    private static final String COL_bgVersion = "bgVersion";
    private static final String COL_bgPeriod = "bgPeriod";
    private static final String COL_bgPeriod_id = "bgPeriod.id";
    private static final String COL_bgElement = "bgElement";
    private static final String COL_currency = "currency";
    private static final String COL_currencyPrecision = "currencyPrecision";
    private static final String COL_oldValue = "oldValue";
    private static final String COL_adjustValue = "adjustValue";
    private static final String COL_newValue = "newValue";
    private static final String COL_adjustRate = "adjustRate";
    private static final String COL_isTotal = "isTotal";
    private static final String COL_orgUnit_id = "orgUnit.id";
    private static final String COL_process_type = "processType";
    private AnalyseVirtualHelper analyseHelper = new AnalyseVirtualHelper((CoreUI)this, this.getTable(), this.getInterface());
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
        mgr = new PopupMenuManager();
    }

    @Override
    public void onLoad() throws Exception {
        this.cellHelper.init();
        super.onLoad();
        MbgUpdateHelper.checkUpdate();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get("InitDataObject") != null) {
            this.btnQuery.setVisible(false);
        }
    }

    @Override
    public MBgAnalyseFilterBaseUI getFilterUI() {
        MbgAdjustAnalyseFilterUI ui = (MbgAdjustAnalyseFilterUI)super.getFilterUI();
        ui.setContainSealUp(true);
        return ui;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.getTable().checkParsed();
        this.getTable().getGroupManager().setGroup(true);
        this.getTable().getMergeManager().setMergeMode(5);
        this.getTable().getGroupManager().group();
        this.getTable().getColumn(COL_adjustRate).getStyleAttributes().setNumberFormat("0.00%");
        this.getTable().getDataRequestManager().putBindContents(COL_id, "mainQuery", "FID");
        this.getTable().getDataRequestManager().putBindContents(COL_orgUnit_id, "mainQuery", "FOrgUnitId");
        this.getTable().getDataRequestManager().putBindContents(COL_orgUnit, "mainQuery", "FOrgUnitName");
        this.getTable().getDataRequestManager().putBindContents(COL_indexMember, "mainQuery", "FIndexName");
        this.getTable().getDataRequestManager().putBindContents(COL_refMember, "mainQuery", "FOtherName");
        this.getTable().getDataRequestManager().putBindContents(COL_bgScenario, "mainQuery", "FBgScenarioName");
        this.getTable().getDataRequestManager().putBindContents(COL_bgVersion, "mainQuery", "FBgVersionName");
        this.getTable().getDataRequestManager().putBindContents(COL_bgPeriod_id, "mainQuery", "FBgPeriodId");
        this.getTable().getDataRequestManager().putBindContents(COL_bgPeriod, "mainQuery", "FBgPeriodName");
        this.getTable().getDataRequestManager().putBindContents(COL_bgElement, "mainQuery", "FBgElementName");
        this.getTable().getDataRequestManager().putBindContents(COL_currency, "mainQuery", "FCurencyName");
        this.getTable().getDataRequestManager().putBindContents(COL_currencyPrecision, "mainQuery", "FCurrencyPrecision");
        this.getTable().getDataRequestManager().putBindContents(COL_oldValue, "mainQuery", "FOldValue");
        this.getTable().getDataRequestManager().putBindContents(COL_newValue, "mainQuery", "FNewValue");
        this.getTable().getDataRequestManager().putBindContents(COL_adjustRate, "mainQuery", "FAdjustRate");
        this.getTable().getDataRequestManager().putBindContents(COL_isTotal, "mainQuery", "FIsTotal");
        this.getTable().getDataRequestManager().putBindContents(COL_process_type, "mainQuery", "FProcessType");
        this.getTable().getDataRequestManager().setDataRequestMode(1);
        this.getTable().addRequestRowSetListener((RequestRowSetListener)this.analyseHelper);
        this.getTable().addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                MBgAdjustAnalyseUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    protected void tblMain_afterDataFill(KDTDataRequestEvent e) {
        Set orgIds = null;
        Map rePeriodIds = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        ArrayList<MbgAdjustAnalyseFilterParam> filterParams = new ArrayList<MbgAdjustAnalyseFilterParam>();
        if (this.getFilterParam() instanceof MbgAdjustAnalyseMultiFilterParam) {
            filterParams.addAll(((MbgAdjustAnalyseMultiFilterParam)this.getFilterParam()).filterParams);
        } else {
            filterParams.add((MbgAdjustAnalyseFilterParam)this.getFilterParam());
        }
        if (filterParams.isEmpty()) {
            return;
        }
        bgSchemeId = ((MbgAdjustAnalyseFilterParam)filterParams.get(0)).getBgScheme().getId().toString();
        HashSet<String> periodIds = new HashSet<String>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        for (MbgAdjustAnalyseFilterParam _filterParam : filterParams) {
            int i;
            for (i = 0; i < _filterParam.getBgPeriod().length; ++i) {
                periodIds.add(_filterParam.getBgPeriod()[i].getId().toString());
            }
            if (_filterParam.getBgOrgUnits() != null && _filterParam.getBgOrgUnits().length > 0) {
                _filterParam.getOrgUnits().clear();
                for (i = 0; i < _filterParam.getBgOrgUnits().length; ++i) {
                    _filterParam.getOrgUnits().add((OrgUnitInfo)_filterParam.getBgOrgUnits()[i].castToFullOrgUnitInfo());
                }
            }
            for (i = 0; i < _filterParam.getOrgUnits().size(); ++i) {
                orgUnitIds.add(_filterParam.getOrgUnits().get(i).getId().toString());
            }
        }
        Map<String, OrgUnitInfo> orgUnitMap = this.getOrgUnitMap();
        try {
            orgIds = MbgAnalyseAdjustFacadeFactory.getRemoteInstance().getShowAliasOrgIds(bgSchemeId, orgUnitIds, ((MbgAdjustAnalyseFilterParam)filterParams.get(0)).isOnlyShowDetail());
            rePeriodIds = MbgAnalyseAdjustFacadeFactory.getRemoteInstance().getPeriodAlias(periodIds);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        ICell cell = null;
        boolean firstFlag = true;
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            IRow row = this.getTable().getRow(r);
            int precision = ((Number)row.getCell(COL_currencyPrecision).getValue()).intValue();
            row.getCell(COL_oldValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
            row.getCell(COL_adjustValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
            row.getCell(COL_newValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
            BigDecimal newValue = (BigDecimal)row.getCell(COL_newValue).getValue();
            BigDecimal oldValue = (BigDecimal)row.getCell(COL_oldValue).getValue();
            row.getCell(COL_adjustValue).setValue((Object)newValue.subtract(oldValue));
            if ("1".equals(String.valueOf(row.getCell(COL_isTotal).getValue()))) {
                row.getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
                this.getTable().getMergeManager().mergeBlock(r, this.getTable().getColumnIndex(COL_indexMember), r, this.getTable().getColumnIndex(COL_refMember));
                row.getCell(this.getTable().getColumnIndex(COL_indexMember)).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                Object value = row.getCell(this.getTable().getColumnIndex(COL_indexMember)).getValue();
                row.getCell(this.getTable().getColumnIndex(COL_indexMember)).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgCommonResource", (String)"total", (Object[])new Object[]{value}));
            }
            for (String orgid : orgIds) {
                if (!orgid.equals(row.getCell(COL_orgUnit_id).getValue())) continue;
                row.getCell(COL_bgPeriod).setValue(rePeriodIds.get(row.getCell(COL_bgPeriod_id).getValue()));
            }
            orgUnitId = (String)row.getCell(COL_orgUnit_id).getValue();
            if (!StringUtils.isEmpty((String)orgUnitId) && orgUnitMap.containsKey(orgUnitId)) {
                row.getCell(COL_orgUnit).setValue((Object)this.getCellHelper().getOrgUnitString(orgUnitMap.get(orgUnitId)));
            }
            cell = row.getCell(COL_process_type);
            Integer cellValue = null;
            if (cell != null && cell.getValue() != null) {
                cellValue = cell.getValue() instanceof BigDecimal ? Integer.valueOf(((BigDecimal)cell.getValue()).intValue()) : (cell.getValue() instanceof Integer ? (Integer)cell.getValue() : Integer.valueOf(1));
                cell.setValue((Object)BgProcessEnum.getEnum(cellValue).getAlias());
                cell.setUserObject((Object)BgProcessEnum.getEnum(cellValue));
                if (firstFlag && !BgProcessEnum.C01.equals((Object)BgProcessEnum.getEnum(cellValue))) {
                    firstFlag = false;
                }
            }
            if (!firstFlag) continue;
        }
    }

    private EntityViewInfo getOrgEntityViewInfo(BgSchemeInfo bgScheme, Set orgUnitIds) throws Exception {
        String bgSchemeId = ((MbgAdjustAnalyseFilterParam)this.getFilterParam()).getBgScheme().getId().toString();
        BaseFilterParam filterParam = (BaseFilterParam)this.getFilterParam();
        if (filterParam.getBgOrgUnits() != null && filterParam.getBgOrgUnits().length > 0) {
            filterParam.getOrgUnits().clear();
            for (int i = 0; i < filterParam.getBgOrgUnits().length; ++i) {
                filterParam.getOrgUnits().add((OrgUnitInfo)filterParam.getBgOrgUnits()[i].castToFullOrgUnitInfo());
            }
        }
        List<OrgUnitInfo> orgUnits = filterParam.getOrgUnits();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        StringBuffer sb = new StringBuffer(" (");
        evi.getSelector().add(COL_id);
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("displayName");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("orgUnitID");
        evi.getSelector().add("viewID");
        evi.setFilter(new FilterInfo());
        for (int i = 0; i < orgUnits.size(); ++i) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("longnumber", (Object)(orgUnits.get(i).getLongNumber() + "%"), CompareType.LIKE));
            sb.append("#" + String.valueOf(i) + " or ");
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)BgViewClientHelper.getBudgetViewID(bgSchemeId), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.EQUALS));
        String str = sb.substring(0, sb.length() - 3) + ") and #" + String.valueOf(orgUnits.size()) + " and #" + String.valueOf(orgUnits.size() + 1);
        evi.getFilter().setMaskString(str);
        return evi;
    }

    private EntityViewInfo getOrgEntityViewInfoSelf(BgSchemeInfo bgScheme, Set orgUnitIds) throws Exception {
        String bgSchemeId = bgScheme.getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        StringBuffer sb = new StringBuffer(" (");
        evi.getSelector().add(COL_id);
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("displayName");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("orgUnitID");
        evi.getSelector().add("viewID");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)BgViewClientHelper.getBudgetViewID(bgSchemeId), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", (Object)orgUnitIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
        return evi;
    }

    @Override
    public Map<String, OrgUnitInfo> getOrgUnitMap() {
        if (this.getFilterParam() instanceof MbgAdjustAnalyseFilterParam) {
            return this.getOrgUnitMap((MbgAdjustAnalyseFilterParam)this.getFilterParam());
        }
        if (this.getFilterParam() instanceof MbgAdjustAnalyseMultiFilterParam) {
            MbgAdjustAnalyseMultiFilterParam multiFilter = (MbgAdjustAnalyseMultiFilterParam)this.getFilterParam();
            HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
            for (MbgAdjustAnalyseFilterParam filterParam : multiFilter.filterParams) {
                orgUnitMap.putAll(this.getOrgUnitMap(filterParam));
            }
            return orgUnitMap;
        }
        return new HashMap<String, OrgUnitInfo>();
    }

    public Map<String, OrgUnitInfo> getOrgUnitMap(MbgAdjustAnalyseFilterParam filterParam) {
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        if (filterParam.getBgOrgUnits() != null && filterParam.getBgOrgUnits().length > 0) {
            filterParam.getOrgUnits().clear();
            for (int i = 0; i < filterParam.getBgOrgUnits().length; ++i) {
                filterParam.getOrgUnits().add((OrgUnitInfo)filterParam.getBgOrgUnits()[i].castToFullOrgUnitInfo());
            }
        }
        if (filterParam.getOrgUnits().isEmpty()) {
            return orgUnitMap;
        }
        List<OrgUnitInfo> orgUnits = filterParam.getOrgUnits();
        HashSet<String> orgUnitIds = new HashSet<String>();
        for (int index = 0; index < orgUnits.size(); ++index) {
            orgUnitIds.add(orgUnits.get(index).getId().toString());
        }
        try {
            BgOrgUnitCollection bgOrgUnitCollection = null;
            bgOrgUnitCollection = filterParam.isOnlyShowDetail() ? BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(this.getOrgEntityViewInfo(filterParam.getBgScheme(), orgUnitIds)) : BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(this.getOrgEntityViewInfoSelf(filterParam.getBgScheme(), orgUnitIds));
            for (int index = 0; index < bgOrgUnitCollection.size(); ++index) {
                orgUnitMap.put(bgOrgUnitCollection.get(index).getOrgUnitID().toString(), (OrgUnitInfo)bgOrgUnitCollection.get(index).castToFullOrgUnitInfo());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return orgUnitMap;
    }

    @Override
    public void actionPastRecordView_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        if (this.getTable().getRowCount() == 0 || this.getTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((row = this.getTable().getRow(this.getTable().getSelectManager().getActiveRowIndex())) == null) {
            return;
        }
        String id = row.getCell(COL_id).getValue().toString();
        String orgId = row.getCell(COL_orgUnit_id).getValue().toString();
        ICell cell = row.getCell(COL_process_type);
        BgProcessEnum processType = null;
        int processTypeInt = 1;
        if (cell != null && cell.getUserObject() != null && cell.getUserObject() instanceof BgProcessEnum && (processType = (BgProcessEnum)((Object)cell.getUserObject())) != null) {
            processTypeInt = processType.getValue();
        }
        String number = null;
        try {
            boolean isOnlyShowAuditData = false;
            FilterParam filterParam = this.getFilterParam();
            if (this.getFilterParam() instanceof MbgAdjustAnalyseMultiFilterParam) {
                List<MbgAdjustAnalyseFilterParam> filterParams = ((MbgAdjustAnalyseMultiFilterParam)this.getFilterParam()).filterParams;
                isOnlyShowAuditData = filterParams.get(0).isOnlyShowAuditData();
            } else {
                MbgAdjustAnalyseFilterParam filterParam1 = (MbgAdjustAnalyseFilterParam)this.getFilterParam();
                isOnlyShowAuditData = filterParam1.isOnlyShowAuditData();
            }
            Map rs = MbgAnalyseAdjustFacadeFactory.getRemoteInstance().pastDataView(id, ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString(), number, processTypeInt, isOnlyShowAuditData);
            UIContext uiContext = new UIContext((Object)this);
            if (rs.get("success") instanceof List) {
                uiContext.put((Object)"data", rs.get("success"));
                uiContext.put((Object)"ORGUNIT_ID", (Object)orgId);
            }
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
            uiContext.put((Object)"schemeHelper", (Object)schemeHelper);
            uiContext.put((Object)COL_process_type, (Object)processType);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgPastRecordViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    @Override
    protected String getExportFileName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgCommonResource", (String)"budgetAdjustAnalyse");
    }

    @Override
    public String getFilterUIName() {
        return MbgAdjustAnalyseFilterUI.class.getName();
    }

    @Override
    protected String getQueryMainName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected int getWidthOfDialog() {
        return 452;
    }

    @Override
    protected int getHeightOfDialog() {
        return 505;
    }

    @Override
    public KDTable getTable() {
        return this.tblMain;
    }

    protected IVirtualAnalyseBaseFacade getInterface() throws BOSException {
        return MbgAnalyseAdjustFacadeFactory.getRemoteInstance();
    }

    @Override
    protected boolean hasDefaultQuery() throws Exception {
        FilterParam filterParam = (FilterParam)this.getUIContext().get("InitDataObject");
        if (filterParam != null) {
            this.setFilterParam(filterParam);
            return true;
        }
        return super.hasDefaultQuery();
    }

    @Override
    protected void executeQuery() throws Exception {
        this.analyseHelper.doQuery(this.getFilterParam());
        if (this.getFilterParam() instanceof MbgAdjustAnalyseFilterParam) {
            this.prmtBgScheme.setData((Object)((MbgAdjustAnalyseFilterParam)this.getFilterParam()).getBgScheme());
        } else if (this.getFilterParam() instanceof MbgAdjustAnalyseMultiFilterParam) {
            this.prmtBgScheme.setData((Object)((MbgAdjustAnalyseMultiFilterParam)this.getFilterParam()).filterParams.get(0).getBgScheme());
        }
    }
}

