/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ui.Excel2007ExportController;
import com.kingdee.bos.ctrl.kdf.export.nio.KDTableDataWrapper;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.client.AbstractMBgAnalyseListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.query.BaseFilterParam;
import com.kingdee.eas.ma.mbg.query.MbgAdjustAnalyseFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MBgAnalyseListUI
extends AbstractMBgAnalyseListUI {
    private static final long serialVersionUID = 7562460827413302527L;
    private static final Logger logger = CoreUIObject.getLogger(MBgAnalyseListUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.executeQuery();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog().show()) {
            this.setFilterParam(this.getFilterUI().getCustomerParams());
            if (this.getFilterParam() instanceof MbgAdjustAnalyseFilterParam) {
                MbgAdjustAnalyseFilterParam filterParam2 = (MbgAdjustAnalyseFilterParam)this.getFilterParam();
                filterParam2.setShowChildIndex(true);
            }
            this.executeQuery();
        }
    }

    public KDTable getTable() {
        return null;
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            BgFileUtil bgFileUtil = new BgFileUtil();
            KDFileChooser fc = bgFileUtil.getFileChooserForExp((Object)this);
            fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "fileExport"));
            fc.setFileFilter((FileFilter)new ExcelFileFilter());
            Excel2007FileFilter xlsxFilter = new Excel2007FileFilter();
            fc.setFileFilter((FileFilter)xlsxFilter);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setSelectedFile(new File(fc.getCurrentDirectory().getPath() + "//" + this.getExportFileName()));
            if (fc.showSaveDialog((Component)((Object)this)) == 0) {
                String sen;
                String postfix = null;
                File file = fc.getSelectedFile();
                String name = file.getName().replaceAll(" ", "");
                String x = file.toString().substring(0, file.toString().indexOf(file.getName()));
                fc.setSelectedFile(new File(x + name));
                if (file.getName().indexOf(".") == -1) {
                    FileFilter fileFilter = fc.getFileFilter();
                    postfix = fileFilter == xlsxFilter ? ".xlsx" : ".xls";
                    file = new File(fc.getSelectedFile() + postfix);
                    fc.setSelectedFile(file);
                }
                if (file != null && file.exists()) {
                    int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "existsFile"));
                    if (re == 1 || re == 2) {
                        return;
                    }
                    if (!file.delete()) {
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                        return;
                    }
                }
                if ((sen = GlobalFunction.getFileExtension((String)file.getPath())).equals("xlsx")) {
                    KDTableDataWrapper wrapper = new KDTableDataWrapper(this.getTable());
                    wrapper.setExportHideCols(this.isExportHideCols());
                    wrapper.setExportSelect(false);
                    wrapper.setExportMergeBlocks(true);
                    Excel2007ExportController.export((String)file.getPath(), (AbstractDataWrapper)wrapper, (boolean)false);
                } else {
                    int i;
                    ArrayList<Integer> rowIndex = new ArrayList<Integer>();
                    for (i = 0; i < this.getTable().getRowCount(); ++i) {
                        if (!this.getTable().getRow(i).getStyleAttributes().getBackground().equals(BgNConstants.LOCK_COLOR)) continue;
                        this.getTable().getRow(i).getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
                        rowIndex.add(i);
                    }
                    this.getTable().getIOManager().exportExcelToFile(false, file);
                    for (i = 0; i < this.getTable().getRowCount(); ++i) {
                        if (!rowIndex.contains(i)) continue;
                        this.getTable().getRow(i).getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
                    }
                }
                bgFileUtil.storeDefaultPathForEXP((Object)x, (Object)this);
            }
        }
    }

    protected boolean isExportHideCols() {
        return false;
    }

    protected String getExportFileName() {
        return "mbgAnalayse";
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        if (this.getTable() != null) {
            this.getTable().getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        if (this.getTable() != null) {
            this.getTable().getPrintManager().printPreview();
        }
    }

    public Map<String, OrgUnitInfo> getOrgUnitMap() {
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        if (((BaseFilterParam)this.getFilterParam()).getOrgUnits().isEmpty()) {
            return orgUnitMap;
        }
        List<OrgUnitInfo> orgUnits = ((BaseFilterParam)this.getFilterParam()).getOrgUnits();
        for (int index = 0; index < orgUnits.size(); ++index) {
            orgUnitMap.put(orgUnits.get(index).getId().toString(), orgUnits.get(index));
        }
        return orgUnitMap;
    }

    public Map<String, BgOrgUnitInfo> getBgOrgUnitMap() {
        HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        if (((BaseFilterParam)this.getFilterParam()).getBgOrgUnits() == null) {
            return orgUnitMap;
        }
        BgOrgUnitInfo[] orgUnits = ((BaseFilterParam)this.getFilterParam()).getBgOrgUnits();
        for (int index = 0; index < orgUnits.length; ++index) {
            orgUnitMap.put(orgUnits[index].getOrgUnitID().toString(), orgUnits[index]);
        }
        return orgUnitMap;
    }

    public void checkSelected() {
        if (this.getTable().getRowCount() == 0 || this.getTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

