/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.MBgAnalyseFacadeFactory;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeBlockSetUI;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgAdjustAnalyseFilterUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.NewDimensionSelectDialog;
import com.kingdee.eas.ma.mbg.client.common.BgProcessSelectDialog;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionDialog;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionSourceMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.MbgAdjustAnalyseFilterParam;
import com.kingdee.eas.ma.mbg.query.MbgAdjustAnalyseMember;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimSettingDisplayInfo;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgAdjustAnalyseFilterUI
extends AbstractMbgAdjustAnalyseFilterUI {
    private static final long serialVersionUID = -5827957659735543459L;
    private static final Logger logger = CoreUIObject.getLogger(MbgAdjustAnalyseFilterUI.class);
    private String ANALYSE_SCHEME_ID = "ANALYSE_SCHEME_ID";
    private String ANALYSE_MEMBER = "ANALYSE_MEMBER";
    private String ANALYSE_BEGIN_PERIOD_ID = "ANALYSE_BEGIN_PERIOD_ID";
    private String ANALYSE_END_PERIOD_ID = "ANALYSE_END_PERIOD_ID";
    private String ANALYSE_BGPERIOD_IDS = "ANALYSE_BGPERIOD_IDS";
    private String ANALYSE_CURRENCY_ID = "ANALYSE_CURRENCY_ID";
    private String ANALYSE_ELEMENT_ID = "ANALYSE_ELEMENT_ID";
    private String ANALYSE_SCENARIO_ID = "ANALYSE_SCENARIO_ID";
    private String ANALYSE_VERSION_ID = "ANALYSE_VERSION_ID";
    private String ANALYSE_ONLY_SHOW_DETAIL = "ANALYSE_ONLY_SHOW_DETAIL";
    private String ANALYSE_ONLY_SHOW_AUDIT_DATA = "ANALYSE_ONLY_SHOW_AUDIT_DATA";
    private String ANALYSE_PROCESS_TYPE = "ANALYSE_PROCESS_TYPE";
    protected static final String COL_INDEX_MEMBERS = "bgIndexMember";
    protected static final String COL_REF_MEMBERS = "dimMember";
    protected boolean isContainSealUp = false;
    protected boolean isOnlySelf = false;
    protected DimensionSourceCollection sources;
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    String accountViewId = null;

    public boolean isContainSealUp() {
        return this.isContainSealUp;
    }

    public void setContainSealUp(boolean isContainSealUp) {
        this.isContainSealUp = isContainSealUp;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public MbgAdjustAnalyseFilterUI() throws Exception {
        this.init();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initResponsibilityCenter();
        this.initBgScheme();
        this.initProcessType();
        this.getCellHelper().init();
    }

    private void initProcessType() {
        BgProcessSelectDialog dialog = this.getBgProcessTypeDialog();
        HashSet<String> filterMembers = new HashSet<String>();
        filterMembers.add(BgProcessEnum.C03.getName());
        dialog.setFilterMembers(filterMembers);
        this.prmtProcessType.setSelector((KDPromptSelector)dialog);
        this.prmtProcessType.addDataChangeListener((DataChangeListener)dialog);
    }

    @Override
    protected void prmtProcessType_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtProcessType_dataChanged(e);
        if (!DimensionCommonHelper.isEqualsPrmt(e.getNewValue(), e.getOldValue())) {
            // empty if block
        }
    }

    private void initResponsibilityCenter() {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"selectOrgUnit"));
        orgView.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
        orgView.setMultiSelect(false);
        orgView.setContainSealUp(this.isContainSealUp);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
    }

    protected void init() throws EASBizException, BOSException {
        this.tblMember.checkParsed();
        this.initBgScheme();
    }

    protected void initBgScheme() {
        this.prmtBgScheme.setEditable(false);
        this.prmtBgScheme.setEnabledMultiSelection(false);
        this.prmtBgScheme.setHistoryRecordEnabled(false);
    }

    protected Set<BOSUuid> queryBgSchemeIds(BOSUuid[] orgUnitIds) throws Exception {
        return BgSchemeFactory.getRemoteInstance().queryShowScheme(orgUnitIds);
    }

    protected void initDimMember() throws EASBizException, BOSException {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        prmt.setSelector((KDPromptSelector)this.initMBgIndexF7());
        this.tblMember.getColumn(COL_INDEX_MEMBERS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
        this.tblMember.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                MbgAdjustAnalyseFilterUI.this.tblMember_editStopped(e);
            }
        });
        NewDimensionSelectDialog combinDialog = this.getCombinRowPromptBox();
    }

    protected NewDimensionSelectDialog getCombinRowPromptBox() {
        NewDimensionSelectDialog dia = null;
        if (!(this.tblMember.getColumn(COL_REF_MEMBERS).getEditor() instanceof KDTDefaultCellEditor && this.tblMember.getColumn(COL_REF_MEMBERS).getEditor().getComponent() instanceof KDBizPromptBox && ((KDBizPromptBox)this.tblMember.getColumn(COL_REF_MEMBERS).getEditor().getComponent()).getSelector() instanceof DimensionDialog)) {
            dia = this.getDimensionDialog();
            KDBizPromptBox memberF7 = new KDBizPromptBox();
            memberF7.setEditable(false);
            memberF7.addDataChangeListener((DataChangeListener)dia);
            memberF7.setSelector((KDPromptSelector)dia);
            memberF7.setDisplayFormatter(new IFormatter(){

                public String valueToString(Object o) {
                    if (o instanceof List) {
                        return BgViewHelper.convertArray(((List)o).toArray(), null).toString();
                    }
                    if (o != null) {
                        return o.toString();
                    }
                    return "";
                }

                public void applyPattern(String pattern) {
                }
            });
            this.tblMember.getColumn(COL_REF_MEMBERS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)memberF7));
            this.tblMember.setUserCellDisplayParser(new IUserCellDisplayParser(){

                public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                    if (MbgAdjustAnalyseFilterUI.COL_REF_MEMBERS.equals(MbgAdjustAnalyseFilterUI.this.tblMember.getColumnKey(colIndex)) && value instanceof List) {
                        return BgViewHelper.convertArray(((List)value).toArray(), null);
                    }
                    return value;
                }
            });
        }
        return dia;
    }

    protected NewDimensionSelectDialog getDimensionDialog() {
        NewDimensionSelectDialog dia = new NewDimensionSelectDialog(this.getCoreUI(), true);
        dia.setBgSchemeId(((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
        dia.setOnlyMbgDim(true);
        return dia;
    }

    protected void tblMember_editStopped(KDTEditEvent e) {
        List indexMembers;
        Object value = e.getValue();
        if (COL_INDEX_MEMBERS.equals(this.tblMember.getColumnKey(e.getColIndex())) && value instanceof List && (indexMembers = (List)value) != null && indexMembers.size() >= 0) {
            IRow sourceRow = this.tblMember.getRow(e.getRowIndex());
            IRow row = null;
            ArrayList<BgDimensionMember> newMembers = null;
            for (int i = 0; i < indexMembers.size(); ++i) {
                if (i != 0) {
                    row = this.tblMember.addRow(e.getRowIndex() + i);
                    this.copyRow(sourceRow, row);
                } else {
                    row = sourceRow;
                }
                newMembers = new ArrayList<BgDimensionMember>();
                newMembers.add((BgDimensionMember)indexMembers.get(i));
                this.setIndexMember(row, newMembers);
            }
        }
    }

    private void setIndexMember(IRow row, List<BgDimensionMember> newMembers) {
        row.getCell(COL_INDEX_MEMBERS).setValue((Object)this.displayMembers(newMembers));
        row.getCell(COL_INDEX_MEMBERS).setUserObject(newMembers);
    }

    protected void setIndexMemberF7(DimensionSourceInfo source, DimensionSourceInfo oldValue, int rowIndex) {
        ICell memberCell = this.tblMember.getCell(rowIndex, COL_INDEX_MEMBERS);
        if (source == null) {
            memberCell.setValue(null);
            memberCell.setEditor(null);
            memberCell.getStyleAttributes().setLocked(true);
            return;
        }
        if (oldValue != null && oldValue.getId().equals((Object)source.getId())) {
            return;
        }
        memberCell.setValue(null);
        memberCell.getStyleAttributes().setLocked(false);
        NewDimensionSourceMemberDialog dialog = new NewDimensionSourceMemberDialog(this.getCoreUI(), source, this.getCurrOrgUnit().getId().toString(), true);
        dialog.setCanFillType(false);
        KDBizPromptBox prmtMember = new KDBizPromptBox();
        prmtMember.setEditable(false);
        prmtMember.setSelector((KDPromptSelector)dialog);
        memberCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMember));
    }

    protected CoreUI getCoreUI() {
        if (this.getUIContext().get("Owner") instanceof CoreUI) {
            return (CoreUI)this.getUIContext().get("Owner");
        }
        return null;
    }

    protected DimensionSourceCollection filterIndexSource(DimensionSourceCollection sources) {
        return sources;
    }

    protected NewDimensionMemberSelectDialog initMBgIndexF7() {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog();
        dialog.setBgSchemeId(((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
        dialog.setMulti(false);
        dialog.setDimension(dimension);
        return dialog;
    }

    protected NewDimensionMemberSelectDialog initDimensionMemberSelectDialog() {
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)null, this.getCurrOrgUnit().getId().toString(), false, true);
        dialog.setOnlyRefDim(true);
        dialog.setOnlySelectItem(true);
        return dialog;
    }

    protected void initPeriod() throws Exception {
        this.prmtBgPeriod.setEditable(false);
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodBeginDate(((BgSchemeInfo)this.prmtBgScheme.getData()).getDateFrom());
        dialog.setBgPeriodEndDate(((BgSchemeInfo)this.prmtBgScheme.getData()).getDateTo());
        dialog.setMultiSelect(true);
        dialog.setBgSchemeID(((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
    }

    protected void initCurrency() throws Exception {
        this.prmtCurrency.setEditable(false);
        Set currencyID = MbgAnalyseExeHelper.getCurrencyID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtCurrency.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCurrency.setEntityViewInfo(view);
    }

    protected void initMbgElement() throws Exception {
        this.prmtBgElement.setEditable(false);
        Set elementID = MbgAnalyseExeHelper.getElementID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtBgElement.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)elementID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtBgElement.setEntityViewInfo(view);
    }

    protected void initScenario() throws Exception {
        this.prmtScenario.setEditable(false);
        Set scenarioID = MbgAnalyseExeHelper.getBgScenarioID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtScenario.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)scenarioID, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtScenario.setEntityViewInfo(view);
    }

    protected void initBgVersion() throws Exception {
        this.prmtBgVersion.setEditable(false);
        Set versionID = MbgAnalyseExeHelper.getBgVersionID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtBgVersion.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)versionID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtBgVersion.setEntityViewInfo(view);
    }

    @Override
    protected boolean isMultiSelect() {
        return true;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] newValue;
            OrgUnitInfo[] oldValue = (OrgUnitInfo[])e.getOldValue();
            if (e.getNewValue() instanceof OrgUnitInfo[] && oldValue.length == (newValue = (OrgUnitInfo[])e.getNewValue()).length) {
                boolean flag = true;
                for (int i = 0; i < oldValue.length; ++i) {
                    if (oldValue[i].getId().toString().equals(newValue[i].getId().toString())) continue;
                    flag = false;
                }
                if (flag) {
                    return;
                }
            }
        } else if (e.getOldValue() instanceof OrgUnitInfo) {
            OrgUnitInfo oldValue = (OrgUnitInfo)e.getOldValue();
            if (e.getNewValue() instanceof OrgUnitInfo) {
                OrgUnitInfo newValue = (OrgUnitInfo)e.getNewValue();
                if (oldValue.getId() == newValue.getId()) {
                    return;
                }
            }
        }
        if (this.prmtOrgUnit.getData() == null) {
            this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
        } else {
            this.resetDisplayFormatter();
            this.setBgSchemeFilter();
        }
    }

    private void resetDisplayFormatter() {
        this.prmtBgPeriod.setData(null);
        this.prmtBgPeriod.setDisplayFormat("$name$");
    }

    protected void setBgSchemeFilter() throws Exception {
        Object data = this.prmtOrgUnit.getData();
        if (data != null && data instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)data;
            try {
                BgNFCHelper.initPrmpPermitedBgschemeInfo(this.prmtBgScheme, orgUnit, this.isOnlySelf, BgNFCHelper.getSourceType((IUIObject)this), false, false, true);
                if (this.prmtBgScheme.getData() == null) {
                    this.prmtBgOrgUnit.setDataNoNotify(null);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (data != null && data instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])data;
            if (orgUnits == null || orgUnits.length == 0) {
                return;
            }
            BOSUuid[] ids = new BOSUuid[orgUnits.length];
            for (int i = 0; i < orgUnits.length; ++i) {
                OrgUnitInfo orgUnitInfo = orgUnits[i];
                ids[i] = orgUnitInfo.getId();
            }
            try {
                BgNFCHelper.initPrmpPermitedBgschemeInfo(this.prmtBgScheme, orgUnits, this.isOnlySelf, BgNFCHelper.getSourceType((IUIObject)this), false, false, true);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    @Override
    protected void prmtScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtScheme_willShow(e);
        BgViewClientHelper.prmtScheme_willShow((Component)((Object)this), this.prmtOrgUnit);
    }

    @Override
    protected void prmtScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtScheme_dataChanged(e);
        if (e.getNewValue() != null && e.getOldValue() != null && e.getNewValue() instanceof BgSchemeInfo && ((BgSchemeInfo)e.getNewValue()).getId().equals((Object)((BgSchemeInfo)e.getOldValue()).getId())) {
            return;
        }
        if (e.getNewValue() == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            return;
        }
        this.tblMember.removeRows();
        if (this.prmtBgScheme.getData() != null) {
            this.resetDisplayFormatter();
            FilterInfo filter = MbgPermissionHelper.addBgSchemePermission(BgNFCHelper.getSourceType((IUIObject)this), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.prmtBgScheme.getEntityViewInfo().getFilter());
            this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
            this.initDimMember();
            this.initScenario();
            this.initPeriod();
            this.initCurrency();
            this.initMbgElement();
            this.initBgVersion();
        }
        this.prmtBgPeriod.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtBgElement.setData(null);
        this.prmtScenario.setData(null);
        this.prmtBgVersion.setData(null);
        this.prmtProcessType.setData(null);
        this.prmtBgOrgUnit.setData(null);
        this.setOrgUnitFilter();
    }

    public BgSchemeInfo getSelectBgScheme() {
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            return (BgSchemeInfo)this.prmtBgScheme.getData();
        }
        return null;
    }

    protected BgPeriodInfo[] getSchemePeriod(BgSchemeInfo bgSchemeInfo) throws Exception {
        if (bgSchemeInfo == null) {
            return null;
        }
        return (BgPeriodInfo[])this.getInterface().getSchemePeriod(bgSchemeInfo.getId());
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgScheme();
        super.btnAddLine_actionPerformed(e);
        IRow row = this.createNewRefRow(true);
    }

    protected IRow createNewRefRow(boolean setDefault) {
        IRow row = this.tblMember.addRow();
        return row;
    }

    @Override
    protected void btnCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnCopyLine_actionPerformed(e);
        int rowIndex = this.tblMember.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            IRow srcRow = this.tblMember.getRow(rowIndex);
            IRow row = this.tblMember.addRow(rowIndex + 1);
            this.copyRow(srcRow, row);
        }
    }

    private void copyRow(IRow srcRow, IRow row) {
        if (row != null) {
            if (srcRow.getCell(COL_INDEX_MEMBERS).getUserObject() != null) {
                this.setIndexMember(row, (List)srcRow.getCell(COL_INDEX_MEMBERS).getUserObject());
            }
            if (srcRow.getCell(COL_REF_MEMBERS).getValue() != null) {
                row.getCell(COL_REF_MEMBERS).setValue(srcRow.getCell(COL_REF_MEMBERS).getValue());
            }
        }
    }

    private Object displayRefMembers(List<DimensionInfo> members) {
        if (members == null || members.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DimensionInfo bgDimensionMember : members) {
            sb.append("(").append(bgDimensionMember.getName()).append(")").append(",");
        }
        sb = sb.deleteCharAt(sb.toString().lastIndexOf(","));
        return sb.toString();
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMember);
        if (rows != null) {
            Collections.sort(rows);
            for (int i = rows.size() - 1; i >= 0; --i) {
                this.tblMember.removeRow(((Integer)rows.get(i)).intValue());
            }
        }
    }

    @Override
    protected void btnFromSelect_actionPerformed(ActionEvent e) throws Exception {
        List formulas;
        String bgSchemeRootId;
        this.checkBgScheme();
        super.btnFromSelect_actionPerformed(e);
        List<OrgUnitInfo> orgUnits = this.getBgOrgUnit();
        if (orgUnits.isEmpty()) {
            this.prmtBgOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectOrgUnit"));
            return;
        }
        String string = bgSchemeRootId = this.getSelectBgScheme() != null ? this.getSelectBgScheme().getId().toString() : null;
        if (StringUtils.isEmpty((String)bgSchemeRootId)) {
            this.prmtBgScheme.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_IDS, orgUnits);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)bgSchemeRootId);
        uiContext.put((Object)"BGSCHEME_ORGUNIT_ID", (Object)this.getBgOrgUnitViewId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getFormSelectUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        MbgAnalyseExeBlockSetUI ui = (MbgAnalyseExeBlockSetUI)uiWindow.getUIObject();
        if (!ui.isHasCancel() && (formulas = ui.getData()) != null) {
            String[] params = null;
            ArrayList<String> dimItems = new ArrayList<String>();
            for (String formulaStr : formulas) {
                params = BgNFSHelper.parseFormulaPara(formulaStr);
                dimItems.add(params[0]);
            }
            List result = MBgAnalyseFacadeFactory.getRemoteInstance().getAnalyseMember(bgSchemeRootId, orgUnits.get(0).getId(), dimItems);
            if (result != null) {
                HashMap<String, MbgDimInfo> dimens = new HashMap<String, MbgDimInfo>();
                CoreBaseCollection col = MbgDimFactory.getRemoteInstance().getCollection();
                if (col != null) {
                    MbgDimInfo mbgDim = null;
                    for (int i = 0; i < col.size(); ++i) {
                        mbgDim = (MbgDimInfo)col.get(i);
                        dimens.put(mbgDim.getRefField(), mbgDim);
                    }
                }
                IRow row = null;
                String key = null;
                ArrayList<BgDimensionMember> tmpList = null;
                HashSet<String> keySet = new HashSet<String>();
                int in = this.tblMember.getRowCount();
                for (int i = 0; i < in; ++i) {
                    row = this.tblMember.getRow(i);
                    key = "";
                    if (row.getCell(COL_INDEX_MEMBERS) != null && row.getCell(COL_INDEX_MEMBERS).getUserObject() != null) {
                        tmpList = (ArrayList<BgDimensionMember>)row.getCell(COL_INDEX_MEMBERS).getUserObject();
                        BgDimensionMember _bgMember = (BgDimensionMember)tmpList.get(0);
                        key = key + _bgMember.getSrcNumber() + ":" + _bgMember.getNumber();
                    }
                    if (row.getCell(COL_REF_MEMBERS) != null && row.getCell(COL_REF_MEMBERS).getValue() != null) {
                        List _otherDim = (List)row.getCell(COL_REF_MEMBERS).getValue();
                        key = key + "," + MbgAdjustAnalyseMember.getRefFields(_otherDim);
                    }
                    keySet.add(key);
                }
                for (AnalyseMember member : result) {
                    key = member.getBgIndex().getSrcNumber() + ":" + member.getBgIndex().getNumber();
                    if (member.getDimMember() != null) {
                        key = key + "," + member.getDimMember().getRefField();
                    }
                    if (keySet.contains(key)) continue;
                    keySet.add(key);
                    row = this.tblMember.addRow();
                    if (member.getBgIndex() != null) {
                        tmpList = new ArrayList<BgDimensionMember>();
                        tmpList.add(member.getBgIndex());
                        this.setIndexMember(row, tmpList);
                    }
                    if (member.getDimMember() == null) continue;
                    ArrayList<DimSettingDisplayInfo> ds = new ArrayList<DimSettingDisplayInfo>();
                    String[] refs = member.getDimMember().getRefField().split(",");
                    for (int i = 0; i < refs.length; ++i) {
                        if (!dimens.containsKey(refs[i])) continue;
                        BgDimSettingsInfo sett = new BgDimSettingsInfo();
                        sett.setDimNumber(((MbgDimInfo)dimens.get(refs[i])).getNumber());
                        sett.setDimName(((MbgDimInfo)dimens.get(refs[i])).getName());
                        ds.add(new DimSettingDisplayInfo(sett));
                    }
                    row.getCell(COL_REF_MEMBERS).setValue(ds);
                }
            }
        }
    }

    protected List<OrgUnitInfo> getBgOrgUnit() {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] _orgUnits = (BgOrgUnitInfo[])this.prmtBgOrgUnit.getData();
            int in = _orgUnits.length;
            for (int i = 0; i < in; ++i) {
                orgUnits.add((OrgUnitInfo)_orgUnits[i].castToFullOrgUnitInfo());
            }
        } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo _orgUnit = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            orgUnits.add((OrgUnitInfo)_orgUnit.castToFullOrgUnitInfo());
        }
        return orgUnits;
    }

    private DimensionSourceInfo getIndexSource(String srcNumber) {
        if (this.sources == null || this.sources.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!this.sources.get(i).getSrcNumber().equals(srcNumber)) continue;
            return this.sources.get(i);
        }
        return null;
    }

    protected String getBgOrgUnitViewId() throws Exception {
        String bgOrgViewId = null;
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            bgOrgViewId = MbgAnalyseExeHelper.getBudgetViewID((BgSchemeInfo)bgSchemeInfo);
        }
        return bgOrgViewId;
    }

    protected String getFormSelectUIName() {
        return MbgAnalyseExeBlockSetUI.class.getName();
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
    }

    @Override
    protected void prmtBgElement_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgElement_dataChanged(e);
    }

    @Override
    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (this.prmtBgScheme.getData() == null) {
                this.prmtBgScheme.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
                re = false;
            }
            if (re && this.prmtBgOrgUnit.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgDataQueryResource", (String)"msgCheckSelect", (Object[])new Object[]{this.contBgOrgUnit.getBoundLabelText()}));
                re = false;
            }
            if (re && this.prmtBgPeriod.getData() == null) {
                this.prmtBgPeriod.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgPeriod"));
                re = false;
            }
            if (re && this.prmtBgVersion.getData() == null) {
                this.prmtBgVersion.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgVersion"));
                re = false;
            }
            if (re && !this.verifyDimesionMembers()) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"dimMemberDuplate"));
                re = false;
            }
        }
        return re;
    }

    private boolean verifyDimesionMembers() {
        return true;
    }

    private IndexMemberDTO contains(Set<IndexMemberDTO> keySet, IndexMemberDTO o) {
        for (IndexMemberDTO key : keySet) {
            if (!key.equals(o)) continue;
            return key;
        }
        return null;
    }

    @Override
    protected FilterParam createFilterParam() {
        return new MbgAdjustAnalyseFilterParam();
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof MbgAdjustAnalyseFilterParam)) {
            return;
        }
        String id = null;
        List members = null;
        MbgAdjustAnalyseFilterParam _filterParam = (MbgAdjustAnalyseFilterParam)filterParam;
        ArrayList bgPeriodIds = new ArrayList();
        ArrayList processTypeList = null;
        id = cp.getCustomerParam(this.ANALYSE_SCHEME_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScheme(new BgSchemeInfo());
            _filterParam.getBgScheme().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgScheme(null);
        }
        members = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(this.ANALYSE_MEMBER)));
        if (members != null) {
            _filterParam.getMembers().addAll(members);
        } else {
            _filterParam.getMembers().clear();
        }
        bgPeriodIds = (ArrayList)BgAnalyseHelper.decodeObject(cp.getCustomerParam("ANALYSE_BGPERIOD_IDS"));
        if (bgPeriodIds != null && !bgPeriodIds.isEmpty()) {
            BgPeriodInfo[] bgPeriodInfos = new BgPeriodInfo[bgPeriodIds.size()];
            for (int i = 0; i < bgPeriodIds.size(); ++i) {
                bgPeriodInfos[i] = new BgPeriodInfo();
                bgPeriodInfos[i].setId(BOSUuid.read((String)((String)bgPeriodIds.get(i))));
            }
            _filterParam.setBgPeriod(bgPeriodInfos);
        } else {
            _filterParam.setBgPeriod(null);
        }
        processTypeList = (ArrayList)BgAnalyseHelper.decodeObject(cp.getCustomerParam(this.ANALYSE_PROCESS_TYPE));
        if (processTypeList != null) {
            BgProcessEnum[] processEnumArray = processTypeList.toArray(new BgProcessEnum[processTypeList.size()]);
            _filterParam.setProcessTypeArray(processEnumArray);
        } else {
            _filterParam.setProcessTypeArray(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_CURRENCY_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setCurrency(new CurrencyInfo());
            _filterParam.getCurrency().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setCurrency(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_ELEMENT_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgElement(new BgElementInfo());
            _filterParam.getBgElement().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgElement(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_SCENARIO_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScenario(new BgScenarioInfo());
            _filterParam.getBgScenario().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgScenario(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_VERSION_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgVersion(new BgVersionInfo());
            _filterParam.getBgVersion().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgVersion(null);
        }
        id = cp.getCustomerParam(this.ANALYSE_ONLY_SHOW_DETAIL);
        _filterParam.setOnlyShowDetail(Boolean.TRUE.toString().equals(id));
        id = cp.getCustomerParam(this.ANALYSE_ONLY_SHOW_AUDIT_DATA);
        _filterParam.setOnlyShowAuditData(Boolean.TRUE.toString().equals(id));
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof MbgAdjustAnalyseFilterParam)) {
            return;
        }
        MbgAdjustAnalyseFilterParam _filterParam = (MbgAdjustAnalyseFilterParam)filterParam;
        ArrayList<String> bgPeriodIds = null;
        if (_filterParam.getBgScheme() != null) {
            cp.addCustomerParam(this.ANALYSE_SCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_SCHEME_ID);
        }
        if (_filterParam.getBgOrgUnits() != null) {
            cp.addCustomerParam(this.ANALYSE_SCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_SCHEME_ID);
        }
        if (_filterParam.getBgPeriod() != null && _filterParam.getBgPeriod().length != 0) {
            bgPeriodIds = new ArrayList<String>();
            for (BgPeriodInfo bg : _filterParam.getBgPeriod()) {
                bgPeriodIds.add(bg.getId().toString());
            }
            cp.addCustomerParam(this.ANALYSE_BGPERIOD_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(bgPeriodIds)));
        } else {
            cp.removeCustomerParam(this.ANALYSE_BGPERIOD_IDS);
        }
        if (!_filterParam.getMembers().isEmpty()) {
            MbgAdjustAnalyseMember member = _filterParam.getMembers().get(0);
            if (member != null && member.getBgIndex() != null && member.getBgIndex().getNumber() != null) {
                cp.addCustomerParam(this.ANALYSE_MEMBER, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(_filterParam.getMembers())));
            } else {
                cp.removeCustomerParam(this.ANALYSE_MEMBER);
            }
        } else {
            cp.removeCustomerParam(this.ANALYSE_MEMBER);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(this.ANALYSE_CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_CURRENCY_ID);
        }
        if (_filterParam.getBgElement() != null) {
            cp.addCustomerParam(this.ANALYSE_ELEMENT_ID, _filterParam.getBgElement().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_ELEMENT_ID);
        }
        if (_filterParam.getBgScenario() != null) {
            cp.addCustomerParam(this.ANALYSE_SCENARIO_ID, _filterParam.getBgScenario().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_SCENARIO_ID);
        }
        if (_filterParam.getBgVersion() != null) {
            cp.addCustomerParam(this.ANALYSE_VERSION_ID, _filterParam.getBgVersion().getId().toString());
        } else {
            cp.removeCustomerParam(this.ANALYSE_VERSION_ID);
        }
        if (_filterParam.isOnlyShowDetail()) {
            cp.addCustomerParam(this.ANALYSE_ONLY_SHOW_DETAIL, String.valueOf(_filterParam.isOnlyShowDetail()));
        } else {
            cp.removeCustomerParam(this.ANALYSE_ONLY_SHOW_DETAIL);
        }
        if (_filterParam.isOnlyShowAuditData()) {
            cp.addCustomerParam(this.ANALYSE_ONLY_SHOW_AUDIT_DATA, String.valueOf(_filterParam.isOnlyShowAuditData()));
        } else {
            cp.removeCustomerParam(this.ANALYSE_ONLY_SHOW_AUDIT_DATA);
        }
        if (_filterParam.getProcessTypeArray() != null) {
            ArrayList<BgProcessEnum> processTypeList = new ArrayList<BgProcessEnum>();
            for (int i = 0; i < _filterParam.getProcessTypeArray().length; ++i) {
                processTypeList.add(_filterParam.getProcessTypeArray()[i]);
            }
            cp.addCustomerParam(this.ANALYSE_PROCESS_TYPE, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(processTypeList)));
        } else {
            cp.removeCustomerParam(this.ANALYSE_PROCESS_TYPE);
        }
    }

    @Override
    protected void loadFromParams(FilterParam filterParam) {
        super.loadFromParams(filterParam);
        if (!(filterParam instanceof MbgAdjustAnalyseFilterParam)) {
            return;
        }
        MbgAdjustAnalyseFilterParam _filterParam = (MbgAdjustAnalyseFilterParam)filterParam;
        this.prmtBgScheme.setData((Object)_filterParam.getBgScheme());
        IRow row = null;
        MbgAdjustAnalyseMember member = null;
        ArrayList<BgDimensionMember> members = null;
        this.tblMember.removeRows();
        int in = _filterParam.getMembers().size();
        for (int i = 0; i < in; ++i) {
            if (!(_filterParam.getMembers().get(i) instanceof MbgAdjustAnalyseMember)) continue;
            member = _filterParam.getMembers().get(i);
            row = this.tblMember.addRow();
            if (member.getBgIndex().getNumber() != null) {
                members = new ArrayList<BgDimensionMember>();
                members.add(member.getBgIndex());
                this.setIndexMember(row, members);
            } else {
                this.setIndexMember(row, null);
            }
            if (member.getDimMember() == null) continue;
            row.getCell(COL_REF_MEMBERS).setValue(member.getDimMember());
        }
        if (_filterParam.getBgOrgUnits() != null) {
            BgOrgUnitInfo[] bgOrgUnitsTemp = _filterParam.getBgOrgUnits();
            BgOrgUnitInfo[] bgOrgUnits = new BgOrgUnitInfo[_filterParam.getBgOrgUnits().length];
            int in2 = _filterParam.getBgOrgUnits().length;
            for (int i = 0; i < in2; ++i) {
                bgOrgUnits[i] = bgOrgUnitsTemp[i];
            }
            this.prmtBgOrgUnit.setDataNoNotify((Object)bgOrgUnits);
        } else {
            this.prmtBgOrgUnit.setDataNoNotify(null);
        }
        this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriod());
        this.prmtCurrency.setData((Object)_filterParam.getCurrency());
        this.prmtBgElement.setData((Object)_filterParam.getBgElement());
        this.prmtScenario.setData((Object)_filterParam.getBgScenario());
        this.prmtBgVersion.setData((Object)_filterParam.getBgVersion());
        this.cbxOnlyShowDetail.setSelected(_filterParam.isOnlyShowDetail());
        this.cbxOnlyShowAuditData.setSelected(_filterParam.isOnlyShowAuditData());
        this.prmtProcessType.setData((Object)_filterParam.getProcessTypeArray());
    }

    private String displayMembers(List<BgDimensionMember> members) {
        if (members == null || members.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BgDimensionMember bgDimensionMember : members) {
            if (this.accountViewId == null && this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
                this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
            }
            if (this.accountViewId != null) {
                sb.append(this.getCellHelper().getIndexDisplayName(this.accountViewId, bgDimensionMember)).append(",");
                continue;
            }
            sb.append(bgDimensionMember.getNumber()).append("(").append(bgDimensionMember.getName()).append(")").append(",");
        }
        sb = sb.deleteCharAt(sb.toString().lastIndexOf(","));
        return sb.toString();
    }

    @Override
    protected void saveToParams(FilterParam filterParam) {
        super.saveToParams(filterParam);
        if (!(filterParam instanceof MbgAdjustAnalyseFilterParam)) {
            return;
        }
        MbgAdjustAnalyseFilterParam _filterParam = (MbgAdjustAnalyseFilterParam)filterParam;
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            _filterParam.setBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        } else {
            _filterParam.setBgScheme(null);
        }
        _filterParam.getMembers().clear();
        MbgAdjustAnalyseMember member = null;
        if (this.tblMember.getRowCount() > 0) {
            IRow row = null;
            List members = null;
            int in = this.tblMember.getRowCount();
            for (int i = 0; i < in; ++i) {
                row = this.tblMember.getRow(i);
                member = new MbgAdjustAnalyseMember();
                if (row.getCell(COL_INDEX_MEMBERS).getValue() == null) {
                    row.getCell(COL_INDEX_MEMBERS).setUserObject(null);
                    member.setBgIndex(null);
                }
                if (row.getCell(COL_INDEX_MEMBERS).getUserObject() != null) {
                    members = (List)row.getCell(COL_INDEX_MEMBERS).getUserObject();
                    member.setBgIndex((BgDimensionMember)members.get(0));
                } else if (row.getCell(COL_INDEX_MEMBERS).getValue() == null) {
                    member = new MbgAdjustAnalyseMember();
                    member.setBgIndex(new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, null, null, null));
                    member.getBgIndex().setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
                    if (row.getCell(COL_REF_MEMBERS).getValue() == null) continue;
                }
                if (row.getCell(COL_REF_MEMBERS).getValue() != null) {
                    member.setDimMember((List)row.getCell(COL_REF_MEMBERS).getValue());
                }
                _filterParam.getMembers().add(member);
            }
        } else {
            member = new MbgAdjustAnalyseMember();
            member.setBgIndex(new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, null, null, null));
            member.getBgIndex().setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
            _filterParam.getMembers().add(member);
        }
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] orgUnits = (BgOrgUnitInfo[])this.prmtBgOrgUnit.getData();
            _filterParam.setBgOrgUnits(orgUnits);
        } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo _orgUnit = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            BgOrgUnitInfo[] orgUnits = new BgOrgUnitInfo[]{_orgUnit};
            _filterParam.setBgOrgUnits(orgUnits);
        }
        if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo[]) {
            _filterParam.setBgPeriod((BgPeriodInfo[])this.prmtBgPeriod.getData());
        } else {
            _filterParam.setBgPeriod(null);
        }
        if (this.prmtProcessType.getData() instanceof BgProcessEnum[]) {
            _filterParam.setProcessTypeArray((BgProcessEnum[])this.prmtProcessType.getData());
        } else if (this.prmtProcessType.getData() instanceof BgProcessEnum) {
            _filterParam.setProcessTypeArray(new BgProcessEnum[]{(BgProcessEnum)((Object)this.prmtProcessType.getData())});
        } else {
            _filterParam.setProcessTypeArray(null);
        }
        if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
            _filterParam.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        } else {
            _filterParam.setCurrency(null);
        }
        if (this.prmtBgElement.getData() instanceof BgElementInfo) {
            _filterParam.setBgElement((BgElementInfo)this.prmtBgElement.getData());
        } else {
            _filterParam.setBgElement(null);
        }
        if (this.prmtScenario.getData() instanceof BgScenarioInfo) {
            _filterParam.setBgScenario((BgScenarioInfo)this.prmtScenario.getData());
        } else {
            _filterParam.setBgScenario(null);
        }
        if (this.prmtBgVersion.getData() instanceof BgVersionInfo) {
            _filterParam.setBgVersion((BgVersionInfo)this.prmtBgVersion.getData());
        } else {
            _filterParam.setBgVersion(null);
        }
        _filterParam.setOnlyShowDetail(this.cbxOnlyShowDetail.isSelected());
        _filterParam.setOnlyShowAuditData(this.cbxOnlyShowAuditData.isSelected());
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        BgPeriodDialog dialog;
        BgPeriodDialog bgPeriodDialog = dialog = this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog ? (BgPeriodDialog)this.prmtBgPeriod.getSelector() : null;
        if (dialog != null) {
            if (e.getNewValue() instanceof BgPeriodInfo) {
                dialog.setBgPeriods(new BgPeriodInfo[]{(BgPeriodInfo)e.getNewValue()});
            } else if (e.getNewValue() instanceof BgPeriodInfo[]) {
                dialog.setBgPeriods((BgPeriodInfo[])e.getNewValue());
            } else if (e.getNewValue() instanceof BgPeriodCollection) {
                dialog.setBgPeriodCollection((BgPeriodCollection)e.getNewValue());
            } else if (e.getNewValue() == null) {
                dialog.setBgPeriods(null);
            }
        }
        this.setBgPeriodAliasDisp();
    }

    private void setBgPeriodAliasDisp() throws EASBizException, BOSException {
        if (this.prmtOrgUnit.getData() != null && this.prmtBgScheme.getData() != null && this.prmtBgPeriod.getData() != null && this.prmtOrgUnit.getData() instanceof OrgUnitInfo[] && ((OrgUnitInfo[])this.prmtOrgUnit.getData()).length == 1) {
            OrgUnitInfo _orgUnit = ((OrgUnitInfo[])this.prmtOrgUnit.getData())[0];
            String orgUnitId = _orgUnit.getId().toString();
            MbgAnalyseExeHelper.addDispNameForPeriods((Object[])((Object[])this.prmtBgPeriod.getData()), (BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
            BgNFCHelper.setBgPeriodF7Display(null, this.prmtBgPeriod, this.prmtBgScheme, orgUnitId);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.prmtBgScheme.setDataNoNotify(null);
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        try {
            this.setBgSchemeFilter();
            this.setOrgUnitFilter();
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        this.tblMember.removeRows();
        this.prmtBgPeriod.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtBgElement.setData(null);
        this.cbxOnlyShowDetail.setSelected(false);
        this.cbxOnlyShowAuditData.setSelected(false);
        this.prmtScenario.setData(null);
        this.prmtBgVersion.setData(null);
    }

    private void checkBgScheme() {
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtBgElement_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
        BgNFormListUI.addRollVersionFilter(this.prmtBgVersion);
    }

    @Override
    protected void prmtCurrency_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    @Override
    protected void prmtScenario_willShow(SelectorEvent e) throws Exception {
        this.checkBgScheme();
    }

    protected BgProcessSelectDialog getBgProcessTypeDialog() {
        BgProcessSelectDialog dialog = new BgProcessSelectDialog((IUIObject)this, true);
        return dialog;
    }

    @Override
    protected void prmtBgOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtBgOrgUnit_willShow(e);
        Object data = this.prmtBgScheme.getData();
        if (data == null) {
            this.prmtBgScheme.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)this.getResourceStr(), (String)"selectBgScheme"));
            e.setCanceled(true);
            return;
        }
        KDPromptSelector selector = this.prmtBgOrgUnit.getSelector();
        if (selector instanceof BgViewOrgDimensionF7) {
            BgViewOrgDimensionF7 f7 = (BgViewOrgDimensionF7)selector;
            HashSet<BgOrgUnitInfo> orgs = new HashSet<BgOrgUnitInfo>();
            if (this.prmtBgOrgUnit.getData() instanceof Object[]) {
                Object[] bgOrgUnits = (Object[])this.prmtBgOrgUnit.getData();
                if (bgOrgUnits != null) {
                    BgOrgUnitInfo info = null;
                    for (int i = 0; i < bgOrgUnits.length; ++i) {
                        info = (BgOrgUnitInfo)bgOrgUnits[i];
                        if (info == null) continue;
                        orgs.add(info);
                    }
                }
            } else if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
                orgs.add((BgOrgUnitInfo)this.prmtBgOrgUnit.getData());
            }
            f7.setSelectOrgInfos(orgs);
        }
    }

    @Override
    protected void prmtBgOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgOrgUnit_dataChanged(e);
    }

    protected void setOrgUnitFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        if (bgScheme == null) {
            return;
        }
        bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, number, name, orgUnit.id where id = '" + bgScheme.getId().toString() + "'");
        BgViewOrgDimensionF7 orgDialog = new BgViewOrgDimensionF7((IUIObject)this);
        orgDialog.setPermissionFilter(true);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgScheme.getId().toString());
        orgDialog.setBgOrgViewId(schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId());
        orgDialog.setOrgUnitId(bgScheme.getOrgUnit().getId().toString());
        orgDialog.setShowVirtualOrg(false);
        orgDialog.setOnlyNoLeaf(false);
        orgDialog.setOnlyLeaf(false);
        orgDialog.setMultipleSelect(true);
        this.prmtBgOrgUnit.setSelector((KDPromptSelector)orgDialog);
        this.setDefaultOrgUnit(orgDialog.getBgOrgViewId());
    }

    private void setDefaultOrgUnit(String bgOrgViewId) throws EASBizException, BOSException {
        if (DimensionCommonHelper.isEmpty(this.prmtOrgUnit.getData())) {
            return;
        }
        String costOrgId = null;
        costOrgId = this.prmtOrgUnit.getData() instanceof OrgUnitInfo[] ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString();
        String selectOrgUnitId = null;
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo o = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            if (StringUtils.isEmpty((String)o.getOrgUnitID())) {
                o = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, orgUnitId where id = '" + o.getId() + "'");
            }
            selectOrgUnitId = o.getOrgUnitID();
        } else if (this.prmtBgOrgUnit.getData() instanceof OrgUnitInfo) {
            selectOrgUnitId = ((OrgUnitInfo)this.prmtBgOrgUnit.getData()).getId().toString();
        }
        if (selectOrgUnitId == null) {
            selectOrgUnitId = "000000000000000000000000000=";
        }
        BgOrgUnitCollection defaultOrg = null;
        defaultOrg = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select * where isVirtual = 0  and viewId = '" + bgOrgViewId + "' and (orgUnitId = '" + costOrgId + "' or orgUnitId = '" + selectOrgUnitId + "')");
        if (defaultOrg == null || defaultOrg.size() == 0) {
            this.prmtBgOrgUnit.setData(null);
        } else if (defaultOrg.size() == 1) {
            this.prmtBgOrgUnit.setData((Object)defaultOrg.get(0));
        } else {
            for (int i = 0; i < defaultOrg.size(); ++i) {
                if (!costOrgId.equals(defaultOrg.get(i).getOrgUnitID())) continue;
                this.prmtBgOrgUnit.setData((Object)defaultOrg.get(i));
                break;
            }
        }
    }

    private class IndexMemberDTO {
        private String indexSrcNumber;
        private String memberNumber;

        public IndexMemberDTO(String indexSrcNumber, String memberNumber) {
            if (indexSrcNumber == null) {
                throw new IllegalArgumentException("Index group must has value!");
            }
            this.indexSrcNumber = indexSrcNumber;
            this.memberNumber = memberNumber;
        }

        public String getIndexSrcNumber() {
            return this.indexSrcNumber;
        }

        public void setIndexSrcNumber(String indexSrcNumber) {
            this.indexSrcNumber = indexSrcNumber;
        }

        public String getMemberNumber() {
            return this.memberNumber;
        }

        public void setMemberNumber(String memberNumber) {
            this.memberNumber = memberNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.indexSrcNumber == null ? 0 : this.indexSrcNumber.hashCode());
            result = 31 * result + (this.memberNumber == null ? 0 : this.memberNumber.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexMemberDTO other = (IndexMemberDTO)obj;
            if (this.indexSrcNumber == null ? other.indexSrcNumber != null : !this.indexSrcNumber.equals(other.indexSrcNumber)) {
                return false;
            }
            if (StringUtils.isEmpty((String)this.memberNumber) || StringUtils.isEmpty((String)other.memberNumber)) {
                return true;
            }
            return this.memberNumber.equals(other.memberNumber);
        }
    }
}

