/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.mbg.BgAdjustBillTypeEnum;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgAdjustFormBlockSetUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustFormProcessUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustFormSpecialProcessUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustViewFormProcessUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustViewFormSelectProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBGAdjustBillHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class MbgAdjustFormBlockSetUI
extends AbstractMbgAdjustFormBlockSetUI {
    private static final long serialVersionUID = -770530881765551584L;
    private static final Logger logger = CoreUIObject.getLogger(MbgAdjustFormBlockSetUI.class);
    private BgOrgUnitInfo selectedOrgUnit;
    private BgOrgUnitInfo currOrgUnit = null;
    private BgFormInfo bgform = null;
    private boolean isClearEntry = false;
    protected BgSchemeDimensionHelper schemeHelper = null;
    private String schemeID = null;
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private boolean hasCancel = true;
    private List<ItemFormula> data = new ArrayList<ItemFormula>();

    public boolean isClearEntry() {
        return this.isClearEntry;
    }

    public void setClearEntry(boolean isClearEntry) {
        this.isClearEntry = isClearEntry;
    }

    public BgFormInfo getBgform() {
        return this.bgform;
    }

    public void setBgform(BgFormInfo bgform) {
        this.bgform = bgform;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.schemeID);
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        this.init();
        this.schemeID = (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        super.onLoad();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtQuery, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtQuery.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MbgAdjustFormBlockSetUI.this.execQuery();
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.toolBar.setEnabled(false);
        this.toolBar.setVisible(false);
    }

    protected void init() throws Exception {
        this.initOrgUnit();
        this.initTable();
    }

    protected void initOrgUnit() throws Exception {
        BgOrgUnitInfo _orgUnit = null;
        BgOrgUnitInfo[] _orgUnits = null;
        Object obj = this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS);
        if (obj != null && obj instanceof List) {
            List _orgUnitLs = (List)obj;
            _orgUnits = new BgOrgUnitInfo[_orgUnitLs.size()];
            int in = _orgUnitLs.size();
            for (int i = 0; i < in; ++i) {
                _orgUnits[i] = _orgUnit = (BgOrgUnitInfo)_orgUnitLs.get(i);
            }
        }
        if (!EmptyUtil.isEmpty(_orgUnits)) {
            this.prmtOrgUnit.setValue((Object)_orgUnits[0]);
        }
        this.initOrgUnit((String)this.getUIContext().get("orgViewId"));
        Object object = this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        if (object != null && object instanceof String) {
            this.setCurrOrgUnit(new BgOrgUnitInfo());
            this.getCurrOrgUnit().setId(BOSUuid.read((String)((String)object)));
        } else if (object != null && object instanceof BgOrgUnitInfo) {
            this.setCurrOrgUnit((BgOrgUnitInfo)object);
            this.prmtOrgUnit.setValue(object);
        } else if (object != null && object instanceof BgOrgUnitInfo[]) {
            this.prmtOrgUnit.setValue(object);
        }
        Object object1 = this.getUIContext().get(BgBaseConstants.ADJUST_WAY);
        if (object1 != null && (BgAdjustBillTypeEnum.inOrg.equals(object1) || BgAdjustBillTypeEnum.INORGADJUST.equals(object1))) {
            this.prmtOrgUnit.setEditable(false);
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    private void initOrgUnit(String bgOrgViewId) {
        Set orgIds;
        BgNewOrgDialog orgUnitDim = new BgNewOrgDialog();
        orgUnitDim.setMultipleSelect(false);
        orgUnitDim.setBgOrgViewId(bgOrgViewId);
        if (BgParamCHelper.isBgAdjustBillFilterOrgRange()) {
            orgUnitDim.setPermissionFilter(true);
        } else {
            orgUnitDim.setPermissionFilter(false);
        }
        if (this.getUIContext().get("isShowVirtualOrg") != null) {
            orgUnitDim.setShowVirtualOrg(!Boolean.FALSE.equals(this.getUIContext().get("isShowVirtualOrg")));
        }
        if (this.getUIContext().get("isFromAdjust") != null && Boolean.TRUE.equals(this.getUIContext().get("isFromAdjust")) && this.getUIContext().get("processType") instanceof BgProcessEnum) {
            if (BgProcessEnum.C01.equals(this.getUIContext().get("processType"))) {
                orgUnitDim.setOnlyLeaf(true);
            } else {
                orgUnitDim.setOnlyNoLeaf(true);
            }
        }
        if (this.getUIContext().get("orgIds") != null && this.getUIContext().get("orgIds") instanceof Set && !(orgIds = (Set)this.getUIContext().get("orgIds")).isEmpty()) {
            orgUnitDim.setCanSelectOrgIds(orgIds);
            if (this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo && ((BgOrgUnitInfo)this.prmtOrgUnit.getData()).getOrgUnitID() != null && !orgIds.contains(((BgOrgUnitInfo)this.prmtOrgUnit.getData()).getOrgUnitID())) {
                this.prmtOrgUnit.setData(null);
            }
        }
        orgUnitDim.setOrgUnitId(this.getUIContext().get(BgBaseConstants.ORGUNIT_ID).toString());
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgUnitDim);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        Object obj = this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        Object currencyID = this.getUIContext().get(BgBaseConstants.CURRENCY_ID);
        Object bgVersionInfo = this.getUIContext().get(BgBaseConstants.BGVERSION_INFO);
        this.addDefaultFilter(filter, "bgScheme.id", obj);
        if (currencyID != null) {
            this.addDefaultFilter(filter, "currency.id", currencyID);
        }
        if (bgVersionInfo != null) {
            String bgVersionID = bgVersionInfo == null ? null : ((BgVersionInfo)bgVersionInfo).getId().toString();
            this.addDefaultFilter(filter, "bgVersion.id", bgVersionID);
        }
        this.addDefaultFilter(filter, "bgVersion.isRollVersion", false);
        this.addDefaultFilter(filter, "isRolled", false);
        if (this.getUIContext().get("processType") instanceof BgProcessEnum) {
            BgProcessEnum processType = (BgProcessEnum)((Object)this.getUIContext().get("processType"));
            this.addDefaultFilter(filter, "processType", processType.getValue());
        }
        filter.getFilterItems().add(new FilterItemInfo("state", this.getDefaultState(), CompareType.INCLUDE));
        return filter;
    }

    protected void addDefaultFilter(FilterInfo filter, String compareExpr, Object compareValue) {
        if (compareValue != null) {
            filter.getFilterItems().add(new FilterItemInfo(compareExpr, compareValue));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)BgBaseConstants.nullID, CompareType.EQUALS));
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        String bgSpecialItemsNumber = null;
        try {
            if (this.getSchemeHelper() != null) {
                Map<String, BgDimensionInfo> map = this.getSchemeHelper().getDimensionBySrcNumber();
                int in = e.getLastRow();
                for (int i = e.getFirstRow(); i <= in; ++i) {
                    String bgSpecialItemsName = null;
                    String bgSpecialItemsNames = null;
                    if (this.tblMain.getCell(i, "bgSpecialItemsNumber") == null) continue;
                    bgSpecialItemsNumber = (String)this.tblMain.getCell(i, "bgSpecialItemsNumber").getValue();
                    bgSpecialItemsNames = (String)this.tblMain.getCell(i, "bgSpeItems").getValue();
                    if (StringUtils.isEmpty((String)bgSpecialItemsNumber)) continue;
                    String[] srcNumber = bgSpecialItemsNumber.split(",");
                    String[] srcName = bgSpecialItemsNames.split(",");
                    for (int j = 0; j < srcNumber.length; ++j) {
                        String src = srcNumber[j].split(":")[0];
                        String name = srcName[j].split(":")[1];
                        if (!map.containsKey(src)) continue;
                        bgSpecialItemsName = bgSpecialItemsName == null ? map.get(src).getName() + ":" + name : bgSpecialItemsName + "," + map.get(src).getName() + ":" + name;
                    }
                    if (StringUtils.isEmpty(bgSpecialItemsName)) continue;
                    this.tblMain.getCell(i, "bgSpeItems").setValue(bgSpecialItemsName);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected Set<Integer> getDefaultState() {
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(2));
        state.add(new Integer(50));
        state.add(new Integer(51));
        return state;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor executor = super.getQueryExecutor(queryPK, viewInfo);
        FilterInfo filter = this.getDefaultFilterForQuery();
        HashSet<String> tmpOrgUnitIds = new HashSet<String>();
        if (this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo orgUnit = (BgOrgUnitInfo)this.prmtOrgUnit.getData();
            tmpOrgUnitIds.add(orgUnit.getOrgUnitID());
        } else if (this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            BgOrgUnitInfo[] orgUnits = (BgOrgUnitInfo[])this.prmtOrgUnit.getData();
            int in = orgUnits.length;
            for (int i = 0; i < in; ++i) {
                tmpOrgUnitIds.add(orgUnits[i].getOrgUnitID());
            }
        }
        if (tmpOrgUnitIds.isEmpty()) {
            tmpOrgUnitIds.add(BgBaseConstants.nullID);
        } else {
            Object obj = this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
            if (obj != null) {
                try {
                    Set bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (String)obj);
                    if (!bgOrgUnitPer.isEmpty()) {
                        Iterator iterator = tmpOrgUnitIds.iterator();
                        while (iterator.hasNext()) {
                            String orgunitid = (String)iterator.next();
                            if (bgOrgUnitPer.contains(orgunitid)) continue;
                            iterator.remove();
                        }
                        if (tmpOrgUnitIds.isEmpty()) {
                            tmpOrgUnitIds.add("000000000000000000000000000=");
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    this.handUIException(e);
                }
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", tmpOrgUnitIds, CompareType.INCLUDE));
        int size1 = filter.getFilterItems().size();
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < size1; ++i) {
            if (i == size1 - 1) {
                sql.append("#").append(i);
                continue;
            }
            sql.append("#").append(i).append(" AND ");
        }
        if (!StringUtils.isEmpty((String)this.txtQuery.getText())) {
            String txt = "%" + this.txtQuery.getText().trim() + "%";
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.number", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.name", (Object)txt, CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("currency.name", (Object)txt, CompareType.LIKE));
            int size2 = filter.getFilterItems().size();
            for (int i = size1; i < size2; ++i) {
                if (i == size1) {
                    sql.append(" AND (").append("#").append(i).append(" OR ");
                    continue;
                }
                if (i == size2 - 1) {
                    sql.append("#").append(i).append(")");
                    continue;
                }
                sql.append("#").append(i).append(" OR ");
            }
            filter.setMaskString(sql.toString());
        }
        String obj = (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        try {
            if (!StringUtils.isEmpty((String)obj)) {
                BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select bgSchemeType.schemeType, id where id = '" + obj + "'");
                try {
                    MbgPermissionHelper.addFieldDataPermission(bgSchemeInfo.getBgSchemeType().getSchemeType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), filter, MbgPermissionTypeEnum.TEMPLATE, "bgtemplate.id", obj, true);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        viewInfo.setFilter(filter);
        return executor;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        Object obj = e.getNewValue();
        if (obj != null && obj instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo info = (BgOrgUnitInfo)obj;
            if (this.getUIContext().get("processType") instanceof BgProcessEnum) {
                BgProcessEnum processType = (BgProcessEnum)((Object)this.getUIContext().get("processType"));
                if (!DimensionCommonHelper.isDecompose(processType) && !info.isIsLeaf()) {
                    this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
                } else if (DimensionCommonHelper.isDecompose(processType) && info.isIsLeaf()) {
                    this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
                }
            }
            if (info.isIsVirtual()) {
                this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
                MsgBox.showError((String)MBGAdjustBillHelper.getString("selectOnlyNoVirtualBgOrg"));
                SysUtil.abort();
            }
        }
        this.execQuery();
    }

    @Override
    protected void btnTxtQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnTxtQuery_actionPerformed(e);
        this.execQuery();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.openFormUI();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    private void openFormUI() throws BOSException, EASBizException, UIException {
        this.checkSelected();
        BOSUuid bgFormId = BOSUuid.read((String)this.getSelectedKeyValue());
        BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo("select id, orgUnit.id, orgUnit.CU.id, bgTemplate.formType, bgVersion.number where id = '" + bgFormId + "'");
        this.setBgform(bgForm);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgFormId);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)bgForm.getOrgUnit());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)bgForm.getOrgUnit().getCU());
        uiContext.put((Object)"type", (Object)bgForm.getBgTemplate().getFormType());
        uiContext.put((Object)BgBaseConstants.BGVERSION_INFO, this.getUIContext().get(BgBaseConstants.BGVERSION_INFO));
        uiContext.put((Object)BgBaseConstants.BGSCENARIO_INFO, this.getUIContext().get(BgBaseConstants.BGSCENARIO_INFO));
        uiContext.put((Object)BgBaseConstants.CURRENCY_INFO, this.getUIContext().get(BgBaseConstants.CURRENCY_INFO));
        uiContext.put((Object)BgBaseConstants.BGELEMENT_INFO, this.getUIContext().get(BgBaseConstants.BGELEMENT_INFO));
        uiContext.put((Object)"isAdjustEntryScenAndEle", this.getUIContext().get("isAdjustEntryScenAndEle"));
        uiContext.put((Object)BgBaseConstants.ADJUST_WAY, this.getUIContext().get(BgBaseConstants.ADJUST_WAY));
        uiContext.put((Object)"BGSCHEME_HELPER", this.getUIContext().get("BGSCHEME_HELPER"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(bgForm), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        List formulas = null;
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType()) || BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
            BgAdjustViewFormProcessUI f7UI = (BgAdjustViewFormProcessUI)uiWindow.getUIObject();
            formulas = f7UI.getFormulaList();
            this.isClearEntry = f7UI.isClearEntry();
        } else if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            BgAdjustFormSpecialProcessUI f7UI = (BgAdjustFormSpecialProcessUI)uiWindow.getUIObject();
            formulas = f7UI.getFormulaList();
            this.isClearEntry = f7UI.isClearEntry();
        } else {
            BgAdjustFormProcessUI f7UI = (BgAdjustFormProcessUI)uiWindow.getUIObject();
            formulas = f7UI.getFormulaList();
            this.isClearEntry = f7UI.isClearEntry();
        }
        if (formulas != null && !formulas.isEmpty()) {
            this.getData().clear();
            this.getData().addAll(formulas);
            if (this.prmtOrgUnit.getData() != null && this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo) {
                this.setSelectedOrgUnit((BgOrgUnitInfo)this.prmtOrgUnit.getData());
            } else if (this.prmtOrgUnit.getData() != null && this.prmtOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
                this.setSelectedOrgUnit(((BgOrgUnitInfo[])this.prmtOrgUnit.getData())[0]);
            }
            this.close(false);
        }
    }

    protected String getEditUIName(BgFormInfo bgForm) {
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return this.getViewFormEditName();
        }
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return this.getViewFormEditName();
        }
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return BgAdjustFormSpecialProcessUI.class.getName();
        }
        return this.getFixFormEditName();
    }

    protected boolean isMultiSelect() {
        return false;
    }

    protected void initTable() {
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        EntityViewInfo view = super.getDefaultEntityViewInfo();
        return view;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getViewFormEditName() {
        return BgAdjustViewFormSelectProcessUI.class.getName();
    }

    protected String getFixFormEditName() {
        return BgAdjustFormProcessUI.class.getName();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void close(boolean hasCancel) {
        this.setHasCancel(hasCancel);
        this.getUIWindow().close();
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.openFormUI();
    }

    @Override
    protected void btnExit_actionPerformed(ActionEvent e) throws Exception {
        super.btnExit_actionPerformed(e);
        this.close(true);
    }

    public void checkSelected() {
        Object obj = this.prmtOrgUnit.getData();
        if (obj == null) {
            MsgBox.showError((String)MBGAdjustBillHelper.getString("selectOrgFirst"));
            SysUtil.abort();
        }
        super.checkSelected();
    }

    public void setSelectedOrgUnit(BgOrgUnitInfo selectedOrgUnit) throws EASBizException, BOSException {
        if (selectedOrgUnit != null && !BgOrgUnitInfo.class.isInstance(selectedOrgUnit)) {
            selectedOrgUnit = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo((IObjectPK)new ObjectSingleKey((Object)selectedOrgUnit.getId()));
        }
        this.selectedOrgUnit = selectedOrgUnit;
    }

    public BgOrgUnitInfo getSelectedOrgUnit() {
        return this.selectedOrgUnit;
    }

    public BgOrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public void setCurrOrgUnit(BgOrgUnitInfo currOrgUnit) {
        this.currOrgUnit = currOrgUnit;
    }

    public CtrlUnitInfo getCurrCU() {
        return this.currCU;
    }

    public void setCurrCU(CtrlUnitInfo currCU) {
        this.currCU = currCU;
    }

    public boolean isHasCancel() {
        return this.hasCancel;
    }

    public void setHasCancel(boolean hasCancel) {
        this.hasCancel = hasCancel;
    }

    public List<ItemFormula> getData() {
        return this.data;
    }
}

