/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.MbgExchangeRateInfo;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgCurrencyTransReportUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class MbgCurrencyTransReportUI
extends AbstractMbgCurrencyTransReportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgCurrencyTransReportUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        BgSchemeInfo defBgSchemeInfo = null;
        OrgUnitInfo defOrgUnitInfo = null;
        if (this.getUIContext().get("BGSCHEME_INFO") instanceof BgSchemeInfo) {
            defBgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
            this.prmtBgScheme.setData((Object)defBgSchemeInfo);
        }
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) instanceof OrgUnitInfo) {
            defOrgUnitInfo = (OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
            this.prmtOrgUnit.setData((Object)defOrgUnitInfo);
        }
    }

    protected void init() throws EASBizException, BOSException {
        this.initPrmtOrgUnit();
        this.initPrmtBgScheme();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        String bgSchemeId = this.getBgSchemeId() != null ? this.getBgSchemeId() : "000000000000000000000000000=";
        String orgUnitId = this.getOrgUnitId() != null ? this.getOrgUnitId() : "000000000000000000000000000=";
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null || filter.getFilterItems().size() == 0) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bgSchemeId", (Object)bgSchemeId, CompareType.EQUALS));
        } else if (BgNFCHelper.findFilterItem(filter, "bgSchemeId") == null) {
            filter.getFilterItems().add(new FilterItemInfo("bgSchemeId", (Object)bgSchemeId, CompareType.EQUALS));
            filter.setMaskString("(" + filter.getMaskString() + ")AND #" + (filter.getFilterItems().size() - 1));
        } else {
            BgNFCHelper.replaceFilterItems(filter, new FilterItemInfo("bgSchemeId", (Object)bgSchemeId, CompareType.EQUALS));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        IRow row = null;
        String orgUnitNumber = null;
        String sourceBgFormNumber = null;
        String bgTemplateNumber = null;
        String rateSchemeNumber = null;
        String targeBgFormNumber = null;
        MbgExchangeRateInfo info = null;
        for (int index = e.getFirstRow(); index <= e.getLastRow(); ++index) {
            row = this.tblMain.getRow(index);
            if (row.getUserObject() instanceof MbgExchangeRateInfo) continue;
            if (row.getCell("orgUnitNumber") != null && row.getCell("orgUnitNumber").getValue() != null) {
                orgUnitNumber = row.getCell("orgUnitNumber").getValue().toString();
                row.getCell("orgUnitName").setValue((Object)(orgUnitNumber + "(" + row.getCell("orgUnitName").getValue().toString() + ")"));
            }
            if (row.getCell("sourceBgFormNumber") != null && row.getCell("sourceBgFormNumber").getValue() != null) {
                sourceBgFormNumber = row.getCell("sourceBgFormNumber").getValue().toString();
                row.getCell("sourceBgFormName").setValue((Object)(sourceBgFormNumber + "(" + row.getCell("sourceBgFormName").getValue().toString() + ")"));
            }
            if (row.getCell("bgTemplateNumber") != null && row.getCell("bgTemplateNumber").getValue() != null) {
                bgTemplateNumber = row.getCell("bgTemplateNumber").getValue().toString();
                row.getCell("bgTemplateName").setValue((Object)(bgTemplateNumber + "(" + row.getCell("bgTemplateName").getValue().toString() + ")"));
            }
            if (row.getCell("rateSchemeNumber") != null && row.getCell("rateSchemeNumber").getValue() != null) {
                rateSchemeNumber = row.getCell("rateSchemeNumber").getValue().toString();
                row.getCell("rateSchemeName").setValue((Object)(rateSchemeNumber + "(" + row.getCell("rateSchemeName").getValue().toString() + ")"));
            }
            if (row.getCell("targeBgFormNumber") != null && row.getCell("targeBgFormNumber").getValue() != null) {
                targeBgFormNumber = row.getCell("targeBgFormNumber").getValue().toString();
                row.getCell("targeBgFormName").setValue((Object)(targeBgFormNumber + "(" + row.getCell("targeBgFormName").getValue().toString() + ")"));
            }
            info = new MbgExchangeRateInfo();
            if (row.getCell("id").getValue() != null) {
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            row.setUserObject((Object)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        try {
            if (newInfo == null && e.getOldValue() != null && this.prmtBgScheme.getUserObject() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
                this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
                this.refreshList();
            }
        }
        finally {
            this.prmtBgScheme.setUserObject(null);
        }
    }

    protected void initPrmtBgScheme() throws EASBizException, BOSException {
        this.setBgSchemeFilter();
    }

    public void setBgSchemeFilter() throws EASBizException, BOSException {
        if (this.prmtOrgUnit.getData() != null) {
            BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.prmtOrgUnit.getData(), null, false, this.getSourceType(), false, false);
            BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, this.getSourceType(), ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId());
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    protected void initPrmtOrgUnit() {
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
    }

    public String getPermissionNum() {
        return "mbg_form01_list";
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        OrgUnitInfo oldInfo = (OrgUnitInfo)e.getOldValue();
        OrgUnitInfo newInfo = (OrgUnitInfo)e.getNewValue();
        if (newInfo == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
            this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
        } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
            this.setBgSchemeFilter();
        }
    }

    protected String getOrgUnitId() {
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            return ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString();
        }
        return null;
    }

    protected String getBgSchemeId() {
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            return ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString();
        }
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"rateSchemeName", "orgUnitName"};
        return locateNames;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

