/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.client.utils.NumberExpandExtInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataAnalyseNumberExpendRender
extends NumberExpendRender {
    private static final Logger logger = CoreUIObject.getLogger(MbgDataAnalyseNumberExpendRender.class);
    private static final String NUMBERANDNAME = "0";
    private static final String NAME = "1";
    private static final String LONGNAME = "2";
    private Map<String, Map<String, String>> orgMap = new HashMap<String, Map<String, String>>();
    private BgSchemeInfo schemeInfo = null;
    private String schemeId = null;
    private Map<String, Map<String, String>> accountMap = new HashMap<String, Map<String, String>>();

    public MbgDataAnalyseNumberExpendRender(int showType) {
        super(showType);
    }

    public MbgDataAnalyseNumberExpendRender(String bgSchemeId) {
        super(0);
        this.setSchemeId(bgSchemeId);
    }

    public Map<String, Map<String, String>> getOrgMap() {
        return this.orgMap;
    }

    public void setOrgMap(Map<String, Map<String, String>> orgMap) {
        this.orgMap = orgMap;
    }

    private Map<String, String> getInitOrgs(String viewId) throws BOSException {
        HashMap<String, String> orgMap = new HashMap<String, String>();
        if (viewId == null) {
            return orgMap;
        }
        if (this.getOrgMap().containsKey(viewId)) {
            return this.getOrgMap().get(viewId);
        }
        try {
            IBgOrgUnit remoteInstance = BgOrgUnitFactory.getRemoteInstance();
            if (remoteInstance == null) {
                return orgMap;
            }
            BgOrgUnitCollection bgOrgUnitCollection = remoteInstance.getBgOrgUnitCollection("where viewID = '" + viewId + "'");
            if (bgOrgUnitCollection != null && bgOrgUnitCollection.size() > 0) {
                String[] numbers;
                String[] lns = null;
                BgOrgUnitInfo info = null;
                HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
                HashMap<String, Set<String>> parentMap = new HashMap<String, Set<String>>();
                HashMap<String, Set<String>> longNumberMap = new HashMap<String, Set<String>>();
                int size = bgOrgUnitCollection.size();
                for (int index = 0; index < size; ++index) {
                    info = bgOrgUnitCollection.get(index);
                    if (info.getNumber() == null) continue;
                    if (!this.getOrgMap().containsKey(viewId)) {
                        this.getOrgMap().put(viewId, new HashMap());
                    }
                    if (!StringUtils.isEmpty((String)info.getDisplayName())) {
                        this.getOrgMap().get(viewId).put(info.getLongNumber(), info.getDisplayName());
                    } else {
                        this.getOrgMap().get(viewId).put(info.getLongNumber(), info.getName());
                    }
                    orgUnitMap.put(info.getNumber(), info);
                    lns = info.getLongNumber().split("!");
                    if (lns.length <= 1) continue;
                    if (!parentMap.containsKey(info.getNumber())) {
                        parentMap.put(info.getNumber(), new HashSet());
                    }
                    ((Set)parentMap.get(info.getNumber())).add(lns[lns.length - 2]);
                }
                for (String thisNumber : numbers = parentMap.keySet().toArray(new String[0])) {
                    this.buildDisplayName(thisNumber, parentMap, orgUnitMap, this.getOrgMap().get(viewId), longNumberMap);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("MbgDataAnalyseNumberExpendRender getInitOrgs error:" + e.getMessage()));
            throw e;
        }
        return orgMap;
    }

    private void buildDisplayName(String thisNumber, Map<String, Set<String>> parentMap, Map<String, BgOrgUnitInfo> orgUnitMap, Map<String, String> displayNameMap, Map<String, Set<String>> longNumberMap) {
        Set<String> parentSet = parentMap.get(thisNumber);
        if (!longNumberMap.containsKey(thisNumber)) {
            longNumberMap.put(thisNumber, new HashSet());
        }
        if (parentSet == null || parentSet.isEmpty()) {
            longNumberMap.get(thisNumber).add(thisNumber);
            if (displayNameMap.get(thisNumber) == null) {
                displayNameMap.put(thisNumber, orgUnitMap.get(thisNumber).getName());
            }
        } else {
            for (String parent : parentSet) {
                this.buildDisplayName(parent, parentMap, orgUnitMap, displayNameMap, longNumberMap);
                for (String pLongNumber : longNumberMap.get(parent)) {
                    String parentDisplayName = displayNameMap.get(pLongNumber);
                    String thisLongNumber = pLongNumber + "!" + thisNumber;
                    longNumberMap.get(thisNumber).add(thisLongNumber);
                    displayNameMap.put(thisLongNumber, parentDisplayName + "_" + orgUnitMap.get(thisNumber).getName());
                }
            }
        }
    }

    public BgSchemeInfo getBgScheme() throws Exception {
        String bgScehemeId = this.getBgSchemeId();
        if (this.schemeInfo == null || !this.schemeInfo.getId().toString().equals(bgScehemeId)) {
            this.schemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, name, number, bgDimSettings.members.*, bgDimSettings.dimNumber where id='" + bgScehemeId + "'");
        }
        return this.schemeInfo;
    }

    public void setSchemeId(String schemeId) {
        this.schemeId = schemeId;
    }

    public String getBgSchemeId() throws Exception {
        return this.schemeId;
    }

    public Map<String, Map<String, String>> getAccountMap() {
        return this.accountMap;
    }

    public void setAccountMap(Map<String, Map<String, String>> accountMap) {
        this.accountMap = accountMap;
    }

    private Map<String, String> getInitAccounts(String viewId) throws BOSException {
        HashMap<String, String> accountMap = new HashMap<String, String>();
        if (viewId == null) {
            return accountMap;
        }
        if (this.getAccountMap().containsKey(viewId)) {
            return this.getAccountMap().get(viewId);
        }
        try {
            IBgAccount iBgAccount = BgAccountFactory.getRemoteInstance();
            if (iBgAccount == null) {
                return accountMap;
            }
            BgAccountCollection colls = iBgAccount.getBgAccountCollection("select number, name, displayName where bgAccountView = '" + viewId + "'");
            if (colls != null && colls.size() > 0) {
                BgAccountInfo info = null;
                int size = colls.size();
                for (int index = 0; index < size; ++index) {
                    info = colls.get(index);
                    if (info.getNumber() == null) continue;
                    if (!this.getAccountMap().containsKey(viewId)) {
                        this.getAccountMap().put(viewId, new HashMap());
                    }
                    if (!StringUtils.isEmpty((String)info.getDisplayName())) {
                        this.getAccountMap().get(viewId).put(info.getNumber(), info.getDisplayName());
                        continue;
                    }
                    this.getAccountMap().get(viewId).put(info.getNumber(), info.getName());
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("MbgDataAnalyseNumberExpendRender getInitAccounts error:" + e.getMessage()));
            throw e;
        }
        return accountMap;
    }

    protected String getDisplayValueByShowType(NumberExpandInfo numberExpandInfo) {
        String displayName;
        block17: {
            displayName = null;
            try {
                this.schemeInfo = this.getBgScheme();
                String accViewId = this.schemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString();
                Set<String> orgViewIds = this.schemeInfo.getOrgViewIds();
                String orgViewId = null;
                if (orgViewIds.size() == 1) {
                    orgViewId = orgViewIds.toArray(new String[0])[0];
                }
                if (this.getOrgMap().isEmpty()) {
                    this.getInitOrgs(orgViewId);
                }
                if (this.getAccountMap().isEmpty()) {
                    this.getInitAccounts(accViewId);
                }
                if (!(numberExpandInfo instanceof NumberExpandExtInfo)) break block17;
                NumberExpandExtInfo expend = (NumberExpandExtInfo)numberExpandInfo;
                String number = expend.getNumber();
                String name = expend.getName();
                String longNumber = expend.getLongNumber();
                String type = expend.getDimension().getNumber();
                if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(type)) {
                    String bgIndexNameStyle = BgParamCHelper.getMbgShowStyle();
                    if (NUMBERANDNAME.equals(bgIndexNameStyle)) {
                        displayName = number + "(" + name + ")";
                    } else if (NAME.equals(bgIndexNameStyle)) {
                        displayName = name;
                    } else if (LONGNAME.equals(bgIndexNameStyle)) {
                        displayName = this.getAccountMap().get(accViewId).get(number);
                    }
                    break block17;
                }
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(type)) {
                    String bgIndexNameStyle = BgParamCHelper.getBgOrgShowStyle();
                    if (NUMBERANDNAME.equals(bgIndexNameStyle)) {
                        displayName = number + "(" + name + ")";
                    } else if (NAME.equals(bgIndexNameStyle)) {
                        displayName = name;
                    } else if (LONGNAME.equals(bgIndexNameStyle)) {
                        displayName = orgViewId != null ? this.getOrgMap().get(orgViewId).get(longNumber) : name;
                    }
                    break block17;
                }
                return super.getDisplayValueByShowType(numberExpandInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("MbgDataAnalyseNumberExpendRender getDisplayValueByShowType error:" + e.getMessage()));
            }
        }
        return displayName;
    }
}

