/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.client.MBgAnalayseExeViewProcessUI;
import com.kingdee.eas.ma.control.client.MBgAnalyseExeProcessUI;
import com.kingdee.eas.ma.control.client.MBgAnalyseExeSpecialProcessUI;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordFactory;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MbgDataQueryTypeEnum;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDataQueryFilterUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.MbgAnalyseDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.MbgItemSelectProcessUI;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.IMbgSelectProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.MbgCslClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.MbgDataQueryFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MbgDataQueryFilterUI
extends AbstractMbgDataQueryFilterUI {
    private static final long serialVersionUID = -2168081936199427189L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDataQueryFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.MbgDataQueryResource";
    protected static final String COL_INDEX_MEMBERS = "bgIndexMember";
    protected static final String COL_REF_MEMBERS = "dimMember";
    private KDRadioButton lastButton;
    private BgSchemeDimensionHelper schemeHelper;
    private BgCellRenderHelper cellHelper;
    String accountViewId;

    public BgSchemeDimensionHelper getSchemeHelper() throws BOSException, EASBizException {
        if (this.schemeHelper == null && this.getSelectBgScheme() != null) {
            if (MbgDataQueryFilterUI.isCsl(this.getQueryType(this.lastButton))) {
                if (this.cboCslOrgTree.getSelectedItem() != null) {
                    this.schemeHelper = MbgCslClientHelper.getInstance().createSchemeHelper(this.getSelectBgScheme().getId().toString(), (OrgTreeInfo)this.cboCslOrgTree.getSelectedItem());
                }
            } else {
                this.schemeHelper = new BgSchemeDimensionHelper(this.getSelectBgScheme().getId().toString());
            }
        }
        return this.schemeHelper;
    }

    public void clearSchemeHelper() {
        this.schemeHelper = null;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public MbgDataQueryFilterUI() throws Exception {
        this.lastButton = this.rdoBgForm;
        this.schemeHelper = null;
        this.cellHelper = new BgCellRenderHelper();
        this.accountViewId = null;
    }

    protected MbgDataQueryTypeEnum getQueryType(KDRadioButton rdo) {
        if (rdo == this.rdoActualForm) {
            return MbgDataQueryTypeEnum.ActualForm;
        }
        if (rdo == this.rdoCslForm) {
            return MbgDataQueryTypeEnum.CslForm;
        }
        if (rdo == this.rdoCslAdjForm) {
            return MbgDataQueryTypeEnum.CslAdjForm;
        }
        if (rdo == this.rdoWorkPaper) {
            return MbgDataQueryTypeEnum.WorkPaper;
        }
        return MbgDataQueryTypeEnum.BgForm;
    }

    protected static boolean isCsl(MbgDataQueryTypeEnum queryType) {
        return MbgDataQueryFilterParam.isCsl(queryType);
    }

    protected BgProcessEnum getProcessType() {
        KDRadioButton rdoProcessType = this.rdoC01;
        if (this.rdoC02.isSelected()) {
            rdoProcessType = this.rdoC02;
        } else if (this.rdoC04.isSelected()) {
            rdoProcessType = this.rdoC04;
        }
        return this.getProcessType(rdoProcessType);
    }

    protected BgProcessEnum getProcessType(KDRadioButton rdoProcessType) {
        if (rdoProcessType == this.rdoC02) {
            return BgProcessEnum.C02;
        }
        if (rdoProcessType == this.rdoC04) {
            return BgProcessEnum.C04;
        }
        return BgProcessEnum.C01;
    }

    @Override
    public void onLoad() throws Exception {
        this.tblMember.checkParsed();
        super.onLoad();
        this.initCostCenter();
        this.initCslOrgTree();
        this.getCellHelper().init();
        this.tblMember.getColumn(COL_REF_MEMBERS).setRenderer((IBasicRender)BgCellRenderHelper.getMemberComRender());
        this.tblMember.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                MbgDataQueryFilterUI.this.tblMember_editStopped(e);
            }
        });
        this.prmtCostCenter.setEditable(false);
    }

    @Override
    protected void rdoBgForm_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoBgForm_itemStateChanged(e);
        this.queryTypeChange(this.rdoBgForm);
    }

    @Override
    protected void rdoActualForm_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoActualForm_itemStateChanged(e);
        this.queryTypeChange(this.rdoActualForm);
    }

    @Override
    protected void rdoCslForm_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoCslForm_itemStateChanged(e);
        this.queryTypeChange(this.rdoCslForm);
    }

    @Override
    protected void rdoCslAdjForm_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoCslAdjForm_itemStateChanged(e);
        this.queryTypeChange(this.rdoCslAdjForm);
    }

    @Override
    protected void rdoWorkPaper_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoWorkPaper_itemStateChanged(e);
        this.queryTypeChange(this.rdoWorkPaper);
    }

    private void queryTypeChange(KDRadioButton rdo) throws Exception {
        IObjectValue newOrgUnit;
        if (this.lastButton == rdo) {
            return;
        }
        MbgDataQueryTypeEnum oldType = this.getQueryType(this.lastButton);
        MbgDataQueryTypeEnum newType = this.getQueryType(rdo);
        boolean oldCsl = MbgDataQueryFilterUI.isCsl(oldType);
        boolean newCsl = MbgDataQueryFilterUI.isCsl(newType);
        this.lastButton = rdo;
        this.initScenario();
        if (MbgDataQueryTypeEnum.BgForm.equals((Object)newType) || MbgDataQueryTypeEnum.ActualForm.equals((Object)newType)) {
            this.prmtBgScenario.setData(null);
        }
        if (MbgDataQueryTypeEnum.BgForm.equals((Object)newType)) {
            this.rdoC01.setEnabled(true);
            this.rdoC02.setEnabled(true);
            this.rdoC04.setEnabled(true);
        } else {
            this.rdoC01.setSelected(true, false);
            this.rdoC01.setEnabled(false);
            this.rdoC02.setEnabled(false);
            this.rdoC04.setEnabled(false);
        }
        this.prmtBgForm.setData(null);
        IObjectValue oldOrgUnit = this.getSelectOrgUnit();
        if (oldCsl != newCsl) {
            this.cslChange(newCsl);
        }
        if (DimensionCommonHelper.isEqualsPrmt(oldOrgUnit, newOrgUnit = this.getSelectOrgUnit())) {
            this.setFormFilter();
        }
    }

    private void cslChange(boolean newCsl) throws Exception {
        this.clearSchemeHelper();
        if (newCsl) {
            this.prmtBgOrgUnit.setData(null);
            this.contCslOrgTree.setVisible(true);
            this.lblCostCenter.setVisible(false);
            this.contBgScheme.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"cslScheme"));
            this.contBgOrgUnit.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"cslOrgUnit"));
        } else {
            this.contCslOrgTree.setVisible(false);
            this.lblCostCenter.setVisible(true);
            this.contBgScheme.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"bgScheme"));
            this.contBgOrgUnit.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"bgOrgUnit"));
        }
        BgSchemeInfo oldScheme = this.getSelectBgScheme();
        this.setBgSchemeFilter(this.getSourceType());
        BgSchemeInfo newScheme = this.getSelectBgScheme();
        if (!DimensionCommonHelper.isEqualsPrmt(oldScheme, newScheme)) {
            this.setOrgUnitFilter();
            this.schemeChange();
        } else {
            this.setOrgUnitFilter();
            this.clearMember();
        }
    }

    @Override
    protected void rdoC01_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoC01_itemStateChanged(e);
        if (1 == e.getStateChange()) {
            this.prmtBgForm.setData(null);
            this.processTypeChange(this.rdoC01);
            this.setFormFilter();
        }
    }

    @Override
    protected void rdoC02_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoC02_itemStateChanged(e);
        if (1 == e.getStateChange()) {
            this.prmtBgForm.setData(null);
            this.processTypeChange(this.rdoC02);
            this.setFormFilter();
        }
    }

    private void processTypeChange(KDRadioButton rdoProcessType) throws Exception {
        boolean oldIsDec;
        BgProcessEnum processType = this.getProcessType(rdoProcessType);
        BgProcessEnum oldProcessType = (BgProcessEnum)((Object)this.prmtBgOrgUnit.getUserObject());
        boolean newIsDec = DimensionCommonHelper.isDecompose(processType);
        if (newIsDec != (oldIsDec = DimensionCommonHelper.isDecompose(oldProcessType))) {
            this.setOrgUnitFilter();
        }
    }

    @Override
    protected void rdoC04_itemStateChanged(ItemEvent e) throws Exception {
        super.rdoC04_itemStateChanged(e);
        if (1 == e.getStateChange()) {
            this.prmtBgForm.setData(null);
            this.processTypeChange(this.rdoC04);
            this.setFormFilter();
        }
    }

    private void initCostCenter() {
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        this.prmtCostCenter.setSelector((KDPromptSelector)f7);
    }

    private void initCslOrgTree() throws Exception {
        MbgCslClientHelper.getInstance().initOrgTreeComboBox(this.cboCslOrgTree);
    }

    @Override
    protected void prmtCostCenter_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCostCenter_dataChanged(e);
        OrgUnitInfo oldInfo = (OrgUnitInfo)e.getOldValue();
        OrgUnitInfo newInfo = (OrgUnitInfo)e.getNewValue();
        if (newInfo == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullCostCenter"));
            this.prmtCostCenter.setDataNoNotify(e.getOldValue());
        } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
            this.setBgSchemeFilter(this.getSourceType());
            boolean isDec = DimensionCommonHelper.isDecompose(this.getProcessType());
            if (this.prmtBgScheme.getData() == null) {
                this.schemeHelper = null;
                this.prmtBgOrgUnit.setDataNoNotify(null);
            }
            if (this.schemeHelper != null) {
                this.setDefaultOrgUnit(this.schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId(), isDec);
            }
        }
    }

    @Override
    protected void cboCslOrgTree_itemStateChanged(ItemEvent e) throws Exception {
        super.cboCslOrgTree_itemStateChanged(e);
        if (1 == e.getStateChange()) {
            this.setBgSchemeFilter(this.getSourceType());
            this.setOrgUnitFilter();
        }
    }

    public RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    public void setBgSchemeFilter(RptSrcTypeEnum sourceType) throws EASBizException, BOSException {
        if (this.contCslOrgTree.isVisible()) {
            MbgCslClientHelper.getInstance().setBgSchemeFilter(this.prmtBgScheme, (OrgTreeInfo)this.cboCslOrgTree.getSelectedItem());
        } else if (this.prmtCostCenter.getData() != null) {
            BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.prmtCostCenter.getData(), null, false, sourceType, false, false);
            BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, sourceType, true, ((OrgUnitInfo)this.prmtCostCenter.getData()).getId());
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (e.getNewValue() == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            return;
        }
        if (DimensionCommonHelper.isEquals(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.schemeChange();
        this.prmtBgOrgUnit.setData(null);
        if (this.rdoC02.isSelected() || this.rdoC04.isSelected()) {
            this.setDefaultOrgUnit(this.getSchemeHelper() == null ? null : this.getSchemeHelper().getBgOrgViewId(), DimensionCommonHelper.isDecompose(this.getProcessType()));
        }
    }

    protected void schemeChange() throws Exception {
        this.clearSchemeHelper();
        if (!MbgDataQueryFilterUI.isCsl(this.getQueryType(this.lastButton))) {
            this.setOrgUnitFilter();
        }
        if (this.getSelectBgScheme() != null) {
            this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme(this.getSelectBgScheme());
        }
        this.tblMember.getColumn(COL_INDEX_MEMBERS).setRenderer((IBasicRender)this.getCellHelper().getOVRender(this.accountViewId));
        this.clearMember();
        this.clearOther();
    }

    protected void clearMember() throws Exception {
        this.tblMember.removeRows();
        this.initDimMember();
    }

    protected void initDimMember() throws EASBizException, BOSException {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        prmt.setSelector((KDPromptSelector)this.initMBgIndexF7());
        this.tblMember.getColumn(COL_INDEX_MEMBERS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
        prmt = new KDBizPromptBox();
        prmt.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    Object obj = MbgDataQueryFilterUI.this.getRowBgIndex();
                    if (obj == null) {
                        MsgBox.showInfo((String)EASResource.getString((String)MbgDataQueryFilterUI.RESOURCE, (String)"accIsNotNull"));
                        e.setCanceled(true);
                    }
                }
                catch (Exception exc) {
                    MbgDataQueryFilterUI.this.handUIException(exc);
                }
            }
        });
        prmt.setEditable(false);
        prmt.setSelector((KDPromptSelector)this.initDimensionMemberSelectDialog());
        this.tblMember.getColumn(COL_REF_MEMBERS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
    }

    protected Object getRowBgIndex() {
        IRow row = this.tblMember.getRow(this.tblMember.getSelectManager().getActiveRowIndex());
        Object obj = this.tblMember.getCell(row.getRowIndex(), COL_INDEX_MEMBERS).getValue();
        return obj;
    }

    protected NewDimensionMemberSelectDialog initDimensionMemberSelectDialog() throws BOSException, EASBizException {
        String[] orgUnitIds = null;
        Object obj = this.prmtBgOrgUnit.getData();
        if (obj != null) {
            if (obj instanceof BgOrgUnitInfo) {
                if (((BgOrgUnitInfo)obj).getOrgUnitID() != null) {
                    orgUnitIds = new String[]{((BgOrgUnitInfo)obj).getOrgUnitID().toString()};
                }
            } else if (obj instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] orgUnits = (OrgUnitInfo[])obj;
                orgUnitIds = new String[orgUnits.length];
                for (int i = 0; i < orgUnits.length; ++i) {
                    orgUnitIds[i] = orgUnits[i].getId().toString();
                }
            }
        }
        MbgAnalyseDimensionMemberSelectDialog dialog = new MbgAnalyseDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionInfo)null, orgUnitIds, false, true);
        dialog.setOnlyRefDim(true);
        dialog.setOnlySelectItem(true);
        if (this.getSelectBgScheme() != null) {
            dialog.setSchemeHelper(this.getSchemeHelper());
            dialog.resetUI();
        } else {
            dialog.setBgSchemeId("000000000000000000000000000=");
        }
        if (MbgDataQueryFilterUI.isCsl(this.getQueryType(this.lastButton))) {
            if (obj != null) {
                if (obj instanceof FullOrgUnitInfo && ((FullOrgUnitInfo)obj).getId() != null) {
                    dialog.setUninGroupId(((FullOrgUnitInfo)obj).getId().toString());
                    dialog.setCanntFilterOrg(true);
                }
            } else {
                OrgTreeInfo treeInfo = (OrgTreeInfo)this.cboCslOrgTree.getSelectedItem();
                if (treeInfo != null) {
                    OrgStructureCollection col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + treeInfo.getId().toString() + "'");
                    ArrayList<String> orgidSet = new ArrayList<String>();
                    for (int i = 0; i < col.size(); ++i) {
                        if (!col.get(i).getUnit().isIsCostOrgUnit()) continue;
                        orgidSet.add(col.get(i).getUnit().getId().toString());
                    }
                    dialog.setOrgUnitIds(orgidSet.toArray(new String[orgidSet.size()]));
                }
            }
        }
        return dialog;
    }

    protected CoreUI getCoreUI() {
        if (this.getUIContext().get("Owner") instanceof CoreUI) {
            return (CoreUI)this.getUIContext().get("Owner");
        }
        return null;
    }

    protected void tblMember_editStopped(KDTEditEvent e) {
        List indexMembers;
        Object value = e.getValue();
        if (COL_INDEX_MEMBERS.equals(this.tblMember.getColumnKey(e.getColIndex())) && value instanceof List && (indexMembers = (List)value) != null && indexMembers.size() > 1) {
            IRow sourceRow = this.tblMember.getRow(e.getRowIndex());
            IRow row = null;
            ArrayList<BgDimensionMember> newMembers = null;
            for (int i = 0; i < indexMembers.size(); ++i) {
                if (i != 0) {
                    row = this.tblMember.addRow(e.getRowIndex() + i);
                    this.copyRow(sourceRow, row);
                } else {
                    row = sourceRow;
                }
                newMembers = new ArrayList<BgDimensionMember>();
                newMembers.add((BgDimensionMember)indexMembers.get(i));
                this.setIndexMember(row, newMembers);
            }
        }
    }

    private void copyRow(IRow srcRow, IRow row) {
        if (row != null) {
            if (srcRow.getCell(COL_INDEX_MEMBERS).getValue() != null && srcRow.getCell(COL_INDEX_MEMBERS).getValue() instanceof List) {
                this.setIndexMember(row, (List)srcRow.getCell(COL_INDEX_MEMBERS).getValue());
            } else if (srcRow.getCell(COL_INDEX_MEMBERS).getUserObject() != null && srcRow.getCell(COL_INDEX_MEMBERS).getUserObject() instanceof List) {
                this.setIndexMember(row, (List)srcRow.getCell(COL_INDEX_MEMBERS).getUserObject());
            }
            if (srcRow.getCell(COL_REF_MEMBERS).getValue() != null) {
                row.getCell(COL_REF_MEMBERS).setValue(srcRow.getCell(COL_REF_MEMBERS).getValue());
            }
        }
    }

    private void setIndexMember(IRow row, List<BgDimensionMember> newMembers) {
        row.getCell(COL_INDEX_MEMBERS).setValue((Object)this.displayMembers(newMembers));
        row.getCell(COL_INDEX_MEMBERS).setUserObject(newMembers);
    }

    private String displayMembers(List<BgDimensionMember> members) {
        if (members == null || members.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BgDimensionMember bgDimensionMember : members) {
            if (this.accountViewId == null && this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
                this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
            }
            if (this.accountViewId != null) {
                sb.append(this.getCellHelper().getIndexDisplayName(this.accountViewId, bgDimensionMember)).append(",");
                continue;
            }
            sb.append(bgDimensionMember.getNumber()).append("(").append(bgDimensionMember.getName()).append(")").append(",");
        }
        sb = sb.deleteCharAt(sb.toString().lastIndexOf(","));
        return sb.toString();
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkSelectBgScheme()) {
            return;
        }
        this.createNewRefRow(true);
    }

    protected IRow createNewRefRow(boolean setDefault) {
        IRow row = this.tblMember.addRow();
        return row;
    }

    @Override
    protected void btnCopyLine_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.tblMember.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            IRow srcRow = this.tblMember.getRow(rowIndex);
            IRow row = this.tblMember.addRow(rowIndex + 1);
            this.copyRow(srcRow, row);
        }
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMember);
        if (rows != null) {
            Collections.sort(rows);
            for (int i = rows.size() - 1; i >= 0; --i) {
                this.tblMember.removeRow(((Integer)rows.get(i)).intValue());
            }
        }
    }

    @Override
    protected void btnFromSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnFromSelect_actionPerformed(e);
        if (this.checkSelectBgScheme() || this.checkSelectBgOrg()) {
            return;
        }
        List<AnalyseMember> result = MbgDataQueryFilterUI.showSelectItemFormula((JComponent)((Object)this), (JComponent)this.btnFromSelect, this.prmtBgForm, this.getQueryType(this.lastButton), (OrgTreeInfo)this.cboCslOrgTree.getSelectedItem());
        if (result != null) {
            IRow row = null;
            String key = null;
            BgDimensionMember _bgMember = null;
            ArrayList<BgDimensionMember> tmpList = null;
            HashSet<String> keySet = new HashSet<String>();
            int in = this.tblMember.getRowCount();
            for (int i = 0; i < in; ++i) {
                row = this.tblMember.getRow(i);
                key = "";
                if (row.getCell(COL_INDEX_MEMBERS) != null && row.getCell(COL_INDEX_MEMBERS).getValue() != null) {
                    if (row.getCell(COL_INDEX_MEMBERS).getValue() instanceof List) {
                        tmpList = (ArrayList<BgDimensionMember>)row.getCell(COL_INDEX_MEMBERS).getValue();
                    } else if (row.getCell(COL_INDEX_MEMBERS).getUserObject() != null) {
                        tmpList = (List)row.getCell(COL_INDEX_MEMBERS).getUserObject();
                    }
                    if (tmpList != null) {
                        _bgMember = (BgDimensionMember)tmpList.get(0);
                        key = key + _bgMember.getSrcNumber() + ":" + _bgMember.getNumber();
                    }
                }
                if (row.getCell(COL_REF_MEMBERS) != null && row.getCell(COL_REF_MEMBERS).getValue() != null) {
                    if (row.getCell(COL_REF_MEMBERS).getValue() instanceof BgDimensionMember) {
                        _bgMember = (BgDimensionMember)row.getCell(COL_REF_MEMBERS).getValue();
                    } else if (row.getCell(COL_INDEX_MEMBERS).getUserObject() != null) {
                        _bgMember = (BgDimensionMember)row.getCell(COL_REF_MEMBERS).getUserObject();
                    }
                    if (_bgMember != null) {
                        key = key + "," + _bgMember.getSrcNumber() + ":" + _bgMember.getNumber();
                    }
                }
                keySet.add(key);
            }
            for (AnalyseMember member : result) {
                key = member.getBgIndex().getSrcNumber() + ":" + member.getBgIndex().getNumber();
                if (member.getDimMember() != null) {
                    key = key + "," + member.getDimMember().getSrcNumber() + ":" + member.getDimMember().getNumber();
                }
                if (keySet.contains(key)) continue;
                row = this.tblMember.addRow();
                if (member.getBgIndex() != null) {
                    tmpList = new ArrayList<BgDimensionMember>();
                    tmpList.add(member.getBgIndex());
                    row.getCell(COL_INDEX_MEMBERS).setValue(tmpList);
                }
                if (member.getDimMember() == null) continue;
                row.getCell(COL_REF_MEMBERS).setValue((Object)member.getDimMember());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AnalyseMember> showSelectItemFormula(JComponent ownerUI, JComponent ownerComp, KDBizPromptBox ownerPrmt, MbgDataQueryTypeEnum queryType, OrgTreeInfo orgTreeInfo) throws Exception {
        IObjectValue info = null;
        if (ownerPrmt.getData() instanceof IObjectValue) {
            info = (IObjectValue)ownerPrmt.getData();
        } else {
            KDBizPromptBox prmtFormSelect = new KDBizPromptBox();
            prmtFormSelect.setName(ownerPrmt.getName());
            prmtFormSelect.setDisplayFormatter(ownerPrmt.getDisplayFormatter());
            prmtFormSelect.setEditFormatter(ownerPrmt.getEditFormatter());
            prmtFormSelect.setCommitParser(ownerPrmt.getCommitParser());
            prmtFormSelect.setQueryInfo(ownerPrmt.getQueryInfo().replaceAll("\\\\", "."));
            prmtFormSelect.setEntityViewInfo(ownerPrmt.getEntityViewInfo());
            prmtFormSelect.setEnabledMultiSelection(false);
            try {
                ownerComp.add((Component)prmtFormSelect);
                prmtFormSelect.setDataBySelector();
            }
            finally {
                ownerComp.remove((Component)prmtFormSelect);
            }
            if (!(prmtFormSelect.getData() instanceof IObjectValue)) {
                return null;
            }
            info = (IObjectValue)prmtFormSelect.getData();
        }
        UIContext uiContext = new UIContext((Object)ownerUI);
        uiContext.put((Object)"InitDataObject", (Object)info);
        uiContext.put((Object)"ORG_TREE_INFO", (Object)orgTreeInfo);
        uiContext.put((Object)"IS_CLS", (Object)MbgDataQueryFilterUI.isCsl(queryType));
        uiContext.put((Object)"QUERY_TYPE", (Object)queryType);
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgItemSelectProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, 66);
        BgBaseHelper.setMaxDialog((IUIWindow)uiWindow);
        uiWindow.show();
        MbgItemSelectProcessUI selectProcessUi = (MbgItemSelectProcessUI)uiWindow.getUIObject();
        return selectProcessUi.getMembers();
    }

    private static IMbgSelectProcessUI openBgFormProcessUI(JComponent ownerUI, BgFormInfo bgFormInfo) throws Exception {
        BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo("select id, orgUnit.id, orgUnit.CU.id, bgTemplate.formType where id = '" + bgFormInfo.getId() + "'");
        UIContext uiContext = new UIContext((Object)ownerUI);
        uiContext.put((Object)"ID", (Object)bgFormInfo.getId().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)bgForm.getOrgUnit());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)bgForm.getOrgUnit().getCU());
        uiContext.put((Object)"type", (Object)bgForm.getBgTemplate().getFormType());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgDataQueryFilterUI.getEditUIName(bgForm), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        return (IMbgSelectProcessUI)uiWindow.getUIObject();
    }

    protected static String getEditUIName(BgFormInfo bgForm) {
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType()) || BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return MbgDataQueryFilterUI.getViewFormEditName();
        }
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return MBgAnalyseExeSpecialProcessUI.class.getName();
        }
        return MbgDataQueryFilterUI.getFixFormEditName();
    }

    protected static String getViewFormEditName() {
        return MBgAnalayseExeViewProcessUI.class.getName();
    }

    protected static String getFixFormEditName() {
        return MBgAnalyseExeProcessUI.class.getName();
    }

    protected NewDimensionMemberSelectDialog initMBgIndexF7() throws EASBizException, BOSException {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog();
        dialog.setSchemeHelper(this.getSchemeHelper());
        dialog.setMulti(true);
        dialog.setDimension(dimension);
        return dialog;
    }

    protected void clearOther() throws Exception {
        this.prmtBgElement.setData(null);
        this.prmtBgPeriod.setData(null);
        this.prmtBgScenario.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtBgVersion.setData(null);
        this.initScenario();
        this.initPeriod();
        this.initCurrency();
        this.initMbgElement();
        this.initBgVersion();
    }

    protected void initPeriod() throws Exception {
        if (this.getSelectBgScheme() == null) {
            return;
        }
        this.prmtBgPeriod.setEditable(false);
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodBeginDate(this.getSelectBgScheme().getDateFrom());
        dialog.setBgPeriodEndDate(this.getSelectBgScheme().getDateTo());
        dialog.setMultiSelect(true);
        dialog.setBgSchemeID(this.getSelectBgScheme().getId().toString());
        dialog.setOnlyLeaf(true);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.addDataChangeListener((DataChangeListener)dialog);
    }

    protected void initCurrency() throws Exception {
        this.prmtCurrency.setEditable(false);
        Set currencyID = MbgAnalyseExeHelper.getCurrencyID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtCurrency.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCurrency.setEntityViewInfo(view);
    }

    protected void initMbgElement() throws Exception {
        this.prmtBgElement.setEditable(false);
        Set elementID = MbgAnalyseExeHelper.getElementID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtBgElement.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)elementID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtBgElement.setEntityViewInfo(view);
    }

    protected void initScenario() throws Exception {
        this.prmtBgScenario.setEditable(false);
        Set scenarioID = MbgAnalyseExeHelper.getBgScenarioID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtBgScenario.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)scenarioID, CompareType.INCLUDE));
        if (MbgDataQueryTypeEnum.BgForm.equals((Object)this.getQueryType(this.lastButton))) {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
        } else if (MbgDataQueryTypeEnum.ActualForm.equals((Object)this.getQueryType(this.lastButton))) {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)1, CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtBgScenario.setEntityViewInfo(view);
    }

    protected void initBgVersion() throws Exception {
        this.prmtBgVersion.setEditable(false);
        Set versionID = MbgAnalyseExeHelper.getBgVersionID((BgSchemeInfo)((BgSchemeInfo)this.prmtBgScheme.getData()));
        EntityViewInfo view = this.prmtBgVersion.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)versionID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtBgVersion.setEntityViewInfo(view);
    }

    protected void setOrgUnitFilter() throws Exception {
        this.prmtBgOrgUnit.setUserObject((Object)this.getProcessType());
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        if (this.lblCostCenter.isVisible()) {
            if (bgScheme == null) {
                return;
            }
            bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, number, name, orgUnit.id where id = '" + bgScheme.getId().toString() + "'");
            BgViewOrgDimensionF7 orgDialog = new BgViewOrgDimensionF7((IUIObject)this);
            orgDialog.setPermissionFilter(true);
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgScheme.getId().toString());
            orgDialog.setBgOrgViewId(schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId());
            orgDialog.setOrgUnitId(bgScheme.getOrgUnit().getId().toString());
            orgDialog.setShowVirtualOrg(false);
            boolean isDec = DimensionCommonHelper.isDecompose(this.getProcessType());
            if (isDec) {
                orgDialog.setOnlyNoLeaf(true);
                orgDialog.setOnlyLeaf(false);
            } else {
                orgDialog.setOnlyNoLeaf(false);
                orgDialog.setOnlyLeaf(true);
            }
            this.prmtBgOrgUnit.setSelector((KDPromptSelector)orgDialog);
            this.setDefaultOrgUnit(orgDialog.getBgOrgViewId(), isDec);
        } else if (this.cboCslOrgTree.getSelectedItem() != null) {
            MbgCslClientHelper.getInstance().refreshCompany((CoreUIObject)this, this.prmtBgOrgUnit, (OrgTreeInfo)this.cboCslOrgTree.getSelectedItem());
        }
    }

    private void setDefaultOrgUnit(String bgOrgViewId, boolean isDec) throws EASBizException, BOSException {
        if (DimensionCommonHelper.isEmpty(this.prmtCostCenter.getData())) {
            return;
        }
        String costOrgId = ((OrgUnitInfo)this.prmtCostCenter.getData()).getId().toString();
        String selectOrgUnitId = null;
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo) {
            BgOrgUnitInfo o = (BgOrgUnitInfo)this.prmtBgOrgUnit.getData();
            if (StringUtils.isEmpty((String)o.getOrgUnitID())) {
                o = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, orgUnitId where id = '" + o.getId() + "'");
            }
            selectOrgUnitId = o.getOrgUnitID();
        } else if (this.prmtBgOrgUnit.getData() instanceof OrgUnitInfo) {
            selectOrgUnitId = ((OrgUnitInfo)this.prmtBgOrgUnit.getData()).getId().toString();
        }
        if (selectOrgUnitId == null) {
            selectOrgUnitId = "000000000000000000000000000=";
        }
        BgOrgUnitCollection defaultOrg = null;
        int isLeaf = isDec ? 0 : 1;
        defaultOrg = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select * where isVirtual = 0 and isLeaf = " + isLeaf + " and viewId = '" + bgOrgViewId + "' and (orgUnitId = '" + costOrgId + "' or orgUnitId = '" + selectOrgUnitId + "')");
        if (defaultOrg == null || defaultOrg.size() == 0) {
            this.prmtBgOrgUnit.setData(null);
        } else if (defaultOrg.size() == 1) {
            this.prmtBgOrgUnit.setData((Object)defaultOrg.get(0));
        } else {
            for (int i = 0; i < defaultOrg.size(); ++i) {
                if (!costOrgId.equals(defaultOrg.get(i).getOrgUnitID())) continue;
                this.prmtBgOrgUnit.setData((Object)defaultOrg.get(i));
                break;
            }
        }
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
        if (this.contCslOrgTree.isVisible()) {
            if (this.cboCslOrgTree.getSelectedItem() == null) {
                e.setCanceled(true);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"msgCheckSelect", (Object[])new Object[]{this.contCslOrgTree.getBoundLabelText()}));
                return;
            }
        } else if (DimensionCommonHelper.isEmpty(this.prmtCostCenter.getData())) {
            e.setCanceled(true);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"msgCheckSelect", (Object[])new Object[]{this.contCslOrgTree.getBoundLabelText()}));
            return;
        }
    }

    @Override
    protected void prmtBgOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtBgOrgUnit_willShow(e);
        if (this.checkSelectBgScheme()) {
            e.setCanceled(true);
            return;
        }
    }

    @Override
    protected void prmtBgOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (DimensionCommonHelper.isEquals(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.prmtBgForm.setData(null);
        this.clearMember();
        this.setFormFilter();
    }

    protected void setFormFilter() throws Exception {
        IObjectValue orgUnit = this.getSelectOrgUnit();
        if (DimensionCommonHelper.isEmpty(orgUnit)) {
            return;
        }
        MbgDataQueryTypeEnum queryType = this.getQueryType(this.lastButton);
        if (MbgDataQueryTypeEnum.ActualForm.equals((Object)queryType)) {
            this.setActualFormFilter();
        } else if (MbgDataQueryTypeEnum.CslForm.equals((Object)queryType)) {
            this.setCslFormFilter();
        } else if (MbgDataQueryTypeEnum.CslAdjForm.equals((Object)queryType)) {
            this.setCslAdjFormFilter();
        } else if (MbgDataQueryTypeEnum.WorkPaper.equals((Object)queryType)) {
            this.setWorkPaperFilter();
        } else {
            this.setBgFormFilter();
        }
    }

    protected void setBgFormFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        BgOrgUnitInfo bgOrgUnit = this.getSelectBgOrgUnit();
        if (bgOrgUnit == null) {
            return;
        }
        String bgOrgUnitId = bgOrgUnit.getOrgUnitID() == null ? "000000000000000000000000000=" : bgOrgUnit.getOrgUnitID();
        this.prmtBgForm.setQueryInfo("com.kingdee.eas.ma.mbg.BgFormF7Query");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "000000000000000000000000000=" : bgScheme.getId().toString())));
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("state".toLowerCase(), state, CompareType.NOTINCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)bgOrgUnitId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35, 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("processType", (Object)this.getProcessType().getValue()));
        this.addBgPermission(bgScheme, evi, "bgTemplate.id");
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.isRollVersion", (Object)false, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgType.id", (Object)"BV/FQwEUEADgABtLwKgSXv9s2OA=", CompareType.NOTEQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgType.id", null, CompareType.EQUALS));
        FilterItemCollection filterItems = evi.getFilter().getFilterItems();
        StringBuilder sql = new StringBuilder();
        int size = filterItems.size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sql.append(" #" + i + ")");
                continue;
            }
            if (i == size - 2) {
                sql.append("(#" + i + " or ");
                continue;
            }
            sql.append("#" + i + " and ");
        }
        evi.getFilter().setMaskString(sql.toString());
        this.addBgOrgUnitPremission(evi.getFilter(), bgOrgUnitId, "orgUnit.id", "creator.id");
        this.prmtBgForm.setEntityViewInfo(evi);
    }

    public void addBgPermission(BgSchemeInfo bgScheme, EntityViewInfo evi, String filterField) {
        try {
            if (bgScheme != null) {
                BgSchemeInfo _bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select bgSchemeType.schemeType where id = '" + bgScheme.getId() + "'");
                MbgPermissionHelper.addFieldDataPermission(_bgScheme.getBgSchemeType().getSchemeType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), evi.getFilter(), MbgPermissionTypeEnum.TEMPLATE, filterField, bgScheme.getId().toString(), true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void addBgOrgUnitPremission(FilterInfo filter, String bgOrgUnitId, String orgField, String userField) throws EASBizException, BOSException {
        Set bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
        if (!bgOrgUnitPer.isEmpty()) {
            HashSet<String> newOrgPerSet = new HashSet<String>();
            if (bgOrgUnitPer.contains(bgOrgUnitId)) {
                newOrgPerSet.add(bgOrgUnitId);
            }
            String mask = filter.getMaskString();
            int size = filter.getFilterItems().size();
            if (newOrgPerSet.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo(orgField, (Object)"000000000000000000000000000=", CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(orgField, newOrgPerSet, CompareType.INCLUDE));
            }
            mask = mask + " and #" + size;
            filter.setMaskString(mask);
        }
    }

    protected void setActualFormFilter() throws Exception {
        Set bgOrgUnitPer;
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        BgOrgUnitInfo bgOrgUnit = this.getSelectBgOrgUnit();
        if (bgOrgUnit == null) {
            return;
        }
        String bgOrgUnitId = bgOrgUnit.getOrgUnitID() == null ? "000000000000000000000000000=" : bgOrgUnit.getOrgUnitID();
        this.prmtBgForm.setQueryInfo("com.kingdee.eas.ma.mbg.BgActualRecordF7Query");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        BgCommHelper.replaceFilterItems((FilterInfo)evi.getFilter(), (FilterItemInfo)new FilterItemInfo("bgForm.bgScheme.id", (Object)(bgScheme == null ? "000000000000000000000000000=" : bgScheme.getId().toString())));
        if (bgScheme != null && !(bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), bgScheme.getId().toString())).isEmpty() && !bgOrgUnitPer.contains(bgOrgUnitId)) {
            bgOrgUnitId = "000000000000000000000000000=";
        }
        BgCommHelper.replaceFilterItems((FilterInfo)evi.getFilter(), (FilterItemInfo)new FilterItemInfo("bgForm.orgUnit.id", (Object)bgOrgUnitId));
        this.addBgPermission(bgScheme, evi, "bgForm.bgTemplate.id");
        this.prmtBgForm.setEntityViewInfo(evi);
    }

    protected void setCslFormFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        OrgUnitInfo orgTree = (OrgUnitInfo)this.getSelectOrgUnit();
        this.prmtBgForm.setQueryInfo("com.kingdee.eas.ma.bgcsl.BgCslFormF7Query");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "000000000000000000000000000=" : bgScheme.getId().toString())));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)(orgTree == null ? "000000000000000000000000000=" : orgTree.getId().toString())));
        this.prmtBgForm.setEntityViewInfo(evi);
    }

    protected void setCslAdjFormFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        OrgUnitInfo orgTree = (OrgUnitInfo)this.getSelectOrgUnit();
        this.prmtBgForm.setQueryInfo("com.kingdee.eas.ma.bgcsl.BgCslAdjFormF7Query");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "000000000000000000000000000=" : bgScheme.getId().toString())));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)(orgTree == null ? "000000000000000000000000000=" : orgTree.getId().toString())));
        this.prmtBgForm.setEntityViewInfo(evi);
    }

    protected void setWorkPaperFilter() throws Exception {
        BgSchemeInfo bgScheme = this.getSelectBgScheme();
        String orgTreeId = null;
        if (this.getSelectOrgUnit() instanceof OrgUnitInfo) {
            orgTreeId = ((OrgUnitInfo)this.getSelectOrgUnit()).getId().toString();
        } else if (this.getSelectOrgUnit() instanceof BgOrgUnitInfo) {
            orgTreeId = ((BgOrgUnitInfo)this.getSelectOrgUnit()).getOrgUnitID();
        }
        this.prmtBgForm.setQueryInfo("com.kingdee.eas.ma.bgcsl.MbgWorkPaperF7Query");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "000000000000000000000000000=" : bgScheme.getId().toString())));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)(orgTreeId == null ? "000000000000000000000000000=" : orgTreeId)));
        this.prmtBgForm.setEntityViewInfo(evi);
    }

    protected BgOrgUnitInfo getSelectBgOrgUnit() throws Exception {
        BgOrgUnitInfo bgOrgUnit = (BgOrgUnitInfo)this.getSelectOrgUnit();
        if (bgOrgUnit != null) {
            BgOrgUnitCollection col = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select id, orgUnitId where id = '" + bgOrgUnit.getId().toString() + "'");
            bgOrgUnit = col == null || col.isEmpty() ? null : col.get(0);
        }
        return bgOrgUnit;
    }

    @Override
    protected void prmtBgForm_willShow(SelectorEvent e) throws Exception {
        this.setFormFilter();
        super.prmtBgForm_willShow(e);
        if (this.checkSelectBgScheme() || this.checkSelectBgOrg()) {
            e.setCanceled(true);
            return;
        }
    }

    @Override
    protected void prmtBgElement_willShow(SelectorEvent e) throws Exception {
        super.prmtBgElement_willShow(e);
        e.setCanceled(this.checkSelectBgScheme());
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        super.prmtBgPeriod_willShow(e);
        e.setCanceled(this.checkSelectBgScheme());
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtBgVersion_willShow(e);
        BgNFormListUI.addRollVersionFilter(this.prmtBgVersion);
        e.setCanceled(this.checkSelectBgScheme());
    }

    @Override
    protected void prmtCurrency_willShow(SelectorEvent e) throws Exception {
        super.prmtCurrency_willShow(e);
        e.setCanceled(this.checkSelectBgScheme());
    }

    @Override
    protected void prmtScenario_willShow(SelectorEvent e) throws Exception {
        super.prmtScenario_willShow(e);
        e.setCanceled(this.checkSelectBgScheme());
    }

    public IObjectValue getSelectOrgUnit() {
        return (IObjectValue)this.prmtBgOrgUnit.getData();
    }

    public BgSchemeInfo getSelectBgScheme() {
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            return (BgSchemeInfo)this.prmtBgScheme.getData();
        }
        return null;
    }

    private boolean checkSelectBgScheme() {
        if (this.getSelectBgScheme() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"msgCheckSelect", (Object[])new Object[]{this.contBgScheme.getBoundLabelText()}));
            return true;
        }
        return false;
    }

    private boolean checkSelectBgOrg() {
        if (!(this.prmtBgOrgUnit.getData() instanceof IObjectValue)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"msgCheckSelect", (Object[])new Object[]{this.contBgOrgUnit.getBoundLabelText()}));
            return true;
        }
        return false;
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (this.contCslOrgTree.isVisible() && this.cboCslOrgTree.getSelectedItem() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"msgCheckSelect", (Object[])new Object[]{this.contCslOrgTree.getBoundLabelText()}));
                return false;
            }
            if (this.checkSelectBgScheme() || this.checkSelectBgOrg()) {
                return false;
            }
            for (int r = 0; r < this.tblMember.getRowCount(); ++r) {
                if (!DimensionCommonHelper.isEmpty(this.tblMember.getCell(r, COL_INDEX_MEMBERS).getValue())) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"msgCheckSelect", (Object[])new Object[]{this.tblMember.getHeadRow(0).getCell(COL_INDEX_MEMBERS).getValue()}));
                return false;
            }
        }
        return re;
    }

    @Override
    protected FilterParam createFilterParam() {
        return new MbgDataQueryFilterParam();
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof MbgDataQueryFilterParam)) {
            return;
        }
        String id = null;
        MbgDataQueryFilterParam _filterParam = (MbgDataQueryFilterParam)filterParam;
        id = cp.getCustomerParam("ANALYSE_QUERY_TYPE");
        if (StringUtils.isEmpty((String)id)) {
            _filterParam.setQueryType(MbgDataQueryTypeEnum.BgForm);
        } else {
            _filterParam.setQueryType(MbgDataQueryTypeEnum.getEnum(id));
        }
        id = cp.getCustomerParam("ANALYSE_PROCESS_TYPE");
        if (StringUtils.isEmpty((String)id)) {
            _filterParam.setProcessType(BgProcessEnum.C01);
        } else {
            _filterParam.setProcessType(BgProcessEnum.getEnum(id));
        }
        id = cp.getCustomerParam("ANALYSE_ORGTREE_ID");
        _filterParam.setOrgTree(DimensionCommonHelper.createNewObject(OrgTreeInfo.class, id));
        id = cp.getCustomerParam("ANALYSE_COSTCENTER_ID");
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setCostCenter((OrgUnitInfo)DimensionCommonHelper.createNewObject(CostCenterOrgUnitInfo.class, id));
        } else {
            _filterParam.setCostCenter((OrgUnitInfo)SysContext.getSysContext().getCurrentCostUnit());
        }
        id = cp.getCustomerParam("ANALYSE_SCHEME_ID");
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScheme(DimensionCommonHelper.createNewObject(BgSchemeInfo.class, id));
        } else {
            _filterParam.setBgScheme(null);
        }
        id = cp.getCustomerParam("ANALYSE_BGORGUNIT_ID");
        if (!StringUtils.isEmpty((String)id)) {
            if (MbgDataQueryFilterUI.isCsl(_filterParam.getQueryType())) {
                _filterParam.setBgOrgUnit((CoreBaseInfo)DimensionCommonHelper.createNewObject(OrgUnitInfo.class, id));
            } else {
                _filterParam.setBgOrgUnit((CoreBaseInfo)DimensionCommonHelper.createNewObject(BgOrgUnitInfo.class, id));
            }
        } else {
            _filterParam.setBgOrgUnit(null);
        }
        id = cp.getCustomerParam("ANALYSE_BGFORM_ID");
        if (!StringUtils.isEmpty((String)id)) {
            Class<Object> infoClass = null;
            infoClass = MbgDataQueryFilterUI.isCsl(_filterParam.getQueryType()) ? MbgCslClientHelper.getInstance().getInfoClassName(_filterParam.getQueryType()) : (MbgDataQueryTypeEnum.ActualForm.equals((Object)_filterParam.getQueryType()) ? BgActualRecordInfo.class : BgFormInfo.class);
            _filterParam.setBgForm(DimensionCommonHelper.createNewObject(infoClass, id));
            if (_filterParam.getBgScheme() != null && _filterParam.getBgOrgUnit() != null) {
                int isPer = 0;
                if (MbgDataQueryTypeEnum.BgForm.equals((Object)_filterParam.getQueryType())) {
                    isPer = 1;
                } else if (MbgDataQueryTypeEnum.ActualForm.equals((Object)_filterParam.getQueryType())) {
                    isPer = 2;
                }
                if (isPer != 0) {
                    try {
                        Set bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), _filterParam.getBgScheme().getId().toString());
                        if (!bgOrgUnitPer.isEmpty()) {
                            BgFormInfo info = null;
                            if (isPer == 1) {
                                info = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(id));
                            } else {
                                BgActualRecordInfo infos = BgActualRecordFactory.getRemoteInstance().getBgActualRecordInfo("select bgForm.orgUnit.id where id ='" + id + "'");
                                info = infos.getBgForm();
                            }
                            if (!bgOrgUnitPer.contains(info.getOrgUnit().getId().toString())) {
                                _filterParam.setBgForm(null);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            _filterParam.setBgForm(null);
        }
        List members = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam("ANALYSE_MEMBER")));
        if (members != null) {
            _filterParam.getMembers().addAll(members);
        } else {
            _filterParam.getMembers().clear();
        }
        List ids = (List)BgAnalyseHelper.decodeObject(cp.getCustomerParam("ANALYSE_BGPERIOD_IDS"));
        _filterParam.setBgPeriods((BgPeriodInfo[])DimensionCommonHelper.createNewObjectArray(BgPeriodInfo.class, (List)ids));
        ids = (List)BgAnalyseHelper.decodeObject(cp.getCustomerParam("ANALYSE_BGVERSION_IDS"));
        _filterParam.setBgVersions((BgVersionInfo[])DimensionCommonHelper.createNewObjectArray(BgVersionInfo.class, (List)ids));
        ids = (List)BgAnalyseHelper.decodeObject(cp.getCustomerParam("ANALYSE_ELEMENT_IDS"));
        _filterParam.setBgElements((BgElementInfo[])DimensionCommonHelper.createNewObjectArray(BgElementInfo.class, (List)ids));
        ids = (List)BgAnalyseHelper.decodeObject(cp.getCustomerParam("ANALYSE_BGSCENARIO_IDS"));
        _filterParam.setBgScenarios((BgScenarioInfo[])DimensionCommonHelper.createNewObjectArray(BgScenarioInfo.class, (List)ids));
        ids = (List)BgAnalyseHelper.decodeObject(cp.getCustomerParam("ANALYSE_CURRENCY_IDS"));
        _filterParam.setCurrencies((CurrencyInfo[])DimensionCommonHelper.createNewObjectArray(CurrencyInfo.class, (List)ids));
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof MbgDataQueryFilterParam)) {
            return;
        }
        MbgDataQueryFilterParam _filterParam = (MbgDataQueryFilterParam)filterParam;
        cp.addCustomerParam("ANALYSE_QUERY_TYPE", _filterParam.getQueryType().getName());
        cp.addCustomerParam("ANALYSE_PROCESS_TYPE", _filterParam.getProcessType().getName());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_ORGTREE_ID", (CoreBaseInfo)_filterParam.getOrgTree());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_COSTCENTER_ID", (CoreBaseInfo)_filterParam.getCostCenter());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_SCHEME_ID", (CoreBaseInfo)_filterParam.getBgScheme());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_BGORGUNIT_ID", _filterParam.getBgOrgUnit());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_BGFORM_ID", _filterParam.getBgForm());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_MEMBER", _filterParam.getMembers());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_BGPERIOD_IDS", (CoreBaseInfo[])_filterParam.getBgPeriods());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_BGSCENARIO_IDS", (CoreBaseInfo[])_filterParam.getBgScenarios());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_BGVERSION_IDS", (CoreBaseInfo[])_filterParam.getBgVersions());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_CURRENCY_IDS", (CoreBaseInfo[])_filterParam.getCurrencies());
        MbgDataQueryFilterUI.setCustomerParam(cp, "ANALYSE_ELEMENT_IDS", (CoreBaseInfo[])_filterParam.getBgElements());
    }

    @Override
    protected void loadFromParams(FilterParam filterParam) {
        super.loadFromParams(filterParam);
        if (!(filterParam instanceof MbgDataQueryFilterParam)) {
            return;
        }
        MbgDataQueryFilterParam _filterParam = (MbgDataQueryFilterParam)filterParam;
        if (MbgDataQueryTypeEnum.ActualForm.equals((Object)_filterParam.getQueryType())) {
            this.rdoActualForm.setSelected(true);
        } else if (MbgDataQueryTypeEnum.CslForm.equals((Object)_filterParam.getQueryType())) {
            this.rdoCslForm.setSelected(true);
        } else if (MbgDataQueryTypeEnum.CslAdjForm.equals((Object)_filterParam.getQueryType())) {
            this.rdoCslAdjForm.setSelected(true);
        } else if (MbgDataQueryTypeEnum.WorkPaper.equals((Object)_filterParam.getQueryType())) {
            this.rdoWorkPaper.setSelected(true);
        } else {
            this.rdoBgForm.setSelected(true);
        }
        if (BgProcessEnum.C02.equals((Object)_filterParam.getProcessType())) {
            this.rdoC02.setSelected(true);
        } else if (BgProcessEnum.C04.equals((Object)_filterParam.getProcessType())) {
            this.rdoC04.setSelected(true);
        } else {
            this.rdoC01.setSelected(true);
        }
        if (_filterParam.getOrgTree() != null) {
            BgNFCHelper.setSelectObject(this.cboCslOrgTree, _filterParam.getOrgTree());
        }
        if (_filterParam.getCostCenter() != null) {
            this.prmtCostCenter.setData((Object)_filterParam.getCostCenter());
        }
        this.prmtBgScheme.setData((Object)_filterParam.getBgScheme());
        this.prmtBgOrgUnit.setData((Object)_filterParam.getBgOrgUnit());
        this.prmtBgForm.setData((Object)_filterParam.getBgForm());
        this.loadMember(_filterParam.getMembers());
        this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriods());
        this.prmtCurrency.setData((Object)_filterParam.getCurrencies());
        this.prmtBgElement.setData((Object)_filterParam.getBgElements());
        this.prmtBgScenario.setData((Object)_filterParam.getBgScenarios());
        this.prmtBgVersion.setData((Object)_filterParam.getBgVersions());
    }

    private void loadMember(List<AnalyseMember> membersList) {
        this.tblMember.removeRows();
        if (membersList == null || membersList.isEmpty()) {
            return;
        }
        IRow row = null;
        AnalyseMember member = null;
        ArrayList<BgDimensionMember> members = null;
        int in = membersList.size();
        for (int i = 0; i < in; ++i) {
            member = membersList.get(i);
            row = this.tblMember.addRow();
            if (member.getBgIndex() != null) {
                members = new ArrayList<BgDimensionMember>();
                members.add(member.getBgIndex());
                row.getCell(COL_INDEX_MEMBERS).setValue(members);
            }
            if (member.getDimMember() == null) continue;
            row.getCell(COL_REF_MEMBERS).setValue((Object)member.getDimMember());
        }
    }

    @Override
    protected void saveToParams(FilterParam filterParam) {
        super.saveToParams(filterParam);
        if (!(filterParam instanceof MbgDataQueryFilterParam)) {
            return;
        }
        MbgDataQueryFilterParam _filterParam = (MbgDataQueryFilterParam)filterParam;
        _filterParam.setQueryType(this.getQueryType(this.lastButton));
        _filterParam.setProcessType(this.getProcessType());
        _filterParam.setOrgTree((OrgTreeInfo)this.cboCslOrgTree.getSelectedItem());
        if (this.prmtCostCenter.getData() instanceof OrgUnitInfo) {
            _filterParam.setCostCenter((OrgUnitInfo)this.prmtCostCenter.getData());
        }
        _filterParam.setBgScheme(this.getSelectBgScheme());
        if (this.prmtBgOrgUnit.getData() instanceof CoreBaseInfo) {
            _filterParam.setBgOrgUnit((CoreBaseInfo)this.prmtBgOrgUnit.getData());
        } else {
            _filterParam.setBgOrgUnit(null);
        }
        if (this.prmtBgForm.getData() instanceof CoreBaseInfo) {
            _filterParam.setBgForm((CoreBaseInfo)this.prmtBgForm.getData());
        } else {
            _filterParam.setBgForm(null);
        }
        this.saveMembers(_filterParam.getMembers());
        _filterParam.setBgPeriods((BgPeriodInfo[])MbgDataQueryFilterUI.getObjects((Object)this.prmtBgPeriod.getData(), BgPeriodInfo.class));
        _filterParam.setCurrencies((CurrencyInfo[])MbgDataQueryFilterUI.getObjects((Object)this.prmtCurrency.getData(), CurrencyInfo.class));
        _filterParam.setBgElements((BgElementInfo[])MbgDataQueryFilterUI.getObjects((Object)this.prmtBgElement.getData(), BgElementInfo.class));
        _filterParam.setBgScenarios((BgScenarioInfo[])MbgDataQueryFilterUI.getObjects((Object)this.prmtBgScenario.getData(), BgScenarioInfo.class));
        _filterParam.setBgVersions((BgVersionInfo[])MbgDataQueryFilterUI.getObjects((Object)this.prmtBgVersion.getData(), BgVersionInfo.class));
    }

    private void saveMembers(List<AnalyseMember> memberList) {
        memberList.clear();
        if (this.tblMember.getRowCount() > 0) {
            IRow row = null;
            AnalyseMember member = null;
            List members = null;
            int in = this.tblMember.getRowCount();
            for (int i = 0; i < in; ++i) {
                row = this.tblMember.getRow(i);
                member = new AnalyseMember();
                members = row.getCell(COL_INDEX_MEMBERS).getValue() instanceof List ? (List)row.getCell(COL_INDEX_MEMBERS).getValue() : (row.getCell(COL_INDEX_MEMBERS).getUserObject() instanceof List ? (List)row.getCell(COL_INDEX_MEMBERS).getUserObject() : null);
                if (members != null) {
                    member.setBgIndex((BgDimensionMember)members.get(0));
                }
                if (row.getCell(COL_REF_MEMBERS).getValue() != null) {
                    member.setDimMember((BgDimensionMember)row.getCell(1).getValue());
                }
                memberList.add(member);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.rdoBgForm.setSelected(true);
        this.rdoC01.setSelected(true);
        this.prmtBgScheme.setDataNoNotify(null);
        if (this.cboCslOrgTree.getItemCount() > 0) {
            this.cboCslOrgTree.setSelectedIndex(0);
        }
        this.prmtCostCenter.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        try {
            this.setBgSchemeFilter(this.getSourceType());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.prmtBgForm.setData(null);
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgOrgUnit.setData(null);
            this.schemeHelper = null;
        }
        try {
            this.clearMember();
            this.clearOther();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

