/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.control.client.MbgAnalyseExeHelper;
import com.kingdee.eas.ma.mbg.BgDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BizCalcTraceFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDataStateEditUI;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MbgDataStateEditUI
extends AbstractMbgDataStateEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDataStateEditUI.class);
    private KDTSortManager sortManager = null;
    private static final String COL_orgunitid = "orgUnit.id";
    private static final String COL_bgDataId = "bgDataId";
    private static final String COL_formula = "formula";
    private static final String COL_bgIndex = "bgIndex";
    private static final String COL_refMember = "refMember";
    private static final String COL_bgPeriod = "bgPeriod";
    private static final String COL_bgScenario = "bgScenario";
    private static final String COL_bgElement = "bgElement";
    private static final String COL_verion = "version";
    private static final String COL_currency = "currency";
    private static final String COL_value = "value";
    private static final String COL_tmpValue = "tmpValue";
    private static final String COL_state = "state";
    private static final String COL_isAdjust = "isAdjust";
    private static final String COL_audOrgId = "audOrgId";
    private static final String COL_audOrgNumber = "audOrgNumber";
    private static final String COL_audOrgName = "audOrgName";
    private static final String COL_reportOrgId = "reportOrgId";
    private static final String COL_reportOrgNumber = "reportOrgNumber";
    private static final String COL_reportOrgName = "reportOrgName";
    private static final String COL_AudFormOrgName = "audFormOrgName";
    private static final String COL_AudFormNumber = "audFormNumber";
    private static final String COL_DataSource = "dataSource";
    private static final String COL_detail = "detail";
    private static final String COL_refBgForm = "refBgForm";
    private static final String COL_versionId = "version.id";
    private String YES = EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"yes");
    private String NO = EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"no");
    private String RES = "com.kingdee.eas.ma.mbg.MbgDataResource";
    private BgFormInfo bgFormInfo = null;
    private List<String> bgformulas = null;
    private int queryType = 0;
    private BgSchemeDimensionHelper schemeHelper = null;
    private List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
    private Object[] bgDataForms = new Object[3];

    public BgFormInfo getBgFormInfo() {
        return this.bgFormInfo;
    }

    public void setBgFormInfo(BgFormInfo bgFormInfo) {
        this.bgFormInfo = bgFormInfo;
    }

    public List<String> getBgformulas() {
        return this.bgformulas;
    }

    public void setBgformulas(List<String> bgformulas) {
        this.bgformulas = bgformulas;
    }

    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    public int getQueryType() {
        return this.queryType;
    }

    private BgSchemeInfo getSelectBgScheme() {
        if (this.getBgFormInfo() != null && this.getBgFormInfo().getBgScheme() != null) {
            return this.getBgFormInfo().getBgScheme();
        }
        return null;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws BOSException, EASBizException {
        if (this.schemeHelper == null && this.getBgFormInfo() != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.getBgFormInfo().getBgScheme().getId().toString());
        }
        return this.schemeHelper;
    }

    public KDTSortManager getSortManager() {
        if (this.sortManager == null) {
            this.sortManager = new KDTSortManager(this.getTable());
            this.sortManager.setSortAuto(false);
        }
        return this.sortManager;
    }

    private void clearResult() {
        if (this.result != null) {
            this.result.clear();
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.beforeOnLoad();
        super.onLoad();
        this.init();
        this.queryData(false);
    }

    protected void beforeOnLoad() {
        if (this.getUIContext().get("BGFORM_INFO") != null) {
            this.setBgFormInfo((BgFormInfo)this.getUIContext().get("BGFORM_INFO"));
        }
        if (this.getUIContext().get("FORMULA") != null) {
            this.setBgformulas((List)this.getUIContext().get("FORMULA"));
        }
    }

    protected void init() throws Exception {
        if (this.getSelectBgScheme() != null) {
            this.initBgAccount();
            this.initBgPeriod();
            this.initBgScenario();
            this.initBgElement();
        }
        KDComboBox combox = new KDComboBox();
        combox.addItem((Object)BgDataStateEnum.Edited);
        combox.addItem((Object)BgDataStateEnum.UnEditeable);
        combox.addItem((Object)BgDataStateEnum.Approved);
        combox.addItem((Object)BgDataStateEnum.Adjust);
        combox.addItem((Object)BgDataStateEnum.UnionReport);
        combox.addItem((Object)BgDataStateEnum.UnionReceive);
        this.getTable().getColumn(COL_state).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combox));
        combox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MbgDataStateEditUI.this.state_itemStateChanged(e);
            }
        });
        if (!BgParamUtils.supportDataStateEdit(null)) {
            this.getTable().getColumn(COL_state).getStyleAttributes().setLocked(true);
            this.btnSave.setVisible(false);
            this.btnBatchAudit.setVisible(false);
            this.btnBatchUnAudit.setVisible(false);
        } else {
            this.getTable().getColumn(COL_state).getStyleAttributes().setLocked(false);
            this.btnSave.setVisible(true);
            this.btnBatchAudit.setVisible(true);
            this.btnBatchUnAudit.setVisible(true);
        }
    }

    protected void state_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        KDComboBox cbx = (KDComboBox)e.getSource();
        int curRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(curRowIndex);
        if (row.getCell(COL_state).getUserObject() instanceof BgDataStateEnum) {
            BgDataStateEnum newState;
            BgDataStateEnum initState = (BgDataStateEnum)((Object)row.getCell(COL_state).getUserObject());
            if (!initState.equals((Object)(newState = (BgDataStateEnum)((Object)cbx.getSelectedItem())))) {
                this.checkEditState(e, initState, newState, row);
            }
            if (initState == null || newState != null && !initState.equals((Object)newState)) {
                row.getCell(COL_state).getStyleAttributes().setBackground(BgNConstants.EDIT_COLOR);
            } else {
                row.getCell(COL_state).getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Boolean checkEditState(ItemEvent e, BgDataStateEnum initState, BgDataStateEnum newState, IRow row) {
        String bgDataId = row.getCell(COL_bgDataId).getValue().toString();
        if (BgDataStateEnum.Edited.equals((Object)initState)) {
            if (BgDataStateEnum.Approved.equals((Object)newState)) {
                Set bgformIds;
                if (this.bgDataForms == null) return true;
                Map bgFormsMap = (Map)this.bgDataForms[0];
                Map bgdataRefFormsIds = (Map)this.bgDataForms[1];
                Map bgdataAuditFormIds = (Map)this.bgDataForms[2];
                if (bgdataRefFormsIds != null && !bgdataRefFormsIds.isEmpty() && bgdataRefFormsIds.containsKey(bgDataId)) {
                    bgformIds = (Set)bgdataRefFormsIds.get(bgDataId);
                    for (String bgFormId : bgformIds) {
                        if (bgFormsMap == null || bgFormsMap.isEmpty() || !bgFormsMap.containsKey(bgFormId) || !BgFormStateEnum.Approved.equals((Object)((BgFormInfo)bgFormsMap.get(bgFormId)).getState())) continue;
                        return true;
                    }
                }
                if (bgdataAuditFormIds != null && !bgdataAuditFormIds.isEmpty() && bgdataAuditFormIds.containsKey(bgDataId)) {
                    bgformIds = (Set)bgdataAuditFormIds.get(bgDataId);
                    for (String bgFormId : bgformIds) {
                        if (bgFormsMap == null || bgFormsMap.isEmpty() || !bgFormsMap.containsKey(bgFormId) || !BgFormStateEnum.Approved.equals((Object)((BgFormInfo)bgFormsMap.get(bgFormId)).getState())) continue;
                        return true;
                    }
                }
                if (e == null) return false;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState1"));
                ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
                SysUtil.abort();
                return true;
            } else {
                if (e == null) return false;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState2", (Object[])new Object[]{newState.getAlias()}));
                ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
                SysUtil.abort();
            }
            return true;
        } else if (BgDataStateEnum.UnEditeable.equals((Object)initState)) {
            if (e == null) return false;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState3"));
            ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
            SysUtil.abort();
            return true;
        } else if (BgDataStateEnum.Approved.equals((Object)initState)) {
            if (BgDataStateEnum.Edited.equals((Object)newState)) {
                Set bgformIds;
                if (this.bgDataForms == null) return true;
                Map bgFormsMap = (Map)this.bgDataForms[0];
                Map bgdataRefFormsIds = (Map)this.bgDataForms[1];
                Map bgdataAuditFormIds = (Map)this.bgDataForms[2];
                if (row.getCell(COL_audOrgId) != null && row.getCell(COL_audOrgId).getValue() != null) {
                    String audOrgId = row.getCell(COL_audOrgId).getValue().toString();
                    if (BgFormStateEnum.Edited.equals((Object)this.getBgFormInfo().getState()) && audOrgId.equals(this.getBgFormInfo().getOrgUnit().getId().toString())) return true;
                    if (e == null) return false;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState1"));
                    ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
                    SysUtil.abort();
                }
                if (bgdataRefFormsIds != null && !bgdataRefFormsIds.isEmpty() && bgdataRefFormsIds.containsKey(bgDataId)) {
                    bgformIds = (Set)bgdataRefFormsIds.get(bgDataId);
                    for (String bgFormId : bgformIds) {
                        if (bgFormsMap == null || bgFormsMap.isEmpty() || !bgFormsMap.containsKey(bgFormId) || BgFormStateEnum.Edited.equals((Object)((BgFormInfo)bgFormsMap.get(bgFormId)).getState())) continue;
                        if (e == null) return false;
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState1"));
                        ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
                        SysUtil.abort();
                    }
                }
                if (bgdataAuditFormIds == null || bgdataAuditFormIds.isEmpty() || !bgdataAuditFormIds.containsKey(bgDataId)) return true;
                bgformIds = (Set)bgdataAuditFormIds.get(bgDataId);
                for (String bgFormId : bgformIds) {
                    if (bgFormsMap == null || bgFormsMap.isEmpty() || !bgFormsMap.containsKey(bgFormId) || BgFormStateEnum.Edited.equals((Object)((BgFormInfo)bgFormsMap.get(bgFormId)).getState())) continue;
                    if (e == null) return false;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState1"));
                    ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
                    SysUtil.abort();
                }
                return true;
            } else {
                if (e == null) return false;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState4", (Object[])new Object[]{newState.getAlias()}));
                ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
                SysUtil.abort();
            }
            return true;
        } else {
            if (e == null) return false;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState5", (Object[])new Object[]{initState.getAlias()}));
            ((KDComboBox)e.getSource()).setSelectedItem((Object)initState, false);
            SysUtil.abort();
        }
        return true;
    }

    @Override
    protected void executeQuery() throws Exception {
    }

    protected void queryData(Boolean longTimeTask) throws Exception {
        if (longTimeTask.booleanValue()) {
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    MbgDataStateEditUI.this.doExecuteQuery();
                    MbgDataStateEditUI.this.fillTable(MbgDataStateEditUI.this.result, MbgDataStateEditUI.this.getFilterMap());
                    return null;
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        } else {
            this.doExecuteQuery();
            this.fillTable(this.result, this.getFilterMap());
        }
    }

    protected void doExecuteQuery() throws EASBizException, BOSException {
        this.result = (List)BizCalcTraceFacadeFactory.getRemoteInstance().queryMbgDatas(this.getBgformulas(), this.getBgFormInfo(), this.getQueryType());
        this.queryBgDataForms(this.result);
    }

    protected void queryBgDataForms(List<Map<String, Object>> result) throws EASBizException, BOSException {
        HashSet<String> bgDataIds = new HashSet<String>();
        Map<String, Object> rowResult = null;
        for (int i = 0; i < result.size(); ++i) {
            rowResult = result.get(i);
            bgDataIds.add(rowResult.get("FBgDataId").toString());
        }
        this.bgDataForms = (Object[])BizCalcTraceFacadeFactory.getRemoteInstance().queryDataForms(this.getBgFormInfo(), bgDataIds);
    }

    @Override
    protected boolean hasDefaultQuery() throws Exception {
        return Boolean.TRUE;
    }

    protected Boolean checkFilterMap(Map<String, Set<String>> filterMap, String dimensionNumber, String memberNumber) {
        return filterMap.containsKey(dimensionNumber) && !filterMap.get(dimensionNumber).isEmpty() && !filterMap.get(dimensionNumber).contains(memberNumber);
    }

    protected Boolean checkFilterMap(Map<String, Set<String>> filterMap, String formulaStr) {
        String[] params = null;
        String bgAccountNum = "";
        String bgPeriodNum = "";
        String bgElementNum = "";
        String bgScenarioNum = "";
        if (filterMap != null && !filterMap.isEmpty() && !StringUtils.isEmpty((String)formulaStr)) {
            params = BgNFSHelper.parseFormulaPara(formulaStr);
            bgAccountNum = params[0].split(",")[0].split(":")[1];
            bgPeriodNum = params[1];
            bgElementNum = params[2];
            bgScenarioNum = params[3];
            if (this.checkFilterMap(filterMap, DimensionConstants.DEF_ACCOUNT_NUMBER, bgAccountNum).booleanValue()) {
                return true;
            }
            if (this.checkFilterMap(filterMap, DimensionConstants.DEF_PERIOD_NUMBER, bgPeriodNum).booleanValue()) {
                return true;
            }
            if (this.checkFilterMap(filterMap, DimensionConstants.DEF_ELEMENT_NUMBER, bgElementNum).booleanValue()) {
                return true;
            }
            if (this.checkFilterMap(filterMap, DimensionConstants.DEF_SCENARIO_NUMBER, bgScenarioNum).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    protected void fillTable(List<Map<String, Object>> result, Map<String, Set<String>> filterMap) {
        this.getTable().removeRows();
        if (result != null && !result.isEmpty()) {
            Map<String, Object> rowResult = null;
            IRow row = null;
            for (int i = 0; i < result.size(); ++i) {
                rowResult = result.get(i);
                if (filterMap != null && this.checkFilterMap(filterMap, (String)rowResult.get("FFormula")).booleanValue()) continue;
                row = this.getTable().addRow();
                row.getCell(COL_bgDataId).setValue(rowResult.get("FBgDataId"));
                row.getCell(COL_orgunitid).setValue(rowResult.get("FOrgUnitID"));
                row.getCell(COL_formula).setValue(rowResult.get("FFormula"));
                row.getCell(COL_bgIndex).setValue(rowResult.get("FBgIndexName"));
                row.getCell(COL_refMember).setValue(rowResult.get("FRefMemberName"));
                row.getCell(COL_bgPeriod).setValue(rowResult.get("FBgPeriodName"));
                row.getCell(COL_bgScenario).setValue(rowResult.get("FScenarioName"));
                row.getCell(COL_bgElement).setValue(rowResult.get("FBgElementName"));
                row.getCell(COL_currency).setValue(rowResult.get("FCurrencyName"));
                row.getCell(COL_verion).setValue(rowResult.get("FVersionName"));
                row.getCell(COL_value).setValue(rowResult.get("FValue"));
                row.getCell(COL_tmpValue).setValue(rowResult.get("FTmpValue"));
                if (rowResult.get("FState") instanceof Number) {
                    row.getCell(COL_state).setUserObject((Object)BgDataStateEnum.getEnum(((Number)rowResult.get("FState")).intValue()));
                    row.getCell(COL_state).setValue((Object)BgDataStateEnum.getEnum(((Number)rowResult.get("FState")).intValue()));
                }
                if (rowResult.get("FIsAdjust") instanceof Number) {
                    row.getCell(COL_isAdjust).setValue((Object)(((Number)rowResult.get("FIsAdjust")).intValue() != 0 ? 1 : 0));
                }
                this.getTable().getColumn(COL_isAdjust).setRenderer(this.getTable().getDefaultRenderer(Boolean.class));
                row.getCell(COL_audOrgId).setValue(rowResult.get("FAudOrgUnitID"));
                row.getCell(COL_audOrgNumber).setValue(rowResult.get("FAudOrgNumber"));
                row.getCell(COL_audOrgName).setValue(rowResult.get("FAudOrgName"));
                row.getCell(COL_reportOrgId).setValue(rowResult.get("FReportOrgUnitID"));
                row.getCell(COL_reportOrgNumber).setValue(rowResult.get("FReportOrgNumber"));
                row.getCell(COL_reportOrgName).setValue(rowResult.get("FReportOrgName"));
                if ("1".equals(String.valueOf(rowResult.get("FDetail")))) {
                    row.getCell(COL_detail).setValue((Object)this.YES);
                } else if ("0".equals(String.valueOf(rowResult.get("FDetail")))) {
                    row.getCell(COL_detail).setValue((Object)this.NO);
                }
                row.getCell(COL_refBgForm).setValue(rowResult.get("FRefFormNumber"));
                row.getCell(COL_versionId).setValue(rowResult.get("FVersion"));
                row.getCell(COL_AudFormOrgName).setValue(rowResult.get("FAudFormOrgName"));
                row.getCell(COL_AudFormNumber).setValue(rowResult.get("FAudFormNumber"));
                if (rowResult.get("FDataSource") == null || !(rowResult.get("FDataSource") instanceof Number)) continue;
                row.getCell(COL_DataSource).setValue((Object)BgDataSourceEnum.getEnum(((Number)rowResult.get("FDataSource")).intValue()));
            }
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.getTable().checkParsed();
        this.getTable().getColumn(COL_isAdjust).setRenderer(this.getTable().getDefaultRenderer(Boolean.class));
        this.getTable().getSelectManager().setSelectMode(15);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.orderByForTable(e);
            return;
        }
    }

    private void orderByForTable(KDTMouseEvent e) throws Exception {
        String columnName;
        if (e.getType() == 0 && (columnName = this.tblMain.getColumn(e.getColIndex()).getKey()) == null) {
            return;
        }
    }

    @Override
    public KDTable getTable() {
        return this.tblMain;
    }

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
        mgr = new PopupMenuManager();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return super.getOrgPK(action);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke(69, 192, false));
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    protected void initBgAccount() throws EASBizException, BOSException {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog();
        dialog.setSchemeHelper(this.getSchemeHelper());
        dialog.setMulti(true);
        dialog.setDimension(dimension);
        this.prmtBgAccount.setSelector((KDPromptSelector)dialog);
        this.prmtBgAccount.setEditable(false);
    }

    protected void initBgPeriod() throws Exception {
        if (this.getSelectBgScheme() == null) {
            return;
        }
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodBeginDate(this.getSelectBgScheme().getDateFrom());
        dialog.setBgPeriodEndDate(this.getSelectBgScheme().getDateTo());
        dialog.setMultiSelect(true);
        dialog.setBgSchemeID(this.getSelectBgScheme().getId().toString());
        dialog.setOnlyLeaf(true);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.setEditable(false);
    }

    protected void initBgElement() throws Exception {
        Set elementID = MbgAnalyseExeHelper.getElementID((BgSchemeInfo)this.getSelectBgScheme());
        EntityViewInfo view = this.prmtBgElement.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)elementID, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtBgElement.setEntityViewInfo(view);
        this.prmtBgElement.setEditable(false);
        this.prmtBgElement.setEnabledMultiSelection(true);
    }

    protected void initBgScenario() throws Exception {
        Set scenarioID = MbgAnalyseExeHelper.getBgScenarioID((BgSchemeInfo)this.getSelectBgScheme());
        EntityViewInfo view = this.prmtBgScenario.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)scenarioID, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtBgScenario.setEntityViewInfo(view);
        this.prmtBgScenario.setEditable(false);
        this.prmtBgScenario.setEnabledMultiSelection(true);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        HashMap mbgDatas = new HashMap();
        HashMap<BgDataStateEnum, Set<String>> mbgFormulas = new HashMap<BgDataStateEnum, Set<String>>();
        String bgDataId = null;
        String formula = null;
        BgDataStateEnum newState = BgDataStateEnum.Edited;
        BgDataStateEnum oldState = null;
        IRow row = null;
        int count = this.getTable().getRowCount();
        if (count >= 0) {
            for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
                row = this.getTable().getRow(rowIndex);
                bgDataId = row.getCell(COL_bgDataId).getValue().toString();
                formula = row.getCell(COL_formula).getValue().toString();
                if (row.getCell(COL_state).getUserObject() instanceof BgDataStateEnum) {
                    oldState = (BgDataStateEnum)((Object)row.getCell(COL_state).getUserObject());
                }
                if (row.getCell(COL_state).getValue() instanceof BgDataStateEnum) {
                    newState = (BgDataStateEnum)((Object)row.getCell(COL_state).getValue());
                }
                if (StringUtils.isEmpty((String)bgDataId) || newState == null || newState.equals((Object)oldState)) continue;
                if (!mbgDatas.containsKey((Object)newState)) {
                    mbgDatas.put(newState, new HashSet());
                }
                ((Set)mbgDatas.get((Object)newState)).add(bgDataId);
                if (!mbgFormulas.containsKey((Object)newState)) {
                    mbgFormulas.put(newState, new HashSet());
                }
                ((Set)mbgFormulas.get((Object)newState)).add(formula);
            }
        }
        if (!mbgDatas.isEmpty()) {
            BizCalcTraceFacadeFactory.getRemoteInstance().updateMbgDateState(this.getBgFormInfo(), mbgDatas);
            this.queryData(true);
            this.afterSave(mbgFormulas);
        }
    }

    protected void afterSave(Map<BgDataStateEnum, Set<String>> mbgFormulas) {
        if (this.getUIContext().get("Book") != null && this.getUIContext().get("Book") instanceof Book && this.getUIContext().get("SpreadContext") != null && this.getUIContext().get("SpreadContext") instanceof SpreadContext) {
            Book book = (Book)this.getUIContext().get("Book");
            SpreadContext spreadContext = (SpreadContext)this.getUIContext().get("SpreadContext");
            Sheet sheet = null;
            Cell cell = null;
            String formulaStr = null;
            int rowCount = 0;
            int colCount = 0;
            int rowIndex = 0;
            int colIndex = 0;
            int sheetSize = book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                sheet = book.getSheet(sheetIndex);
                rowCount = sheet.getMaxRowIndex();
                colCount = sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        cell = sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                        if (cell.isLocked()) {
                            if (!mbgFormulas.containsKey((Object)BgDataStateEnum.Edited) || !mbgFormulas.get((Object)BgDataStateEnum.Edited).contains(formulaStr)) continue;
                            BgNFSHelper.setLockOfCell(cell, false);
                            BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
                            this.repaintCell(spreadContext, cell);
                            continue;
                        }
                        if (!mbgFormulas.containsKey((Object)BgDataStateEnum.Approved) || !mbgFormulas.get((Object)BgDataStateEnum.Approved).contains(formulaStr)) continue;
                        BgNFSHelper.setLockOfCell(cell, true);
                        BgNFSHelper.setBackGroup(cell, BgNConstants.LOCK_COLOR);
                        this.repaintCell(spreadContext, cell);
                    }
                }
            }
        }
    }

    private void repaintCell(SpreadContext spreadContext, Cell cell) {
        if (spreadContext == null || cell == null) {
            return;
        }
        spreadContext.repaint(new Rectangle(SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)true)));
    }

    @Override
    public void actionBatchAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchAudit_actionPerformed(e);
        this.checkSelected();
        this.doBatch(true);
    }

    @Override
    public void actionBatchUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchUnAudit_actionPerformed(e);
        this.checkSelected();
        this.doBatch(false);
    }

    protected void doBatch(Boolean isAudit) {
        BgDataStateEnum newState = null;
        BgDataStateEnum initState = null;
        KDTSelectBlock block = null;
        IRow row = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            int rangeCount = range.size();
            int allCount = 0;
            int successCount = 0;
            for (int i = 0; i < rangeCount; ++i) {
                block = (KDTSelectBlock)range.get(i);
                if (block == null) continue;
                int rowBegin = block.getBeginRow();
                int rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    row = this.tblMain.getRow(j);
                    ++allCount;
                    if (row.getCell(COL_state).getUserObject() instanceof BgDataStateEnum) {
                        initState = (BgDataStateEnum)((Object)row.getCell(COL_state).getUserObject());
                    }
                    if (isAudit.booleanValue()) {
                        if (this.checkEditState(null, initState, BgDataStateEnum.Approved, row).booleanValue() || BgDataStateEnum.Approved.equals((Object)initState)) {
                            row.getCell(COL_state).setValue((Object)BgDataStateEnum.Approved);
                            ++successCount;
                        }
                    } else if (this.checkEditState(null, initState, BgDataStateEnum.Edited, row).booleanValue() || BgDataStateEnum.Edited.equals((Object)initState)) {
                        row.getCell(COL_state).setValue((Object)BgDataStateEnum.Edited);
                        ++successCount;
                    }
                    newState = (BgDataStateEnum)((Object)row.getCell(COL_state).getValue());
                    if (initState == null || newState != null && !initState.equals((Object)newState)) {
                        row.getCell(COL_state).getStyleAttributes().setBackground(BgNConstants.EDIT_COLOR);
                        continue;
                    }
                    row.getCell(COL_state).getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
                }
            }
            if (isAudit.booleanValue()) {
                if (allCount != successCount) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState6", (Object[])new Object[]{allCount, allCount - successCount}));
                }
            } else if (allCount != successCount) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"cannotEditState7", (Object[])new Object[]{allCount, allCount - successCount}));
            }
        }
    }

    @Override
    protected void prmtBgAccount_dataChanged(DataChangeEvent e) throws Exception {
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        filterMap.put(DimensionConstants.DEF_INDEX_NUMBER, this.getNumbers(e.getNewValue()));
        filterMap.put(DimensionConstants.DEF_PERIOD_NUMBER, this.getNumbers(this.prmtBgPeriod));
        filterMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, this.getNumbers(this.prmtBgElement));
        filterMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, this.getNumbers(this.prmtBgScenario));
        this.fillTable(this.result, filterMap);
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        filterMap.put(DimensionConstants.DEF_INDEX_NUMBER, this.getNumbers(this.prmtBgAccount));
        filterMap.put(DimensionConstants.DEF_PERIOD_NUMBER, this.getNumbers(e.getNewValue()));
        filterMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, this.getNumbers(this.prmtBgElement));
        filterMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, this.getNumbers(this.prmtBgScenario));
        this.fillTable(this.result, filterMap);
    }

    @Override
    protected void prmtBgElement_dataChanged(DataChangeEvent e) throws Exception {
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        filterMap.put(DimensionConstants.DEF_INDEX_NUMBER, this.getNumbers(this.prmtBgAccount));
        filterMap.put(DimensionConstants.DEF_PERIOD_NUMBER, this.getNumbers(this.prmtBgPeriod));
        filterMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, this.getNumbers(e.getNewValue()));
        filterMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, this.getNumbers(this.prmtBgScenario));
        this.fillTable(this.result, filterMap);
    }

    @Override
    protected void prmtBgScenario_dataChanged(DataChangeEvent e) throws Exception {
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        filterMap.put(DimensionConstants.DEF_INDEX_NUMBER, this.getNumbers(this.prmtBgAccount));
        filterMap.put(DimensionConstants.DEF_PERIOD_NUMBER, this.getNumbers(this.prmtBgPeriod));
        filterMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, this.getNumbers(this.prmtBgElement));
        filterMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, this.getNumbers(e.getNewValue()));
        this.fillTable(this.result, filterMap);
    }

    protected Map<String, Set<String>> getFilterMap() {
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        filterMap.put(DimensionConstants.DEF_INDEX_NUMBER, this.getNumbers(this.prmtBgAccount));
        filterMap.put(DimensionConstants.DEF_PERIOD_NUMBER, this.getNumbers(this.prmtBgPeriod));
        filterMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, this.getNumbers(this.prmtBgElement));
        filterMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, this.getNumbers(this.prmtBgScenario));
        return filterMap;
    }

    protected Set<String> getNumbers(KDBizPromptBox prmtbox) {
        HashSet<String> numbers = new HashSet<String>();
        if (prmtbox == null || prmtbox.getData() == null) {
            return numbers;
        }
        return this.getNumbers(prmtbox.getData());
    }

    protected Set<String> getNumbers(Object obj) {
        HashSet<String> numbers;
        block5: {
            block7: {
                block6: {
                    block4: {
                        numbers = new HashSet<String>();
                        if (!(obj instanceof DataBaseInfo)) break block4;
                        if (StringUtils.isEmpty((String)((DataBaseInfo)obj).getNumber())) break block5;
                        numbers.add(((DataBaseInfo)obj).getNumber());
                        break block5;
                    }
                    if (!(obj instanceof DataBaseInfo[])) break block6;
                    DataBaseInfo[] arr = (DataBaseInfo[])obj;
                    DataBaseInfo info = null;
                    for (int i = 0; i < arr.length; ++i) {
                        info = arr[i];
                        if (info == null || StringUtils.isEmpty((String)info.getNumber())) continue;
                        numbers.add(info.getNumber());
                    }
                    break block5;
                }
                if (!(obj instanceof List)) break block7;
                List lst = (List)obj;
                if (lst.isEmpty()) break block5;
                for (int i = 0; i < lst.size(); ++i) {
                    if (!(lst.get(i) instanceof BgDimensionMember)) continue;
                    numbers.add(((BgDimensionMember)lst.get(i)).getNumber());
                }
                break block5;
            }
            if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    if (!(arr[i] instanceof DataBaseInfo)) continue;
                    numbers.add(((DataBaseInfo)arr[i]).getNumber());
                }
            }
        }
        return numbers;
    }

    @Override
    protected void rbCurrentFormSelectData_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 2) {
            this.selectChangeQuery(0);
        }
    }

    @Override
    protected void rbCurrentFormRefData_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 2) {
            this.selectChangeQuery(1);
        }
    }

    @Override
    protected void rbCurrentFormAuditRangeData_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 2) {
            this.selectChangeQuery(2);
        }
    }

    protected void selectChangeQuery(int type) throws Exception {
        this.setQueryType(type);
        this.clearResult();
        this.queryData(true);
    }

    protected boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    @Override
    protected String getExportFileName() {
        return EASResource.getString((String)this.RES, (String)"mbgDataStateEdit");
    }
}

