/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.AbstractBgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedResultCollection;
import com.kingdee.eas.ma.mbg.BgFinalizedResultEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.IBgFinalizedResult;
import com.kingdee.eas.ma.mbg.MbgDataStateSynFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDataStateSynNewProgressUI;
import com.kingdee.eas.ma.mbg.client.MyMsgBox;
import com.kingdee.eas.ma.mbg.client.utils.MbgDataStateSynClientHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MbgDataStateSynNewProgressUI
extends AbstractMbgDataStateSynNewProgressUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDataStateSynNewProgressUI.class);
    private boolean isClose = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.progBar.setStringPainted(true);
        BgFormCollection bgFormColls = (BgFormCollection)((Object)this.getUIContext().get("BGFORM_INFO"));
        BgFinalizedResultInfo resultInfo = this.getResult();
        List resultList = this.startExecuteThread(bgFormColls, resultInfo);
        this.startShowResultThread(resultInfo, bgFormColls, resultList);
    }

    protected void startShowResultThread(final BgFinalizedResultInfo resultInfo, final BgFormCollection bgFormColls, final List resultList) {
        Thread result = new Thread(){

            @Override
            public void run() {
                if (UserMonitorClientTool.getRegistryInfo() != null) {
                    UserMonitorClientTool.getRegistryInfo().setFinished(false);
                }
                try {
                    MbgDataStateSynNewProgressUI.this.showResult(resultInfo, bgFormColls, resultList);
                }
                finally {
                    if (UserMonitorClientTool.getRegistryInfo() != null) {
                        UserMonitorClientTool.getRegistryInfo().setFinished(true);
                    }
                }
            }
        };
        result.start();
    }

    protected BgFinalizedResultInfo getResult() throws BOSException, EASBizException {
        BgFinalizedResultInfo result = null;
        IBgFinalizedResult iBgFinalizedResult = BgFinalizedResultFactory.getRemoteInstance();
        result = new BgFinalizedResultInfo();
        result.setId(BOSUuid.create((BOSObjectType)result.getBOSType()));
        result.setState(BgFinalizedResultEnum.syn);
        result.setResult("\u64cd\u4f5c\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026");
        result.setCurrentIndex(0);
        result.setTotalCount(0);
        iBgFinalizedResult.save(result);
        return result;
    }

    protected List startExecuteThread(final BgFormCollection bgFormColls, final BgFinalizedResultInfo resultInfo) {
        final ArrayList resultList = new ArrayList();
        Thread executor = new Thread(){

            @Override
            public void run() {
                resultList.addAll(MbgDataStateSynNewProgressUI.this.execute(bgFormColls, resultInfo));
            }
        };
        executor.start();
        return resultList;
    }

    protected List execute(BgFormCollection bgFormColls, BgFinalizedResultInfo resultInfo) {
        List resultList = null;
        try {
            resultList = (List)MbgDataStateSynFacadeFactory.getRemoteInstance().executeSynNew(bgFormColls, resultInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.destroyWindow();
        return resultList;
    }

    @Override
    protected void btnBackStage_actionPerformed(ActionEvent e) throws Exception {
        super.btnBackStage_actionPerformed(e);
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        this.isClose = true;
        return super.destroyWindow();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuBar.setVisible(false);
        if (this.statusBar != null) {
            this.statusBar.setVisible(false);
        }
    }

    private void showResult(BgFinalizedResultInfo resultInfo, BgFormCollection bgFormColls, List resultList) {
        long startTime = System.currentTimeMillis();
        long maxTimeout = 6000000L;
        ObjectUuidPK pk = new ObjectUuidPK(resultInfo.getId());
        boolean isFirst = true;
        while (!this.isClose) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
            try {
                AbstractBgFinalizedResultInfo r = null;
                BgFinalizedResultCollection col = BgFinalizedResultFactory.getRemoteInstance().getBgFinalizedResultCollection("where id = '" + pk + "'");
                if (col != null && !col.isEmpty()) {
                    r = col.get(0);
                    if (isFirst) {
                        isFirst = false;
                    }
                }
                if (r == null) {
                    if (System.currentTimeMillis() - startTime <= maxTimeout) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)"\u6570\u636e\u72b6\u6001\u540c\u6b65\u8d85\u65f6");
                    this.destroyWindow();
                    return;
                }
                if (BgFinalizedResultEnum.success.equals((Object)r.getState())) {
                    this.isClose = true;
                    MbgDataStateSynClientHelper.showResult(this, resultList);
                    return;
                }
                if (BgFinalizedResultEnum.exception.equals((Object)r.getState())) {
                    this.isClose = true;
                    this.showException((BgFinalizedResultInfo)r);
                    return;
                }
                if (!BgFinalizedResultEnum.syn.equals((Object)r.getState())) continue;
                this.progBar.setMaximum(bgFormColls.size());
                this.progBar.setValue(bgFormColls.size());
                this.lblState.setText(r.getResult());
                this.progBar.setString(r.getCurrentIndex() + "/" + bgFormColls.size());
                this.updateUI();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                if (MbgDataStateSynNewProgressUI.isSessionClosedException(e)) {
                    if (MyMsgBox.showSessionError((Component)((Object)this), e) == 99) continue;
                    this.isClose = true;
                    continue;
                }
                this.isClose = true;
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    private static boolean isSessionClosedException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (true) {
            int errorCode = Utils.getRPCErrorCode((Throwable)exc);
            if (Utils.isRPCException((Throwable)exc) && (errorCode == 1002 || errorCode == 1001) || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                return true;
            }
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
    }

    private void showException(BgFinalizedResultInfo r) {
        MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u6570\u636e\u72b6\u6001\u540c\u6b65\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8ba9\u5b9e\u65bd\u6536\u96c6\u65e5\u5fd7\u540e\u53cd\u9988\u5206\u6790\uff01", (String)r.getException(), (int)1);
    }
}

