/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgDimListF7UI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class MbgDimListF7UI
extends AbstractMbgDimListF7UI {
    private static final Logger logger = CoreUIObject.getLogger(MbgDimListF7UI.class);
    public static final String COL_ID = "id";
    public static final String COL_NUMBER = "number";
    public static final String COL_NAME = "name";
    public static final String COL_LEVEL = "level";
    public static final String COL_ISlEAF = "isLeaf";
    public static final String MBG_DIM = "mbgDim";
    private String orgID = null;
    private String mbgDim = null;
    public List result = null;
    private boolean isCanceled = true;

    public List getResult() {
        return this.result;
    }

    public void setResult(List result) {
        this.result = result;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void onLoad() throws Exception {
        this.orgID = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.mbgDim = (String)this.getUIContext().get(MBG_DIM);
        super.onLoad();
        this.initTable();
        if (RptSrcTypeEnum.PT_BUDGET_REPORT.equals((Object)this.getSourceType())) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else if (RptSrcTypeEnum.FY_BUDGET_REPORT.equals((Object)this.getSourceType())) {
            this.tblMain.getSelectManager().setSelectMode(2);
        } else if (RptSrcTypeEnum.ZJ_BUDGET_REPORT.equals((Object)this.getSourceType())) {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
    }

    public RptSrcTypeEnum getSourceType() {
        if (this.getUIContext().get("sourceType") != null) {
            return (RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType"));
        }
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    protected void initTable() {
        this.tblMain.checkParsed();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            return;
        }
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionConfirm();
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.actionConfirm();
    }

    protected void actionConfirm() throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, new HashSet(idList), CompareType.INCLUDE));
        this.result = Arrays.asList(this.getBizInterface().getCollection(view).toArray());
        if (this.result.size() == 0) {
            this.result = null;
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MbgDimFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        HashSet<String> longNumbers = new HashSet<String>();
        HashSet<String> costCenterID = new HashSet<String>();
        try {
            CostCenterOrgUnitInfo costCenter = (CostCenterOrgUnitInfo)CostCenterOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.orgID));
            String longNumber = costCenter.getLongNumber();
            String[] numbers = longNumber.split("!");
            for (int i = 0; i < numbers.length; ++i) {
                StringBuffer tmpNum = new StringBuffer();
                for (int j = 0; j <= i; ++j) {
                    tmpNum.append(numbers[j]).append("!");
                }
                tmpNum.deleteCharAt(tmpNum.length() - 1);
                longNumbers.add(tmpNum.toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            view.setFilter(filter1);
            filter1.getFilterItems().add(new FilterItemInfo("longNumber", longNumbers, CompareType.INCLUDE));
            CostCenterOrgUnitCollection coll = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                CostCenterOrgUnitInfo costCenterInfo = coll.get(i);
                costCenterID.add(costCenterInfo.getId().toString());
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", costCenterID, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)"cgF89YoyRcmRucQ54HHobtF3hSs=", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
        viewInfo.setFilter(this.getQueryFilter(filter));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo(COL_NUMBER));
        viewInfo.setSorter(sorter);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.mbgDim)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo(COL_NUMBER, (Object)this.mbgDim, CompareType.INCLUDE));
            this.result = Arrays.asList(this.getBizInterface().getCollection(view).toArray());
            if (this.result.size() == 0) {
                this.result = null;
            }
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnMbgDimSearch_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    private FilterInfo getQueryFilter(FilterInfo filter) {
        String queryStr = this.txtMbgDimSearch.getText();
        if (!StringUtils.isEmpty((String)queryStr)) {
            FilterInfo _filter = new FilterInfo();
            _filter.getFilterItems().add(new FilterItemInfo(COL_NUMBER, (Object)("%" + queryStr + "%"), CompareType.LIKE));
            _filter.getFilterItems().add(new FilterItemInfo(COL_NAME, (Object)("%" + queryStr + "%"), CompareType.LIKE));
            _filter.setMaskString("#0 OR #1");
            try {
                filter.mergeFilter(_filter, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    @Override
    protected void txtMbgDimSearch_focusLost(FocusEvent e) throws Exception {
        this.refreshList();
    }
}

