/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgFormDimensionRelationEditUI;
import com.kingdee.eas.ma.mbg.client.MbgDimRelationSelectUI;
import com.kingdee.eas.ma.mbg.client.ViewListFormRelationBaseF7UI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MbgFormDimensionRelationEditUI
extends AbstractMbgFormDimensionRelationEditUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = 1056798913596242597L;
    private static final Logger logger = CoreUIObject.getLogger(MbgFormDimensionRelationEditUI.class);
    public static final String VIEW_MANAGER = "VIEW_MANAGER";
    public static final String MULTIPLE_ROW_SELECT = "MULTIPLE_ROW_SELECT";
    public static final String FILTER_MAP = "FILTER_MAP";
    private CostCenterOrgUnitInfo orgUnit = null;
    protected final Map<DimensionRelationshipGroupInfo, MbgRelationMap> relations = new HashMap<DimensionRelationshipGroupInfo, MbgRelationMap>();
    private boolean isCancel = true;
    private boolean isDimensionDelete = false;
    private boolean multipleSelect = true;
    private final Map<String, Set<String>> bgTemplateRelations = new HashMap<String, Set<String>>();

    public boolean isMultipleSelect() {
        return this.multipleSelect;
    }

    @Override
    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        return DimensionMemberSelectHelper.getSchemeHelper(this.getUIContext().get("Owner"));
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("isDimensionDel") instanceof Boolean) {
            this.isDimensionDelete = (Boolean)this.getUIContext().get("isDimensionDel");
        }
        if (this.getUIContext().get(MULTIPLE_ROW_SELECT) instanceof Boolean) {
            this.multipleSelect = (Boolean)this.getUIContext().get(MULTIPLE_ROW_SELECT);
        }
        super.onLoad();
        this.readBgTemplateRelation();
        this.readOrgUnit();
        this.readGroup();
        this.loadGroup();
        if (this.isDimensionDelete()) {
            this.fillValueToTable(this.getGroupInfo(), null);
        }
    }

    private void readBgTemplateRelation() throws Exception {
        String bgTemplateId = (String)this.getUIContext().get("BGTEMPLATE_ID");
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return;
        }
        BgViewDimensionInfo bgTemplateView = BgViewDimensionFactory.getRemoteInstance().getBgViewDimensionInfo("select data where template.id = '" + bgTemplateId + "'");
        IMbgViewManager view = new MbgXMLParser().parse(bgTemplateView.getData());
        if (view != null && view.getRelationMaps() != null) {
            for (int r = 0; r < view.getRelationMaps().size(); ++r) {
                MbgRelationMap map = view.getRelationMaps().get(r);
                if (map.getRelationShips() == null || map.getRelationShips().isEmpty()) continue;
                HashSet<String> ships = new HashSet<String>();
                this.bgTemplateRelations.put(map.getGroup().getId().toString(), ships);
                for (int s = 0; s < map.getRelationShips().size(); ++s) {
                    ships.add(map.getRelationShips().get(s).getDimensionNumber());
                }
            }
        }
    }

    public void onShow() throws Exception {
        if (this.isDimensionDelete() && this.isMultipleSelect()) {
            this.tblMain.getColumn("select").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("select").getStyleAttributes().setHided(true);
        }
    }

    private void fillValueToTable(DimensionRelationshipGroupInfo groupInfo, String filterStr) throws EASBizException, BOSException {
        if (this.relations == null || this.relations.isEmpty()) {
            return;
        }
        if (!this.relations.containsKey(groupInfo)) {
            return;
        }
        MbgRelationMap map = this.relations.get(groupInfo);
        DimensionRelationshipCollection colls = map.getRelationShips();
        ViewListFormRelationBaseF7UI.processPeriodN(colls);
        this.fillValueToTable(colls, groupInfo, filterStr);
    }

    private void fillValueToTable(DimensionRelationshipCollection dimRelationCol, DimensionRelationshipGroupInfo groupInfo, String filterStr) throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        if (this.isDimensionDelete() && this.isMultipleSelect()) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"relationDelete"));
            this.tblMain.getColumn("select").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("select").getStyleAttributes().setHided(true);
        }
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("select").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        DimensionRelationshipInfo shipInfo = null;
        Set<String> temp = this.bgTemplateRelations.get(groupInfo.getId().toString());
        IRow row = null;
        int rowSize = 0;
        String dimensionName = null;
        String dimensionNumber = null;
        Map filterValueMap = (Map)this.getUIContext().get(FILTER_MAP);
        int j = dimRelationCol.size();
        for (int i = 0; i < j; ++i) {
            shipInfo = dimRelationCol.get(i);
            dimensionName = shipInfo.getDimensionName();
            dimensionNumber = shipInfo.getDimensionNumber();
            if (!StringUtils.isEmpty((String)filterStr)) {
                boolean numberContain = false;
                boolean nameContain = false;
                if (dimensionName.indexOf(filterStr) >= 0) {
                    numberContain = true;
                }
                if (!StringUtils.isEmpty((String)dimensionNumber) && dimensionNumber.contains(BgBaseConstants.SEP_THR_STR)) {
                    String[] numArr = dimensionNumber.split(BgBaseConstants.SEP_THR_STR);
                    for (int m = 0; m < numArr.length; ++m) {
                        String memberNum = numArr[m];
                        if (!memberNum.contains(BgBaseConstants.SEP_FOUR_STR) || memberNum.length() <= 4 || memberNum.substring(4, memberNum.length()).indexOf(filterStr) < 0) continue;
                        numberContain = true;
                    }
                }
                if (!numberContain && !nameContain) continue;
            }
            if (!DimensionMemberRelationShipHelper.isInFilter(dimensionNumber, filterValueMap)) continue;
            row = this.tblMain.addRow();
            row.setUserObject((Object)shipInfo);
            if (temp != null && temp.contains(shipInfo.getDimensionNumber())) {
                row.getCell("select").getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
            }
            row.getCell("select").setValue((Object)false);
            row.getCell(DimensionConstants.DIMENSION_NUMBER).setValue((Object)shipInfo.getDimensionNumber());
            row.getCell(DimensionConstants.DIMENSION_NAME).setValue((Object)shipInfo.getDimensionName());
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT).setValue((Object)this.orgUnit);
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT_ID).setValue((Object)this.orgUnit.getId().toString());
            ++rowSize;
        }
        KDTDataRequestEvent e1 = new KDTDataRequestEvent(this.tblMain);
        e1.setFirstRow(0);
        e1.setLastRow(rowSize - 1);
        DimensionRelationClientHelper.initRowValue(this, e1, this.tblMain, groupInfo, true, this.orgUnit, null, this.getSchemeHelper());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        if (this.isDimensionDelete()) {
            this.initAddButton(false);
        } else {
            this.initAddButton(true);
        }
    }

    private void initAddButton(boolean isAddDimension) {
        this.btnAddLine.setVisible(isAddDimension);
        this.btnCopyLine.setVisible(isAddDimension);
        this.btnDeleteLine.setVisible(isAddDimension);
        this.btnImport.setVisible(isAddDimension);
        this.btnExport.setVisible(isAddDimension);
        this.btnOk.setVisible(isAddDimension);
        this.btnCancel.setVisible(isAddDimension);
        this.btnSelectDimRelation.setVisible(isAddDimension);
        this.btnDelete.setVisible(!isAddDimension);
        this.btnSelectAll.setVisible(!isAddDimension);
        this.btnClearAll.setVisible(!isAddDimension);
        this.txtSearch.setEnabled(!isAddDimension);
        this.txtSearch.setVisible(!isAddDimension);
        this.btnSearch.setEnabled(!isAddDimension);
        this.btnSearch.setVisible(!isAddDimension);
        this.kDSeparator2.setVisible(!isAddDimension);
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        String filterStr = this.txtSearch.getText();
        this.fillValueToTable(this.getGroupInfo(), filterStr);
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        super.txtSearch_focusLost(e);
        String filterStr = this.txtSearch.getText();
        this.fillValueToTable(this.getGroupInfo(), filterStr);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        DimensionRelationshipInfo info;
        LinkedHashMap<String, DimensionRelationshipInfo> numbers = new LinkedHashMap<String, DimensionRelationshipInfo>();
        int size = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            IRow row = this.tblMain.getRow(rowIndex);
            if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            info = (DimensionRelationshipInfo)row.getUserObject();
            numbers.put(info.getDimensionNumber(), info);
        }
        if (numbers.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        String bgFormId = (String)this.getUIContext().get("BGFORM_ID");
        String orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        String groupUnitId = (String)this.getUIContext().get("GROUPORG_ID");
        IMbgViewManager view = (IMbgViewManager)this.getUIContext().get(VIEW_MANAGER);
        List hasDatas = MBGFormFacadeFactory.getRemoteInstance().getHasDataRelation(bgFormId, orgId, view, this.getGroupInfo().getId().toString(), new HashSet(numbers.keySet()), this.getSchemeHelper());
        StringBuffer msg = new StringBuffer();
        boolean allSuccess = true;
        String successMsg = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"deleteDetailSuccess");
        String failMsg = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"deleteDetailFail");
        if (hasDatas != null && !hasDatas.isEmpty()) {
            DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);
            cacheHelper.addGroup(this.getGroupInfo());
            allSuccess = false;
            Iterator it = numbers.keySet().iterator();
            while (it.hasNext()) {
                if (msg.length() > 0) {
                    msg.append("\r\n");
                }
                info = (DimensionRelationshipInfo)numbers.get(it.next());
                String temp = DimensionClientHelper.getDimensionNumberMessage(this.getSchemeHelper(), info.getDimensionNumber());
                if (hasDatas.contains(info.getDimensionNumber())) {
                    msg.append(MessageFormat.format(failMsg, temp));
                    it.remove();
                    continue;
                }
                msg.append(MessageFormat.format(successMsg, temp));
            }
        }
        if (!numbers.isEmpty()) {
            int re = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"synchDeleteData"));
            if (re == 0) {
                HashMap<String, Serializable> paramete = new HashMap<String, Serializable>();
                paramete.put("paramete", new HashSet(numbers.keySet()));
                paramete.put("groupInfo", this.getGroupInfo());
                paramete.put("ORGUNIT_ID", (Serializable)this.getUIContext().get("ORGUNIT_ID"));
                DimensionRelationshipFactory.getRemoteInstance().deleteData(paramete);
            }
            MbgRelationMap relationMap = this.relations.get(this.getGroupInfo());
            DimensionRelationshipCollection colls = relationMap.getRelationShips();
            for (int index = colls.size() - 1; index >= 0; --index) {
                DimensionRelationshipInfo shipInfo = colls.get(index);
                if (!numbers.containsKey(shipInfo.getDimensionNumber())) continue;
                colls.remove(shipInfo);
            }
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"deleteFail"), (String)msg.toString(), (int)1);
            this.isCancel = true;
            return;
        }
        this.txtSearch.setText("");
        this.fillValueToTable(this.getGroupInfo(), null);
        if (allSuccess) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"deleteSuccess"));
            this.isCancel = false;
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"deleteFail"), (String)msg.toString(), (int)1);
            this.isCancel = false;
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            if (this.tblMain.getCell(index, "select").getStyleAttributes().isLocked()) continue;
            this.tblMain.getCell(index, "select").setValue((Object)true);
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            this.tblMain.getCell(index, "select").setValue((Object)false);
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        if (this.multipleSelect) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
        if (this.isDimensionDelete() && this.isMultipleSelect()) {
            this.tblMain.getColumn("select").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("select").getStyleAttributes().setHided(true);
        }
    }

    private void readOrgUnit() throws Exception {
        String orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.orgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
    }

    private void loadGroup() {
        this.cbxGroup.addItems(this.relations.keySet().toArray());
    }

    protected void readGroup() {
        IMbgViewManager view = (IMbgViewManager)this.getUIContext().get(VIEW_MANAGER);
        if (view == null || view.getRelationMaps() == null || view.getRelationMaps().isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"hasNotRelation"));
            SysUtil.abort();
        }
        for (int r = 0; r < view.getRelationMaps().size(); ++r) {
            this.relations.put(view.getRelationMaps().get(r).getGroup(), view.getRelationMaps().get(r));
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        super.btnExport_actionPerformed(e);
        DimensionRelationClientHelper.export(this, this.getGroupInfo(), this.tblMain, this.getSchemeHelper());
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnImport_actionPerformed(e);
        Map map = DimensionRelationClientHelper.importExcel(this, this.tblMain, this.orgUnit, null, this.getGroupInfo(), this.getSchemeHelper());
        if (map != null && !map.isEmpty()) {
            DimensionRelationshipCollection col = null;
            if (!map.containsKey("collection")) {
                return;
            }
            col = (DimensionRelationshipCollection)((Object)map.get("collection"));
            this.checkNumber(col);
            int firtRow = this.tblMain.getRowCount();
            for (int i = 0; i < col.size(); ++i) {
                IRow row = this.tblMain.addRow();
                DimensionRelationshipInfo info = col.get(i);
                row.setUserObject((Object)info);
                row.getCell(DimensionConstants.DIMENSION_NUMBER).setValue((Object)info.getDimensionNumber());
                row.getCell(DimensionConstants.DIMENSION_NAME).setValue((Object)info.getDimensionName());
                row.getCell(DimensionConstants.DIMENSION_ORGUNIT).setValue((Object)this.orgUnit);
                row.getCell(DimensionConstants.DIMENSION_ORGUNIT_ID).setValue((Object)this.orgUnit.getId().toString());
            }
            KDTDataRequestEvent e1 = new KDTDataRequestEvent(this.tblMain);
            e1.setFirstRow(firtRow);
            e1.setLastRow(firtRow + col.size() - 1);
            DimensionRelationClientHelper.initRowValue(this, e1, this.tblMain, this.getGroupInfo(), false, this.orgUnit, null, this.getSchemeHelper());
        }
    }

    private void checkNumber(DimensionRelationshipCollection col) throws EASBizException, BOSException {
        Map checkMap = DimensionRelationshipFactory.getRemoteInstance().checkRelation(col, null);
        String msg = (String)checkMap.get("msg");
        col = (DimensionRelationshipCollection)((Object)checkMap.get("result"));
        if (!StringUtils.isEmpty((String)msg)) {
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        DimensionRelationClientHelper.addRow(this.tblMain, this.getGroupInfo(), this.orgUnit, null);
    }

    protected DimensionRelationshipGroupInfo getGroupInfo() {
        return (DimensionRelationshipGroupInfo)this.cbxGroup.getSelectedItem();
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        BgCommCHelper.removeRows((KDTable)this.tblMain);
    }

    @Override
    protected void btnCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnCopyLine_actionPerformed(e);
        DimensionRelationClientHelper.copyRow(this.tblMain, this.orgUnit, null, this.getSchemeHelper());
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        DimensionRelationshipGroupInfo group = this.getGroupInfo();
        if (group == null) {
            return;
        }
        this.runSave(group);
        this.tblMain.removeRows();
        this.getUIWindow().close();
    }

    protected void runSave(DimensionRelationshipGroupInfo group) throws Exception {
        this.verifyInput(this, this.tblMain, group, this.orgUnit);
        DimensionRelationClientHelper.store(this, this.tblMain, group, this.orgUnit, null);
        this.saveRelation(group);
    }

    private void verifyInput(CoreUI ownerUi, KDTable tblMain, DimensionRelationshipGroupInfo group, CostCenterOrgUnitInfo orgUnit2) throws EASBizException, BOSException {
        DimensionRelationClientHelper.verifyInput(this, tblMain, this.getSchemeHelper(), orgUnit2);
        HashMap<String, String[]> relaNum_Name = new HashMap<String, String[]>();
        ArrayList<String> numberList = new ArrayList<String>();
        String number = null;
        String name = null;
        Object[] keyNameArr = DimensionRelationClientHelper.getRelationKeyName(tblMain);
        String[] relationNameArr = null;
        IRow row = null;
        int j = tblMain.getBody().size();
        for (int i = 0; i < j; ++i) {
            row = tblMain.getRow(i);
            number = (String)row.getCell(DimensionConstants.DIMENSION_NUMBER).getValue();
            name = (String)row.getCell(DimensionConstants.DIMENSION_NAME).getValue();
            relationNameArr = name.split(DimensionConstants.TICK_SEPARATOR);
            if (relationNameArr.length != keyNameArr.length) {
                throw new BOSException();
            }
            numberList.add(number);
            relaNum_Name.put(number, relationNameArr);
        }
        List list = DimensionRelationshipFactory.getRemoteInstance().checkCanAdd(group.getId().toString(), orgUnit2.getId().toString(), numberList);
        StringBuffer showMsg = new StringBuffer();
        if (list != null && !list.isEmpty()) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                relationNameArr = (String[])relaNum_Name.get(list.get(i));
                this.getRelationShowMsg(keyNameArr, relationNameArr, showMsg);
            }
            String msg = MessageFormat.format(DimensionRelationClientHelper.getDimCommResource("relationExist"), showMsg.toString());
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    protected void getRelationShowMsg(Object[] keyNameArr, String[] relationNameArr, StringBuffer showMsg) {
        if (keyNameArr == null || relationNameArr == null || keyNameArr.length != relationNameArr.length) {
            return;
        }
        int j = keyNameArr.length;
        for (int i = 0; i < j; ++i) {
            showMsg.append(keyNameArr[i]).append(DimensionConstants.COLON_SEPARATOR).append(relationNameArr[i]);
            if (i == j - 1) continue;
            showMsg.append(DimensionConstants.COMMA_SEPARATOR);
        }
        showMsg.append("\n");
    }

    @Override
    protected void cbxGroup_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxGroup_itemStateChanged(e);
        if (e != null && e.getStateChange() == 1) {
            DimensionRelationshipGroupInfo group = (DimensionRelationshipGroupInfo)e.getItem();
            this.tblMain.removeRows();
            this.loadTempTable(group, this.orgUnit);
            if (this.isDimensionDelete()) {
                this.fillValueToTable(group, this.txtSearch.getText());
            } else {
                boolean isCanAdd = true;
                MbgRelationMap relationMap = this.relations.get(group);
                if (!relationMap.isSelectRelation() && this.bgTemplateRelations.containsKey(group.getId().toString()) && !this.bgTemplateRelations.get(group.getId().toString()).isEmpty()) {
                    isCanAdd = false;
                }
                this.btnSelectDimRelation.setEnabled(isCanAdd);
                this.btnAddLine.setEnabled(isCanAdd);
                this.btnCopyLine.setEnabled(isCanAdd);
                this.btnDeleteLine.setEnabled(isCanAdd);
                this.btnImport.setEnabled(isCanAdd);
                this.btnExport.setEnabled(isCanAdd);
            }
            this.tblMain.getColumn(DimensionConstants.ORGUNIT2).getStyleAttributes().setHided(true);
            if (this.tblMain.getColumn(DimensionConstants.ISENABLE2) != null) {
                this.tblMain.getColumn(DimensionConstants.ISENABLE2).getStyleAttributes().setHided(true);
            }
        } else if (e != null && e.getStateChange() == 2) {
            DimensionRelationshipGroupInfo group = (DimensionRelationshipGroupInfo)e.getItem();
            if (group == null) {
                return;
            }
            if (!this.isDimensionDelete()) {
                this.checkModify(group);
            }
        }
    }

    protected void loadTempTable(DimensionRelationshipGroupInfo group, CostCenterOrgUnitInfo orgUnit) throws Exception {
        DimensionRelationClientHelper.loadTempTable(this, this.tblMain, group, orgUnit, null, this.getSchemeHelper(), false);
    }

    private boolean checkModify(DimensionRelationshipGroupInfo group) {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount > 0) {
            int confirm = MsgBox.showConfirm3((Component)((Object)this), (String)DimensionRelationClientHelper.getDimCommResource("dataError3"));
            if (confirm == 2) {
                return false;
            }
            if (confirm == 1) {
                return true;
            }
            try {
                this.runSave(group);
            }
            catch (AbortException e) {
                return false;
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        return true;
    }

    private void saveRelation(DimensionRelationshipGroupInfo group) throws EASBizException, BOSException {
        int i;
        int r2;
        DimensionRelationshipCollection col = new DimensionRelationshipCollection();
        DimensionRelationshipInfo info = null;
        for (r2 = 0; r2 < this.tblMain.getRowCount(); ++r2) {
            info = (DimensionRelationshipInfo)this.tblMain.getRow(r2).getUserObject();
            if (info.get("TRANS_PERIOD") instanceof Boolean && ((Boolean)info.get("TRANS_PERIOD")).booleanValue()) continue;
            col.add((DimensionRelationshipInfo)this.tblMain.getRow(r2).getUserObject());
        }
        if (!col.isEmpty()) {
            Map r2 = DimensionRelationshipFactory.getRemoteInstance().importDimensionRelation(col, group, this.orgUnit.getId().toString(), null, new BgSchemeDimensionHelper(group.getBgScheme().getId().toString()));
        }
        col.clear();
        for (r2 = 0; r2 < this.tblMain.getRowCount(); ++r2) {
            col.add((DimensionRelationshipInfo)this.tblMain.getRow(r2).getUserObject());
        }
        MbgRelationMap relationMap = this.relations.get(group);
        HashSet<String> numbers = new HashSet<String>();
        for (i = 0; i < relationMap.getRelationShips().size(); ++i) {
            numbers.add(relationMap.getRelationShips().get(i).getDimensionNumber());
        }
        for (i = 0; i < col.size(); ++i) {
            if (numbers.contains(col.get(i).getDimensionNumber())) continue;
            relationMap.getRelationShips().add(col.get(i));
        }
        this.isCancel = false;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        DimensionRelationClientHelper.tblMain_editStopped(this, e, this.getSchemeHelper());
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public boolean isDimensionDelete() {
        return this.isDimensionDelete;
    }

    public void setDimensionDelete(boolean isDimensionDelete) {
        this.isDimensionDelete = isDimensionDelete;
    }

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
        mgr = new PopupMenuManager();
    }

    protected boolean checkBeforeWindowClosing() {
        DimensionRelationshipGroupInfo group;
        boolean value = super.checkBeforeWindowClosing();
        if (this.isDimensionDelete()) {
            return value;
        }
        if (value && (group = this.getGroupInfo()) != null) {
            return this.checkModify(group);
        }
        return value;
    }

    @Override
    protected void btnSelectDimRelation_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectDimRelation_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"DimensionRelationshipGroup", (Object)this.getGroupInfo());
        uiContext.put((Object)"orgUnit", (Object)this.orgUnit);
        uiContext.put((Object)"BGFORM_ID", this.getUIContext().get("BGFORM_ID"));
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgDimRelationSelectUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        }
        catch (UIException e1) {
            this.handUIException(e1);
            SysUtil.abort();
        }
        uiWindow.show();
        DimensionRelationshipCollection dimRelationCol = ((MbgDimRelationSelectUI)uiWindow.getUIObject()).getDimRelationCol();
        if (dimRelationCol != null && !dimRelationCol.isEmpty()) {
            this.fillValueToTable(dimRelationCol, this.getGroupInfo(), null);
        } else {
            uiWindow.close();
            SysUtil.abort();
        }
    }
}

