/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgPropertyAnalyseF7UI;
import com.kingdee.eas.ma.mbg.client.MbgPropertiesAnalyseCommonExplorer;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class MbgPropertyAnalyseF7UI
extends AbstractMbgPropertyAnalyseF7UI {
    private static final long serialVersionUID = -5187648293267604263L;
    private static final Logger logger = CoreUIObject.getLogger(MbgPropertyAnalyseF7UI.class);
    public static final String PROPERTYDIMENSION = "propertyDimension";
    public static final String ISMULSELECT = "isMulSelect";
    public static final String DIMENSIONS = "dimensions";
    public static final String PROVIDER = "provider";
    public static final String ANALYSE = "analyse";
    private Map<String, BgDimensionInfo> dimensions = null;
    private boolean isMultiSelect = true;
    private KDPanel analyse = null;
    private Map<String, List<Map<String, List<BgDimensionMember>>>> propertiesDimension = null;
    private IProvider provider = null;
    String normalize = FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + "MbgPropertyAnalyse.properties"));

    public KDPanel getAnalyse() {
        return this.analyse;
    }

    public void setAnalyse(KDPanel analyse) {
        this.analyse = analyse;
    }

    public Map<String, BgDimensionInfo> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, BgDimensionInfo> dimensions) {
        this.dimensions = dimensions;
    }

    public Map<String, List<Map<String, List<BgDimensionMember>>>> getPropertiesDimension() {
        return this.propertiesDimension;
    }

    public void setPropertiesDimension(Map<String, List<Map<String, List<BgDimensionMember>>>> propertiesDimension) {
        this.propertiesDimension = propertiesDimension;
    }

    public IProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IProvider provider) {
        this.provider = provider;
    }

    protected void initContext() {
        this.isMultiSelect = (Boolean)this.getUIContext().get(ISMULSELECT);
        this.propertiesDimension = (Map)this.getUIContext().get(PROPERTYDIMENSION);
        this.analyse = (KDPanel)this.getUIContext().get(ANALYSE);
        this.provider = (IProvider)this.getUIContext().get(PROVIDER);
        this.dimensions = (Map)this.getUIContext().get(DIMENSIONS);
    }

    public void onLoad() throws Exception {
        this.initContext();
        super.onLoad();
        if (this.isMultiSelect) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() == 2) {
                        MbgPropertyAnalyseF7UI.this.btnOk_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    MbgPropertyAnalyseF7UI.this.handUIException(exc);
                }
            }
        });
    }

    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.data = new BgPropertySortCollection();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null && range.size() > 0) {
            int rangeCount = range.size();
            for (int i = 0; i < rangeCount; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int start = block.getBeginRow();
                int end = block.getEndRow();
                for (int j = start; j <= end; ++j) {
                    this.data.add((BgPropertySortInfo)this.tblMain.getRow(j).getUserObject());
                }
            }
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    protected void executeQuery() throws EASBizException, BOSException {
        super.executeQuery();
        if (this.propertiesDimension != null && !this.propertiesDimension.isEmpty()) {
            Set<String> proSortIds = this.propertiesDimension.keySet();
            IRow row = null;
            String proId = null;
            int in = 0;
            for (int i = this.tblMain.getRowCount() - 1; i >= in; --i) {
                row = this.tblMain.getRow(i);
                proId = ((BOSUuid)row.getCell("id").getValue()).toString();
                if (proSortIds == null || proSortIds.contains(proId)) continue;
                this.tblMain.removeRow(i);
            }
        }
    }

    public BgPropertySortCollection getData() {
        return super.getData();
    }

    public void dataChanged(DataChangeEvent eventObj) {
        try {
            if (eventObj != null && eventObj.getNewValue() != null) {
                Component comp;
                BgPropertySortInfo obj;
                Object newValue = eventObj.getNewValue();
                Object oldValue = eventObj.getOldValue();
                BgPropertySortInfo info = null;
                BgPropertySortInfo oldInfo = null;
                if (newValue != null && newValue instanceof BgPropertySortInfo) {
                    info = (BgPropertySortInfo)newValue;
                } else if (newValue != null && newValue instanceof BgPropertySortCollection && (obj = ((BgPropertySortCollection)newValue).get(0)) != null && obj instanceof BgPropertySortInfo) {
                    info = obj;
                }
                if (oldValue != null && oldValue instanceof BgPropertySortInfo) {
                    oldInfo = (BgPropertySortInfo)oldValue;
                } else if (oldValue != null && oldValue instanceof BgPropertySortCollection && (obj = ((BgPropertySortCollection)oldValue).get(0)) != null && obj instanceof BgPropertySortInfo) {
                    oldInfo = obj;
                }
                if (oldInfo != null && info != null && oldInfo.getNumber().equals(info.getNumber())) {
                    return;
                }
                MbgQingAnalyseFacadeFactory.getRemoteInstance().setPropertiesDataByCache(info, this.propertiesDimension, this.dimensions, this.provider.getBillId());
                if (this.analyse.getComponents() != null && this.analyse.getComponents().length > 1 && (comp = ((KDPanel)this.analyse.getComponent(1)).getComponent(0)) != null && comp instanceof MbgPropertiesAnalyseCommonExplorer) {
                    MbgPropertiesAnalyseCommonExplorer explor = (MbgPropertiesAnalyseCommonExplorer)((Object)comp);
                    explor.destroyWindow();
                    this.analyse.remove(1);
                }
                KDPanel explorerPnl = new KDPanel();
                MbgPropertiesAnalyseCommonExplorer explorer = new MbgPropertiesAnalyseCommonExplorer(this.getProvider(), info);
                explorer.onLoad();
                explorerPnl.setLayout((LayoutManager)new BorderLayout());
                explorerPnl.add("Center", (Component)((Object)explorer));
                this.analyse.add("Center", (Component)explorerPnl);
            }
        }
        catch (Exception e) {
            logger.error((Object)"MbgPropertiesAnalyseCommonExplorer onload error:", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"propertiesAnalyseTitle");
    }
}

