/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseCalculateInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgQingAnalyseCalculateProcessUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class MbgQingAnalyseCalculateProcessUI
extends AbstractMbgQingAnalyseCalculateProcessUI {
    private static final long serialVersionUID = -5755724688757757732L;
    private static final Logger logger = CoreUIObject.getLogger(MbgQingAnalyseCalculateProcessUI.class);
    protected NumberExpendRender render = new NumberExpendRender(0);
    private static final String ORG_ID = "id";
    private static final String ORG_NUMBER = "number";
    private static final String ORG_LONGNUMBER = "longNumber";
    private static final String ORG_ISLEAF = "isleaf";
    private static final String ORG_LEVEL = "level";
    private static final String ORG_ISVIRTUAL = "isVirtual";
    private static final String ORG_NAME = "name";
    private static final String STATE = "state";
    private static final String LASTRUNTIME = "lastRunTime";
    private static final String USER = "user";
    private BgSchemeInfo bgSchemeInfo = null;

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext() != null && this.getUIContext().get("BGSCHEME_INFO") != null) {
            this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        }
        this.tblMain.checkParsed();
        BgCommHelper.removeEditHelper((KDTable)this.tblMain);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(ORG_NAME).setRenderer((IBasicRender)this.render);
        this.fillTable();
        this.setTableDisplayStyle();
    }

    private void fillTable() throws EASBizException, BOSException {
        List calculateProcess = MbgQingAnalyseFacadeFactory.getRemoteInstance().getCalculateProcess(this.bgSchemeInfo);
        for (MbgQingAnalyseCalculateInfo info : calculateProcess) {
            IRow row = this.tblMain.addRow();
            row.getCell(ORG_ID).setValue((Object)info.getId());
            row.getCell(ORG_NUMBER).setValue((Object)info.getNumber());
            row.getCell(ORG_LONGNUMBER).setValue((Object)info.getLongNumber());
            row.getCell(ORG_LEVEL).setValue((Object)info.getLevel());
            row.getCell(ORG_ISVIRTUAL).setValue((Object)info.isVirtual());
            row.getCell(ORG_ISLEAF).setValue((Object)info.isIsleaf());
            row.getCell(ORG_NAME).setValue((Object)info.getName());
            row.getCell(STATE).setValue((Object)info.getState());
            row.getCell(USER).setValue((Object)info.getUserName());
            if (!EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"planStateEnd").equals(info.getState())) continue;
            row.getCell(LASTRUNTIME).setValue((Object)info.getLastRunTime());
        }
    }

    protected void setTableDisplayStyle() {
        IRow row = null;
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        int level = 0;
        NumberExpandInfo expandInfo = null;
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            id = (String)row.getCell(ORG_ID).getValue();
            number = (String)row.getCell(ORG_NUMBER).getValue();
            longNumber = (String)row.getCell(ORG_LONGNUMBER).getValue();
            level = (Integer)row.getCell(ORG_LEVEL).getValue();
            boolean isleaf = (Boolean)row.getCell(ORG_ISLEAF).getValue();
            boolean isVirtual = (Boolean)row.getCell(ORG_ISVIRTUAL).getValue();
            name = (String)row.getCell(ORG_NAME).getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isleaf);
            expandInfo.setName(isVirtual ? name + "(s)" : name);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell(ORG_NAME).setValue((Object)expandInfo);
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            NumberExpandInfo expandInfo;
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn(ORG_NAME).getColumnIndex() && this.render.inRectForBgOrg(expandInfo = (NumberExpandInfo)row.getCell(ORG_NAME).getValue(), e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, expandInfo);
            }
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) {
        boolean isLeaf = (Boolean)row.getCell(ORG_ISLEAF).getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) {
        int rowIndex;
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        NumberExpandInfo expandInfo = null;
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        int rowCount = this.tblMain.getRowCount3();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(ORG_NAME).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            while (rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(ORG_NAME).getValue()).getLongNumber()).startsWith(parentLongNumber + "!")) {
                if (expandInfo.getLevel() - parentLevel == 1) {
                    child.getStyleAttributes().setHided(false);
                    if (!expandInfo.isLeaf()) {
                        expandInfo.setExpandStatus(false);
                    }
                }
                ++rowIndex;
            }
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }
}

