/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseException;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.client.FunctionSelectF7UI;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import java.awt.event.ActionEvent;
import java.util.HashSet;

public class MbgQingAnalyseFunctionSelectF7UI
extends FunctionSelectF7UI {
    private BgOrgViewInfo viewInfo = null;

    public BgOrgViewInfo getViewInfo() {
        return this.viewInfo;
    }

    public void setViewInfo(BgOrgViewInfo viewInfo) {
        this.viewInfo = viewInfo;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsLeap();
        super.btnOk_actionPerformed(e);
    }

    @Override
    protected void init() {
        super.init();
        if (this.getMemberSelectType().equals((Object)BgMemberSelectTypeEnum.Member)) {
            // empty if block
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.viewInfo = (BgOrgViewInfo)this.getUIContext().get("BgOrgView");
    }

    @Override
    protected boolean isMoveVirtualOrg(IRow row) {
        return false;
    }

    private void checkIsLeap() throws EASBizException, BOSException {
        HashSet<String> result = null;
        if (this.tblRight.getRowCount() > 0) {
            result = new HashSet<String>();
            for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
                IRow row = this.tblRight.getRow(i);
                BgDimensionMember member = this.getMemberOfRow(row);
                String number = member.getNumber();
                result.add(number);
            }
            boolean isLeap = MbgQingAnalyseFacadeFactory.getRemoteInstance().checkIsLeap(this.viewInfo.getId().toString(), result);
            if (isLeap) {
                throw new MbgQingAnalyseException(MbgQingAnalyseException.ISLEAP);
            }
        }
    }

    @Override
    protected void setShareOrgUnSelect() {
    }
}

