/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.client.utils.SimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.AbstractBgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgOrgunitViewFoldEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IMbgQingAnalyse;
import com.kingdee.eas.ma.mbg.IMbgQingAnalyseFacade;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseException;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseIntegrateFactory;
import com.kingdee.eas.ma.mbg.QingAnalyseFunctionLabel;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractMbgQingAnalyseListUI;
import com.kingdee.eas.ma.mbg.client.MbgQingAnalyseCalculateProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgQingAnalyseCreateDataUI;
import com.kingdee.eas.ma.mbg.client.MbgQingAnalyseEditUI;
import com.kingdee.eas.ma.mbg.client.MbgQingAnalyseFileConvertUI;
import com.kingdee.eas.ma.mbg.client.MbgQingAnalyseRemoveDataUI;
import com.kingdee.eas.ma.mbg.client.QingAnalyseFunctionPanel;
import com.kingdee.eas.ma.mbg.client.utils.BgFormAuditClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgQingAnalyseUtils;
import com.kingdee.eas.ma.mbg.progress.IProgressMonitor;
import com.kingdee.eas.ma.mbg.progress.IRunnableWithProgress;
import com.kingdee.eas.ma.mbg.progress.ProgressDialogHelper;
import com.kingdee.eas.ma.mbg.progress.ProgressDialogNew;
import com.kingdee.eas.ma.mbg.query.QingDataFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MbgQingAnalyseListUI
extends AbstractMbgQingAnalyseListUI
implements ISimpleQuickQueryHandler {
    private static final Logger logger = CoreUIObject.getLogger(MbgQingAnalyseListUI.class);
    private BgSchemeInfo bgSchemeInfo = null;
    private boolean isCalculated = true;
    protected SimpleQuickQueryHandler quickQuery = null;
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.MbgQingAnalyseResource";
    protected FilterParam filterParam = null;
    private ProgressDialogNew progressDialog = null;
    MbgQingAnalyseCreateDataUI createDataUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.treeOrgUnit.setModel(null);
        super.onLoad();
        this.initTreePopMenu();
        this.initPanel();
        this.initCostCenter();
        this.quickQuery = new SimpleQuickQueryHandler(this.txtSearch, (ISimpleQuickQueryHandler)this);
    }

    protected void initTreePopMenu() {
        Map map = this.initMap();
        JMenuItem mItem = null;
        for (int i = 0; i < this.treeOrgUnit.getPopupMenu().getComponentCount(); ++i) {
            if (!(this.treeOrgUnit.getPopupMenu().getComponent(i) instanceof JMenuItem)) continue;
            mItem = (JMenuItem)this.treeOrgUnit.getPopupMenu().getComponent(i);
            String text = null;
            try {
                String key = mItem.getActionCommand();
                if (!map.containsKey(key)) continue;
                text = map.get(key).toString();
                mItem.setText(text);
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)"Read resource error:", (Throwable)e);
            }
        }
        this.treeOrgUnit.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                return MbgQingAnalyseListUI.this.isShowTreePopMenu();
            }
        });
    }

    protected boolean isShowTreePopMenu() {
        return true;
    }

    private Map initMap() {
        String resource = "com.kingdee.eas.ma.mbg.client.BgFormResource";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("actopen", EASResource.getString((String)resource, (String)"actopen"));
        map.put("actclose", EASResource.getString((String)resource, (String)"actclose"));
        map.put("actopenll", EASResource.getString((String)resource, (String)"actopenll"));
        map.put("actopenall", EASResource.getString((String)resource, (String)"actopenall"));
        map.put("actcloseall", EASResource.getString((String)resource, (String)"actcloseall"));
        return map;
    }

    private void initPanel() {
        this.pnlAnalyse.removeAll();
        QingAnalyseFunctionPanel sonPanel = new QingAnalyseFunctionPanel(this.pnlAnalyse, new ArrayList<MbgQingAnalyseInfo>());
        sonPanel.setBackground(new Color(241, 243, 242));
        this.pnlAnalyse.add((Component)((Object)sonPanel), (Object)"Center");
        this.repaint((JComponent)this.pnlAnalyse);
    }

    protected void initListener() {
        super.initListener();
        AbstractAction convertFileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                BgSchemeInfo bgSchemeInfo = MbgQingAnalyseListUI.this.getBgSchemeInfo();
                if (bgSchemeInfo == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"438_BgNTemplateListUI"));
                    return;
                }
                try {
                    UIContext ctx = new UIContext((Object)this);
                    ctx.put((Object)"BGSCHEME_INFO", (Object)MbgQingAnalyseListUI.this.getBgSchemeInfo());
                    ctx.put((Object)"BGORGUNIT_INFO", (Object)MbgQingAnalyseListUI.this.getSelectedOrgUnit());
                    IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgQingAnalyseFileConvertUI.class.getName(), (Map)ctx);
                    ui.show();
                }
                catch (UIException e) {
                    MbgQingAnalyseListUI.this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
        };
    }

    private void initCostCenter() {
        this.prmtOrgUnit.setData((Object)SysContext.getSysContext().getCurrentCostUnit());
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setUIAction((IUIObject)this, (ItemAction)this.actionOnLoad);
        f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        f7.setPermissionItem(this.getPermissionNum());
        this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
    }

    protected OrgUnitInfo getSelectOrgUnit() {
        return (OrgUnitInfo)this.prmtOrgUnit.getData();
    }

    public String getPermissionNum() {
        return "mbg_qingAnalyse00_listUI";
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.prmtOrgUnit.getData(), this.isOnlySelf(), this.getSourceType(), false, false);
    }

    private RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    private boolean isOnlySelf() {
        return false;
    }

    protected void refreshOrgUnitTree() throws Exception {
        try {
            TreeModel treeModel = this.loadOrgTreeModel();
            this.treeOrgUnit.setModel(treeModel);
            this.locateCurrentOrg();
            this.treeOrgUnit.expandOnLevel(1);
            this.treeOrgUnit.repaint();
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof AbortException) {
                throw (AbortException)ex.getCause();
            }
            this.handUIExceptionAndAbort(ex);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        this.dealVirtualOrg();
        this.refresh(this.txtSearch.getText().trim());
    }

    private void dealVirtualOrg() {
        TreePath path = this.treeOrgUnit.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)tn.getUserObject();
        if (bgOrgUnitInfo.isIsVirtual()) {
            this.setKDWorkButton(false);
            this.setKDMenuItem(false);
        } else {
            this.setKDWorkButton(true);
            this.setKDMenuItem(true);
        }
    }

    private void setKDMenuItem(boolean state) {
        this.btnAdd.setEnabled(state);
        this.btnEdit.setEnabled(state);
        this.btnDelete.setEnabled(state);
        this.btnRefresh.setEnabled(state);
        this.btnCopy.setEnabled(state);
        this.btnCalculate.setEnabled(state);
        this.btnCalculateProcess.setEnabled(state);
    }

    private void setKDWorkButton(boolean state) {
        this.menuItemAddNew.setEnabled(state);
        this.menuItemEdit.setEnabled(state);
        this.menuItemDelete.setEnabled(state);
        this.menuItemCopy.setEnabled(state);
        this.menuItemCalculate.setEnabled(state);
        this.menuItemCalculateProcess.setEnabled(state);
    }

    protected void refresh(String filter) throws BOSException, EASBizException {
        this.initPanel();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgInfo = this.getOrgUnitInfo(node);
        BgSchemeInfo bgSchemeInfo = this.getBgSchemeInfo();
        ArrayList idList = new ArrayList();
        IMbgQingAnalyseFacade iAnalyse = MbgQingAnalyseFacadeFactory.getRemoteInstance();
        if (orgInfo == null || bgSchemeInfo == null || !iAnalyse.checkOrgPermission(orgInfo.getId().toString()) || this.checkSelectedOrgPermission((OrgUnitInfo)orgInfo)) {
            return;
        }
        if (filter.equals(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"404_NewDimensionMemberF7UI"))) {
            filter = null;
        }
        List parentOrgShareMode = this.getFacadeInterface().getParentOrgShareModer(this.getBgSchemeInfo(), MbgQingAnalyseHelper.getOrgViewInfo(null, this.getBgSchemeInfo()), orgInfo.getId().toString(), filter);
        this.createLabel(parentOrgShareMode, bgSchemeInfo);
    }

    private void refresh() throws BOSException, EASBizException {
        this.refresh(null);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("description"));
        selectors.add(new SelectorItemInfo("share"));
        selectors.add(new SelectorItemInfo("bgSchemeId"));
        selectors.add(new SelectorItemInfo("orgUnitId"));
        selectors.add(new SelectorItemInfo("imgPath"));
        selectors.add(new SelectorItemInfo("bgPeriod.*"));
        selectors.add(new SelectorItemInfo("refBizCalc.*"));
        selectors.add(new SelectorItemInfo("refBizCalc.bizCalc.*"));
        selectors.add(new SelectorItemInfo("qingAnalyseDimSetting.*"));
        selectors.add(new SelectorItemInfo("qingAnalyseDimSetting.members.*"));
        return selectors;
    }

    private boolean checkSelectedOrgPermission(OrgUnitInfo orgInfo) {
        boolean hasPermission = true;
        try {
            BgPermissionUtil.checkPermission((OrgUnitInfo)orgInfo, (String)this.getMbgQingAnalyseListPermission());
        }
        catch (EASBizException e) {
            logger.error((Object)"MbgQingAnalyseListUI checkSelctedOrgPermission failed", (Throwable)e);
            hasPermission = false;
        }
        catch (BOSException e) {
            logger.error((Object)"MbgQingAnalyseListUI checkSelctedOrgPermission failed", (Throwable)e);
            hasPermission = false;
        }
        return !hasPermission;
    }

    private String getMbgQingAnalyseListPermission() {
        return "mbg_qingAnalyse00_listUI";
    }

    private void createLabel(List<MbgQingAnalyseInfo> idList, BgSchemeInfo bgSchemeInfo) {
        QingAnalyseFunctionPanel analysePanel = (QingAnalyseFunctionPanel)((Object)this.pnlAnalyse.getComponent(0));
        analysePanel.removeAll();
        analysePanel.getCacheList().clear();
        analysePanel.setCacheList(idList);
        analysePanel.setOrgUnitInfo(this.getSelectedOrgUnit());
        analysePanel.setUi(this);
        analysePanel.setSchemeInfo(bgSchemeInfo);
        analysePanel.load();
    }

    private IMbgQingAnalyse getBizInterface() throws BOSException {
        return MbgQingAnalyseFactory.getRemoteInstance();
    }

    private TreeModel loadOrgTreeModel() throws Exception {
        TreeModel treeModel = null;
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgscheme = (BgSchemeInfo)this.prmtBgScheme.getData();
            BgOrgViewInfo orgView = MbgQingAnalyseHelper.getOrgViewInfo(null, bgscheme);
            BOSUuid orgUnitId = BgOrgUnitFactory.getRemoteInstance().getBuildTreeOrgUnitId(bgscheme.getOrgUnit().getId(), orgView.getId());
            treeModel = BgOrgTreeHelper.buildMultiTreeModel(this.treeOrgUnit, orgView.getId().toString(), orgUnitId.toString(), true, false, true);
            BgViewClientHelper.addBeforeAction(this, this.treeOrgUnit, orgView.getId(), bgscheme.getOrgUnit().getId(), false, false);
        }
        return treeModel;
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        OrgUnitInfo oldInfo = (OrgUnitInfo)e.getOldValue();
        OrgUnitInfo newInfo = (OrgUnitInfo)e.getNewValue();
        if (newInfo == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isNullOrgUnit"));
            this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
        } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
            this.setBgSchemeFilter(this.getSourceType(), false);
        }
    }

    private void setBgSchemeFilter(RptSrcTypeEnum sourceType, boolean isOnlyFixle) throws EASBizException, BOSException {
        BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.prmtOrgUnit.getData(), null, this.isOnlySelf(), sourceType, isOnlyFixle, false);
        BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, this.getSourceType(), (OrgUnitInfo)this.prmtOrgUnit.getData());
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        if (newInfo == null && e.getOldValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isNullBgScheme"));
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            return;
        }
        this.refreshOrgUnitTree();
    }

    private void locateCurrentOrg() throws BOSException, EASBizException {
        block8: {
            CostCenterOrgUnitInfo currentOrg;
            block7: {
                IFullOrgUnit iou = FullOrgUnitFactory.getRemoteInstance();
                currentOrg = SysContext.getSysContext().getCurrentCostUnit();
                if (currentOrg != null && currentOrg.getId() != null && this.treeOrgUnit.getRowCount() != 1) break block7;
                if (this.treeOrgUnit.getRowCount() <= 0) break block8;
                this.treeOrgUnit.setSelectionRow(0);
                break block8;
            }
            if (this.treeOrgUnit.getRowCount() == 0) {
                // empty if block
            }
            int height = this.treeOrgUnit.getRowCount();
            for (int i = 0; i < height; ++i) {
                TreePath tp = this.treeOrgUnit.getPathForRow(i);
                if (tp == null) continue;
                DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                if (tn == null) {
                    return;
                }
                FullOrgUnitInfo org = this.getOrgUnitInfo(tn);
                if (org == null || org.getId() == null || !org.getId().toString().equals(currentOrg.getId().toString())) continue;
                this.treeOrgUnit.setSelectionRow(i);
                break;
            }
        }
        if (this.treeOrgUnit.getSelectionPath() == null && this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.setSelectionRow(0);
        }
        AbstractBgOrgViewInfo orgView = null;
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgscheme = (BgSchemeInfo)this.prmtBgScheme.getData();
            orgView = MbgQingAnalyseHelper.getOrgViewInfo(null, bgscheme);
        }
        if (orgView != null && orgView.getBgOrguniteDirectFold() == BgOrgunitViewFoldEnum.unfold) {
            this.treeOrgUnit.expandOnLevel(3);
        } else {
            this.treeOrgUnit.expandOnLevel(2);
        }
    }

    protected FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgInfo = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            if (node.getUserObject() instanceof OrgStructureInfo) {
                OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
                if (oui != null && oui.getUnit() != null) {
                    orgInfo = oui.getUnit();
                    orgInfo.setLongNumber(oui.getLongNumber());
                }
                return orgInfo;
            }
            if (node.getUserObject() instanceof OrgUnitInfo) {
                return ((OrgUnitInfo)node.getUserObject()).castToFullOrgUnitInfo();
            }
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                return ((BgOrgUnitInfo)node.getUserObject()).castToFullOrgUnitInfo();
            }
        }
        return orgInfo;
    }

    private void createUIWindow(String id, String oprtState) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)this.getBgSchemeInfo());
        uiContext.put((Object)"BGORGUNIT_INFO", (Object)this.getSelectedOrgUnit());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
    }

    private SelectorItemCollection getOtherSelectors(SelectorItemCollection selector) {
        selector.add(new SelectorItemInfo("bgPeriod.*"));
        selector.add(new SelectorItemInfo("refBizCalc.*"));
        selector.add(new SelectorItemInfo("refBizCalc.bizCalc.*"));
        selector.add(new SelectorItemInfo("qingAnalyseDimSetting.*"));
        selector.add(new SelectorItemInfo("qingAnalyseDimSetting.members.*"));
        return selector;
    }

    private IMbgQingAnalyseFacade getFacadeInterface() throws BOSException {
        return MbgQingAnalyseFacadeFactory.getRemoteInstance();
    }

    private QingAnalyseFunctionLabel getSelectedLabel() throws MbgQingAnalyseException {
        this.verify();
        QingAnalyseFunctionPanel analysePanel = (QingAnalyseFunctionPanel)((Object)this.pnlAnalyse.getComponent(0));
        QingAnalyseFunctionLabel currentLabel = analysePanel.getCurrentLabel();
        if (currentLabel == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notSelectedRecord"));
            SysUtil.abort();
        }
        return currentLabel;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtBgScheme.setEditable(false);
    }

    protected String getEditUIName() {
        return MbgQingAnalyseEditUI.class.getName();
    }

    protected BgSchemeInfo getBgSchemeInfo() {
        return (BgSchemeInfo)this.prmtBgScheme.getData();
    }

    protected OrgUnitInfo getSelectedOrgUnit() {
        TreePath path = this.treeOrgUnit.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        FullOrgUnitInfo orgInfo = this.getOrgUnitInfo(tn);
        return orgInfo;
    }

    public void repaint(JComponent c) {
        c.revalidate();
        c.repaint();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.doQuickQuery();
    }

    public void doQuickQuery() {
        try {
            this.refresh(this.quickQuery.getFilterString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        if (this.treeOrgUnit == null || this.getSelectedOrgUnit() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isNullTreeOrgUnit"));
            return;
        }
        this.createUIWindow(null, OprtState.ADDNEW);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (action == this.actionAddNew || action == this.actionEdit || action == this.actionView || action == this.actionDelete || action == this.actionCopy || action == this.actionAnalyse || action == this.actionCalculate || action == this.actionCalculateProcess) {
            try {
                this.verify();
            }
            catch (MbgQingAnalyseException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            String orgId = this.getSelectedOrgUnit().getId().toString();
            if (orgId != null) {
                return new ObjectStringPK(orgId);
            }
        }
        return super.getOrgPK(action);
    }

    private void verify() throws MbgQingAnalyseException {
        if (this.getBgSchemeInfo() == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLBGSCHEME);
        }
        if (this.getSelectedOrgUnit() == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLORGUNIT);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        QingAnalyseFunctionLabel selectedLabel = this.getSelectedLabel();
        MbgQingAnalyseInfo mbgQingAnalyseInfo = selectedLabel.getMenu();
        if (!mbgQingAnalyseInfo.getOrgUnitId().toString().equals(this.getSelectedOrgUnit().getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cantEditShare"));
            return;
        }
        this.createUIWindow(mbgQingAnalyseInfo.getId().toString(), OprtState.EDIT);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        QingAnalyseFunctionLabel currentLabel = this.getSelectedLabel();
        MbgQingAnalyseInfo mbgQingAnalyseInfo = currentLabel.getMenu();
        this.createUIWindow(mbgQingAnalyseInfo.getId().toString(), OprtState.VIEW);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        QingAnalyseFunctionLabel currentLabel = this.getSelectedLabel();
        MbgQingAnalyseInfo mbgQingAnalyseInfo = currentLabel.getMenu();
        if (!mbgQingAnalyseInfo.getOrgUnitId().toString().equals(this.getSelectedOrgUnit().getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cantDeleteShare"));
            return;
        }
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isDelete"));
        if (result != 0) {
            return;
        }
        this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(mbgQingAnalyseInfo.getId()));
        this.refresh(this.txtSearch.getText());
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        QingAnalyseFunctionLabel selectedLabel = this.getSelectedLabel();
        MbgQingAnalyseInfo analyseInfo = selectedLabel.getMenu();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.addObjectCollection((IObjectCollection)this.getSelectors());
        selector = this.getOtherSelectors(selector);
        MbgQingAnalyseInfo mbgQingAnalyseInfo = this.getBizInterface().getMbgQingAnalyseInfo((IObjectPK)new ObjectUuidPK(analyseInfo.getId()), selector);
        MbgQingAnalyseInfo cloneInfo = mbgQingAnalyseInfo.deepClone();
        cloneInfo.setOrgUnitId(BOSUuid.read((String)this.getSelectedOrgUnit().getId().toString()));
        cloneInfo.setName(EASResource.getString((String)RESOURCE, (String)"copyName") + analyseInfo.getName());
        this.getBizInterface().addnew(cloneInfo);
        this.refresh(this.txtSearch.getText());
    }

    @Override
    public void actionAnalyse_actionPerformed(ActionEvent e) throws Exception {
        QingAnalyseFunctionLabel currentLabel = this.getSelectedLabel();
        String analyseId = currentLabel.getMenu().getId().toString();
        MbgQingAnalyseFacadeFactory.getRemoteInstance().checkCalculateState(this.getBgSchemeInfo(), this.getSelectedOrgUnit());
        boolean flag = MbgQingAnalyseUtils.verifyAnalyse(MbgQingAnalyseFactory.getRemoteInstance(), analyseId, this.getSelectedOrgUnit(), this.getBgSchemeInfo());
        if (!flag) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cannotAnalyse"));
            return;
        }
        MbgQingAnalyseFacadeFactory.getRemoteInstance().checkQingFilesIsEmpty(this.getBgSchemeInfo(), this.getSelectedOrgUnit().getId().toString());
        MbgQingAnalyseHelper.analyse(this, currentLabel.getMenu(), this.getSelectedOrgUnit());
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        if (this.getBgSchemeInfo() == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLBGSCHEME);
        }
        MbgQingAnalyseFacadeFactory.getRemoteInstance().checkCalculateState(this.getBgSchemeInfo());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"calculateMessage"));
        BgSchemeInfo bgSchemeInfo = this.getBgSchemeInfo();
        MbgQingAnalyseSwingWorker work = new MbgQingAnalyseSwingWorker(this, bgSchemeInfo);
        work.start();
    }

    @Override
    public void actionCalculateProcess_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)this.getBgSchemeInfo());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgQingAnalyseCalculateProcessUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(this.txtSearch.getText());
    }

    public CommonQueryDialog getDialog() {
        return this.createCommonQueryDialog();
    }

    protected IMetaDataPK createQueryPk() {
        return MetaDataPK.create((String)"com.kingdee.eas.ma.base.BgElementQuery");
    }

    protected CommonQueryDialog createCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        dialog.setOwner((Component)this.getUIContext().get("Owner"));
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK(this.createQueryPk());
        dialog.setTitle(this.getCreateDataUI().getUITitle());
        dialog.setWidth(this.getWidthOfDialog());
        dialog.setHeight(this.getHeightOfDialog());
        dialog.setMaxReturnCountVisible(false);
        dialog.addUserPanel((KDPanel)this.getCreateDataUI());
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        return dialog;
    }

    protected int getWidthOfDialog() {
        return 480;
    }

    protected int getHeightOfDialog() {
        return 400;
    }

    public void setFilterParam(FilterParam filterParam) {
        this.filterParam = filterParam;
    }

    public void setFilterParam(CustomerParams cp) {
        this.setFilterParam(this.getCreateDataUI().getFilterParam(cp));
    }

    public FilterParam getFilterParam() {
        return this.filterParam;
    }

    @Override
    public void actionCreateData_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        if (this.getDialog().show()) {
            this.setFilterParam(this.getCreateDataUI().getCustomerParams());
            BgFormAuditClientHelper.checkProgressLoading((Component)((Object)this), e, this.getProgressDialog(e));
            BgFormAuditClientHelper.loadMonitorMsg(this.progressDialog, true);
            IRunnableWithProgress runnableWithProgress = this.getCreateDataProgress(e, (Component)((Object)this), this.getFilterParam());
            try {
                this.progressDialog.run(true, true, runnableWithProgress, this.progressDialog, false);
            }
            catch (Exception var1) {
                logger.error((Object)("create qing Data " + this.getActionName(e) + " errror"), (Throwable)var1);
            }
            this.setMessageText(EASResource.getString((String)RESOURCE, (String)"createDataSuccess"));
            this.showMessage();
        }
        this.createDataUI = null;
    }

    private IRunnableWithProgress getCreateDataProgress(final ActionEvent e, Component ui, final FilterParam filterParam) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec(IProgressMonitor monitor) throws Exception {
                String actionName = MbgQingAnalyseListUI.this.getActionName(e);
                monitor.beginTask(EASResource.getString((String)MbgQingAnalyseListUI.RESOURCE, (String)"taskName"), -1);
                monitor.setTaskName(EASResource.getString((String)MbgQingAnalyseListUI.RESOURCE, (String)"taskName"));
                monitor.subTaskBegin(EASResource.getString((String)MbgQingAnalyseListUI.RESOURCE, (String)"createQingDataTaskBegin"));
                try {
                    MbgQingAnalyseIntegrateFactory.getRemoteInstance().createAnalyseDataByOrg((QingDataFilterParam)filterParam);
                }
                catch (Exception var) {
                    logger.error((Object)"", (Throwable)var);
                    SysUtil.abort();
                }
                finally {
                    monitor.done();
                }
                return null;
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        };
    }

    protected ProgressDialogNew getProgressDialog(ActionEvent e) {
        if (ProgressDialogHelper.isMonitorEnd(this.progressDialog)) {
            this.progressDialog = null;
        }
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialogHelper.createProgressDialogNew(this, true);
            this.progressDialog.setActionEvent(e);
        }
        return this.progressDialog;
    }

    private MbgQingAnalyseCreateDataUI getCreateDataUI() {
        if (null == this.createDataUI) {
            try {
                this.createDataUI = (MbgQingAnalyseCreateDataUI)((Object)Class.forName(MbgQingAnalyseCreateDataUI.class.getName()).newInstance());
                this.createDataUI.setOwnerUi(this);
                Map uiContext = this.createDataUI.getUIContext();
                uiContext.put("BGSCHEME_INFO", this.getBgSchemeInfo());
                uiContext.put("BGORGUNIT_INFO", this.getSelectedBgOrgUnit());
                uiContext.put("ORGUNIT_COST", this.prmtOrgUnit.getData());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.createDataUI;
    }

    @Override
    public void actionRemoveData_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)this.getBgSchemeInfo());
        uiContext.put((Object)"BGORGUNIT_INFO", (Object)this.getSelectedBgOrgUnit());
        uiContext.put((Object)"ORGUNIT_COST", this.prmtOrgUnit.getData());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgQingAnalyseRemoveDataUI.class.getName(), (Map)uiContext, null, this.oprtState);
        uiWindow.show();
    }

    private BgOrgUnitInfo getSelectedBgOrgUnit() {
        BgOrgUnitInfo info = null;
        TreePath path = this.treeOrgUnit.getSelectionPath();
        if (path == null) {
            return info;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node.getUserObject() instanceof BgOrgUnitInfo) {
            info = (BgOrgUnitInfo)node.getUserObject();
        }
        return info;
    }

    private static class MbgQingAnalyseSwingWorker
    extends SwingWorker {
        private BgSchemeInfo bgSchemeInfo = null;
        private CoreUI ui = null;

        public MbgQingAnalyseSwingWorker(CoreUI ui, BgSchemeInfo bgSchemeInfo) {
            this.ui = ui;
            this.bgSchemeInfo = bgSchemeInfo;
        }

        public Object construct() {
            try {
                MbgQingAnalyseFacadeFactory.getRemoteInstance().calculate(this.bgSchemeInfo);
            }
            catch (EASBizException e) {
                this.ui.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.ui.handUIExceptionAndAbort((Exception)((Object)e));
            }
            return null;
        }
    }
}

