/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.MbgProgressBaseUI;
import com.kingdee.eas.ma.base.progress.IMbgProgress;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.MbgConvertSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgSchemeSplitUI;
import com.kingdee.eas.ma.mbg.cube.utils.MbgSchemeSplitInfo;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgSchemeSplitUI
extends AbstractMbgSchemeSplitUI {
    protected static final String resource = "com.kingdee.eas.ma.mbg.MbgConvertSchemeResource";
    private static final long serialVersionUID = -6327778364390685388L;
    private static final Logger logger = CoreUIObject.getLogger(MbgSchemeSplitUI.class);
    protected static final String COL_seq = "seq";
    protected static final String COL_seqData = "seqData";
    protected static final String COL_bgAccountNumber = "bgAccountNumber";
    protected static final String COL_bgAccountName = "bgAccountName";
    protected static final String COL_bgAccountData = "bgAccountData";
    private MbgSchemeSplitInfo splitInfo = null;
    private boolean isLoading = false;

    public MbgSchemeSplitInfo getSplitInfo() {
        if (this.splitInfo == null) {
            this.splitInfo = (MbgSchemeSplitInfo)BgAnalyseHelper.clone(this.getOriginalSplitInfo());
        }
        return this.splitInfo;
    }

    public MbgSchemeSplitInfo getOriginalSplitInfo() {
        return (MbgSchemeSplitInfo)this.getUIContext().get("InitDataObject");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setEditable(false);
        this.loadData();
    }

    protected void loadData() {
        this.isLoading = true;
        try {
            this.loadCombox();
            this.loadSplit();
        }
        finally {
            this.isLoading = false;
        }
    }

    private void loadCombox() {
        this.cbxMove.removeAllItems();
        this.cbxMove.addItem((Object)EASResource.getString((String)resource, (String)"moveSplit"));
        if (this.getSplitInfo() == null || this.getSplitInfo().splitData == null) {
            return;
        }
        for (int i = 0; i < this.getSplitInfo().splitData.size(); ++i) {
            String seq = this.getSeq(i);
            this.cbxMove.addItem((Object)EASResource.getString((String)resource, (String)"moveToSplit", (Object[])new Object[]{seq}));
        }
    }

    protected String getSeq(int i) {
        return String.valueOf((char)(65 + i));
    }

    private void loadSplit() {
        this.prmtBgScheme.setData((Object)this.getSplitInfo().bgScheme);
        this.tblMain.checkParsed();
        BgViewHelper.removeEditHelper(this.tblMain);
        BgNationalFormatUIUtil.setNumberDisplayFormat((IColumn)this.tblMain.getColumn(COL_seqData));
        this.tblMain.getColumn(COL_seqData).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        BgNationalFormatUIUtil.setNumberDisplayFormat((IColumn)this.tblMain.getColumn(COL_bgAccountData));
        this.tblMain.getColumn(COL_bgAccountData).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.removeRows();
        for (int i = 0; i < this.getSplitInfo().splitData.size(); ++i) {
            String seq = this.getSeq(i);
            int dataCount = 0;
            Object[] accounts = this.getSplitInfo().splitData.get(i).toArray(new String[0]);
            Arrays.sort((Object[])accounts);
            int beginRow = -1;
            for (Object account : accounts) {
                int data = 0;
                if (this.getSplitInfo().rootCountMap.containsKey(account)) {
                    data = this.getSplitInfo().rootCountMap.get(account);
                }
                dataCount += data;
                IRow row = this.tblMain.addRow();
                if (beginRow == -1) {
                    beginRow = row.getRowIndex();
                }
                row.getCell(COL_bgAccountNumber).setValue(account);
                row.getCell(COL_bgAccountName).setValue((Object)this.getSplitInfo().rootAccount.get(account).getName());
                row.getCell(COL_bgAccountData).setValue((Object)data);
            }
            this.tblMain.getCell(beginRow, COL_seq).setValue((Object)seq);
            this.tblMain.getCell(beginRow, COL_seqData).setValue((Object)dataCount);
            if (accounts.length <= 0) continue;
            this.tblMain.getMergeManager().mergeBlock(beginRow, 0, beginRow + accounts.length - 1, 0);
            this.tblMain.getMergeManager().mergeBlock(beginRow, 1, beginRow + accounts.length - 1, 1);
        }
    }

    @Override
    protected void cbxMove_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.isLoading) {
            return;
        }
        if (this.cbxMove.getSelectedIndex() == 0) {
            return;
        }
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            this.cbxMove.setSelectedIndex(0);
            return;
        }
        if (this.cbxMove.getSelectedIndex() != 0) {
            this.moveSplit(this.cbxMove.getSelectedIndex() - 1);
        }
    }

    private void moveSplit(int toIndex) {
        Set<String> target = this.getSplitInfo().splitData.get(toIndex);
        Set<String> selected = this.getSelectNumbers();
        target.addAll(selected);
        for (int i = this.getSplitInfo().splitData.size() - 1; i >= 0; --i) {
            if (this.getSplitInfo().splitData.get(i) == target) continue;
            this.getSplitInfo().splitData.get(i).removeAll(selected);
            if (!this.getSplitInfo().splitData.get(i).isEmpty()) continue;
            this.getSplitInfo().splitData.remove(i);
        }
        this.loadData();
    }

    private Set<String> getSelectNumbers() {
        List rowIndexes = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < rowIndexes.size(); ++i) {
            result.add((String)this.tblMain.getCell(((Integer)rowIndexes.get(i)).intValue(), COL_bgAccountNumber).getValue());
        }
        return result;
    }

    @Override
    protected void btnAddnew_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
        }
        catch (AbortException e1) {
            return;
        }
        if (this.getSplitInfo().splitData.size() >= 26) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resource, (String)"maxSplitSize"));
            return;
        }
        this.getSplitInfo().splitData.add(new HashSet());
        this.moveSplit(this.getSplitInfo().splitData.size() - 1);
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnReset_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resource, (String)"confirmReset"));
        if (result != 0) {
            return;
        }
        this.splitInfo = null;
        this.loadData();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    protected void btnStart_actionPerformed(ActionEvent e) throws Exception {
        MbgConvertProgress invoke = new MbgConvertProgress();
        invoke.bgSchemeId = this.getSplitInfo().bgScheme.getId().toString();
        MbgProgressBaseUI.showProgressUI((CoreUIObject)this, (IMbgProgress)invoke);
    }

    class MbgConvertProgress
    implements IMbgProgress {
        private String bgSchemeId = null;

        MbgConvertProgress() {
        }

        public String getTitle() {
            return EASResource.getString((String)MbgSchemeSplitUI.resource, (String)"progressTitle");
        }

        public String getProgressKey() {
            return MbgSchemeSplitInfo.getProgressKey(this.bgSchemeId);
        }

        public Object start() throws Exception {
            MbgConvertSchemeFacadeFactory.getRemoteInstance().convertSplit(MbgSchemeSplitUI.this.getSplitInfo());
            return true;
        }

        public Object cancel() throws Exception {
            return false;
        }

        public void end(Object result) {
            MsgBox.showInfo((Component)((Object)MbgSchemeSplitUI.this), (String)EASResource.getString((String)MbgSchemeSplitUI.resource, (String)"convertSucess"));
            MbgSchemeSplitUI.this.destroyWindow();
        }

        public void exception(Exception e) {
            MbgSchemeSplitUI.this.handUIException(e);
        }
    }
}

