/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.MbgUpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractMbgUpdateMemberChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateMemberExpUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateOrgChildUI;
import com.kingdee.eas.ma.mbg.client.MbgUpdateSchemeTemplateChildUI;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateConfigInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateMemberInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MbgUpdateMemberChildUI
extends AbstractMbgUpdateMemberChildUI {
    private static final long serialVersionUID = -6567497924656754262L;
    private static final Logger logger = CoreUIObject.getLogger(MbgUpdateMemberChildUI.class);
    public static String COLUMN_ORG_NUMBER = "orgNumber";
    public static String COLUMN_ORG_NAME = "orgName";
    public static String COLUMN_DIMENSION = "dimmension";
    public static String COLUMN_DIMENSIONMEMBER = "dimMember";
    public static String COLUMN_DETAILORG_NUMBER = "orgDetailNumber";
    public static String COLUMN_DETAILORG_NAME = "orgDetailName";
    public static String[] COLUMU_KEYS = new String[]{COLUMN_ORG_NUMBER, COLUMN_ORG_NAME, COLUMN_DIMENSION, COLUMN_DIMENSIONMEMBER, COLUMN_DETAILORG_NUMBER, COLUMN_DETAILORG_NAME};

    @Override
    protected String getNextUIClassName() {
        return MbgUpdateSchemeTemplateChildUI.class.getName();
    }

    @Override
    protected String getPrevUIClassName() {
        return MbgUpdateOrgChildUI.class.getName();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        MbgUpdateConfigInfo configInfo = this.getConfigInfo();
        List memberInfos = null;
        try {
            if (memberInfos == null) {
                memberInfos = MbgUpdateFacadeFactory.getRemoteInstance().checkMember(configInfo);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.loadTableData(memberInfos);
    }

    private void loadTableData(List<MbgUpdateMemberInfo> memberInfos) {
        this.memberTable.removeRows();
        this.addTableData(memberInfos);
    }

    protected void checkTableParsed() {
        this.memberTable.checkParsed();
    }

    private void addTableData(List<MbgUpdateMemberInfo> memberInfos) {
        if (memberInfos != null && memberInfos.size() > 0) {
            IRow iRow = null;
            for (int i = 0; i < memberInfos.size(); ++i) {
                iRow = this.memberTable.addRow();
                MbgUpdateMemberInfo info = memberInfos.get(i);
                iRow.getCell(COLUMN_ORG_NUMBER).setValue(info.getSourceOrg().getNumber() == null ? null : info.getSourceOrg().getNumber());
                iRow.getCell(COLUMN_ORG_NAME).setValue(info.getSourceOrg().getName() == null ? null : info.getSourceOrg().getName());
                iRow.getCell(COLUMN_DIMENSION).setValue(info.getDimension().getName() == null ? null : info.getDimension().getName());
                iRow.getCell(COLUMN_DIMENSIONMEMBER).setValue(info.getMember().getNumber() == null ? null : info.getMember().getNumber());
                iRow.getCell(COLUMN_DETAILORG_NUMBER).setValue(info.getTargetOrg().getName() == null ? null : info.getTargetOrg().getName());
                iRow.getCell(COLUMN_DETAILORG_NAME).setValue(info.getTargetOrg().getNumber() == null ? null : info.getTargetOrg().getNumber());
                iRow.setUserObject((Object)info);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        int count = this.memberTable.getRowCount();
        if (count != 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"detailOrgNotExistDimMem"));
            SysUtil.abort();
        }
    }

    @Override
    protected void exportData_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckExport"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileFilter filter = null;
        File file = null;
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            int re;
            filePath = fileChooser.getSelectedFile().getPath();
            filter = fileChooser.getFileFilter();
            file = fileChooser.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                if (filter instanceof ExcelFileFilter) {
                    filePath = fileChooser.getSelectedFile() + ".xls";
                }
                file = new File(filePath);
            }
            if (file.exists() && ((re = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckFileExist"))) == 1 || re == 2)) {
                return;
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        try {
            if (filter instanceof ExcelFileFilter) {
                KDSBook kdsBook = new KDSBook("001");
                KDSSheet kdsSheet = new KDSSheet(kdsBook, "Sheet1");
                kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"font"), 0, 9));
                kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
                kdsSheet.setCellValue(0, 0, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgNumber"));
                kdsSheet.setCellValue(0, 1, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgName"));
                kdsSheet.setCellValue(0, 2, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"dimension"));
                kdsSheet.setCellValue(0, 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"dimMember"));
                kdsSheet.setCellValue(0, 4, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"detailOrgNumber"));
                kdsSheet.setCellValue(0, 5, (Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"detailOrgName"));
                IRow row = null;
                for (int i = 0; i < this.memberTable.getRowCount(); ++i) {
                    row = this.memberTable.getRow(i);
                    kdsSheet.setCellValue(i + 1, 0, row.getCell(0).getValue() == null ? null : row.getCell(0).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 1, row.getCell(1).getValue() == null ? null : row.getCell(1).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 2, row.getCell(2).getValue() == null ? null : row.getCell(2).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 3, row.getCell(3).getValue() == null ? null : row.getCell(3).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 4, row.getCell(4).getValue() == null ? null : row.getCell(4).getValue().toString());
                    kdsSheet.setCellValue(i + 1, 5, row.getCell(5).getValue() == null ? null : row.getCell(5).getValue().toString());
                }
                kdsBook.addSheet(null, kdsSheet);
                ExportManager export = new ExportManager();
                export.exportToExcel(kdsBook, filePath);
                kdsBook = null;
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckExportSuccess"));
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgCheckFileOpened"));
        }
    }

    private KDTable loadTempTblData() throws EASBizException, BOSException {
        KDTable tbl = MbgUpdateMemberExpUI.createKDTableTemplateData();
        IRow destRow = null;
        IRow srcRow = null;
        tbl.removeRows();
        for (int j = 0; j < this.memberTable.getRowCount(); ++j) {
            destRow = tbl.addRow();
            srcRow = this.memberTable.getRow(j);
            destRow.getCell(COLUMU_KEYS[0]).setValue(srcRow.getCell(COLUMU_KEYS[0]).getValue());
            destRow.getCell(COLUMU_KEYS[1]).setValue(srcRow.getCell(COLUMU_KEYS[1]).getValue());
            destRow.getCell(COLUMU_KEYS[2]).setValue(srcRow.getCell(COLUMU_KEYS[2]).getValue());
            destRow.getCell(COLUMU_KEYS[3]).setValue(srcRow.getCell(COLUMU_KEYS[3]).getValue());
            destRow.getCell(COLUMU_KEYS[4]).setValue(srcRow.getCell(COLUMU_KEYS[4]).getValue());
            destRow.getCell(COLUMU_KEYS[5]).setValue(srcRow.getCell(COLUMU_KEYS[5]).getValue());
        }
        return tbl;
    }
}

