/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgDetailMemberEnum;
import com.kingdee.eas.ma.mbg.BgPeriodTypeEnum;
import com.kingdee.eas.ma.mbg.function.dataType.IMbgFunctionDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionEnumDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionF7DataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionSpinnerDataType;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunctionTextFieldDataType;
import com.kingdee.eas.util.client.ExceptionHandler;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MbgWidgetGenerator {
    private static final Logger logger = CoreUIObject.getLogger(MbgWidgetGenerator.class);
    private JComponent controller;

    public JComponent getController(IMbgFunctionDataType type) {
        this.controller = null;
        if (type instanceof MbgFunctionF7DataType) {
            MbgFunctionF7DataType f7DataType = (MbgFunctionF7DataType)type;
            KDBizPromptBox prompt = new KDBizPromptBox();
            prompt.setName(f7DataType.getName());
            prompt.setEditable(true);
            prompt.setEditFormat(f7DataType.getEdit_fm());
            prompt.setDisplayFormat(f7DataType.getDisplay_fm());
            prompt.setCommitFormat(f7DataType.getCommit_fm());
            prompt.setRequired(true);
            try {
                Class<?> cl = Class.forName(f7DataType.getSource());
                Object obj = cl.newInstance();
                if (obj instanceof KDPromptSelector) {
                    prompt.setSelector((KDPromptSelector)obj);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.controller = prompt;
        } else if (type instanceof MbgFunctionEnumDataType) {
            MbgFunctionEnumDataType enumDataType = (MbgFunctionEnumDataType)type;
            KDComboBox combox = new KDComboBox();
            combox.setEditable(true);
            try {
                Class<?> cl = Class.forName(enumDataType.getSource());
                if ("periodType".equals(enumDataType.getName())) {
                    combox.addItems(BgPeriodTypeEnum.getEnumList().toArray());
                } else {
                    combox.addItems(BgDetailMemberEnum.getEnumList().toArray());
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.controller = combox;
        } else if (type instanceof MbgFunctionTextFieldDataType) {
            KDTextField fd = new KDTextField();
            fd.setRequired(((MbgFunctionTextFieldDataType)type).isRequired());
            fd.setEnabled(((MbgFunctionTextFieldDataType)type).isEnable());
            fd.setEditable(true);
            this.controller = fd;
        } else if (type instanceof MbgFunctionSpinnerDataType) {
            KDSpinner spinner = new KDSpinner();
            spinner.setRequired(((MbgFunctionSpinnerDataType)type).isRequired());
            spinner.setEnabled(((MbgFunctionSpinnerDataType)type).isEnable());
            spinner.setEditable(true);
            this.controller = spinner;
        }
        return this.controller;
    }

    public JComponent getController() {
        return this.controller;
    }
}

