/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.uiframe.client.DlgShowListener;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.client.BgPanel;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.ExitSystemHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class MyMsgBox
extends KDDialog {
    protected static final Logger logger = Logger.getLogger(MyMsgBox.class);
    public static final int CANCEL_OPTION = 2;
    public static final int RECONN_OPTION = 99;
    protected boolean isDetail = false;
    private int result = 2;

    public int getResult() {
        return this.result;
    }

    public static int showSessionError(Component comp, Throwable exc) {
        MyMsgBox msgBox = MyMsgBox.createMsgBox(comp, exc);
        msgBox.setModal(true);
        DlgShowListener listener = new DlgShowListener((Component)((Object)msgBox));
        msgBox.addWindowListener((WindowListener)listener);
        msgBox.show();
        return msgBox.getResult();
    }

    private static MyMsgBox createMsgBox(Component owner, Throwable exc) {
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        if (ownerWindow instanceof Frame) {
            return new MyMsgBox((Frame)ownerWindow, exc);
        }
        if (ownerWindow instanceof Dialog) {
            return new MyMsgBox((Dialog)ownerWindow, exc);
        }
        return new MyMsgBox((Frame)null, exc);
    }

    public MyMsgBox(Dialog owner, Throwable exc) {
        super(owner);
        this.jbInit(exc);
    }

    public MyMsgBox(Frame owner, Throwable exc) {
        super(owner);
        this.jbInit(exc);
    }

    protected void jbInit(Throwable exc) {
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Color bottomBgColor = new Color(230, 230, 230);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(null);
        String msg = MessageFormat.format(EASResource.getString((String)"sessionClosedMsg"), "\n", "\n", "\n");
        String detail = ExceptionHandler.buildDetail((Throwable)exc);
        BgPanel bgPanel = new BgPanel(AdvMsgBox.getImgInfoError(), msg);
        final Dimension bgPanelDimension = bgPanel.getPreferredSize();
        int normalBottomHeight = 42;
        int advanceBottomHeight = 202;
        contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + 42));
        bgPanel.setBounds(0, 0, bgPanelDimension.width, bgPanelDimension.height);
        contentPane.add((Component)((Object)bgPanel));
        JPanel pnlBottom = new JPanel();
        pnlBottom.setLayout(null);
        pnlBottom.setBounds(0, bgPanelDimension.height, bgPanelDimension.width, 202);
        contentPane.add(pnlBottom);
        pnlBottom.setBackground(bottomBgColor);
        KDSeparator sp = new KDSeparator();
        sp.setBounds(0, 0, bgPanelDimension.width, 2);
        pnlBottom.add((Component)sp);
        KDButton btnCancel = new KDButton(EASResource.getString((String)"cancel"));
        btnCancel.setMargin(new Insets(2, 1, 2, 1));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMsgBox.this.result = 2;
                MyMsgBox.this.dispose();
            }
        });
        KDButton btnReConnection = new KDButton(EASResource.getString((String)"reConnection"));
        btnReConnection.setMargin(new Insets(2, 1, 2, 1));
        btnReConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyMsgBox.this.setSize(20, 20);
                try {
                    SystemEntry.instance.innerReLogin();
                    MyMsgBox.this.setStatusMessage(EASResource.getString((String)"reconnectionSuccess"));
                    MyMsgBox.this.result = 99;
                }
                catch (Exception e1) {
                    logger.error((Object)"ReloginAction", (Throwable)e1);
                }
                MyMsgBox.this.dispose();
            }
        });
        KDButton btnQuitSystem = new KDButton(EASResource.getString((String)"quitSystem"));
        btnQuitSystem.setMargin(new Insets(2, 1, 2, 1));
        btnQuitSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExitSystemHelper.preparedExit();
                    MainFrame.closeApplicationWhenSessionTimeOut();
                }
                catch (Throwable ee) {
                    logger.error((Object)"close windows occur error!", ee);
                    System.exit(-1);
                }
            }
        });
        btnCancel.setText(EASResource.getString((String)"ignore"));
        btnCancel.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MyMsgBox.this.respondToKeyPressing(e, bgPanelDimension, 42, 202);
            }
        });
        btnQuitSystem.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MyMsgBox.this.respondToKeyPressing(e, bgPanelDimension, 42, 202);
            }
        });
        btnReConnection.setBounds(172, 11, 77, 21);
        btnQuitSystem.setBounds(257, 11, 77, 21);
        btnCancel.setBounds(342, 11, 77, 21);
        pnlBottom.add((Component)btnReConnection);
        pnlBottom.add((Component)btnQuitSystem);
        pnlBottom.add((Component)btnCancel);
        this.setDefaultFocus((Component)btnCancel);
        KDTextAreaCtrl txtDetail = new KDTextAreaCtrl();
        txtDetail.getTextComponent().setEditable(false);
        txtDetail.setText(detail);
        txtDetail.setSelectionStart(0);
        txtDetail.setSelectionEnd(0);
        txtDetail.setBounds(10, 43, 409, 150);
        txtDetail.getTextComponent().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MyMsgBox.this.respondToKeyPressing(e, bgPanelDimension, 42, 202);
            }
        });
        pnlBottom.add((Component)txtDetail);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    protected void respondToKeyPressing(KeyEvent e, Dimension bgPanelDimension, int normalBottomHeight, int advanceBottomHeight) {
        if (e.getKeyCode() == 69 && e.isControlDown()) {
            JPanel contentPane = (JPanel)this.getContentPane();
            if (this.isDetail) {
                contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + normalBottomHeight));
                this.pack();
                this.isDetail = false;
            } else {
                contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + advanceBottomHeight));
                this.pack();
                this.isDetail = true;
            }
        }
    }

    protected void setDefaultFocus(final Component comp) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                comp.requestFocusInWindow();
            }
        });
    }

    private void setStatusMessage(String text) {
        IUIObject o = SystemEntry.instance.getMainUIObject().getSelectedUIObject();
        if (o instanceof CoreUI) {
            CoreUI ui = (CoreUI)o;
            ui.setMessageText(text);
            ui.showMessage();
        }
    }
}

