/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.DimensionDisplayModeEnum;
import com.kingdee.eas.ma.mbg.client.AbstractOrgUnitMemberSelectF7UI;
import com.kingdee.eas.ma.mbg.client.utils.OrgUnitMemberSelectDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgUnitMemberSelectF7UI
extends AbstractOrgUnitMemberSelectF7UI {
    private static final long serialVersionUID = -7661144673421374164L;
    private static final Logger logger = CoreUIObject.getLogger(OrgUnitMemberSelectF7UI.class);
    private Object data;
    private boolean isCanceled = true;
    private NumberExpandHelper numberHelper = null;
    private String orgTreeId = null;
    private String orgUnionId = null;

    public void onLoad() throws Exception {
        this.mainTable.setEditable(false);
        this.mainTable.getSelectManager().setSelectMode(2);
        super.onLoad();
        if (this.getUIContext().get(OrgUnitMemberSelectDialog.ORGTREE_ID) != null) {
            this.orgTreeId = this.getUIContext().get(OrgUnitMemberSelectDialog.ORGTREE_ID).toString();
        }
        if (this.getUIContext().get(BgBaseConstants.UNIONGROUP_ID) != null) {
            this.orgUnionId = this.getUIContext().get(BgBaseConstants.UNIONGROUP_ID).toString();
        }
        this.initCombItem();
        OrgUnitCollection unionDebt = this.loadUnionDebtByOrgTreeId(this.orgTreeId, this.orgUnionId);
        this.putUnionDebtToTable(unionDebt);
    }

    private void initCombItem() {
        this.combOrgUnit.addItem((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgCommonResource", (String)"unionDebt"));
        this.combOrgUnit.setEnabled(false);
        this.combFilter.removeAllItems();
        this.combFilter.addItem((Object)DimensionDisplayModeEnum.Number);
        this.combFilter.addItem((Object)DimensionDisplayModeEnum.Name);
        this.combFilter.setSelectedItem((Object)DimensionDisplayModeEnum.Name);
        this.combFilterType.addItem((Object)CompareSignEnum.EQUALSSIGN);
        this.combFilterType.addItem((Object)CompareSignEnum.LIKESIGN);
        this.combFilterType.setSelectedItem((Object)CompareSignEnum.LIKESIGN);
    }

    private void putUnionDebtToTable(OrgUnitCollection unionDebt) {
        if (unionDebt == null || unionDebt.isEmpty()) {
            return;
        }
        this.mainTable.checkParsed();
        this.mainTable.getSelectManager().setSelectMode(2);
        OrgUnitInfo orgUnitInfo = null;
        IRow iRow = null;
        for (int i = 0; i < unionDebt.size(); ++i) {
            iRow = this.mainTable.addRow();
            orgUnitInfo = unionDebt.get(i);
            iRow.getCell("number").setValue((Object)orgUnitInfo.getNumber());
            iRow.getCell("longNumber").setValue((Object)orgUnitInfo.getLongNumber());
            iRow.getCell("isLeaf").setValue((Object)orgUnitInfo.isIsLeaf());
            iRow.getCell("name").setValue((Object)orgUnitInfo.getName());
            iRow.getCell("level").setValue((Object)orgUnitInfo.getLevel());
            iRow.setUserObject((Object)orgUnitInfo);
        }
    }

    private OrgUnitCollection loadUnionDebtByOrgTreeId(String orgTreeId, String unionId) throws BOSException, SQLException {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        Set canDisplayOrgIds = null;
        if (this.getUIContext().containsKey("orgIds")) {
            canDisplayOrgIds = (Set)this.getUIContext().get("orgIds");
        }
        OrgUnitCollection orgColls = new OrgUnitCollection();
        StringBuffer queryUnionDebtSql = new StringBuffer();
        queryUnionDebtSql.append("SELECT ").append("ORGSTRUCTURE.FUnitId AS ID,").append("UNIT.FName_l2 AS NAME, ").append("UNIT.FNumber AS NUMBER, ").append("ORGSTRUCTURE.FLongNumber AS LONGNUMBER ,").append("ORGSTRUCTURE.FLEVEL ,").append("ORGSTRUCTURE.FISLEAF  AS ISLEAF ").append(" FROM T_ORG_Structure AS ORGSTRUCTURE ").append(" LEFT OUTER JOIN T_ORG_BaseUnit AS UNIT ").append("ON ORGSTRUCTURE.FUnitId = UNIT.FID").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ").append("ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" LEFT OUTER JOIN T_ORG_Structure AS PARENT ").append("ON ORGSTRUCTURE.FParentID = PARENT.FID").append(" LEFT OUTER JOIN T_ORG_OUPartFI AS PARTFI ").append("ON UNIT.FPartFIID = PARTFI.FID").append(" WHERE  UNIT.FISGROUPING = 1 ");
        if (!StringUtils.isEmpty((String)orgTreeId)) {
            queryUnionDebtSql.append("AND TREE.FID = '").append(orgTreeId).append("'");
        }
        queryUnionDebtSql.append(" ORDER BY LONGNUMBER ASC ");
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)queryUnionDebtSql.toString()).executeSQL();
        OrgUnitInfo orgUnitInfo = null;
        BOSUuid unitId = null;
        while (rowSet.next()) {
            orgUnitInfo = new OrgUnitInfo();
            unitId = BOSUuid.read((String)rowSet.getString("ID"));
            orgUnitInfo.setId(unitId);
            orgUnitInfo.setName(rowSet.getString("NAME"));
            orgUnitInfo.setNumber(rowSet.getString("NUMBER"));
            orgUnitInfo.setLongNumber(rowSet.getString("LONGNUMBER"));
            orgUnitInfo.setLevel(rowSet.getInt("FLEVEL"));
            orgUnitInfo.setIsLeaf(rowSet.getBoolean("ISLEAF"));
            if (canDisplayOrgIds != null && !canDisplayOrgIds.contains(unitId.toString())) continue;
            orgColls.add(orgUnitInfo);
        }
        return orgColls;
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuery_actionPerformed(e);
        if (!StringUtils.isEmpty((String)this.txtFilter.getText())) {
            this.filterUnionByFilterCondition(this.mainTable, (DimensionDisplayModeEnum)((Object)this.combFilter.getSelectedItem()), (CompareSignEnum)this.combFilterType.getSelectedItem(), this.txtFilter.getText());
        } else {
            this.mainTable.removeRows();
            this.mainTable.checkParsed();
            OrgUnitCollection unionDebt = this.loadUnionDebtByOrgTreeId(this.orgTreeId, this.orgUnionId);
            this.putUnionDebtToTable(unionDebt);
        }
    }

    private void filterUnionByFilterCondition(KDTable mainTable, DimensionDisplayModeEnum combFilter, CompareSignEnum compareType, String searchText) {
        if (StringUtils.isEmpty((String)searchText)) {
            return;
        }
        IRow row = null;
        boolean isHide = false;
        String curNumber = null;
        String curName = null;
        int count = mainTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = mainTable.getRow(i);
            curNumber = row.getCell("number").getValue().toString();
            curName = row.getCell("name").getValue().toString();
            if (DimensionDisplayModeEnum.Name.equals((Object)combFilter)) {
                if (CompareSignEnum.EQUALSSIGN.equals((Object)compareType)) {
                    isHide = curName.equals(searchText);
                } else if (CompareSignEnum.LIKESIGN.equals((Object)compareType)) {
                    isHide = curName.indexOf(searchText) > -1;
                }
            } else if (DimensionDisplayModeEnum.Number.equals((Object)combFilter)) {
                if (CompareSignEnum.EQUALSSIGN.equals((Object)compareType)) {
                    isHide = curNumber.equals(searchText);
                } else if (CompareSignEnum.LIKESIGN.equals((Object)compareType)) {
                    isHide = curNumber.indexOf(searchText) > -1;
                }
            }
            row.getStyleAttributes().setHided(!isHide);
        }
    }

    private NumberExpandHelper getNumberExpandHelper() {
        if (this.numberHelper == null) {
            this.numberHelper = new NumberExpandHelper((CoreUI)this, this.mainTable);
        }
        return this.numberHelper;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        int selectedRowIndex = BgCommCHelper.getSelectedRowIndex((KDTable)this.mainTable);
        if (selectedRowIndex >= 0) {
            this.data = this.mainTable.getRow(selectedRowIndex).getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int selectedRowIndex = BgCommCHelper.getSelectedRowIndex((KDTable)this.mainTable);
            if (selectedRowIndex >= 0) {
                this.data = this.mainTable.getRow(selectedRowIndex).getUserObject();
                this.isCanceled = false;
                this.getUIWindow().close();
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }
}

